// **********************************************************************
//
// Copyright (c) 1999
// Object Oriented Concepts, Inc.
// Billerica, MA, USA
//
// All Rights Reserved
//
// **********************************************************************

#include <OB/CORBA.h>
#include <Test_impl.h>

#include <limits.h>

#ifdef HAVE_UNISTD_H
#   include <unistd.h>
#endif

void
TestInterface_impl::opVoid()
{
}

TestInterface::StringSequence*
TestInterface_impl::opContext(const char* pattern, CORBA_Context_ptr ctx)
{
    CORBA_NVList_var values;
    ctx -> get_values("", 0, pattern, values.out());
    
    CORBA_ULong len = values -> count();
    StringSequence* result = new StringSequence(len * 2);
    result -> length(len * 2);
    for(CORBA_ULong i = 0 ; i < len ; i++)
    {
	char* s;
	    *(values -> item(i) -> value()) >>= s;
	    (*result)[i * 2] = values -> item(i) -> name();
	    (*result)[i * 2 + 1] = CORBA_string_dup(s);
    }
    
    return result;
}

void
TestInterfaceEx_impl::opVoidEx()
{
    throw ExVoid();
}

CORBA_Short
TestInterface_impl::attrShort()
{
    return aShort;
}

void
TestInterface_impl::attrShort(CORBA_Short val)
{
    aShort = val;
}

CORBA_Short
TestInterface_impl::opShort(CORBA_Short a0,
			    CORBA_Short& a1,
			    CORBA_Short& a2)
{
    aShort = a0 + a1;
    a1 = a2 = aShort;
    return aShort;
}

CORBA_Short
TestInterfaceEx_impl::opShortEx(CORBA_Short a0,
				CORBA_Short& a1,
				CORBA_Short&)
{
    aShort = a0 + a1;
    throw ExShort(aShort);
    return 0; // Some compilers need this
}

CORBA_Long
TestInterface_impl::attrLong()
{
    return aLong;
}

void
TestInterface_impl::attrLong(CORBA_Long val)
{
    aLong = val;
}

CORBA_Long
TestInterface_impl::opLong(CORBA_Long a0,
			   CORBA_Long& a1,
			   CORBA_Long& a2)
{
    aLong = a0 + a1;
    a1 = a2 = aLong;
    return aLong;
}

CORBA_Long
TestInterfaceEx_impl::opLongEx(CORBA_Long a0,
			       CORBA_Long& a1,
			       CORBA_Long&)
{
    aLong = a0 + a1;
    throw ExLong(aLong);
    return 0; // Some compilers need this
}

CORBA_UShort
TestInterface_impl::attrUShort()
{
    return aUShort;
}

void
TestInterface_impl::attrUShort(CORBA_UShort val)
{
    aUShort = val;
}

CORBA_UShort
TestInterface_impl::opUShort(CORBA_UShort a0,
			     CORBA_UShort& a1,
			     CORBA_UShort& a2)
{
    aUShort = a0 + a1;
    a1 = a2 = aUShort;
    return aUShort;
}

CORBA_UShort
TestInterfaceEx_impl::opUShortEx(CORBA_UShort a0,
				 CORBA_UShort& a1,
				 CORBA_UShort&)
{
    aUShort = a0 + a1;
    throw ExUShort(aUShort);
    return 0; // Some compilers need this
}

CORBA_ULong
TestInterface_impl::attrULong()
{
    return aULong;
}

void
TestInterface_impl::attrULong(CORBA_ULong val)
{
    aULong = val;
}

CORBA_ULong
TestInterface_impl::opULong(CORBA_ULong a0,
			    CORBA_ULong& a1,
			    CORBA_ULong& a2)
{
    aULong = a0 + a1;
    a1 = a2 = aULong;
    return aULong;
}

CORBA_ULong
TestInterfaceEx_impl::opULongEx(CORBA_ULong a0,
				CORBA_ULong& a1,
				CORBA_ULong&)
{
    aULong = a0 + a1;
    throw ExULong(aULong);
    return 0; // Some compilers need this
}

CORBA_Float
TestInterface_impl::attrFloat()
{
    return aFloat;
}

void
TestInterface_impl::attrFloat(CORBA_Float val)
{
    aFloat = val;
}

CORBA_Float
TestInterface_impl::opFloat(CORBA_Float a0,
			    CORBA_Float& a1,
			    CORBA_Float& a2)
{
    aFloat = a0 + a1;
    a1 = a2 = aFloat;
    return aFloat;
}

CORBA_Float
TestInterfaceEx_impl::opFloatEx(CORBA_Float a0,
				CORBA_Float& a1,
				CORBA_Float&)
{
    aFloat = a0 + a1;
    throw ExFloat(aFloat);
    return 0; // Some compilers need this
}

CORBA_Double
TestInterface_impl::attrDouble()
{
    return aDouble;
}

void
TestInterface_impl::attrDouble(CORBA_Double val)
{
    aDouble = val;
}

CORBA_Double
TestInterface_impl::opDouble(CORBA_Double a0,
			     CORBA_Double& a1,
			     CORBA_Double& a2)
{
    aDouble = a0 + a1;
    a1 = a2 = aDouble;
    return aDouble;
}

CORBA_Double
TestInterfaceEx_impl::opDoubleEx(CORBA_Double a0,
				 CORBA_Double& a1,
				 CORBA_Double&)
{
    aDouble = a0 + a1;
    throw ExDouble(aDouble);
    return 0; // Some compilers need this
}

CORBA_Boolean
TestInterface_impl::attrBoolean()
{
    return aBoolean;
}

void
TestInterface_impl::attrBoolean(CORBA_Boolean val)
{
    aBoolean = val;
}

CORBA_Boolean
TestInterface_impl::opBoolean(CORBA_Boolean a0,
			      CORBA_Boolean& a1,
			      CORBA_Boolean& a2)
{
    aBoolean = a0 && a1;
    a1 = a2 = aBoolean;
    return aBoolean;
}

CORBA_Boolean
TestInterfaceEx_impl::opBooleanEx(CORBA_Boolean a0,
				  CORBA_Boolean& a1,
				  CORBA_Boolean&)
{
    aBoolean = a0 && a1;
    throw ExBoolean(aBoolean);
    return 0; // Some compilers need this
}

CORBA_Char
TestInterface_impl::attrChar()
{
    return aChar;
}

void
TestInterface_impl::attrChar(CORBA_Char val)
{
    aChar = val;
}

CORBA_Char
TestInterface_impl::opChar(CORBA_Char a0,
			   CORBA_Char& a1,
			   CORBA_Char& a2)
{
    aChar = a0 + a1;
    a1 = a2 = aChar;
    return aChar;
}

CORBA_Char
TestInterfaceEx_impl::opCharEx(CORBA_Char a0,
			       CORBA_Char& a1,
			       CORBA_Char&)
{
    aChar = a0 + a1;
    throw ExChar(aChar);
    return 0; // Some compilers need this
}

CORBA_Octet
TestInterface_impl::attrOctet()
{
    return aOctet;
}

void
TestInterface_impl::attrOctet(CORBA_Octet val)
{
    aOctet = val;
}

CORBA_Octet
TestInterface_impl::opOctet(CORBA_Octet a0,
			    CORBA_Octet& a1,
			    CORBA_Octet& a2)
{
    aOctet = a0 + a1;
    a1 = a2 = aOctet;
    return aOctet;
}

CORBA_Octet
TestInterfaceEx_impl::opOctetEx(CORBA_Octet a0,
				CORBA_Octet& a1,
				CORBA_Octet&)
{
    aOctet = a0 + a1;
    throw ExOctet(aOctet);
    return 0; // Some compilers need this
}

char*
TestInterface_impl::attrString()
{
    return CORBA_string_dup(aString);
}

void
TestInterface_impl::attrString(const char* val)
{
    aString = val;
}

char*
TestInterface_impl::opString(const char* a0,
			     char*& a1,
			     char*& a2)
{
    aString = CORBA_string_alloc(strlen(a0) + strlen(a1));
    strcpy(aString.inout(), a0);
    strcat(aString.inout(), a1);
    CORBA_string_free(a1);
    a1 = CORBA_string_dup(aString);
    a2 = CORBA_string_dup(aString);
    return CORBA_string_dup(aString);
}

char*
TestInterfaceEx_impl::opStringEx(const char* a0,
				 char*& a1,
				 char*&)
{
    aString = CORBA_string_alloc(strlen(a0) + strlen(a1));
    strcpy(aString.inout(), a0);
    strcat(aString.inout(), a1);
    throw ExString(aString);
    return 0; // Some compilers need this
}

CORBA_Any*
TestInterface_impl::attrAny()
{
    return new CORBA_Any(aAny);
}

void
TestInterface_impl::attrAny(const CORBA_Any& val)
{
    aAny = val;
}

CORBA_Any*
TestInterface_impl::opAny(const CORBA_Any& a0,
			  CORBA_Any& a1,
			  CORBA_Any*& a2)
{
    aAny = a0;
    a1 = aAny;
    a2 = new CORBA_Any(aAny);
    return new CORBA_Any(aAny);
}

CORBA_Any*
TestInterfaceEx_impl::opAnyEx(const CORBA_Any& a0,
			      CORBA_Any&,
			      CORBA_Any*&)
{
    aAny = a0;
    throw ExAny(aAny);
    return 0; // Some compilers need this
}

TestInterface::TestEnum
TestInterface_impl::attrTestEnum()
{
    return aTestEnum;
}

void
TestInterface_impl::attrTestEnum(TestEnum val)
{
    aTestEnum = val;
}

TestInterface::TestEnum
TestInterface_impl::opTestEnum(TestEnum a0,
			       TestEnum& a1,
			       TestEnum& a2)
{
    aTestEnum = a0;
    a1 = a2 = aTestEnum;
    return aTestEnum;
}

TestInterface::TestEnum
TestInterfaceEx_impl::opTestEnumEx(TestEnum a0,
				   TestEnum&,
				   TestEnum&)
{
    aTestEnum = a0;
    throw ExTestEnum(aTestEnum);
    return TestEnum1; // Some compilers need this
}

TestInterface_ptr
TestInterface_impl::attrTestInterface()
{
    return TestInterface::_duplicate(aTestInterface);
}

void
TestInterface_impl::attrTestInterface(TestInterface_ptr val)
{
    aTestInterface = TestInterface::_duplicate(val);
}

TestInterface_ptr
TestInterface_impl::opTestInterface(TestInterface_ptr a0,
				    TestInterface_ptr& a1,
				    TestInterface_ptr& a2)
{
    aTestInterface = TestInterface::_duplicate(a0);
    CORBA_release(a1);
    a1 = TestInterface::_duplicate(aTestInterface);
    a2 = TestInterface::_duplicate(aTestInterface);
    return TestInterface::_duplicate(aTestInterface);
}

TestInterface_ptr
TestInterfaceEx_impl::opTestInterfaceEx(TestInterface_ptr a0,
					TestInterface_ptr&,
					TestInterface_ptr&)
{
    aTestInterface = TestInterface::_duplicate(a0);
    throw ExTestInterface(aTestInterface);
    return TestInterface::_nil(); // Some compilers need this
}

TestInterface::FixedStruct
TestInterface_impl::attrFixedStruct()
{
    return aFixedStruct;
}

void
TestInterface_impl::attrFixedStruct(const TestInterface::FixedStruct& val)
{
    aFixedStruct = val;
}

TestInterface::FixedStruct
TestInterface_impl::opFixedStruct(const TestInterface::FixedStruct& a0,
				  TestInterface::FixedStruct& a1,
				  TestInterface::FixedStruct& a2)
{
    aFixedStruct = a0;
    a1 = a2 = aFixedStruct;
    return aFixedStruct;
}

TestInterface::FixedStruct
TestInterfaceEx_impl::opFixedStructEx(const TestInterface::FixedStruct& a0,
				      TestInterface::FixedStruct&,
				      TestInterface::FixedStruct&)
{
    aFixedStruct = a0;
    throw ExFixedStruct(aFixedStruct);
    return FixedStruct(); // Some compilers need this
}

TestInterface::VariableStruct*
TestInterface_impl::attrVariableStruct()
{
    return new VariableStruct(aVariableStruct);
}

void
TestInterface_impl::attrVariableStruct(const TestInterface::VariableStruct&
				       val)
{
    aVariableStruct = val;
}

TestInterface::VariableStruct*
TestInterface_impl::opVariableStruct(const TestInterface::VariableStruct& a0,
				     TestInterface::VariableStruct& a1,
				     TestInterface::VariableStruct*& a2)
{
    aVariableStruct = a0;
    a1 = aVariableStruct;
    a2 = new VariableStruct(aVariableStruct);
    return new VariableStruct(aVariableStruct);
}

TestInterface::VariableStruct*
TestInterfaceEx_impl::opVariableStructEx(const TestInterface::VariableStruct&
					 a0,
					 TestInterface::VariableStruct&,
					 TestInterface::VariableStruct*&)
{
    aVariableStruct = a0;
    throw ExVariableStruct(aVariableStruct);
    return new VariableStruct; // Some compilers need this
}

TestInterface::FixedUnion
TestInterface_impl::attrFixedUnion()
{
    return aFixedUnion;
}

void
TestInterface_impl::attrFixedUnion(const TestInterface::FixedUnion& val)
{
    aFixedUnion = val;
}

TestInterface::FixedUnion
TestInterface_impl::opFixedUnion(const TestInterface::FixedUnion& a0,
				 TestInterface::FixedUnion& a1,
				 TestInterface::FixedUnion& a2)
{
    aFixedUnion = a0;
    a1 = a2 = aFixedUnion;
    return aFixedUnion;
}

TestInterface::FixedUnion
TestInterfaceEx_impl::opFixedUnionEx(const TestInterface::FixedUnion& a0,
				     TestInterface::FixedUnion&,
				     TestInterface::FixedUnion&)
{
    aFixedUnion = a0;
    throw ExFixedUnion(aFixedUnion);
    return FixedUnion(); // Some compilers need this
}

TestInterface::VariableUnion*
TestInterface_impl::attrVariableUnion()
{
    return new VariableUnion(aVariableUnion);
}

void
TestInterface_impl::attrVariableUnion(const TestInterface::VariableUnion& val)
{
    aVariableUnion = val;
}

TestInterface::VariableUnion*
TestInterface_impl::opVariableUnion(const TestInterface::VariableUnion& a0,
				    TestInterface::VariableUnion& a1,
				    TestInterface::VariableUnion*& a2)
{
    aVariableUnion = a0;
    a1 = aVariableUnion;
    a2 = new VariableUnion(aVariableUnion);
    return new VariableUnion(aVariableUnion);
}

TestInterface::VariableUnion*
TestInterfaceEx_impl::opVariableUnionEx(const TestInterface::VariableUnion& a0,
					TestInterface::VariableUnion&,
					TestInterface::VariableUnion*&)
{
    aVariableUnion = a0;
    throw ExVariableUnion(aVariableUnion);
    return new VariableUnion; // Some compilers need this
}

TestInterface::StringSequence*
TestInterface_impl::attrStringSequence()
{
    return new StringSequence(aStringSequence);
}

void
TestInterface_impl::attrStringSequence(const TestInterface::StringSequence&
				       val)
{
    aStringSequence = val;
}

TestInterface::StringSequence*
TestInterface_impl::opStringSequence(const TestInterface::StringSequence& a0,
				     TestInterface::StringSequence& a1,
				     TestInterface::StringSequence*& a2)
{
    aStringSequence = a0;
    for(CORBA_ULong i = 0 ; i < a1.length() ; i++)
	aStringSequence.append(a1[i]);

    a1 = aStringSequence;
    a2 = new StringSequence(aStringSequence);
    return new StringSequence(aStringSequence);
}

TestInterface::StringSequence*
TestInterfaceEx_impl::
opStringSequenceEx(const TestInterface::StringSequence& a0,
		   TestInterface::StringSequence& a1,
		   TestInterface::StringSequence*&)
{
    aStringSequence = a0;
    for(CORBA_ULong i = 0 ; i < a1.length() ; i++)
	aStringSequence.append(a1[i]);

    throw ExStringSequence(aStringSequence);
    return new StringSequence; // Some compilers need this
}

TestInterface::FixedArray_slice*
TestInterface_impl::attrFixedArray()
{
    return FixedArray_dup(aFixedArray);
}

void
TestInterface_impl::attrFixedArray(const TestInterface::FixedArray val)
{
    FixedArray_copy(val, aFixedArray);
}

TestInterface::FixedArray_slice*
TestInterface_impl::opFixedArray(const TestInterface::FixedArray a0,
				 TestInterface::FixedArray a1,
				 TestInterface::FixedArray a2)
{
    FixedArray_copy(a0, aFixedArray);
    FixedArray_copy(aFixedArray, a1);
    FixedArray_copy(aFixedArray, a2);
    return FixedArray_dup(aFixedArray);
}

TestInterface::FixedArray_slice*
TestInterfaceEx_impl::opFixedArrayEx(const TestInterface::FixedArray a0,
				     TestInterface::FixedArray,
				     TestInterface::FixedArray)
{
    FixedArray_copy(a0, aFixedArray);
#ifdef HAVE_VCPLUSPLUS_BUGS
    throw ExFixedArray((const FixedArray_slice*)aFixedArray);
#else
    throw ExFixedArray(aFixedArray);
#endif
    return FixedArray_alloc(); // Some compilers need this
}

TestInterface::VariableArray_slice*
TestInterface_impl::attrVariableArray()
{
    return VariableArray_dup(aVariableArray);
}

void
TestInterface_impl::attrVariableArray(const TestInterface::VariableArray val)
{
    VariableArray_copy(val, aVariableArray);
}

TestInterface::VariableArray_slice*
TestInterface_impl::opVariableArray(const TestInterface::VariableArray a0,
				    TestInterface::VariableArray a1,
				    TestInterface::VariableArray_slice*& a2)
{
    VariableArray_copy(a0, aVariableArray);
    VariableArray_copy(aVariableArray, a1);
    a2 = VariableArray_dup(aVariableArray);
    return VariableArray_dup(aVariableArray);
}

TestInterface::VariableArray_slice*
TestInterfaceEx_impl::opVariableArrayEx(const TestInterface::VariableArray a0,
					TestInterface::VariableArray,
					TestInterface::VariableArray_slice*&)
{
    VariableArray_copy(a0, aVariableArray);
#ifdef HAVE_VCPLUSPLUS_BUGS
    throw ExVariableArray((const VariableArray_slice*)aVariableArray);
#else
    throw ExVariableArray(aVariableArray);
#endif
    return VariableArray_alloc(); // Some compilers need this
}

TestInterface::FixedArraySequence*
TestInterface_impl::attrFixedArraySequence()
{
    return new FixedArraySequence(aFixedArraySequence);
}

void
TestInterface_impl::
attrFixedArraySequence(const TestInterface::FixedArraySequence& val)
{
    aFixedArraySequence = val;
}

TestInterface::FixedArraySequence*
TestInterface_impl::
opFixedArraySequence(const TestInterface::FixedArraySequence& a0,
		     TestInterface::FixedArraySequence& a1,
		     TestInterface::FixedArraySequence*& a2)
{
    aFixedArraySequence.length(a0.length() + a1.length());
    
    CORBA_ULong i;
    CORBA_ULong n = 0;

    for(i = 0 ; i < a0.length() ; i++)
	FixedArray_copy(a0[i], aFixedArraySequence[n++]);
	
    for(i = 0 ; i < a1.length() ; i++)
	FixedArray_copy(a1[i], aFixedArraySequence[n++]);

    a1 = aFixedArraySequence;
    a2 = new FixedArraySequence(aFixedArraySequence);
    return new FixedArraySequence(aFixedArraySequence);
}

TestInterface::FixedArraySequence*
TestInterfaceEx_impl::
opFixedArraySequenceEx(const TestInterface::FixedArraySequence& a0,
		       TestInterface::FixedArraySequence& a1,
		       TestInterface::FixedArraySequence*&)
{
    aFixedArraySequence.length(a0.length() + a1.length());
    
    CORBA_ULong i;
    CORBA_ULong n = 0;

    for(i = 0 ; i < a0.length() ; i++)
	FixedArray_copy(a0[i], aFixedArraySequence[n++]);
	
    for(i = 0 ; i < a1.length() ; i++)
	FixedArray_copy(a1[i], aFixedArraySequence[n++]);

    throw ExFixedArraySequence(aFixedArraySequence);

    // Some compilers need this
    return new FixedArraySequence(aFixedArraySequence);
}

TestInterface::VariableArraySequence*
TestInterface_impl::attrVariableArraySequence()
{
    return new VariableArraySequence(aVariableArraySequence);
}

void
TestInterface_impl::
attrVariableArraySequence(const TestInterface::VariableArraySequence& val)
{
    aVariableArraySequence = val;
}

TestInterface::VariableArraySequence*
TestInterface_impl::
opVariableArraySequence(const TestInterface::VariableArraySequence& a0,
			TestInterface::VariableArraySequence& a1,
			TestInterface::VariableArraySequence*& a2)
{
    aVariableArraySequence.length(a0.length() + a1.length());
    
    CORBA_ULong i;
    CORBA_ULong n = 0;

    for(i = 0 ; i < a0.length() ; i++)
	VariableArray_copy(a0[i], aVariableArraySequence[n++]);
	
    for(i = 0 ; i < a1.length() ; i++)
	VariableArray_copy(a1[i], aVariableArraySequence[n++]);

    a1 = aVariableArraySequence;
    a2 = new VariableArraySequence(aVariableArraySequence);
    return new VariableArraySequence(aVariableArraySequence);
}

TestInterface::VariableArraySequence*
TestInterfaceEx_impl::
opVariableArraySequenceEx(const TestInterface::VariableArraySequence& a0,
			  TestInterface::VariableArraySequence& a1,
			  TestInterface::VariableArraySequence*&)
{
    aVariableArraySequence.length(a0.length() + a1.length());
    
    CORBA_ULong i;
    CORBA_ULong n = 0;

    for(i = 0 ; i < a0.length() ; i++)
	VariableArray_copy(a0[i], aVariableArraySequence[n++]);
	
    for(i = 0 ; i < a1.length() ; i++)
	VariableArray_copy(a1[i], aVariableArraySequence[n++]);

    throw ExVariableArraySequence(aVariableArraySequence);

    // Some compilers need this
    return new VariableArraySequence(aVariableArraySequence);
}

void
TestInterfaceEx_impl::op_UNKNOWN_Ex()
{
    throw CORBA_UNKNOWN(1, CORBA_COMPLETED_YES);
}

void
TestInterfaceEx_impl::op_BAD_PARAM_Ex()
{
    throw CORBA_BAD_PARAM(2, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_NO_MEMORY_Ex()
{
    throw CORBA_NO_MEMORY(3, CORBA_COMPLETED_MAYBE);
}

void
TestInterfaceEx_impl::op_IMP_LIMIT_Ex()
{
    throw CORBA_IMP_LIMIT(4, CORBA_COMPLETED_YES);
}

void
TestInterfaceEx_impl::op_COMM_FAILURE_Ex()
{
    throw CORBA_COMM_FAILURE(5, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_INV_OBJREF_Ex()
{
    throw CORBA_INV_OBJREF(6, CORBA_COMPLETED_MAYBE);
}

void
TestInterfaceEx_impl::op_NO_PERMISSION_Ex()
{
    throw CORBA_NO_PERMISSION(7, CORBA_COMPLETED_YES);
}

void
TestInterfaceEx_impl::op_INTERNAL_Ex()
{
    throw CORBA_INTERNAL(8, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_MARSHAL_Ex()
{
    throw CORBA_MARSHAL(9, CORBA_COMPLETED_MAYBE);
}

void
TestInterfaceEx_impl::op_INITIALIZE_Ex()
{
    throw CORBA_INITIALIZE(10, CORBA_COMPLETED_YES);
}

void
TestInterfaceEx_impl::op_NO_IMPLEMENT_Ex()
{
    throw CORBA_NO_IMPLEMENT(11, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_BAD_TYPECODE_Ex()
{
    throw CORBA_BAD_TYPECODE(12, CORBA_COMPLETED_MAYBE);
}

void
TestInterfaceEx_impl::op_BAD_OPERATION_Ex()
{
    throw CORBA_BAD_OPERATION(13, CORBA_COMPLETED_YES);
}

void
TestInterfaceEx_impl::op_NO_RESOURCES_Ex()
{
    throw CORBA_NO_RESOURCES(14, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_NO_RESPONSE_Ex()
{
    throw CORBA_NO_RESPONSE(15, CORBA_COMPLETED_MAYBE);
}

void
TestInterfaceEx_impl::op_PERSIST_STORE_Ex()
{
    throw CORBA_PERSIST_STORE(16, CORBA_COMPLETED_YES);
}

void
TestInterfaceEx_impl::op_BAD_INV_ORDER_Ex()
{
    throw CORBA_BAD_INV_ORDER(17, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_TRANSIENT_Ex()
{
    throw CORBA_TRANSIENT(18, CORBA_COMPLETED_MAYBE);
}

void
TestInterfaceEx_impl::op_FREE_MEM_Ex()
{
    throw CORBA_FREE_MEM(19, CORBA_COMPLETED_YES);
}

void
TestInterfaceEx_impl::op_INV_IDENT_Ex()
{
    throw CORBA_INV_IDENT(20, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_INV_FLAG_Ex()
{
    throw CORBA_INV_FLAG(21, CORBA_COMPLETED_MAYBE);
}

void
TestInterfaceEx_impl::op_INTF_REPOS_Ex()
{
    throw CORBA_INTF_REPOS(22, CORBA_COMPLETED_YES);
}

void
TestInterfaceEx_impl::op_BAD_CONTEXT_Ex()
{
    throw CORBA_BAD_CONTEXT(23, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_OBJ_ADAPTER_Ex()
{
    throw CORBA_OBJ_ADAPTER(24, CORBA_COMPLETED_MAYBE);
}

void
TestInterfaceEx_impl::op_DATA_CONVERSION_Ex()
{
    throw CORBA_DATA_CONVERSION(25, CORBA_COMPLETED_YES);
}

void
TestInterfaceEx_impl::op_OBJECT_NOT_EXIST_Ex()
{
    throw CORBA_OBJECT_NOT_EXIST(26, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_TRANSACTION_REQUIRED_Ex()
{
    throw CORBA_TRANSACTION_REQUIRED(27, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_TRANSACTION_ROLLEDBACK_Ex()
{
    throw CORBA_TRANSACTION_ROLLEDBACK(28, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_INVALID_TRANSACTION_Ex()
{
    throw CORBA_INVALID_TRANSACTION(29, CORBA_COMPLETED_NO);
}

void
TestInterfaceEx_impl::op_INV_POLICY_Ex()
{
    throw CORBA_INV_POLICY(30, CORBA_COMPLETED_NO);
}

void
TestInterface_impl::releaseInternal()
{
    //
    // Avoid cyclic object dependencies
    //
    aTestInterface = TestInterface::_nil();
    aVariableUnion = VariableUnion();
}

void
TestInterface_impl::deactivate()
{
    //
    // Deactivate the server
    //
    CORBA_BOA_var boa = _boa();
    boa -> deactivate_impl(CORBA_ImplementationDef::_nil());
}

void
TestInterfaceTimeout_impl::sleepOneway(CORBA_ULong sec)
{
#ifdef WIN32
    Sleep(sec * 1000);
#else
    sleep(sec);
#endif
};

void
TestInterfaceTimeout_impl::sleepTwoway(CORBA_ULong sec)
{
#ifdef WIN32
    Sleep(sec * 1000);
#else
    sleep(sec);
#endif
};

