# **********************************************************************
#
# Copyright (c) 1999
# Object Oriented Concepts, Inc.
# Billerica, MA, USA
#
# All Rights Reserved
#
# **********************************************************************

top_srcdir	= ..

LIB_NAME	= $(top_srcdir)\lib\CosProperty.lib
CLIENT_NAME	=
SERVER_NAME	= $(top_srcdir)\bin\propserv.exe

LIB_PDB_NAME    = $(top_srcdir)\lib\CosProperty.pdb

UTILS           = $(SERVER_NAME) \
		  $(CLIENT_NAME)

#
# Work around the inference rules problem with nmake.
#
!ifndef BUILD_UTILS

PDB_FLAGS       = /Fd$(LIB_PDB_NAME)
TARGETS		= $(LIB_NAME)

!else

TARGETS 	= $(UTILS)

!endif

!include $(top_srcdir)\config\Make.rules.mak

IDLDIR		= $(top_srcdir)\idl
HDIR		= $(top_srcdir)\include\OB

LIB_OBJS	= CosProperty.obj \
		  CosProperty_skel.obj \
		  CosProperty_impl.obj

COMMON_OBJS	=

CLIENT_OBJS	=

SERVER_OBJS	= CosProperty_impl.obj \
		  Server.obj

ALL_CXXFLAGS	= $(CXXFLAGS) $(PDB_FLAGS)
ALL_CPPFLAGS	= /I. /I$(top_srcdir)\include $(OB_CPPFLAGS) $(CPPFLAGS)
ALL_LIBS	= $(LIB_NAME) $(OB_LIBS) $(LIBS)
 
$(LIB_NAME): $(LIB_OBJS)
	$(AR) $(ARFLAGS) /out:$@ $(LIB_OBJS)

$(SERVER_NAME): $(COMMON_OBJS) $(SERVER_OBJS) $(LIB_NAME)
	$(LINK) $(LINKFLAGS) /out:$@ \
	$(COMMON_OBJS) $(SERVER_OBJS) $(ALL_LIBS)
 
CosProperty.cpp $(HDIR)\CosProperty.h: $(IDLDIR)\CosProperty.idl
	del /q CosProperty.cpp $(HDIR)\CosProperty.h
	del /q CosProperty_skel.cpp $(HDIR)\CosProperty_skel.h
	$(IDL) -I$(IDLDIR) --header-dir OB $(IDLDIR)\CosProperty.idl
	move CosProperty.h $(HDIR)
	move CosProperty_skel.h $(HDIR)

CosProperty_skel.cpp $(HDIR)\CosProperty_skel.h: CosProperty.cpp

Config.h:
	echo /* dummy file */ > $@

!ifndef BUILD_UTILS

install:: all

all depend install clean test::
	$(MAKE) /f Makefile.mak BUILD_UTILS=1 $@

!else

install:: all
	copy $(LIB_NAME) $(libdir)
	copy $(LIB_PDB_NAME) $(libdir)
	copy $(SERVER_NAME) $(bindir)

!endif

!include .windep
