c-----------------------------------------------------------------------
c
c> General purpose tape program to process foreign NL tapes
c> The tapes are assumed to be fixed blocksize (FB) with nospanned
c> record lengths, (blocklen is a multiple of the reclen)
c
c  Ejo Schrama                 Contact list (use item 1 as priority first)
c  Dep. of Geodesy             1) gdfgejo@hdetud51.bitnet   earn/bitnet
c  Thijsseweg 11               2) gdfgejo@hdetud1.bitnet    earn/bitnet
c  TU Delft                    3) schrama@hdetud5.bitnet    earn/bitnet
c  2629 JA Delft               4) tudgv1::schrama           surfnet
c  The Netherlands             5) Country=31 015 784975     voice
c
c Usage:
c
c Say $ mount/foreign mt:
c Simply run the program and answer all questions.
c
c-----------------------------------------------------------------------
      program readnl
      implicit none
 
      parameter in=5,out=6,outlu=1
 
      include '($ssdef)'
 
      byte block(65535)
      character*1 option
      integer*2 code
      integer*4 status,len,nrblk,iskip,optioncode
      integer*4 lrecl,blksize,skips,l1,l2,i,filenr
      character*80 tapename,outda
      logical go
 
      write(out,*) 'Reading NL tapes, E. Schrama 13-apr-89.'
      write(out,*)
      write(out,*) 'A short description:'
      write(out,*)
      write(out,*) '  1) I will attempt to assign a tape channel.'
      write(out,*) '  2) I attempt to rewind the tape.'
      write(out,*) '  3) A tape name is asked (any string will do).'
      write(out,*) '  4) File number to start at?'
      write(out,*) '  5) EBCDIC/ASCII conversion required?'
      write(out,*)
      write(out,*) 'Items 1) till 5) are always carried out, it follows:'
      write(out,*)
      write(out,*) '  6) Blocksize and record length of the file on tape?'
      write(out,*) '  7) Output disk file for that one?'
      write(out,*) '  8) Do a following file? (if true then goto 6)'
      write(out,*)
      write(out,*) 'At last:'
      write(out,*)
      write(out,*) '  9) Rewind tape'
      write(out,*) ' 10) Terminate program'
      write(out,*)
 
      call tape_assign(status)
      if (status.ne.1) then
        call lib$signal(%val(status))
        stop 'error assigning tape.'
      endif
 
      call tape_rewind(status,code)
      if (status.ne.1) then
        call lib$signal(%val(status))
        stop 'error rewinding tape.'
      endif
      if (code.ne.ss$_normal) stop 'error rewinding tape.'
 
      write(out,'('' Enter tape name (optional)      : '',$)')
      read(in,'(q,a)',end=9999) l1,tapename
 
      write(out,'('' Enter file nr on tape (1=first) : '',$)')
      read(in,*,end=9999) skips
      filenr=skips
      skips=skips-1
      do iskip=1,skips ! perform skipping of blocks
 4      continue
          call tape_getblk(block,len,status,code)
          if (code.eq.ss$_endoffile) goto 5
          if (code.eq.ss$_parity) then
            call parerr('parity error at skipping blocks loop')
          end if
        goto 4
 5      continue
      end do
 
      write(out,'('' Data is [E]bcdic or [A]scii     : '',$)')
      read(in,'(A)',end=9999) option
      optioncode=0
      if (option.eq.'a') optioncode=0
      if (option.eq.'A') optioncode=0
      if (option.eq.'e') optioncode=1
      if (option.eq.'E') optioncode=1
 
 1    write(out,'('' Enter blksize,reclen            : '',$)')
      read(in,*,end=9999) blksize,lrecl
 
      write(out,'('' Please enter output file name   : '',$)')
      read(in,'(q,a)',end=9999) l2,outda
 
      write(out,1000) tapename(1:l1),filenr,blksize,lrecl,outda(1:l2)
 1000 format(/' From the tape ',a,
     -       ' file#',i2.2,
     -       ' with block size ',i5,
     -       ' and record size ',i3,/
     -       ' a copy will be made in file ',a/)
 
      open(unit=outlu,file=outda,status='new',carriagecontrol='list')
      rewind outlu
      nrblk=0
 10   len=65535
        call tape_getblk(block,len,status,code)
        nrblk=nrblk+1
        if (code.eq.ss$_endoffile) goto 20
        if (code.eq.ss$_parity) then
          call parerr('parity error at processing blocks loop')
        end if
        call process(block,len,outlu,lrecl,blksize,optioncode)
      goto 10
 20   continue
      close(outlu)
      write(out,'('' Number of blocks processed :'',i5)') nrblk
 
      write(out,'('' Do next file (t) or stop program (f) ?'',$)')
      read(in,*,end=9999) go
      filenr=filenr+1
      if (go) goto 1
 
      write(out,*) 'rewind tape'
      call tape_rewind(status,code)
      if (status.ne.1) then
        call lib$signal(%val(status))
        stop 'error rewinding tape.'
      endif
      if (code.ne.ss$_normal) stop 'error rewinding tape.'
 
 9999 write(out,*) 'Have a nice day, please DISMOUNT the tape.'
      end
c------------------------------------------------------------------------
      subroutine process(block,len,lu,lrecl,blksize,optioncode)
      implicit none
 
      parameter imax=256  ! (max record length)
 
      byte block(1),char,char1,rec(imax)
      integer len,i,j,lu,lrecl,blksize,optioncode
      integer istat,lib$tra_ebc_asc
 
      if (len.gt.blksize) stop 'block taken greater than blksize.'
      if (mod(len,lrecl).ne.0) stop 'block taken no multiple of lrecl.'
      if (lrecl.gt.imax) stop 'max record length equals to 256.'
 
      do i=0,len-lrecl,lrecl
        if (optioncode.eq.0) then
          do j=1,lrecl
            rec(j)=block(i+j)
          end do
        else
          do j=1,lrecl
            char=block(i+j)
            istat=lib$tra_ebc_asc(%descr(char),%descr(char1))
            rec(j)=char1
          end do
        end if
        write(lu,'(<lrecl>a1)') (rec(j),j=1,lrecl)
      end do
 
      return
      end
c------------------------------------------------------------------------
c
c Parity error conflicts
c
c------------------------------------------------------------------------
      subroutine parerr(message)
      implicit none
 
      character*(*) message
      character*1 option
      integer irc
 
      write(6,*)
      write(6,*) 'Warning --->'//message
      write(6,*)
 
 10   write(6,'('' What to do, (a)bort or (c)ontinue ?'')')
      read(5,'(a)',end=10,err=10) option
 
      irc=-1
      if (option.eq.'A') irc=1
      if (option.eq.'a') irc=1
      if (option.eq.'C') irc=0
      if (option.eq.'c') irc=0
 
      if(irc.eq.-1) goto 10
 
      if (irc.eq.1) stop
 
      end
