###########################################################################
# MMS/MMK file for Samba for VMS
# by Eckart Meyer 1995,1996
# derived from
# Makefile for Samba SMB client/server for unix
# Copyright Andrew Tridgell 1992,1993,1994
###########################################################################

O = OBJ_$(__ARCH)
EXE = EXE_$(__ARCH)
OLB = OLB_$(__ARCH)
LIS = LIS_$(__ARCH)
MAP = MAP_$(__ARCH)
.SUFFIXES
.SUFFIXES : .$(EXE) .$(OLB) .$(O) .C

# Add any optimisation or debugging flags here
#FLAGS1 = /DEBUG/NOOPTIMIZE/LIST=$*.$(LIS)/SHOW=ALL
#FLAGS1 = /DEBUG/NOOPTIMIZE $(CDEBUG)
FLAGS1 = $(CDEBUG)
#LIBS1 = /DEBUG
LIBS1 = $(LDEBUG)

.IFDEF __SOCKETSHR__
TCPIP = ,SOCKETSHR.OPT/OPT
.ELSE
.IFDEF __DECC__
TCPIP =
.ELSE
TCPIP = ,SYS$LIBRARY:UCX$IPC/LIB
.ENDIF
.ENDIF

.IFDEF __DECC__
VAXCRTL =
.ELSE
VAXCRTL = ,VAXCRTL.OPT/OPT
.ENDIF

.IFDEF __ALPHA__
LINK = LINK/EXE=$*.$(EXE)
SYSEXE = /SYSEXE
.ELSE
LINK = LINK/EXE=$*.$(EXE)
SYSEXE = ,SYS$SYSTEM:SYS.STB/SELECTIVE_SEARCH
.ENDIF

LIBS2 = $(VAXCRTL) $(TCPIP)

LIBR = LIBRARY/REPLACE

DEFINES =
FLAGSM = /OBJ=$*.$(O) /DEFINE=(MODULE_NAME=$*$(DEFINES))
#LIBSM = /map=$*.$(MAP)
#LIBSM = /debug
LIBSM =


CC = $(CC)/DECC conf.h+
CFLAGS  = $(__CFLAGS) $(FLAGSM) $(FLAGS1)
LIBS = $(LIBS1) $(LIBSM) $(LIBS2)

SPROGS = smbd nmbd
PROGS1 = smbclient testparm testprns smbstatus smbpasswd 
PROGS = $(PROGS1) nmblookup
SCRIPTS = smbtar addtosmbpass


.FIRST
	@ show default
.IFDEF SAMBA_SETUP_DONE
.ELSE
	@ write sys$output ""
	@ write sys$output "Type ""@[.vms]setup"" and then try again"
	@ write sys$output ""
	@ a = samba_setup_done	! produces an error an stops mms
.ENDIF

.c.$(O) : $(INCLUDES)
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

all : $(SPROGS) $(PROGS)
	-@ !

INCLUDES1 = version.h local.h includes.h smb.h 
INCLUDES2 = trans2.h 
INCLUDES = $(INCLUDES1) $(INCLUDES2)


VMSOBJ = vms_sup.$(O) vms_dir.$(O) get.$(O) stat.$(O) getopt.$(O) priv.$(O) \
	setuid.$(O) setuser.$(O) hpwd.$(O) stm_read.$(O) posixtim.$(O) \
	tcp.$(O) utime.$(O)

UTILOBJ1 = $(VMSOBJ) util.$(O) system.$(O) charset.$(O) kanji.$(O) fault.$(O) smbencrypt.$(O) charcnv.$(O) 
UTILOBJ2 = $(UTILOBJ1) md4.$(O) loadparm.$(O) params.$(O) pcap.$(O) username.$(O) time.$(O) 
UTILOBJ = $(UTILOBJ2) interface.$(O) replace.$(O) 
PARAMOBJ = $(UTILOBJ) ufc.$(O) smbpass.$(O) access.$(O) shmem.$(O) 
SMBDOBJ1 = $(PARAMOBJ) trans2.$(O) pipes.$(O) message.$(O) dir.$(O) printing.$(O) locking.$(O) 
SMBDOBJ2 = ipc.$(O) reply.$(O) mangle.$(O) chgpasswd.$(O) password.$(O) quotas.$(O) uid.$(O) 
SMBDOBJ = predict.$(O) clientgen.$(O) $(SMBDOBJ1) $(SMBDOBJ2) $(VTP_OBJ) 
NMBDOBJ1 = nmblib.$(O) namepacket.$(O) nameresp.$(O) nmbsync.$(O) nameannounce.$(O) nameelect.$(O) 
NMBDOBJ2 = namedbresp.$(O) namedbwork.$(O) namedbserver.$(O) namedbsubnet.$(O) namedbname.$(O)  
NMBDOBJ3 = nameservresp.$(O) nameservreply.$(O) namelogon.$(O) namebrowse.$(O) namework.$(O) nameserv.$(O) clientutil.$(O) 
NMBDOBJ = $(UTILOBJ) $(NMBDOBJ1) $(NMBDOBJ2) $(NMBDOBJ3) 


smbd :		smbd.$(EXE)
	-@ !

#smbrun :	smbrun.$(EXE)
#	-@ !

nmblookup :	nmblookup.$(EXE)
	-@ !

nmbd :		nmbd.$(EXE)
	-@ !

smbclient :	smbclient.$(EXE)
	-@ !

smbstatus :	smbstatus.$(EXE)
	-@ !

testparm :	testparm.$(EXE)
	-@ !

testprns :	testprns.$(EXE)
	-@ !

smbpasswd :	smbpasswd.$(EXE)
	-@ !


smbd.$(EXE) :	server.$(O) $(SMBDOBJ)
	$(LINK) server.$(O),samba.$(OLB)/lib $(LIBS) $(SYSEXE)

#smbrun.$(EXE) :	smbrun.$(O)
#	$(LINK) smbrun.$(O) $(LIBS)

nmblookup.$(EXE) :	nmblookup.$(O) namequery.$(O) nmblib.$(O) $(UTILOBJ)  
	$(LINK) nmblookup.$(O),samba.$(OLB)/lib $(LIBS)

nmbd.$(EXE) :	nmbd.$(O) $(NMBDOBJ) 
	$(LINK) nmbd.$(O),samba.$(OLB)/lib $(LIBS)

smbclient.$(EXE) :	client.$(O) clitar.$(O) getsmbpass.$(O) namequery.$(O) \
			nmblib.$(O) $(UTILOBJ) 
	$(LINK) client.$(O),samba.$(OLB)/lib $(LIBS)

smbstatus.$(EXE) :	status.$(O) $(PARAMOBJ) 
	$(LINK) status.$(O),samba.$(OLB)/lib $(LIBS)

testparm.$(EXE) :	testparm.$(O) $(PARAMOBJ)
	$(LINK) testparm.$(O),samba.$(OLB)/lib $(LIBS)

testprns.$(EXE) :	testprns.$(O) $(PARAMOBJ)
	$(LINK) testprns.$(O),samba.$(OLB)/lib $(LIBS)

smbpasswd.$(EXE) :	smbpasswd.$(O) getsmbpass.$(O) $(PARAMOBJ)
	$(LINK) smbpasswd.$(O),samba.$(OLB)/lib $(LIBS)


server.$(O) :	server.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O) /noglobal

nmbd.$(O) :	nmbd.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O) /noglobal

nmblookup.$(O) :	nmblookup.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O) /noglobal

status.$(O) :	status.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O) /noglobal

testparm.$(O) :	testparm.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O) /noglobal

client.$(O) :	client.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O) /noglobal

smbpasswd.$(O) :	smbpasswd.c
	$(CC) $*.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O) /noglobal

#
# VMS support modules
#

vms_sup.$(O) :	[.vms]vms_sup.c
	$(CC) [.vms]vms_sup.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

vms_dir.$(O) :	[.vms]vms_dir.c
	$(CC) [.vms]vms_dir.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

get.$(O) :	[.vms]get.c
	$(CC) [.vms]get.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

stat.$(O) :	[.vms]stat.c
	$(CC) [.vms]stat.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

getopt.$(O) :	[.vms]getopt.c
	$(CC) [.vms]getopt.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

hpwd.$(O) :	[.vms]hpwd.c
	$(CC) [.vms]hpwd.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

priv.$(O) :	[.vms]priv.c
	$(CC) [.vms]priv.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

setuid.$(O) :	[.vms]setuid.c
	$(CC) [.vms]setuid.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

setuser.$(O) :	[.vms]setuser.mar
	MACRO/OBJ=.$(O) [.vms]setuser.mar
	$(LIBR) samba.$(OLB) $*.$(O)

stm_read.$(O) :	[.vms]stm_read.c
	$(CC) [.vms]stm_read.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

posixtim.$(O) :	[.vms]posixtim.c
	$(CC) [.vms]posixtim.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

tcp.$(O) :	[.vms]tcp.c
	$(CC) [.vms]tcp.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

utime.$(O) :	[.vms]utime.c
	$(CC) [.vms]utime.c $(CFLAGS) 
	$(LIBR) samba.$(OLB) $*.$(O)

