/*
 * intro.c  
 *
 * Copyright 1999 Allan Latham <alatham@flexsys-group.com>
 *
 */

#include "clddmount.h"
#include <stdio.h>
#include <unistd.h>
#include <sys/resource.h>


int cldd_intro (const char *progname)
{
	struct rlimit	rlim;

	printf("\n%s, version %01d.%01d (c) 1999 Allan Latham <alatham@flexsys-group.com>\n\n", progname, CLDD_VERSION/10, CLDD_VERSION%10);
	printf("This is licenced software but no charge is made for its use.\n");
	printf("NO WARRANTY whatsoever is offered with this product.\n");
	printf("NO LIABILITY whatsoever is accepted for its use.\n");
	printf("You are using this entirely at your OWN RISK.\n");
	printf("See the GNU Public Licence for full details.\n\n");

	rlim.rlim_cur = 0;
	rlim.rlim_max = 0;
	setrlimit(RLIMIT_CORE, &rlim);

	if (getuid()) {
	    CLDDERROR(201)
	    return 1;
	}
	return 0;
}
