/*
 * This file provides a wrapper that integrates the getstats 1.2 program 
 * with a CGI script that runs in response to a HTML form submission.
 *
 * If the program is run interactively and not as script, the arguments
 * are interpreted by the regular getstats main().  When run as a CGI script,
 * the getstats main() routine is called using an argument vector synthesized
 * from the data posted by the form.
 *
 * Author: David Jones
 * Date:   14-JUL-1994
 * Revised: 19-JUL-1994		Fixes for use with DECC.
 *
 * Adapted for use by both the CERN and OSU DECthreads servers on
 * 06-JAN-1995 by Foteos Macrides, macrides@sci.wfeb.edu.
 */
#include "getstats_tailor.h"
#include <stdlib.h>
/*
 * re-define printf/putchar to vector though a global pointer so we
 * can use either printf() or cgi_printf.
 */
#include <string.h>
#include <stdio.h>			/* Pick up any printf/putchar defs */
static int (*printf_proc)() = &printf;	/* default to standard printf*/

#ifdef printf
#undef printf
#endif
#define printf (*printf_proc)

#ifdef puchar
#undef putchar
#endif
#define putchar(x) (*printf_proc)("%c",x)
#if defined(UCXTCP) || defined(TCPWARE)
#ifndef UCX
#define UCX 1
#endif
#endif
/*
 */
#if defined(CGI) && !defined(NOCGILIB)
#include "cgilib.h"
#include "scriptlib.h"
#else
#define cgi_init(a,b)  1
#define cgi_info(a) getenv(strcpy(&cgi_info_buf[4], a)-4)
static char cgi_info_buf[64] = { 'W', 'W', 'W', '_' };
#define cgi_printf printf
static FILE *cgi_content_file() { return stdin; }
#endif /* CGI && !NOCGILIB */
/*
 * Make jacket main for getstats.
 */
int main ( int argc, char **argv )
{
    int form_request(), getstats_main();
    if ( argc > 1 ) if ( (strcmp(argv[1],"POST")==0) ||
			     (strcmp(argv[1],"GET" )==0) ) {
	/*
	 * Argument is not an option, assume this is CGI form request.
	 */
	printf_proc = &cgi_printf;
	if ( !form_request ( &argc, &argv ) ) exit(1);
    } else {
	/*
	 * Attempt to determine server name dynamically.
	 */
	char *site = getenv ( "GETSTATS_SERVERSITE" );
	if ( site ) {
	    server_site_string = malloc ( strlen(site) + 1 );
	    strcpy ( server_site_string, site );
	}
#if defined(CGI) && !defined(NOCGILIB)
	/* Assume script wrapper will put in CGI or RAW mode. */
	if ( getenv ( "NET_LINK" ) ) {
	    net_link_open();
	    printf_proc = &net_link_printf;
	}
#endif /* CGI && !NOCGILIB */
    }
    return getstats_main ( argc, argv );
}

#ifdef VAXC
FILE *opt_fopen ( char *fname, char *mode, ... )
{
    return fopen ( fname, mode, "mbc=64", "shr=put", "shr=upd" );
}
#define fopen opt_fopen
#endif
/*
 * The author of getstats, Kevin Hughes (kevinh@eit.com) insists that getstats.c
 * be distributed in its original form.
 */
#ifdef __DECC
int getstats_main ( int argc, char **argv ) {
    void getstats_main2();
    getstats_main2 ( argc, argv );
    return 1;
}
int inet_addr(), isvalidreq();

#define noshare
#define main getstats_nullmain; void getstats_main2
#else
#define main getstats_main
#endif
#include "getstats_12-orig.c"
#undef main
