/*
 * Define thread-friendly wrappers for basic  TCP/IP client operations.
 */
typedef void  *tc_socket;

int tc_open_tcp_socket ( 
    char *target_host, 			/* Remote host to connect to */
    int target_port, 			/* Report port, (local port 'ANY') */
    int attr_count,			/* Optional attributes */
    char **attributes, 			/* Attribute specifcations, see below */
    tc_socket *cnx, 			/* Handle to connection */
    char err_msg[256] );		/* Description of error code, if any */

int tc_close ( tc_socket cnx );		/* Synchronous close */
int tc_detach ( tc_socket cnx );	/* allow shareing of connection */
int tc_attach ( tc_socket cnx );	/* allow shareing of connection */

/*
 * Time limit only affects reads and writes.
 */
int tc_set_time_limit ( tc_socket cnx,  int seconds );
int tc_write ( tc_socket, void *buffer, int bufsize, int *written );
int tc_read ( tc_socket, void *buffer, int bufsize, int *written );
/*
 * The following routines define an aynchronous interface for full duplex
 * operation.  The start_io function initiates a read or write operation as
 * indicated by the direction argument (0-write, 1-read).  Initiating a read
 * while a read is pending or a write while a write is pending is an error,
 * however a read and write may be pending at the same time.
 *
 * The io_stall function blocks the thread until a pending I/O operation
 * completes or another thread calls tc_attention.  The flags argument
 * returns status bits:
 *	0 - if set, write completed with bytes_written bytes transferred.
 *      1 - if set, read completed with bytes_read bytes transferred.
 *      2 - Unexpected return status of system service operation.
 *      3 - If set, attention routine has been called.
 */
int tc_start_io ( tc_socket cnx, int direction, void *buffer, int bufsize );
int tc_io_stall ( tc_socket cnx, int *flags, int *bytes_read, int *bytes_written );
int tc_attention ( tc_socket cnx );
/*
 * The attributes argument in tc_open_tcp_socket is an array of character
 * pointers where is character string specifies an attribute modifier
 * for the created socket.
 *
 *    "local_port=nnn"		Use local port of nnn rather than 'ANY'
 *    "keepalive"		Set keepalive attribute.
 */
