

#include <stdio.h>
#include <math.h>

int TwoSides;
int NPTS;
float RAD;
float CRAD;

main(argc, argv)
    int argc;
    char **argv;
{
	int i, j, Div;
	double f, turn, x, y, z, y2;
	int t1, t2, t3, t4;

	if (argc > 3)
	{
		fprintf(stderr, "usage: %s [-p<num_pts>] [-r<radius>] [-two]\n",
			argv[0]);
	}
	TwoSides = 0;
	NPTS = 0;
	RAD = 0.2;
	CRAD = 1.0;
	for (i = 1; i < argc; i++)
	{
		if ((argv[i][0] == '-')&&(argv[i][1] == 'p'))
		{
			NPTS = atoi(&argv[i][2]);
		}
		else if ((argv[i][0] == '-')&&(argv[i][1] == 'r'))
		{
			RAD = atof(&argv[i][2]);
			if (RAD <= 0.0)
			{
				fprintf(stderr, "Warning RAD (%f) is too small setting it to 0.2\n", RAD);
				RAD = 0.2;
			}
		}
		else if ((argv[i][0] == '-')&&(argv[i][1] == 'R'))
		{
			CRAD = atof(&argv[i][2]);
			if (CRAD <= 0.0)
			{
				fprintf(stderr, "Warning CRAD (%f) is too small setting it to 1.0\n", CRAD);
				CRAD = 1.0;
			}
		}
	}

	if (NPTS == 0)
	{
		fprintf(stderr, "Warning no points argument passed.\n");
		fprintf(stderr, "Setting Number of Points to 20\n");
		NPTS = 20;
	}

	Div = (int)(RAD * NPTS);
	Div = Div / 2;
	if (Div < 1)
	{
		Div = 1;
	}

	printf("%d\n", (NPTS * (Div * 2 + 1)));
	printf("%d\n", (Div * 2 * NPTS * 4));
	for (i=0; i<NPTS; i++)
	{
		f = ((double)i * 2 / NPTS);
		x = CRAD * sin(f * M_PI);
		y = CRAD * cos(f * M_PI);
		turn = ((double)i / NPTS);
		for (j=0; j<Div; j++)
		{
			z = RAD * (Div - j) / Div * cos(turn * M_PI);
			y2 = RAD * (Div - j) / Div * sin(turn * M_PI);
			printf("%lf %lf %lf\n", x, y + y2, z);
		}
		printf("%lf %lf %lf\n", x, y, 0.0);
		for (j=1; j<=Div; j++)
		{
			z = RAD * j / Div * cos(turn * M_PI);
			y2 = RAD * j / Div * sin(turn * M_PI);
			printf("%lf %lf %lf\n", x, y - y2, -z);
		}
	}

	t1 = 0;
	t2 = 1;
	t3 = Div * 2 + 1;
	t4 = t3 + 1;
	for (i=0; i<(NPTS - 1); i++)
	{
		for (j=0; j<(Div * 2); j++)
		{
			printf("%d %d %d P2\n", t1, t2, t4);
			printf("%d %d %d P2\n", t1, t4, t3);
			t1++;
			t2++;
			t3++;
			t4++;
		}
		t1++;
		t2++;
		t3++;
		t4++;
	}
	t3 = Div * 2;
	t4 = t3 - 1;
	for (j=0; j<(Div * 2); j++)
	{
		printf("%d %d %d P2\n", t1, t2, t4);
		printf("%d %d %d P2\n", t1, t4, t3);
		t1++;
		t2++;
		t3--;
		t4--;
	}

	t1 = 0;
	t2 = 1;
	t3 = Div * 2 + 1;
	t4 = t3 + 1;
	for (i=0; i<(NPTS - 1); i++)
	{
		for (j=0; j<(Div * 2); j++)
		{
			printf("%d %d %d P3\n", t1, t4, t2);
			printf("%d %d %d P3\n", t1, t3, t4);
			t1++;
			t2++;
			t3++;
			t4++;
		}
		t1++;
		t2++;
		t3++;
		t4++;
	}
	t3 = Div * 2;
	t4 = t3 - 1;
	for (j=0; j<(Div * 2); j++)
	{
		printf("%d %d %d P3\n", t1, t4, t2);
		printf("%d %d %d P3\n", t1, t3, t4);
		t1++;
		t2++;
		t3--;
		t4--;
	}

	printf("Colormap 256\n");
	printf("red green blue\n");
	printf("0 0 0\n");
	printf("0 0 0\n");
	printf("255 0 0\n");
	printf("0 0 255\n");
}

