/*
 * This implements a sorted binary tree to do Z buffering.
 */
#include <stdio.h>
#include "list.h"

#define	M_VAL	2

extern int	*AllPolys, *iptr;
extern float	*AllPts;
extern float	*AllProbs;
extern int	*AllPixels;
extern int	LowMem;


struct node_rec *TreeRoot = NULL;



/*
 * Insert a polygon into the tree based on its Z value.
 */
struct list_rec *
InsertVal(vptr, nptr)
	struct list_rec *vptr;
	struct node_rec *nptr;
{
	struct node_rec *t_nptr;
	struct list_rec *t_lptr;
	int cnt;

	t_lptr = nptr->list;
	if (t_lptr->z >= vptr->z)
	{
		t_lptr = vptr;
		t_lptr->next = nptr->list;
		nptr->list = t_lptr;
	}
	else
	{
		while (t_lptr->next != NULL)
		{
			if (t_lptr->next->z >= vptr->z)
			{
				break;
			}
			t_lptr = t_lptr->next;
		}
		vptr->next = t_lptr->next;
		t_lptr->next = vptr;
	}

	cnt = 0;
	t_lptr = nptr->list;
	while (t_lptr != NULL)
	{
		cnt++;
		t_lptr = t_lptr->next;
	}
	t_lptr = NULL;
	if (cnt > M_VAL)
	{
		t_lptr = nptr->list;
		cnt = 1;
		while (cnt < (M_VAL / 2))
		{
			t_lptr = t_lptr->next;
			cnt++;
		}
		t_nptr = (struct node_rec *)XtMalloc(sizeof(struct node_rec));
		t_nptr->list = nptr->list;
		nptr->list = t_lptr->next;
		t_lptr->next = NULL;
		t_nptr->next = nptr->list->left;
		nptr->list->left = t_nptr;
		t_lptr = nptr->list;
		nptr->list = nptr->list->next;
		if (nptr == TreeRoot)
		{
			TreeRoot = (struct node_rec *)XtMalloc(sizeof(struct node_rec));
			TreeRoot->list = t_lptr;
			t_lptr->next = NULL;
			TreeRoot->next = nptr;
			t_lptr = NULL;
		}
	}
	return(t_lptr);
}


/*
 * Find a polygon in the tree.  If you can't find it, insert it, and then
 * return the inserted position.
 */
struct list_rec *
FindVal(vptr, nptr)
	struct list_rec *vptr;
	struct node_rec *nptr;
{
	struct list_rec *t_lptr;
	struct list_rec *ret;
	int found;

	found = 0;
	t_lptr = nptr->list;
	while (t_lptr != NULL)
	{
		if (t_lptr->z >= vptr->z)
		{
			if (t_lptr->left != NULL)
			{
				found = 1;
				ret = FindVal(vptr, t_lptr->left);
				if (ret != NULL)
				{
					ret = InsertVal(ret, nptr);
				}
			}
			break;
		}
		t_lptr = t_lptr->next;
	}
	if (t_lptr == NULL)
	{
		if (nptr->next != NULL)
		{
			found = 1;
			ret = FindVal(vptr, nptr->next);
			if (ret != NULL)
			{
				ret = InsertVal(ret, nptr);
			}
		}
	}
	if (found == 0)
	{
		ret = InsertVal(vptr, nptr);
	}
	return(ret);
}


/*
 * Turn a polygon into a list structure, and then add it.
 */
void
AddList(indx, dist, cosine_theta)
	int indx;
	float dist;
	float cosine_theta;
{
	struct list_rec *list_ptr;
	float *pa, *pb, *pc;
	float z1, z2, z3, zc;
	float *fptr;
	int *iptr1;

	if (LowMem)
	{
		fptr = (float *)(AllProbs);
	}
	else
	{
		fptr = (float *)(AllProbs + indx);
	}
	iptr1 = (int *)(AllPixels + indx);
	iptr = (int *)(AllPolys + (indx * 3));
	pa = (float *)(AllPts + (*iptr * 3));
	pb = (float *)(AllPts + (*(iptr + 1) * 3));
	pc = (float *)(AllPts + (*(iptr + 2) * 3));

	z1 = *(pa + 2) - dist;
	z2 = *(pb + 2) - dist;
	z3 = *(pc + 2) - dist;
	zc = (z1 + z2 + z3) / 3;

	if (TreeRoot == NULL)
	{
		TreeRoot = (struct node_rec *)XtMalloc(sizeof(struct node_rec));
		TreeRoot->next = NULL;
		TreeRoot->list = (struct list_rec *)XtMalloc(sizeof(struct list_rec));
		TreeRoot->list->a = pa;
		TreeRoot->list->b = pb;
		TreeRoot->list->c = pc;
		TreeRoot->list->z = zc;
		TreeRoot->list->cos_theta = cosine_theta;
		TreeRoot->list->prob = *fptr;
		TreeRoot->list->pixel = *iptr1;
		TreeRoot->list->next = NULL;
		TreeRoot->list->left = NULL;
	}
	else
	{
		list_ptr = (struct list_rec *)XtMalloc(sizeof(struct list_rec));
		list_ptr->a = pa;
		list_ptr->b = pb;
		list_ptr->c = pc;
		list_ptr->z = zc;
		list_ptr->cos_theta = cosine_theta;
		list_ptr->prob = *fptr;
		list_ptr->pixel = *iptr1;
		list_ptr->next = NULL;
		list_ptr->left = NULL;
		list_ptr = FindVal(list_ptr, TreeRoot);
		if (list_ptr != NULL)
		{
			fprintf(stderr, "Error:  AddList failed!\n");
		}
	}
}

