#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/FileSB.h>
#include "color.h"

extern void Duplicate();
extern void DetailZero();
extern void Shade();
extern void DoScript();

extern float distance;
extern int LowMem;
extern int Changes;
extern Bool ScriptMode;
extern int save_xt, save_yt, save_zt;
extern int save_iter;


struct col_rec BaseColors[256];
int	BaseCells, BaseCount;
int	OrigNpts, OrigNpolys;
int	Npts, Npolys;
int	*OrigPolys, *AllPolys, *iptr;
float	*OrigPts, *AllPts, *fptr;
int	*OrigPixels, *AllPixels;
float	*OrigProbs, *AllProbs;
double	Total_Rot[3][3];


/*
 * Read a wireframe description form a file
 */
void
readframe(file)
	char *file;
{
	int i, j, scale;
	FILE *fp;
	int *iptr1, *iptr2;
	float *fptr1, *fptr2;
	int red, green, blue;
	int *ptr[3];
	char c;
	char line[100];

	/*
	 * Open the filename passed for read.  If cannot read or filename is
	 * invalid, then report error.
	 */
	if ((file == NULL)||(*file == '\0'))
	{
		fp = NULL;
	}
	else
	{
		fp = fopen(file, "r");
		if (fp == NULL)
		{
			fprintf(stderr, "cannot open file (%s) for reading\n",
				file);
		}
	}

	/*
	 * If file open failed then no object, otherwise read the number of
	 * points and polygons in the object
	 */
	if (fp == NULL)
	{
		OrigNpts = 0;
		OrigNpolys = 0;
	}
	else
	{
		fscanf(fp, "%d\n", &OrigNpts);
		fscanf(fp, "%d\n", &OrigNpolys);

		/*
		 * set up storage for, and read in all the point data.
		 */
		OrigPts = (float *)XtMalloc(OrigNpts * 3 * sizeof(float));
		fptr = OrigPts;
		for (i=0; i<OrigNpts; i++)
		{
			fscanf(fp, "%f ", fptr++);
			fscanf(fp, "%f ", fptr++);
			fscanf(fp, "%f ", fptr++);
		}

		/*
		 * set up storage for polygon vertices, and optional pixel
		 * values and opacities.
		 * Read in the these values.  Pixel defaults to -1 and opacity
		 * defaults to 1.0 if not defined.
		 */
		if (LowMem)
		{
			OrigProbs = (float *)XtMalloc(sizeof(float));
			*OrigProbs = 1.0;
			fptr = OrigProbs;
		}
		else
		{
			OrigProbs = (float *)XtMalloc(OrigNpolys *
						sizeof(float));
			fptr = OrigProbs;
		}
		OrigPixels = (int *)XtMalloc(OrigNpolys * sizeof(int));
		iptr1 = OrigPixels;
		OrigPolys = (int *)XtMalloc(OrigNpolys * 3 * sizeof(int));
		iptr = OrigPolys;
		for (i=0; i<OrigNpolys; i++)
		{
			fscanf(fp, "%d ", iptr++);
			fscanf(fp, "%d ", iptr++);
			fscanf(fp, "%d", iptr++);
			*iptr1 = -1;
			*fptr = 1.0;
			while (((c = (char)fgetc(fp)) != '\n')&&(c != EOF))
			{
				if ((c != ' ')&&(c != '\t'))
				{
					if (c == 'P')
					{
						fscanf(fp, "%d", iptr1);
					}
					else if (c == 'O')
					{
						fscanf(fp, "%f", fptr);
					}
					else
					{
						fprintf(stderr, "Error:  Unknown Key Character(%c) found on polygon specification line %d\n", c, i);
					}
				}
			}
			iptr1++;
			if (!LowMem)
			{
				fptr++;
			}
		}
	}

	/* 
	 * Look for next line to start with "Colormap" if there is an
	 * optional colormap to read in.
	 */
	line[0] = '\0';
	if (fp != NULL)
	{
		fscanf(fp, "%s %d\n", line, &scale);
	}
	if (strcmp(line, "Colormap") == 0)
	{
		for (i=0; i<3; i++)
		{
			fscanf(fp, "%s", line);
			if (strcmp(line, "red")==0)
			{
				ptr[i] = &red;
			}
			else if (strcmp(line, "green")==0)
			{
				ptr[i] = &green;
			}
			else if (strcmp(line, "blue")==0)
			{
				ptr[i] = &blue;
			}
			else
			{
				fprintf(stderr,"File %s has improper format for optional colormap\n", file);
			}
		}
		while ((c = (char)fgetc(fp)) != '\n');
		BaseCount = 0;
		for (i=0; i<scale; i++)
		{
			if (fscanf(fp, "%d %d %d\n", ptr[0], ptr[1], ptr[2])
				== 3)
			{
				BaseColors[i].red = red;
				BaseColors[i].green = green;
				BaseColors[i].blue = blue;
				BaseCount++;
			}
			else
			{
				BaseColors[i].red = 0;
				BaseColors[i].green = 0;
				BaseColors[i].blue = 0;
			}
		}
	}
	else
	/*
	 * If there was no colormap, set a grayscale colormap by default
	 */
	{
		scale = 256;
		for (i=0; i<scale; i++)
		{
			BaseColors[i].red = i;
			BaseColors[i].green = i;
			BaseColors[i].blue = i;
		}
		BaseCount = 256;
	}

	BaseCells = scale;
	Npts = OrigNpts;
	Npolys = OrigNpolys;

if (LowMem)
{
	AllPts = OrigPts;
	AllProbs = OrigProbs;
	AllPixels = OrigPixels;
	AllPolys = OrigPolys;
}
else
{
	/*
	 * Set up the points arrays.
	 */
	AllPts = (float *)XtMalloc(Npts * 3 * sizeof(float));
	fptr1 = AllPts;
	fptr2 = OrigPts;
	for (i=0; i<Npts; i++)
	{
		*fptr1++ = *fptr2++;
		*fptr1++ = *fptr2++;
		*fptr1++ = *fptr2++;
	}

	/*
	 * Set up the opacity array.
	 */
	AllProbs = (float *)XtMalloc(Npolys * sizeof(float));
	fptr1 = AllProbs;
	fptr2 = OrigProbs;
	for (i=0; i<Npolys; i++)
	{
		*fptr1++ = *fptr2++;
	}

	/*
	 * Set up the pixel array.
	 */
	AllPixels = (int *)XtMalloc(Npolys * sizeof(int));
	iptr1 = AllPixels;
	iptr2 = OrigPixels;
	for (i=0; i<Npolys; i++)
	{
		*iptr1++ = *iptr2++;
	}

	/*
	 * Set up the polygon array.
	 */
	AllPolys = (int *)XtMalloc(Npolys * 3 * sizeof(int));
	iptr1 = AllPolys;
	iptr2 = OrigPolys;
	for (i=0; i<Npolys; i++)
	{
		*iptr1++ = *iptr2++;
		*iptr1++ = *iptr2++;
		*iptr1++ = *iptr2++;
	}
}
	if (fp != NULL)
	{
		fclose(fp);
	}
/*
fprintf(stderr, "Read %d colors out of %d cells\n", BaseCount, BaseCells);
*/
	/*
	 * Initialize the cumulative rotation matrix to the identity matrix.
	 */
	for (j=0; j<3; j++)
	{
		for (i=0; i<3; i++)
		{
			if (i == j)
			{
				Total_Rot[i][j] = 1.0;
			}
			else
			{
				Total_Rot[i][j] = 0.0;
			}
		}
	}
}


/*
 * Initiate the read of a new file.
 * reset distance, detail, and shadetype
 */
void
DoRead(w, client_data, call_data)
        Widget w;
        caddr_t client_data, call_data;
{
	XmFileSelectionBoxCallbackStruct *dp;
	char *file;
	int i;

	dp = (XmFileSelectionBoxCallbackStruct *)call_data;
	XmStringGetLtoR(dp->value, XmSTRING_DEFAULT_CHARSET, &file);

	/*
	 * This is for my hacked in script execution.
	 * this call will never return because DoScript() always exits.
	 */
	if (ScriptMode == True)
	{
		DoScript(file);
		return;
	}

	if ((LowMem)&&(OrigNpts > 0))
	{
		XtFree(OrigPolys);
		XtFree(OrigPts);
		XtFree(OrigProbs);
		XtFree(OrigPixels);
	}
	else if (OrigNpts > 0)
	{
		XtFree(OrigPolys);
		XtFree(AllPolys);
		XtFree(OrigPts);
		XtFree(AllPts);
		XtFree(OrigProbs);
		XtFree(AllProbs);
		XtFree(OrigPixels);
		XtFree(AllPixels);
	}
	readframe(file);
	distance = 0.0;
	save_xt = 0;
	save_yt = 0;
	save_zt = 0;
	save_iter = 0;
	Changes = 0;
	DetailZero(w, (caddr_t)1, call_data);
	Shade(w, (caddr_t)0, call_data);
}

