$   ver = 'F$VERIFY(0)
$   GOTO COPYTREES
$!
$!	COPYTREES.COM
$!
$!	Author:  J. L. BINGHAM
$!		  (Formerly VAX SIG Tapecopy Coordinator;
$!		   now with Digital Equipment Corporation)
$!
$!	Adapted by: Alan L. Zirkle
$!		     Naval Surface Warfare Center
$!		     Dahlgren, VA 22448
$!		     (703) 663-8023
$!
$!	This version is new for the Spring '89 tapes.  COPYTREES now allows
$!	the entry of a blocksize for the BACKUP command; if any is entered,
$!	/INTERCHANGE is not done.   This allows getting more on one reel of
$!	tape (at the expense of making the tape harder to copy).
$!
$!	This command procedure is designed to make the copying of directory
$!  trees containing VAX Systems SIG Symposia tapes easy and consistent.  A
$!  small file suitable for a label is produced; it contains escape sequen-
$!  ces for LA120 small print.  This file can be copied to OPA0 if you have
$!  an 11-7xx.  The file is given a name of ddmmmhhmm.LBL, where the begin-
$!  ning day/month/hour/minute of the copy is encoded in the name.
$!
$!	This procedure assumes it is being run on a VT100-compatible screen,
$!  since it contains many escape sequences to do screen formatting.
$!
$!	The symposia tapes are assumed to be in directory trees named
$!
$!			dev:[VAXnnn...]
$!
$!  where 'dev' is either a device name or a rooted directory name.  For ex-
$!  ample, if you have the tapes in MYDISK:[A.B.VAXnnn...], then you should
$!  define a root logical name (such as "DECUS") like:
$!
$!	$ DEFINE DECUS 'F$TRNLNM("MYDISK")'[A.B.] /TRAN=(TERM,CON)
$!
$!  If you build the tapes in batch mode, this definition should be in your
$!  LOGIN.COM (or SYLOGIN.COM or /SYSTEM in SYSTARTUP.COM).
$!
$!      Normally, there is a VAX000 tree, and trees with names like VAX88A1,
$!  VAX88A2, etc.  When you enter any of these names, you do not use brackets
$!  or ellipses.
$!
$!	When it asks you for the name of the output tape to use, you can
$!  enter an actual device name ("MFA0", "$1$MSA0") or ask for a generic
$!  assignment ("TU78/GEN", "TU77,TU78/GEN").
$!
$!  Normal usage:
$!
$!    (a) 1600 bpi 9-track tapes
$!
$!	Two or more 2400-foot reels contain a symposium set; the first reel
$!	contains the VAX000 tree and the VAXnnx1 tree; the second reel con-
$!	tains the VAXnnx2 tree.  A separate invocation of COPYTREES is
$!	necessary for each reel.
$!
$!	For Fall 1988 there were five trees, VAX88B1-VAX88B5, and five
$!	1600 bpi reels were required.
$!
$!    (b) 6250 bpi 9-track tape
$!
$!	One 2400 foot reel contains a symposium set--The VAX000 tree, and
$!	all VAXnnxn trees.
$!
$!    (c) TK50 cartridge
$!
$!	Two cartridges contains a symposium set.  Any density entered is
$!	ignored.
$!
$!	To configure this procedure for your system, edit the lines con-
$!  taining the string '!##'.
$!
$!		     THE FOLLOWING TWO SYMBOL
$!		 VALUES ARE INSTALLATION-SPECIFIC
$!				|
$!				|
$!				V
$ COPYTREES:
$   VAXSIG$LABL =  ""				  !##	! Where label file goes
$!							! (use null if unneeded)
$   VAXSIG$SHOP =  "ALAN ZIRKLE (703)663-8023"	  !##	! Who is responsible.
$!
$   procdir = F$ELEMENT(0,"]",F$ENV("PROCEDURE")) + "]"
$!
$   ECHO = "WRITE SYS$OUTPUT"
$!
$   IF F$MODE() .EQS. "BATCH" THEN  GOTO BATCH
$!
$   IF F$TYPE(VAXSIG$DISK) .NES. "" THEN  GOTO DISPLAY
$!
$!	THE FOLLOWING SEVEN VALUES ARE DEFAULTS AND CAN BE OVERRIDDEN
$!	AT EXECUTION TIME; ANY NEW SETTINGS ARE SAVED UNTIL LOGOUT.
$!
$   VAXSIG$DISK == "DECUS" !##	! Disk or root containing VAXxxx directories
$   VAXSIG$TAPE == "MF:"   !##	! Mag tape drive to use
$   VAXSIG$DENS == "6250"  !##	! Mag tape density to use
$   VAXSIG$MODE == "B"	   !##	! Copy mode (I or B for Interactive or Batch)
$   VAXSIG$VERF == "N"	   !##	! Do verify passes on BACKUPs?
$   VAXSIG$BQUE = "SYS$BATCH"	      !## Batch queue to use in "B" copy mode
$   VAXSIG$BLOK == "/BLOCKSIZE=24576" !## Either "/BLOCKSIZE=nnnn" or
$!						 "/INTERCHANGE"
$!
$!  VAXSIG$DIRS	    ! Directories to copy, separated by commas.  Example:
$!		    !		"VAX000,VAX87C,VAX87D,VAX87E"
$!		    !  You also may include device/root names, as in:
$!		    !		"DEV1:VAX87C,VAX87D,DEV2:VAX87E"
$!		    !  (VAX87C and D willbe copied from DEV1 in this example).
$!		    !  And, you can abbreviate "VAXxxx" to "xxx".
$!
$!  VAXSIG$WHOM	    ! For whom the tape is being made (for label).
$!
$ DISPLAY:
$   IF p1 .NES. "" THEN  VAXSIG$TAPE == p1	! You can optionally specify
$   IF p2 .NES. "" THEN  VAXSIG$DIRS == p2
$   IF p2 .EQS. "" .AND. F$TYPE(VAXSIG$DIRS) .EQS. "" THEN -
	VAXSIG$DIRS == "VAX000,VAX88B1,VAX88B2,VAX88B3,VAX88B4,VAX88B5" !##
$!
$   IF F$TYPE(VAXSIG$QUEU) .EQS. "" THEN  VAXSIG$QUEU == VAXSIG$BQUE
$!
$   y = "interactively"
$   IF VAXSIG$MODE .EQS. "B" THEN  y = "[1mIN BATCH MODE[m" + -
			" on queue [1m" + VAXSIG$QUEU + "[m"
$   z = " with"
$   IF .NOT. VAXSIG$VERF THEN  z = "[1mWITHOUT[m"
$!
$   ECHO " "
$   ECHO "Defaults are:    Source disk[1m ",VAXSIG$DISK," [m"
$   ECHO "                 Output tape[1m ",VAXSIG$TAPE," [m"
$   ECHO "                Tape density[1m ",VAXSIG$DENS," [m"
$   ECHO "               Blocking mode[1m ",VAXSIG$BLOK," [m"
$   ECHO "       The copy will be done ",y,","
$   ECHO "                             ",z," verify passes."
$!
$   INQUIRE x "
  Do you want to change the defaults (Y/N) [N]"
$   IF .NOT. x THEN  GOTO SPECIFY
$!
$   bk = F$ELEMENT(1,"=",VAXSIG$BLOK)
$   IF VAXSIG$BLOK .EQS. "/INTERCHANGE" THEN  bk = "I"
$!
$   INQUIRE x "
	Enter Source disk  [''VAXSIG$DISK']"
$   x = x - ":"
$   IF x .NES. "" THEN  VAXSIG$DISK == x
$   INQUIRE x "
	Enter Output tape  [''VAXSIG$TAPE']"
$   IF x .NES. "" THEN  VAXSIG$TAPE == x
$   INQUIRE x "
	Enter Tape density [''VAXSIG$DENS']"
$   IF x .NES. "" THEN  VAXSIG$DENS == x
$   INQUIRE X "
     Enter blocksize, or I for /INTERCHANGE [''bk']"
$   IF x .EQS. ""  THEN  x = bk
$   IF x .EQS. "I" THEN  VAXSIG$BLOK == "/INTERCHANGE"
$   IF x .NES. "I" THEN  VAXSIG$BLOK == "/BLOCKSIZE=" + x
$   INQUIRE x "
    Copy interactively or batch (I/B) [''VAXSIG$MODE']"
$   IF x .NES. "" THEN  VAXSIG$MODE == F$EXTRACT(0,1,x)
$   IF VAXSIG$MODE .NES. "B" THEN  GOTO D2
$   INQUIRE x "
    Enter Batch queue [''VAXSIG$QUEU']"
$   IF x .NES. "" THEN  VAXSIG$QUEU == x
$ D2:
$   INQUIRE x "
    Run verify passes on BACKUPs (Y/N) [''VAXSIG$VERF']"
$   IF x .NES. "" THEN  VAXSIG$VERF == F$EXTRACT(0,1,x)
$   GOTO DISPLAY
$!
$ SPECIFY:
$   default = ""
$   IF VAXSIG$DIRS .NES. "" THEN -
      default = "
    The default is [1;7m " + VAXSIG$DIRS + " [m."
$!
$   ECHO "
    Enter name(s) of tree(s) to be copied" + -
					     " (don't forget VAX000 if needed)."
$   IF default .NES. "" THEN  ECHO default
$   ECHO " "
$   INQUIRE candidates "    Enter trees"
$   IF candidates .EQS. "" THEN  candidates = VAXSIG$DIRS
$   IF candidates .EQS. "" THEN  GOTO SPECIFY
$!
$   VAXSIG$DIRS == F$EDIT(candidates,"COLLAPSE,UNCOMMENT")
$!
$   ECHO " "				! Here we test that all of the trees
$   lastdevice = VAXSIG$DISK		!  actually exist.
$   candidates = VAXSIG$DIRS
$   trailer = "]"
$   failed = "F"
$ TESTLOOP:
$   GOSUB PARSEDIRS
$   IF candidate .EQS. "" THEN  GOTO TESTEND
$   exists = F$PARSE(candidate) .NES. ""
$   IF exists THEN  	  ECHO "          ",candidate," exists."
$   IF .NOT. exists THEN  ECHO "          [1m",candidate,-
					" does NOT exist!!![m"
$   IF .NOT. exists THEN  failed = "T"
$   GOTO TESTLOOP
$!
$ TESTEND:
$   IF failed THEN  GOTO SPECIFY
$!
$   IF VAXSIG$LABL .NES. "" THEN -
		INQUIRE VAXSIG$WHOM "
For whom are you making this tape"
$!
$   IF F$GETDVI(VAXSIG$TAPE,"EXISTS") THEN -
		INQUIRE OK "
Load a tape on ''VAXSIG$TAPE' and enter <CR>"
$!
$   ECHO " "
$   IF VAXSIG$MODE .NES. "B" THEN  GOTO PROCEED
$!
$   SUBMIT 'procdir'COPYTREES -
	/PARAM=("''VAXSIG$DISK'","''VAXSIG$TAPE'",  'VAXSIG$DENS', -
		"''VAXSIG$DIRS'",  'VAXSIG$VERF' ,"''VAXSIG$WHOM'", -
		"''VAXSIG$BLOK'") -
		/QUEUE='VAXSIG$QUEU' /NOTIFY /KEEP		    !## /KEEP ?
$   ECHO " "
$   GOTO EXIT2
$!
$ PROCEED:
$   ON WARNING   THEN  GOTO ERROR
$   ON CONTROL_Y THEN  GOTO ERROR
$!
$   ALLOCATE 'VAXSIG$TAPE' SIG$TAPE
$   media =  F$GETDVI("SIG$TAPE:","MEDIA_NAME")
$!
$   densityqual = "/DENSITY=" + VAXSIG$DENS
$   IF media .EQS. "TK50" THEN  densityqual = ""
$!
$   mountqual = ""
$   IF media .NES. "TK50" THEN  mountqual = "/CACHE=TAPE"
$!
$!  The following MOUNT, DISMOUNT is in case operator intervention is required.
$!
$   MOUNT /FOREIGN SIG$TAPE: -
		/COMMENT="----- Load output tape for VAX SIG TAPECOPY -----"
$   DISMOUNT /NOUNLOAD SIG$TAPE:
$   INITIALIZE 'densityqual' SIG$TAPE: VAXSIG
$   ECHO "Initialized ",F$TRNLNM("SIG$TAPE")," as VAXSIG"
$!
$   MOUNT /FOREIGN 'densityqual' 'mountqual' SIG$TAPE:
$!
$   error = "F"					! No error has occurred
$   errcount = F$GETDVI("SIG$TAPE:","ERRCNT")	! Initial tape error count
$!
$   time = F$EXTRACT(0,17,F$TIME())
$   ECHO " "
$!
$!  Format of label file name is ddmmmhhmm.LBL
$!
$   IF VAXSIG$LABL .EQS. "" THEN  GOTO NOLABEL
$!
$   label = F$EXTRACT(0,6,time) + F$EXTRACT(12,5,time) - "-" - ":" - " "
$   label = VAXSIG$LABL + label + ".LBL"
$!
$   OPEN /WRITE /ERROR=LABEL_ERROR LABEL 'label'
$!
$   WL = "WRITE LABEL"
$!
$   WL "[4w[2z"			! LA120 formatting
$   WL "This tape is for:  ",VAXSIG$WHOM,"

"
$   WL "_____________________________________________________________"
$   WL "|							    |"
$   WL "|             VAX SYSTEMS SIG TAPE COPY PROJECT		    |"
$   WL "|							    |"
$   WL "|  TAPE IS IN BACKUP /INTERCHANGE FORMAT, ",VAXSIG$DENS," BPI DENSITY  |"
$   WL "|  SEE [VAX000]0README.1ST       ",VAXSIG$SHOP," |"
$   WL "|							    |"
$   WL "|  THIS TAPE CONTAINS:                   ",time,"  |"
$   WL "|    ROOT DIRECTORY     SAVE-SET NAME      APPROX BLOCKS    |"
$!
$ NOLABEL:
$   ECHO " "
$!
$   lastdevice = VAXSIG$DISK
$   candidates = VAXSIG$DIRS
$   trailer = "...]"
$   rewind = "/REWIND"
$!
$ LOOP:
$   GOSUB PARSEDIRS
$   IF candidate .EQS. "" THEN  GOTO EXIT
$!
$   @'procdir'TREETAPE 'candidate' 'rewind'
$!
$   rewind = "/NOREWIND"
$   GOTO LOOP
$!
$ BATCH:
$   VAXSIG$DISK == P1
$   VAXSIG$TAPE == P2
$   VAXSIG$DENS == P3
$   VAXSIG$DIRS == P4
$   VAXSIG$VERF == P5
$   VAXSIG$WHOM == P6
$   VAXSIG$BLOK == P7
$   GOTO PROCEED
$!
$ PARSEDIRS:
$   candidate = F$ELEMENT(0,",",candidates)
$   IF candidate .EQS. "" THEN  RETURN
$   candidates = candidates - candidate - ","
$   candevice = F$ELEMENT(0,":",candidate)
$   candirect = F$ELEMENT(1,":",candidate)
$   IF candirect .NES. ":" THEN  GOTO PARSEDIRS2
$   candirect = candevice
$   candevice = lastdevice
$ PARSEDIRS2:
$   lastdevice = candevice
$   candirect = candirect - "[" - "]" - "..."
$   IF F$LENGTH(candirect) .EQ. 3 THEN  candirect = "VAX" + candirect
$   candidate = candevice + ":[" + candirect + trailer
$   RETURN
$!
$ LABEL_ERROR:
$	ECHO "******COPY INCOMPLETE******"
$	ECHO "Have your tailored COPYTREES.COM to your installation?"
$	ECHO "If not, edit the lines containing ""!##"""
$	GOTO EXIT2
$!
$ ERROR:
$   ECHO "******COPY INCOMPLETE******"
$   IF F$LOGICAL("LABEL") .EQS. "" THEN  GOTO EXIT2
$   error = "Y"
$!
$ EXIT:
$   DUMMY = 'F$VERIFY(0)
$!
$   IF F$TRNLNM("LABEL") .EQS. "" THEN  GOTO NOLABEL2
$   WL "|___________________________________________________________|"
$   WL "[w[z"	! LA120 escape sequences
$   CLOSE LABEL
$!
$ NOLABEL2:
$   IF error THEN  GOTO EXIT2
$!
$   errcount = F$GETDVI("SIG$TAPE:","ERRCNT") - errcount
$   IF errcount .LE. 0 THEN  GOTO EXIT1
$!
$   IF F$MODE() .EQS. "BATCH" THEN  GOTO B_ERR
$!
$   ECHO "
[1;7m     There were ",errcount," device errors",-
					" writing the tape     [m
"
$   GOTO EXIT1
$!
$ B_ERR:
$   ECHO "
======================================================"
$   ECHO "     There were ",errcount," device errors writing the tape"
$   ECHO "======================================================
"
$!
$ EXIT1:
$   SHOW TIME
$   IF VAXSIG$LABL .EQS. "" THEN  GOTO EXIT2
$   label = F$SEARCH(label)
$   ECHO "
 Label Information is ",label," 
"
$!
$ EXIT2:
$   SET NOON
$   ON CONTROL_Y THEN CONTINUE
$   IF .NOT. F$GETDVI("SIG$TAPE:","EXISTS") THEN  GOTO END
$   IF F$GETDVI("SIG$TAPE:","MNT") THEN  DISMOUNT SIG$TAPE:
$   DEALLOCATE SIG$TAPE:
$   DEASSIGN SIG$TAPE
$!
$ END:
$   IF ver THEN  SET VERIFY
