c
c	READ_NOTES - A utility to read notesfiles without the need to have a
c	VAX Notes license.  
c
c	For documentation on the notefile format, see DECUServe conference
c	VAX_NOTES_UTILITY, note 181.*.  Without that thread, this program would
c	have taken much longer to write.  Thanks Dale!
c
c	This program makes a few assumptions about the notefile being 
c	converted. 
c
c	- that if there is no .0 note, there are no replies.  It is the authors
c	  belief that VAX Notes enforces this
c	- that there is no single line in a note that is longer than ~1900
c	  characters (see PROCESS_TYPE_80 for actual limit).  While VAX Notes
c	  doesn't enforce this, it is reasonable to assume that a longer text 
c	  line would be extremely difficult to read.  Behavior of READ_NOTES 
c	  should a line exceed the limit is "undefined".
c
c  Modification history
c	
c	V1.2	Bruce Bowler	6-Feb-1993
c		- Fix problem with type 00 records.  If the new moderator has
c		  a shorter name than the old moderator, there is "junk" left
c		  in the record.  We've got to skip that junk by looking for
c		  a 'DF'x
c		- Fix problem with test lines longer than 133 characters. 
c		  Expand limit to 255 characters.
c		- Deal with continuation records in type 80 section.
c	V1.1	Bruce Bowler	5-Nov-1992
c		- fixed problem with GET_LENGTH.  Had an implicit type 
c		  conversion occuring that was occasionally causing a negative
c		  length.
c		- Added command line processing to get information.
c		- Added logic so that if START > END, END = START on RANGE.
c	V1.0	Bruce Bowler	2-Nov-1992
c		- Initial release
c
	implicit none

	include 'notes$itemdef.inc'
	include 'read_notes.inc'

	character*255 in_file, out_file
	character*5 cstart, cend
	integer len, start, end, tstart, tend, topic_number, size_of
	integer status, in_len, out_len, cli$get_value, min, max
	integer cli$present
c
c	Get the input filename from the command line and open it
c
	status = cli$get_value('FILENAME', in_file, in_len)
	open (	unit=1,		name=in_file(1:in_len),	status='OLD',
	1	readonly,	organization='INDEXED',	access='KEYED',
	1	shared,		recordtype='VARIABLE',	form='FORMATTED',
	1	defaultfile='.NOTE', err=10)
c
c	Either get the output filename from the command line or derive it from
c	the input filename.  In either case open it when we have it.  The
c	default name is the input filename with .LIS, in the current directory
c
	if (.not. cli$get_value('OUTPUT', out_file, out_len)) then
	    inquire (unit=1, name=in_file)
	    start = 1
	    do while (in_file(start:start) .ne. ']')
		start = start + 1
	    end do
	    start = start + 1
	    end = start
	    do while (in_file(end:end) .ne. '.')
		end = end + 1
	    end do
	    end = end - 1
	    out_file = in_file(start:end)
	    out_len = end - start + 1
	endif
	open (	unit=2,		name=out_file(1:out_len),	
	1	status='NEW',	carriagecontrol='LIST',
	1	recl=255,	defaultfile='.LIS')
c
	dir_only = cli$present('DIRECTORY')
c
c	process the notefile information (type 00) records.  
c
	call process_notefile_info
c
c	Get the range of topics to display.  The default is all of them.  If
c	the user-specified range end is before range start, then only the topic
c	specified by start is displayed
c
	start = 1
	end = num_topics
	if (cli$get_value('RANGE.START', cstart, len)) then
	    read (cstart(1:len),900) tstart
	    start = max(1, min(num_topics, tstart))
	endif
	if (cli$get_value('RANGE.END', cend, len)) then
	    read (cend(1:len),900) tend
	    end = min(num_topics, max(start,tend))
	endif
c
c	Display the requested topics
c
	do topic_number = start,end
	    call process_topic(topic_number)
	enddo

	call exit

 10	write (6,901) in_file(1:in_len)
	call exit

 900	format (i)
 901	format (' File ',a, ' note found or un-openable')

	end
c
	subroutine process_notefile_info
c
c	read the notefile until we run out of type 00 records.
c
	implicit none

	include 'notes$itemdef.inc'
	include 'read_notes.inc'

	integer len, key
c
c	read only the first record and the record with key = '00000010' since
c	they're the only ones we care about.  Since we're reading only in a
c	server-less environment, we don't care about members, keywords, etc. 
c	Making the above "assumptions" saves countless I/O and greatly improves
c	perceived performance.
c
	read (1,900,end=10) record.ckey, len, record.char_rest
	call process_type_00(record,len)
	key = '00000010'x
	read (1,900,key=key,err=10) record.ckey, len, record.char_rest
	call process_type_00(record,len)
	return

 10	write (6,901)
	call exit

 20	return

 900	format (a,q,a)
 901	format (' Malformed NOTEFILE - Exiting')

	end
c
	subroutine process_topic (topic_no)
c
c	processes all records in the notefile that relate to the passed
c	topic number.  
c
c	Build a key for "topic.0"
c	get info on topic
c	get text of note
c	for reply = 1 to max_reply
c	    display info about "topic.reply"
c
	implicit none

	include 'notes$itemdef.inc'
	include 'read_notes.inc'

	integer key, len, topic_no, i

	key = topic_no * 2**16
	read (1,900,err=10,keyid=1,key=key) record.ckey, len, record.char_rest
	call process_type_40 (record,len)
	do 20 i = 1,num_responses
	    key = topic_no * 2**16 + i
	    read (1,900,err=20,keyid=1,key=key) record.ckey, len, 
	1						record.char_rest
	    call process_type_40 (record,len)
 20	end do
 10	return

 900	format (a,q,a)

	end
c
	subroutine process_type_00 (record,len)
c
c	Process the 00 records.  Since we're a "blanket" reader, we only care
c	about the "conference" info.  We don't need to worry about members,
c	keywords or nodes
c
	implicit none


	include 'notes$itemdef.inc'
	include 'read_notes.inc'

	character*23 cre_time,mod_time
	character*80 title, notice
	integer*4 num_notes, tlen, length, tag, get_tag, get_length, lib$movc3
	integer*4 status, sys$asctim, len, title_len, notice_len, t_off, n_off

	ptr = 1
	if (record.keypart.key0 .eq. '00000000'x) then
	    status = lib$movc3(4,record.byte_rest(21),num_notes)
	    status = lib$movc3(4,record.byte_rest(25),num_topics)
	    status = sys$asctim(tlen, cre_time,record.byte_rest(29),) 
	    status = sys$asctim(tlen, mod_time,record.byte_rest(37),) 
	    write (6,900) num_notes,num_topics,cre_time,mod_time
	endif
	if (record.keypart.key0 .eq. '00000010'x) then
	    tag = get_tag(record.byte_rest(ptr),record.byte_rest(ptr+1))
	    do while (ptr .le. len)
		length = get_length(record.byte_rest(ptr),
	1			    record.byte_rest(ptr+1),
	1			    record.byte_rest(ptr+2))
		if (tag .eq. NOTES$K_NOTEFILE_TITLE) then
		    write (6,901) record.char_rest(ptr:ptr+length-1)
		    title = record.char_rest(ptr:ptr+length-1)
		    title_len = length
		end if
		if (tag .eq. NOTES$K_NOTEFILE_MODERATOR) then
		    write (6,902) record.char_rest(ptr:ptr+length-1)
		end if
		if (tag .eq. NOTES$K_NOTEFILE_NOTICE) then
		    write (6,903) record.char_rest(ptr:ptr+length-1)
		    title = record.char_rest(ptr:ptr+length-1)
		    title_len = length
		end if
		ptr = ptr + length 
		do while (record.byte_rest(ptr) .ne. 'DF'x)
		    ptr = ptr + 1
		end do
		tag = get_tag(record.byte_rest(ptr), record.byte_rest(ptr+1))
	    end do
	    if (dir_only) then
		t_off = (80-title_len)/2
		n_off = (80-notice_len-6)/2
		write (2,200)	title(1:title_len),
	1			cre_time(1:17), 
	1			num_topics,
	1			mod_time(1:17),
	1			notice(1:notice_len)
	    endif
	endif

	return

 200	format (80('-'),/,
	1	<t_off>x,a,/,
	1	'Created: ',a,t33,i5,' topics',t55,'Updated: ',a,/,
	1	<n_off>x,'-< ',a,' >-',/,
	1	' Topic  Author               Date         Repl  Title',/,
	1	80('-'))
 900	format (' Total notes:  ',i,/,
	1	' Total topics: ',i,/,
	1	' Created:      ',a,/,
	1	' Modified:     ',a)
 901	format (' Title:        ',a)
 902	format (' Moderator:    ',a)
 903	format (' Notice:       ',a)

	end
c
	subroutine process_type_40 (record,len)
c
c	process the 40 records.  For each record, dump out the header, then
c	find any text records (type 80) and have them displayed.
c
	implicit none

	include 'notes$itemdef.inc'
	include 'read_notes.inc'

	character*23 out_time
	character*30 author
	character*80 title,thread_title
	character*11 note_string
	integer*2 length
	integer*4 temp,topic,reply, hidden, writelock, len, tlen
	integer*4 tag, get_tag, get_length, author_len, title_len
	integer*4 thread_len,num_records, key_80, calc_80_key, lent
	integer*4 lib$movc3, sys$asctim, status

	topic = record.keypart.topic
	reply = record.keypart.reply
	ptr = 1
	hidden = 0
	writelock = 0

	if (reply .eq. 0) num_responses = 0

	tag = get_tag(record.byte_rest(ptr), record.byte_rest(ptr+1))
	do while (ptr .le. len)
	    length = get_length(record.byte_rest(ptr),
	1			record.byte_rest(ptr+1),
	1			record.byte_rest(ptr+2))
	    if (tag .eq. NOTES$K_NOTE_AUTHOR) then
		author = record.char_rest(ptr:ptr+length-1)
		author_len = length
	    end if
	    if (tag .eq. NOTES$K_NOTE_CREATE_TIME) then
		status = sys$asctim(tlen, out_time, record.byte_rest(ptr),) 
	    end if
	    if (tag .eq. NOTES$K_NOTE_TITLE) then
		title = record.char_rest(ptr:ptr+length-1)
		title_len = length
		if (reply .eq. 0) then
		    thread_title = title
		    thread_len = length
		end if
	    end if
	    if (tag .eq. NOTES$K_NOTE_NUMRECORDS) then
		status = lib$movc3 (4, record.byte_rest(ptr), num_records)
	    end if
	    if (tag .eq. NOTES$K_NOTE_NUMRESPONSES) then
		status = lib$movc3 (4, record.byte_rest(ptr), num_responses)
	    end if
	    if (tag .eq. NOTES$K_NOTE_WRITELOCK) then
		status = lib$movc3 (4, record.byte_rest(ptr), writelock)
	    end if
	    if (tag .eq. NOTES$K_NOTE_HIDDEN) then
		status = lib$movc3 (4, record.byte_rest(ptr), hidden)
	    end if
	    ptr = ptr + length 
	    tag = get_tag(record.byte_rest(ptr), record.byte_rest(ptr+1))
	end do
	if (hidden .eq. 0) then
	    call write_note_header (topic, reply, title(1:title_len),
	1			    author(1:author_len), out_time(1:17), 
	1			    num_responses, num_records, 
	1			    thread_title(1:thread_len))
	    if (.not. dir_only) then
		key_80 = calc_80_key (record.keypart.key0)
		read (1,900,err=10,key=key_80,keyid=0) record.ckey, lent, 
	1					       record.char_rest
		call process_type_80 (record,lent)
	    endif
	  else
	    call write_note_header (topic, reply, ' ', ' ', out_time(1:17), 
	1			    num_responses, num_records,' ')
	end if

 10	return

 900	format (a,q,a)

	end
c
	integer function size_of (arg)
c
c	Return the number of digits in the argument.  It will return an
c	incorrect result if the argument is negative.  As called by this
c	program, that's OK, since we'll never (knowingly) pass it a value 
c	less than 0
c
	implicit none

	integer arg,temp
	real float

	if (arg .gt. 0) then
	    temp = log10(float(arg)) + 1
	  else
	    temp = 1
	endif
	size_of = temp

	return
	end
c
	subroutine write_note_header (	topic, reply, title, author, time, 
	1				max, lines, thread)
c
c	This routine formats and prints the header of each note.  It takes care
c	of centering the text, printing the reply info in the proper format,
c	etc
c
	implicit none

	include 'read_notes.inc'

	character*(*) title, author, time,thread
	character*11 note_no
	character*13 trailer_1
	character*14 trailer_2
	integer*4 top_size, rep_size, max_size, line_size, size_of
	integer*4 topic, reply, max, lines, chars_used, space, space1, space2

	top_size = size_of (topic)
	rep_size = size_of (reply)
	max_size = size_of (max)
	line_size = size_of (lines)

	write (note_no,900) topic,reply

	if (.not. dir_only) then
	    write (trailer_1,901) max
	    write (trailer_2,902) reply,max

	    write (2,100) 

	    if (reply .eq. 0 .and. max .eq. 1) then
		chars_used = 14 + top_size + len(thread)
		space1 = (80 - chars_used)/2
		space2 = space1
		if (space1 + space2 + chars_used .ne. 80) space2 = space2 + 1
		write (2,101) note_no(1:top_size+rep_size+1),thread
	    endif
	    if (reply .eq. 0 .and. max .ne. 1) then
		chars_used = 14 + top_size + rep_size + len(thread) + max_size 
		space1 = (80 - chars_used)/2
		space2 = space1
		if (space1 + space2 + chars_used .ne. 80) space2 = space2 + 1
		write (2,102) note_no(1:top_size+rep_size+1),thread, 
	1		  trailer_1(1:max_size+8)
	    endif
	    if (reply .ne. 0) then
		chars_used = 10 + top_size + 2*rep_size + len(thread) + max_size
		space1 = (80 - chars_used)/2
		space2 = space1
		if (space1 + space2 + chars_used .ne. 80) space2 = space2 + 1
		write (2,103) note_no(1:top_size+rep_size+1),thread,
	1			trailer_2(1:rep_size + max_size + 4)
	    endif
	    space = 80 - (len(author) + line_size + 7 + len(time))
	    write (2,104) author, lines, time
	    space = (80 - (3 + len(title)+ 3))/2
	    if (reply .ne. 0 .and. len(title) .ne. 0) write (2,105) title

	    write (2,106)
	  else
	    if (reply .eq. 0) then
		write (2,200)	topic, 
	1			author, 
	1			time(1:11),
	1			max, 
	1			title
	      else
		write (2,201)	author, 
	1			time(1:11), 
	1			note_no(1:top_size+rep_size+1), 
	1			title
	    endif
	endif

 100	format (80('='))
 101	format ('Note ',a,<space1>x,a,<space2>x,'1 Reply')
 102	format ('Note ',a,<space1>x,a,<space2>x,a)
 103	format ('Note ',a,<space1>x,a,<space2>x,a)
 104	format (a,<space>x,i<line_size>,' lines ',a)
 105	format (<space>x,'-< ',a,' >-')
 106	format (80('-'))
 200	format (i6,t10,a,t30,a,t42,i5,2x,a)
 201	format (   t10,a,t30,a,<5-top_size>x,a,2x,a)
 900	format (i<top_size>,'.',i<rep_size>)
 901	format (i<max_size>,' Replies')
 902	format (i<rep_size>,' of ',i<max_size>)

	return
	end
C
	subroutine process_type_80 (record,len)
c
c	Processes type 80 (text) records.  Prints out all text records until
c	there is no more to print out.  If needed, it will read more records
c	from the notes file.
c
	implicit none

	include 'notes$itemdef.inc'
	include 'read_notes.inc'

	byte value(948)	
	byte temp_rest (1896)
	integer*2 lent,length,lent1,start
	integer*4 len, status, lib$movc3, tag, get_tag, get_length, key, i

	lent = len
	ptr = 1
	status = lib$movc3 (lent,record.byte_rest(ptr),temp_rest)
	tag = get_tag(temp_rest(ptr), temp_rest(ptr+1))
	do while (ptr .le. len .and. tag .ne. NOTES$K_TEXT_END)
	    length = get_length(temp_rest(ptr),
	1			temp_rest(ptr+1),
	1			temp_rest(ptr+2))
	    if (ptr+length .gt. len) then
c
c	ut-oh, we ran out of data, get more!
c
		key = record.keypart.key0 + 1
		read (1,900,key=key,keyid=0) record.ckey,lent,record.char_rest
		lent1 = len - ptr + 1
		status = lib$movc3(lent1,temp_rest(ptr),temp_rest(1))
		start = 1
		if (record.keypart.cont_mark .eq. 1) then
		    start = 5
		    lent  = lent-4
		endif
		status = lib$movc3(lent,record.byte_rest(start),
	1				temp_rest(lent1+1))
		ptr = 1
		len = lent+lent1
	    endif
	    status = lib$movc3 (length,temp_rest(ptr),value)
	    if (tag .eq. NOTES$K_TEXT_STRING) then
		write (2,901) (value(i),i=1,length)
	    end if
	    if (tag .eq. NOTES$K_TEXT_END) then
		tag = tag
	    end if
	    ptr = ptr + length 
	    tag = get_tag(temp_rest(ptr), temp_rest(ptr+1))
	end do
	return

 900	format (a,q,a)
 901	format (<length>a1)

	end
c
	integer function get_tag(tag1, tag2)
c
c	return the TAG value given the input bytes.
c
	implicit none

	include 'read_notes.inc'

	byte tag1, tag2
	integer temp

	if (tag1 .eq. 'DF'x) then 
	    temp = tag2
	    ptr = ptr + 2
	  else
	    temp = tag1 - 'C0'x
	    ptr = ptr + 1
	endif
	get_tag = temp

	return
	end
c
	integer function get_length (len1, len2, len3)
c
c	Return the integer length given the various possible input formats
c
	implicit none

	include 'read_notes.inc'

	byte len1, len2, len3
	integer temp

	if (len1 .eq. 0) then
	    temp = 0
	    ptr = ptr + 1
	endif
	if (len1 .gt. 0 .and. len1 .le. 128) then
	    temp = zext(len1)
	    ptr = ptr + 1
	endif
	if (len1 .eq. '81'x) then
	    temp = zext(len2)
	    ptr = ptr + 2
	endif
	if (len1 .eq. '82'x) then
	    temp = zext(len3)*2**8 + zext(len2)	! is this right?
	    ptr = ptr + 3
	endif
	get_length = temp

	return
	end
c
	integer function calc_80_key (key_40)
c
c	Given a type 40 key, return the first associated type 80 key
c
	implicit none
	integer key_40, temp

	temp = key_40 .and. '00ffffff'x
	temp = temp * 128
	temp = temp .or. '80000000'x
	calc_80_key = temp

	return
	end
