/*
	Copyright (C) 2004 Jonas Lindholm

	This software was developed by Jonas Lindholm, jlhm@usa.net

	History

	V1.0		Jonas Lindholm	2004-05-14

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

typedef struct iosb_s {
	short unsigned		stat;
	short unsigned		len;
	int unsigned		opt;
} IOSB;


typedef struct item3_s {
	short unsigned		buflen;
	short unsigned		item;
	void			*bufadr;
	void			*retlen;
} ITEM3;


typedef struct lgi_ipc_msg_s {
	struct {
		short unsigned	minver;
		short unsigned	majver;
	} version;

	int unsigned		pid;    /* not used */
	int unsigned		cmd;
	int unsigned		reqid;
	int unsigned		rplyid;
	int unsigned		chksum; /* not used */
	int unsigned		status;
	int unsigned		res[4]; /* reserved area */

	union {
		struct {
			char		mbxname[32];
		} init;
		struct {
			char		identity[256];
			int		jobtype;
		} identity;
		struct {
			char		credential[256];
		} authenticate;
		struct {
			char		password[256];
		} password;
	} request;

	union {
		struct {
			int unsigned	res;
		} init;
		struct {
			char		identity[256];
		} identity;
		struct {
			int unsigned	res;
		} authenticate;
		struct {
			int unsigned	res;
		} error;
	} reply;

} LGI_IPC_MSG;


#define	IPC_CMD_ERROR		0
#define	IPC_CMD_INIT		1
#define	IPC_CMD_IDENTITY	2
#define	IPC_CMD_AUTHENTICATE	3
#define	IPC_CMD_PASSWORD	4	/* used when changing password */


int do_trnlnm(char *lnm, char *trn, int trnlen, int accmode);

