$! BUILD_PERL.COM --  Build and install Perl and associated goodies
$!
$! 22-Apr-2004 -- Craig Berry -- use Perl 5.8.4 and updated module list
$! 16-Aug-2001 -- make finding code courtesy of Sebastian Bazley
$! 31-May-2001 -- Craig Berry -- original version
$!	
$!
$ on error then goto basic_failure
$ phase == "SETUP"
$!
$! Find out the top level build directory.
$ whoami = f$parse(f$environment("PROCEDURE"),,,,"NO_CONCEAL")
$ topdir = f$parse(whoami,,,"DEVICE") + f$parse(whoami,,,"DIRECTORY")
$! strip end and add back what we need for rooted logical
$ topdir = topdir - ".][000000" - "][" - "].;" - "]" + ".]"  
$! 
$ define/translation_attributes=concealed perlkit 'topdir'
$ show logical perlkit
$!
$ set default perlkit:[000000]
$ show default
$!
$! Determine what make utility to use, choosing first the value of 
$! perl_make (if any), next MMK, then MMS, and finally flag an error 
$! and exit if there is neither MMS nor MMK.
$!
$ make_cmd == "?"
$ if f$type(perl_make) .eqs. "STRING" ! User has chosen the make utility
$ then
$	make_cmd == perl_make
$ else
$    ! Check if MMK is installed
$    if f$type(MMK) .eqs. "STRING" 
$    then 
$	make_cmd == MMK
$    else
$       ! Check if MMS is installed
$	l_msg=f$environment("MESSAGE")
$	set message /nofacility/noidentifcation/noseverity/notext
$	mms /identification
$	l_status=$status
$	set message 'l_msg'
$!
$	if l_status .eq. 1 ! MMS is installed
$	then
$	    make_cmd == "MMS" ! quotes needed
$	endif
$    endif
$ endif
$ if make_cmd .eqs. "?"
$ then
$	gosub make_cmd_error
$	exit 18
$ endif
$ write sys$output "Perl will be built using ",make_cmd
$ make_cmd /ident ! this may need changing for other make utilities ...
$ l_status=$status
$ if l_status .eq. %x38090 ! DCL-W-IVVERB
$ then
$	gosub make_cmd_error
$	exit 18
$ endif
$!
$ if p2 .nes. "" then goto 'p2'
$!
$ write sys$output "Unpacking Perl source archive..."
$ unzip -"q" source.zip
$ set default perlkit:[source]
$ show default
$!
$ CONFIGURE:
$!
$! Configure.com uses the prefix symbol to assign the 
$! equivalence name for perl_root when it is writing
$! perl_setup.com, which in turn determines the install
$! location.  We'll accept it as our first parameter or 
$! choose a default location at the same level as the 
$! source tree.
$!
$ prefix = p1
$ if prefix .eqs. "" then prefix = "perlkit:[perl.]"
$ prefixbase = prefix - ".]"
$ prefix = prefixbase + "]"
$ prefix = F$PARSE(prefix,,,,"NO_CONCEAL,SYNTAX_ONLY") - "][" - ".;"
$ prefixbase = prefix - "]"
$ prefix = prefixbase + ".]"
$ write sys$output "The installed Perl's root will be ''prefix'" 
$!
$ phase == "CONFIGURE"
$ write sys$output "Configuring Perl for the local system..."
$ set default perlkit:[source]
$ show default
$ @configure -"des" -"Dcf_email=system"
$!
$ BUILD:
$!
$ phase == "BUILD"
$ write sys$output "Building Perl..."
$ set default perlkit:[source]
$ show default
$ make_cmd
$!
$ TEST:
$!
$ phase == "TEST"
$ write sys$output "Running Perl's test suite..."
$ set default perlkit:[source]
$ show default
$ make_cmd test
$!
$ INSTALL:
$!
$ phase == "INSTALL"
$ write sys$output "Installing Perl..."
$ set default perlkit:[source]
$ show default
$ make_cmd install 
$!
$! Make any libraries we need.
$!
$ LIBRARIES:
$ phase == "LIBRARIES"
$ set default perlkit:[000000]
$ show default
$ write sys$output "Unpacking additional libraries..."
$ unzip -"q" libraries.zip
$ set default perlkit:[libraries]
$ show default
$!
$ call make_library [.expat] make_cmd/DESCRIPTION=[.vms]
$!
$! Make any Perl extensions we're including.
$!
$ MODULES:
$ set noon	! build the ones we can even if one fails
$ phase == "MODULES"
$ set default perlkit:[000000]
$ show default
$ write sys$output "Unpacking Perl extensions..."
$ unzip -"q" modules.zip
$ set default perlkit:[modules]
$ show default
$ @perlkit:[source]perl_setup.com
$!
$ call make_module Compress-Zlib
$ call make_module Data-FixedFormat
$ call make_module DBI
$ call make_module HTML-Tagset		! must be before HTML::Parser
$ call make_module HTML-Parser
$ call make_module URI
$ call make_module LIBWWW-PERL
$ call make_module MIME-LITE
$ call make_module SMG
$ call make_module VMS-DEVICE
$ call make_module VMS-FILEUTILS
$ call make_module VMS-FINDFILE
$ call make_module VMS-INDEXEDFILE	! must be before VMS::FlatFile
$ call make_module VMS-FLATFILE
$ call make_module VMS-ICC
$ call make_module VMS-LIBRARIAN
$ call make_module VMS-LOCK
$ call make_module VMS-MAIL
$ call make_module VMS-MISC "POLLUTE=1"
$ call make_module VMS-MONITOR "POLLUTE=1"
$ call make_module VMS-PERSONA
$ call make_module VMS-PRIV "POLLUTE=1"
$ call make_module VMS-PROCESS "POLLUTE=1"
$ call make_module VMS-QUEUE
$ call make_module VMS-SYSTEM
$ call make_module VMS-USER "POLLUTE=1"
$ call make_module XML-PARSER "EXPATLIBPATH=perlkit:[libraries.expat]" -
                              "EXPATINCPATH=perlkit:[libraries.expat.lib]" 
$!
$ set default perlkit:[source]
$ show default
$ copy/log/noconfirm perl_setup.com [-]
$ make_cmd realclean
$ write sys$output "It's hard to believe, but I'm done!"
$ exit
$!
$ basic_failure: 
$!  Come here if something failed that was too essential to consider continuing without it.
$  exit_status = $status
$  write sys$output "Terminated at ''phase' due to " + f$message(exit_status)
$  exit exit_status
$!
$ make_library: subroutine
$  location = p1
$  command1 = p2
$  command2 = p3
$  saved_cwd = f$directory()
$  on error then goto exit_make_library
$!
$  set default 'location'
$  show default
$!  
$  verify = f$verify(1)
$  if command1 .nes. "" then 'command1'
$  if command2 .nes. "" then 'command2'
$  verify = f$verify(verify)
$!
$ exit_make_library:
$  set default 'saved_cwd'
$!
$ endsubroutine
$!
$ make_module: subroutine
$  module = p1
$  saved_cwd = f$directory()
$  on error then goto exit_make_module
$!
$  set default [.'module']
$  show default
$!
$  write sys$output "Configuring ''module'..."
$  perl Makefile.PL "''p2'" "''p3'" "''p4'" "''p5'" "''p6'" "''p7'" "''p8'" 
$  write sys$output "Building ''module'..."
$  make_cmd all
$  set noon
$  write sys$output "Testing ''module'..."
$  make_cmd test
$  set on
$  write sys$output "Installing ''module'..."
$  make_cmd install
$  make_cmd realclean
$!
$ exit_make_module:
$  set default 'saved_cwd'
$!
$ endsubroutine
$!
$ make_cmd_error: subroutine
$ type sys$input

	Cannot determine Perl MAKE command.

	Define the symbol PERL_MAKE to tell me what to use, e.g.

	PERL_MAKE == "MMS" ! quotes are needed
	or
	PERL_MAKE ==  MMK  ! do not use quotes unless MMK is installed

$ endsubroutine
