$!---------------make.com for Xvmsutils---------------------------------------
$! make xvmsutils under OpenVMS
$!
$! In case of problems with the build you might want to contact me at
$! zinser@zinser.no-ip.info(preferred) or 
$! zinser@sysdev.deutsche-boerse.com (Work)
$!
$ SAVE_VERIFY='F$VERIFY(0)
$ Make   = ""
$ true   = 1
$ false  = 0
$ tmpnam = "temp_" + f$getjpi("","pid")
$ tc     = tmpnam + ".c"
$ mapfile = "x11vmsshr.map"
$!
$! Make sure no "rouge" includes are leftover from previous runs
$!
$ hlist = "dirent.h#tzset.h#pwd.h#fcntl.h"
$ i = 0
$HLOOP:
$ hdel = f$element(i,"#",hlist)
$ if (hdel .nes. "#")
$ then
$   i = i + 1
$   if f$search(hdel) .nes. "" then delete 'hdel';*
$   goto hloop
$ endif
$!
$! Check for MMK/MMS
$!
$ If F$Search ("Sys$System:MMS.EXE") .nes. "" Then Make = "MMS"
$ If F$Type (MMK) .eqs. "STRING" Then Make = "MMK"
$!
$ if p1 .Eqs. "CLEAN" then goto clean
$ if p1 .Eqs. "CLOBBER" then goto clobber
$ if p1 .Eqs. "INSTALL" then goto install
$!
$!	Compile the X11 Unix and VMS Utils library
$!
$! Establish the Compiling Environment
$!
$ Cpu_Model = F$GetSYI("HW_MODEL")
$!
$!  Get the compiler options via the logical name COPTS
$!
$ cflags = f$trnlnm("COPTS")
$!
$!
$! Get the compiler used
$!
$ decc = f$search("SYS$SYSTEM:DECC$COMPILER.EXE") .NES. "" -
         .and. CFLAGS - "/VAXC" .eqs. CFLAGS
$ all_cflags = CFLAGS + "/include=[]"
$ if decc 
$  then 
$   all_cflags = "/DECC/PREFIX=all " + all_cflags
$   makmac = "/macro=(__DECC__=1"
$ else
$   makmac = "/macro=(__VAXC__=1"
$ endif
$!
$!  Get the linker options via the logical name LOPTS
$!
$ link_options = f$trnlnm("LOPTS")
$!
$!  Find out which X-Version we're running.  This will fail for older
$!  VMS versions (i.e., v5.5-1).  Therefore, choose DECWindows XUI for
$!  default.
$!
$ On Error Then oldx = 1
$ @sys$update:decw$get_image_version sys$share:decw$xlibshr.exe decw$version
$ if f$extract(4,3,decw$version).ges."1.2"
$ then
$   oldx = 0
$ else
$   oldx = 1
$   makmac = ''makmac' + ",__oldx__=1"
$ endif
$!
$! Check out the VMS version we are using
$!
$ if f$extract(1,3,f$getsyi("Version")) .ges. "6.2"
$  then
$   vv62 = 1
$   makmac = ''makmac' + ",__vv62__=1"
$  else
$   vv62 = 0
$ endif
$ if f$extract(1,3,f$getsyi("Version")) .ges. "7.0"
$  then
$   vv7 = 1
$   makmac = ''makmac' + ",__vv7__=1"
$  else
$   vv7 = 0
$ endif
$ makmac = ''makmac' + ")"
$ On Error Then continue
$ if f$search("XVMSUTILS.OLB") .eqs. ""
$ then
$	lib/create/log/object xvmsutils.olb
$ endif
$!
$! Create linker option file
$!
$ open/write optf xvmsutils.opt
$ open/write topt tmp.opt
$ write optf "CHOOSE_WINDOW.OBJ"
$ write optf "CREATE_DIR.OBJ"
$ write optf "FATALERR.OBJ"
$ write optf "GETHOSTNAME.OBJ"
$ write optf "HPWD.OBJ"
$ write optf "LNM.OBJ"
$ write optf "LOWERCASE.OBJ"
$ write optf "PRINT_EVENT.OBJ"
$ write optf "PSEUDO_ROOT.OBJ"
$ write optf "TIMER.OBJ"
$ write optf "VALIDATE.OBJ"
$ write optf "VMS_STAT.OBJ"
$ if oldx then write optf "XMISC.OBJ"
$ if vv62.eq.0 .or. .not.decc then write optf "GETOPT.OBJ"
$ if vv7.eq.0 .or. .not.decc
$   then
$    write optf "POPEN.OBJ"
$    write optf "PUTENV.OBJ"
$    write optf "UNIX_TIMES.OBJ"
$ endif
$ close topt
$ write sys$output "Compiling VMS UNIX Emulation Utilites"
$ gosub check_function
$  if (Make .nes. "")
$   then
$    'Make' 'makmac
$  else
$!
$!  Compile the "C" files
$!
$ CALL MAKE CHOOSE_WINDOW.OBJ	"CC ''all_cflags' CHOOSE_WINDOW.C"	CHOOSE_WINDOW.C
$ CALL MAKE CREATE_DIR.OBJ	"CC ''all_cflags' CREATE_DIR.C"		CREATE_DIR.C
$ CALL MAKE FATALERR.OBJ	"CC ''all_cflags' FATALERR.C"		FATALERR.C
$ CALL MAKE GETHOSTNAME.OBJ	"CC ''all_cflags' GETHOSTNAME.C"	GETHOSTNAME.C
$ CALL MAKE HPWD.OBJ		"CC ''all_cflags' HPWD.C"		HPWD.C
$ CALL MAKE LNM.OBJ		"CC ''all_cflags' LNM.C"		LNM.C
$ CALL MAKE LOWERCASE.OBJ       "CC ''all_cflags' LOWERCASE.C"		LOWERCASE.C
$ CALL MAKE PRINT_EVENT.OBJ	"CC ''all_cflags' PRINT_EVENT.C"	PRINT_EVENT.C
$ CALL MAKE PSEUDO_ROOT.OBJ	"CC ''all_cflags' PSEUDO_ROOT.C"	PSEUDO_ROOT.C
$ CALL MAKE TIMER.OBJ		"CC ''all_cflags' TIMER.C"		TIMER.C
$ CALL MAKE VALIDATE.OBJ	"CC ''all_cflags' VALIDATE.C"		VALIDATE.C
$ CALL MAKE VMS_STAT.OBJ	"CC ''all_cflags' VMS_STAT.C"		VMS_STAT.C
$!
$! Only compile for X11R4 or earlier
$!
$ if oldx.eq.1
$  then
$     CALL MAKE XMISC.OBJ	"CC ''all_cflags' XMISC.C"	XMISC.C
$ endif
$ if vv62.eq.0 .or. .not.decc
$   then
$    CALL MAKE GETOPT.OBJ	"CC ''all_cflags' GETOPT.C"	GETOPT.C
$ endif
$ if vv7.eq.0 .or. .not.decc
$   then
$    CALL MAKE POPEN.OBJ	"CC ''all_cflags' POPEN.C"	POPEN.C
$    CALL MAKE PUTENV.OBJ       "CC ''all_cflags' PUTENV.C"	PUTENV.C
$    CALL MAKE UNIX_TIMES.OBJ	"CC ''all_cflags' UNIX_TIMES.C"	UNIX_TIMES.C
$ endif
$!
$!
$ write sys$output "Building VMS UNIX Emulation Library"
$ CALL MAKE XVMSUTILS.OLB	"LIBRARY/replace/log XVMSUTILS.OLB *.OBJ"	*.OBJ
$endif
$!
$!
$ write optf "sys$share:decw$xlibshr.exe/share"
$ close optf
$!
$! Alpha gets a shareable image
$!
$ If Cpu_Model .gt. 1024
$ Then
$   LINK_/NODEB/NOSHARE/NOEXE/MAP='mapfile'/full xvmsutils.opt/opt
$   call anal_map_axp 'mapfile' _link.opt
$   LINK_/NODEB/SHARE=x11vmsshr.exe xvmsutils.opt/opt,_link.opt/opt
$   dele/noconf 'mapfile';*
$ endif
$!
$ dele/noconf *.opt;*
$ exit
$!
$ Clobber:	! Delete executables, Purge directory and clean up object files and listings
$ Delete/noconfirm/log *.olb;*
$ Delete/noconfirm/log [-.lib]xvmsutils.olb;*
$!
$ Clean:	! Purge directory, clean up object files and listings
$ Purge
$ Delete/noconfirm/log *.lis;*
$ Delete/noconfirm/log *.obj;*
$!
$ exit
$!
$ Install:
$ write sys$output "Install currently not implemented"
$ exit
$!
$!------------------------------------------------------------------------------
$!
$! Check if a specific function needs to be implemented
$!
$CHECK_FUNCTION:
$!
$! drand48...
$!
$ func = "rand48"
$ hfile = ""
$ copy sys$input: 'tc
$ deck
#include <stdlib.h>
#include <stdio.h>
int main(){
 srand48(42.);
 printf("%f\n",drand48());
 return EXIT_SUCCESS;
}
$ eod
$ gosub cc_prop_check
$!
$! random...
$!
$ func = "random"
$ hfile = ""
$ copy sys$input: 'tc
$ deck
#include <stdlib.h>
#include <stdio.h>

int main(){
 srandom(42);
 printf("%d\n",random());
 return EXIT_SUCCESS;
}
$ eod
$ gosub cc_prop_check
$!
$! snprintf...
$!
$ func = "snprintf"
$ hfile = ""
$ copy sys$input: 'tc
$ deck
#include <stdio.h>
int main(){
  char test[10];
  snprintf(test,6,"%s","hello");
}
$ eod
$ gosub cc_prop_check
$!
$! tzset
$!
$ func = "tzset"
$ hfile = "tzset"
$ copy sys$input 'tc
$ deck
#include <time.h>
int main(){
  tzset(); 
}
$ eod
$ gosub cc_prop_check
$!
$! directory
$!
$ func = "directory"
$ hfile = "dirent"
$ copy sys$input 'tc
$ deck
#include <dirent.h>
int main(){}    
$ eod
$ gosub cc_prop_check
$!
$! getpwnam
$!
$ func = "getpwnam"
$ hfile = "pwd"
$ copy sys$input 'tc
$ deck
#include <pwd.h>
int main(){}    
$ eod
$ gosub cc_prop_check
$!
$! getpwuid
$!
$ func = "getpwuid"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <pwd.h>
int main(){}    
$ eod
$ gosub cc_prop_check
$!
$! x11vms_getpwuid - horrible hack to get around missing functionality in
$!                   the C RTLs implementation
$!
$ func = "x11vms_getpwuid"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <pwd.h>
#include <stdio.h>
#include <unistd.h>
int main(){
  struct passwd *PasswdRec;
  PasswdRec = getpwuid(getuid());
  printf("%s\n",PasswdRec->pw_gecos);
}
$ eod
$ gosub cc_prop_check
$!
$! fcntl.h
$!
$ func = ""
$ hfile = "fcntl.h"
$ copy sys$input 'tc
$ deck
#include <fcntl.h>
int main(){}    
$ eod
$ gosub cc_prop_check
$!
$! strcasecmp.c
$!
$ func = "strcasecmp"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <string.h>
#include <stdio.h>
int main(){
 char *s1 = "ABC";
 char *s2 = "ABC";
 strcasecmp(s1,s2);
}
$ eod
$ gosub cc_prop_check
$!
$! uname
$!
$ func = "uname"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <sys/utsname.h>
#include <stdio.h>
#include <stdlib.h>
int main(){
  struct utsname *buf;
  buf = (struct utsname *)malloc(sizeof(buf));
  uname(buf);
  printf("%s\n",buf->sysname); 
}
$ eod
$ gosub cc_prop_check
$!
$! usleep
$!
$ func = "usleep"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <unistd.h>
int main(){
  usleep(10); 
}
$ eod
$ gosub cc_prop_check
$!
$! strdup
$!
$ func = "strdup"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <string.h>
int main(){
  strdup("AABAA");
}
$ eod
$ gosub cc_prop_check
$!
$! getlogin
$!
$ func = "getlogin"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <unistd.h>
int main(){
  getlogin();
}
$ eod
$ gosub cc_prop_check
$!
$! IOCTL for UCX (real TCP stacks have this anyhow)
$!
$ if (f$trnlnm("UCX$NETWORK").nes."" .or. f$trnlnm("TCPIP$NETWORK").nes."")
$ then
$   func = "ioctl"
$   hfile = ""
$   copy sys$input 'tc
$   deck
#include <stdlib.h>
#include <ioctl.h>
int main(){
  ioctl(1,1,NULL);
}
$   eod
$   gosub cc_prop_check
$ endif
$!
$! strings
$!
$ func = "strings"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <strings.h>
int main(){
  index("ABC",'C');
}
$ eod
$ gosub cc_prop_check
$!
$! tempnam
$!
$ func = "tempnam"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <stdio.h>
int main(){
  printf("%s\n",tempnam("sys$scratch:","tmp"));
}
$ eod
$ gosub cc_prop_check
$!
$! getpass
$!
$ func = "getpass"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <unistd.h>
#include <stdio.h>
int main(){
  printf("%s\n",getpass("Secret:"));
}
$ eod
$ gosub cc_prop_check
$!
$! getpass
$!
$ func = "grp"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <unistd.h>
int main(){
  getgroups(0,NULL);
}
$ eod
$ gosub cc_prop_check
$!
$! unlink
$!
$ func = "unlink"
$ hfile = ""
$ copy sys$input 'tc
$ deck
#include <unistd.h>
int main(){
  unlink("temp.txt"); 
}
$ eod
$ gosub cc_prop_check
$!
$ return
$!
$!------------------------------------------------------------------------------
$!
$! Check for properties of C/C++ compiler
$!
$CC_PROP_CHECK:
$ cc_prop = true
$ set message/nofac/noident/nosever/notext
$ on error then continue
$ cc 'all_cflags' 'tmpnam'
$ if .not. ($status) then cc_prop = false
$! The headers might lie about the capabilities of the RTL
$ on error then continue
$ link 'tmpnam',tmp.opt/opt
$ if .not. ($status)  then cc_prop = false
$ set message/fac/ident/sever/text
$ delete/nolog 'tmpnam'.*;*
$ if cc_prop 
$ then
$   if (func .nes. "") 
$   then
$     write sys$output "Function ''func' implemented in C RTL"
$   else
$     write sys$output "h-file ''hfile' part of C RTL"
$   endif
$ else 
$   if (func .nes. "")
$   then  
$     CALL MAKE 'func'.OBJ  "CC ''all_cflags' ''func'.C" 'func'.C
$     lib/replace/log  xvmsutils.olb 'func'.obj
$     write optf "''func'.obj"
$   endif
$   if (hfile .nes. "") then copy 'hfile'_in 'hfile'
$ endif
$ return
$!
$!------------------------------------------------------------------------------
$!
$MAKE: SUBROUTINE   !SUBROUTINE TO CHECK DEPENDENCIES
$ V = 'F$Verify(0)
$! P1 = What we are trying to make
$! P2 = Command to make it
$! P3 - P8  What it depends on
$
$ If F$Search(P1) .Eqs. "" Then Goto Makeit
$ Time = F$CvTime(F$File(P1,"RDT"))
$arg=3
$Loop:
$	Argument = P'arg
$	If Argument .Eqs. "" Then Goto Exit
$	El=0
$Loop2:
$	File = F$Element(El," ",Argument)
$	If File .Eqs. " " Then Goto Endl
$	AFile = ""
$Loop3:
$	OFile = AFile
$	AFile = F$Search(File)
$	If AFile .Eqs. "" .Or. AFile .Eqs. OFile Then Goto NextEl
$	If F$CvTime(F$File(AFile,"RDT")) .Ges. Time Then Goto Makeit
$	Goto Loop3
$NextEL:
$	El = El + 1
$	Goto Loop2
$EndL:
$ arg=arg+1
$ If arg .Le. 8 Then Goto Loop
$ Goto Exit
$
$Makeit:
$ Set Verify
$ 'P2
$ VV='F$Verify(0)
$Exit:
$ If V Then Set Verify
$ENDSUBROUTINE
$!
$!------------------------------------------------------------------------------
$!
$! Analyze Map for OpenVMS AXP
$!
$ ANAL_MAP_AXP: Subroutine   
$ V = 'F$Verify(0)
$ SET SYMBOL/GENERAL/SCOPE=(NOLOCAL,NOGLOBAL)
$ SAY := "WRITE_ SYS$OUTPUT"
$ 
$ IF F$SEARCH("''P1'") .EQS. ""
$ THEN
$    SAY "  ANAL_MAP_AXP:  Error, no mapfile provided"
$    goto exit_aa
$ ENDIF
$ IF "''P2'" .EQS. ""
$ THEN
$    SAY "  ANALYZE_MAP_AXP:  Error, no output file provided"
$    goto exit_aa
$ ENDIF
$
$ LINK_TMP  = F$PARSE(P2,,,"DEVICE")+F$PARSE(P2,,,"DIRECTORY")+F$PARSE(P2,,,"NAME")+".TMP"
$
$ SAY "  creating PSECT list in ''P2'"
$ OPEN_/READ IN 'P1'
$ OPEN_/WRITE OUT 'P2'
$ WRITE_ OUT "!"
$ WRITE_ OUT "! ### PSECT list extracted from ''P1'"
$ WRITE_ OUT "!" 
$ LOOP_PSECT_SEARCH:
$    READ_/END=EOF_PSECT IN REC
$    if F$EXTRACT(0,5,REC) .nes. "$DATA" then goto LOOP_PSECT_SEARCH
$ LAST = ""
$ LOOP_PSECT:
$    READ_/END=EOF_PSECT IN REC
$    if F$EXTRACT(0,1,REC) .eqs. "$" .and. F$EXTRACT(0,5,REC) .nes. "$DATA" then goto EOF_PSECT
$    if REC - "NOPIC,OVR,REL,GBL,NOSHR,NOEXE,  WRT,NOVEC" .nes. REC
$    then 
$       J = F$LOCATE(" ",REC)
$       S = F$EXTRACT(0,J,REC)
$       IF S .EQS. LAST THEN GOTO LOOP_PSECT
$       WRITE_ OUT "symbol_vector = (" +  S + " = PSECT)"
$       P$_'S= 1
$       LAST = S
$    endif
$    GOTO LOOP_PSECT
$
$ EOF_PSECT:
$    CLOSE_ IN
$    CLOSE_ OUT 
$!
$ OPEN_/READ IN 'P1'
$ OPEN_/APPEND OUT 'P2'
$ WRITE_ OUT "!"
$ WRITE_ OUT "! ### Global definition list extracted from ''P1'"
$ WRITE_ OUT "!" 
$ LOOP_DATA_SEARCH:
$   READ_/END=EOF_DATA IN REC
$   if f$locate("NOPIC,OVR,REL,GBL,NOSHR,NOEXE",rec) .eq. f$length(rec) -
      then goto LOOP_DATA_SEARCH
$   s = f$element(0," ",rec)      
$!   write_ out "symbol_vector = (" + s + " = DATA)"
$   p$_'s' =1
$   goto loop_data_search 
$ EOF_DATA:
$ CLOSE_ IN
$ CLOSE_ OUT
$ SAY "  appending list of UNIVERSAL procedures to ''P2'"
$ SEARCH_/NOHIGH/WINDOW=(0,0) 'P1' " R-"/OUT='LINK_TMP
$ OPEN_/READ IN 'LINK_TMP
$ OPEN_/APPEND OUT 'P2'
$ WRITE_ OUT "!"
$ WRITE_ OUT "! ### UNIVERSAL procedures and global definitions extracted from ''P1'"
$ WRITE_ OUT "!" 
$ LOOP_UNIVERSAL:
$    READ_/END=EOF_UNIVERSAL IN REC
$    data = 0
$    J = F$LOCATE(" R-",REC)
$    S = F$EXTRACT(J+3,F$length(rec),REC)
$    IF (F$TYPE(P$_'S').EQS."").and.(data.ne.1) 
$    THEN
$       WRITE_ OUT "symbol_vector = ("+S+"	= PROCEDURE)"
$    ELSE
$       WRITE_ OUT "symbol_vector = ("+S+"	= DATA)"
$    ENDIF
$    GOTO LOOP_UNIVERSAL
$ EOF_UNIVERSAL:
$    CLOSE_ IN
$    CLOSE_ OUT
$    if f$search("''LINK_TMP'") .nes. "" then DELETE_/NOLOG/NOCONFIRM 'LINK_TMP';*
$
$ EXIT_AA:
$ if V then set verify
$ endsubroutine 
