$! Compile and link latex2rtf under OpenVMS
$!
$! In case of problems with the install you might contact me at
$! zinser@zinser.no-ip.info (preferred) or zinser@sysdev.deutsche-boerse.de
$!
$!------------------------------------------------------------------------------
$!
$! Define some general constants
$!
$ true     = 1
$ false    = 0
$ tmpnam   = "TEMP" + f$getjpi("","PID") + ".TXT"
$ prognam  = "Latex2rtf"
$ its_decc = false
$ its_vaxc = false
$ its_gnuc = false
$ ccopt    = ""
$ lopts    = ""
$ linkonly = false
$ its_vax  = f$getsyi("cpu") .lt. 128
$!
$ gosub check_opts
$!
$ gosub check_compiler
$!
$ if its_decc .and. its_vax then ccopt = "/DECC" + ccopt
$  
$ open/write optf 'prognam'.opt
$FLOOP:
$ CSRC = f$search("*.c")
$ if csrc .nes. ""
$ then
$   fname = f$parse(csrc,,,"name")
$   write optf fname, ".obj"
$   if linkonly then goto floop
$   cfname = f$parse(csrc,,,"name") + f$parse(csrc,,,"type")
$   write sys$output "Compiling ", cfname
$   cc 'cfname
$   goto floop
$ endif
$ close optf
$ write sys$output "Linking ''prognam'..." 
$ link/exe='prognam'.exe 'lopts' 'prognam'.opt/opt
$ exit
$CC_ERR:
$ write sys$output "C compiler required to build ''prognam'"
$ goto err_exit
$ERR_EXIT:
$ set message/facil/ident/sever/text
$ close/nolog optf
$ close/nolog aconf_in
$ close/nolog aconf
$ close/nolog tmpc
$ write sys$output "Exiting..."
$ exit 2
$!------------------------------------------------------------------------------
$!
$! Look for the compiler used 
$!
$CHECK_COMPILER:
$ if (.not. (its_decc .or. its_vaxc .or. its_gnuc))
$ then
$   its_decc = (f$search("SYS$SYSTEM:DECC$COMPILER.EXE") .nes. "")
$   its_vaxc = .not. its_decc .and. (F$Search("SYS$System:VAXC.Exe") .nes. "")
$   its_gnuc = .not. (its_decc .or. its_vaxc) .and. (f$trnlnm("gnu_cc") .nes. "")
$ endif
$!
$! Exit if no compiler available
$!
$ if (.not. (its_decc .or. its_vaxc .or. its_gnuc)) 
$ then goto CC_ERR
$ else
$   if its_decc then write sys$output "CC compiler check ... Compaq C"
$   if its_vaxc then write sys$output "CC compiler check ... VAX C"
$   if its_gnuc then write sys$output "CC compiler check ... GNU C"
$ endif
$ return
$!------------------------------------------------------------------------------
$!
$! Check command line options and set symbols accordingly
$!
$ CHECK_OPTS:
$ i = 1
$ OPT_LOOP:
$ if i .lt. 9
$ then
$   cparm = f$edit(p'i',"upcase")
$   if cparm .eqs. "DEBUG"
$   then
$     ccopt = ccopt + "/noopt/deb"
$     lopts = lopts + "/deb"
$   endif
$   if f$locate("CCOPT=",cparm) .lt. f$length(cparm)
$   then
$     start = f$locate("=",cparm) + 1
$     len   = f$length(cparm) - start
$     ccopt = ccopt + f$extract(start,len,cparm)
$   endif
$   if cparm .eqs. "LINK" then linkonly = true
$   if f$locate("LOPTS=",cparm) .lt. f$length(cparm) 
$   then
$     start = f$locate("=",cparm) + 1
$     len   = f$length(cparm) - start
$     lopts = lopts + f$extract(start,len,cparm)
$   endif
$   if f$locate("CC=",cparm) .lt. f$length(cparm) 
$   then
$     start  = f$locate("=",cparm) + 1
$     len    = f$length(cparm) - start
$     cc_com = f$extract(start,len,cparm)
      if (cc_com .nes. "DECC") .and. - 
         (cc_com .nes. "VAXC") .and. - 
	 (cc_com .nes. "GNUC")
$     then
$       write sys$output "Unsupported compiler choice ''cc_com' ignored"
$       write sys$output "Use DECC, VAXC, or GNUC instead"
$     else 
$     	if cc_com .eqs. "DECC" then its_decc = true   
$     	if cc_com .eqs. "VAXC" then its_vaxc = true   
$     	if cc_com .eqs. "GNUC" then its_gnuc = true   
$     endif 
$   endif
$   i = i + 1
$   goto opt_loop
$ endif
$ return
$!------------------------------------------------------------------------------
