/*****************************************************************************/
/*
                                CgiLib.h

05-APR-2001  MGD  v1.6.0
22-MAR-2001  MGD  v1.5.3
08-JAN-2001  MGD  v1.5.2
09-DEC-2000  MGD  v1.5.1
28-OCT-2000  MGD  v1.5.0
24-JUN-2000  MGD  v1.4.2
30-MAY-2000  MGD  v1.4.1
09-APR-2000  MGD  v1.4.0
19-FEB-2000  MGD  v1.3.0
24-SEP-1999  MGD  v1.2.0
26-JUN-1999  MGD  v1.1.0
24-APR-1999  MGD  v1.0.0
*/
/*****************************************************************************/

#ifndef CGILIB_H_LOADED
#define CGILIB_H_LOADED 1

#define CGILIB_VERSION "1.6.1"

#define CGILIB_CGIPLUS_VAR_RECORD "CGILIB_CGIPLUS_VAR_RECORD"

/* Alpha NO MEMBER ALIGNMENT unless otherwise specified */
#ifdef __ALPHA
#   pragma member_alignment __save
#   pragma nomember_alignment
#endif

/* constants for tracking what environment it's catering for */
#define CGILIB_ENVIRONMENT_WASD      1
#define CGILIB_ENVIRONMENT_CGIPLUS   2
#define CGILIB_ENVIRONMENT_OSU       3
#define CGILIB_ENVIRONMENT_PURVEYOR  4
#define CGILIB_ENVIRONMENT_APACHE    5
#define CGILIB_ENVIRONMENT_CGI       6

#define CGILIB_ENVIRONMENT_STDOUT_BINARY 1
#define CGILIB_ENVIRONMENT_STDOUT_RECORD 2

#ifdef CGILIB_OBJECT_MODULE
#  define CGILIB_ALL_SUPPORT 1
#  define CGILIB_USAGE "/OBJ"
#else
#  define CGILIB_USAGE "/INC"
#endif

#ifdef __ALPHA
#   define CGILIB_SOFTWAREID "CGILIB AXP-" CGILIB_VERSION CGILIB_USAGE
#else
#   define CGILIB_SOFTWAREID "CGILIB VAX-" CGILIB_VERSION CGILIB_USAGE
#endif

/* always gonna use this */
#define CGILIB_ENVIRONMENT_SUPPORT 1
#define CGILIB_RESPONSE_SUPPORT 1

#ifndef CGILIB_ALL_SUPPORT
#   define CGILIB_ALL_SUPPORT 0
#endif
#if CGILIB_ALL_SUPPORT
#   define CGILIB_CGIVAR_SUPPORT 1
#   define CGILIB_CGIPLUS_SUPPORT 1
#   define CGILIB_OSU_SUPPORT 1
#   define CGILIB_POST_SUPPORT 1
#   define CGILIB_GENERAL_SUPPORT 1
#   define CGILIB_RESPONSE_SUPPORT 1
#endif

/* includes code supporting CGI variables */
#ifndef CGILIB_CGIVAR_SUPPORT
#   define CGILIB_CGIVAR_SUPPORT 0
#endif

/* includes code supporting CGIplus variables */
#ifndef CGILIB_CGIPLUS_SUPPORT
#   define CGILIB_CGIPLUS_SUPPORT 0
#endif

/* includes code supporting OSU variables and output stream */
#ifndef CGILIB_OSU_SUPPORT
#   define CGILIB_OSU_SUPPORT 0
#endif

/* if false excludes code providing request body processing */
#ifndef CGILIB_POST_SUPPORT
#   define CGILIB_POST_SUPPORT 0
#endif

/* if false excludes code providing support/conversion routines */
#ifndef CGILIB_GENERAL_SUPPORT
#   define CGILIB_GENERAL_SUPPORT 0
#endif

/* if false excludes code providing support/conversion routines */
#ifndef CGILIB_RESPONSE_SUPPORT
#   define CGILIB_RESPONSE_SUPPORT 0
#endif

#if CGILIB_CGIVAR_SUPPORT
    /* includes code supporting non-"WWW_" prefixed variables */
#   ifndef CGILIB_CGIVAR_NON_WASD
#      define CGILIB_CGIVAR_NON_WASD 1
#   endif
    /* size of memory allocation in CgiLib__VarList() */
#   ifndef CGILIB_VARLIST_CHUNK
#      define CGILIB_VARLIST_CHUNK 2048
#   endif
#endif

/* if providing CGIplus variables */
#ifdef CGILIB_CGIPLUS_SUPPORT
#   ifdef CGILIB_CGIPLUS_LINE_SIZE
       /* for backward compatibility */
#      define CGILIB_CGIPLUS_RECORD_SIZE CGILIB_CGIPLUS_RECORD_SIZE
#   endif
#   ifndef CGILIB_CGIPLUS_RECORD_SIZE
       /* set fairly large to allow for CGIplus stream variables */
#      define CGILIB_CGIPLUS_RECORD_SIZE 16384
#   endif
#endif

/* if providing body processing support functions */
#ifdef CGILIB_POST_SUPPORT
#   ifndef CGILIB_BODY_CHUNK
#      define CGILIB_BODY_CHUNK 4096
#   endif
    /* size of memory allocation in CgiLib__VarList() */
#   ifndef CGILIB_VARLIST_CHUNK
#      define CGILIB_VARLIST_CHUNK 2048
#   endif
#endif

/* if providing support functions */
#ifdef CGILIB_GENERAL_SUPPORT
#   ifndef CGILIB_ENCODED_CHUNK
#      define CGILIB_ENCODED_CHUNK 256
#   endif
#   ifndef CGILIB_ESCAPED_CHUNK
#      define CGILIB_ESCAPED_CHUNK 256
#   endif
    /* bitwise values used in CgiLibAnchorEscapeHtml() */
#   define CGILIB_ANCHOR_NONE  0
#   define CGILIB_ANCHOR_WEB   1
#   define CGILIB_ANCHOR_MAIL  2
#   define CGILIB_ANCHOR_ALL  -1
#endif

/* if providing response-generation functions */
#if CGILIB_RESPONSE_SUPPORT

#   ifndef CGILIB_RESPONSE_BODY
       /* <BODY...> tag parameters */
#      define CGILIB_RESPONSE_BODY              ""
#   endif
#   ifndef CGILIB_RESPONSE_CHARSET
       /* script-specified ";charset=xxx" if the content is text */
#      define CGILIB_RESPONSE_CHARSET           NULL
#   endif
#   ifndef CGILIB_RESPONSE_DEFAULT_CHARSET
       /* default ";charset=xxx" if the content is text */
#      define CGILIB_RESPONSE_DEFAULT_CHARSET   "ISO-8859-1"
#   endif
#   ifndef CGILIB_RESPONSE_SOFTWAREID
       /* for <META...> tag information */
#      define CGILIB_RESPONSE_SOFTWAREID  CGILIB_SOFTWAREID
#   endif
#   ifndef CGILIB_RESPONSE_ERROR_MESSAGE
#      define CGILIB_RESPONSE_ERROR_MESSAGE     "Reported by script."
#   endif

#   ifndef CGILIB_RESPONSE_ERROR_STATUS
       /* HTTP status code when reporting errors */
#      define CGILIB_RESPONSE_ERROR_STATUS      404
#   endif
#   ifndef CGILIB_RESPONSE_ERROR_TITLE
       /* large, bolded error report page title */
#      define CGILIB_RESPONSE_ERROR_TITLE       "ERROR"
#   endif
#   ifndef CGILIB_RESPONSE_ERROR_INFO
       /* post-error-report text message (site-specific) */
#      define CGILIB_RESPONSE_ERROR_INFO        ""
#   endif

#   ifndef CGILIB_RESPONSE_SUCCESS_STATUS
       /* HTTP status code when reporting success */
#      define CGILIB_RESPONSE_SUCCESS_STATUS      200
#   endif
#   ifndef CGILIB_RESPONSE_SUCCESS_TITLE
       /* large, bolded success report page title */
#      define CGILIB_RESPONSE_SUCCESS_TITLE     "SUCCESS"
#   endif
#   ifndef CGILIB_RESPONSE_SUCCESS_MESSAGE
#      define CGILIB_RESPONSE_SUCCESS_MESSAGE   "Reported by script."
#   endif

#endif

/* the varlists can be used to store POSTED "form" variables as well */
#if CGILIB_CGIPLUS_SUPPORT
#   define CGILIB_VARLIST 1
#endif
#if CGILIB_OSU_SUPPORT
#   define CGILIB_VARLIST 1
#endif
#if CGILIB_BODY_SUPPORT
#   define CGILIB_VARLIST 1
#endif
#if CGILIB_RESPONSE_SUPPORT
#   define CGILIB_VARLIST 1
#endif
#ifndef CGILIB_VARLIST
#   define CGILIB_VARLIST 0
#endif

/* do we need the response status code text function? */
#if CGILIB_GENERAL_SUPPORT
#   define CGILIB_STATUS_CODE_TEXT 1
#endif
#if CGILIB_RESPONSE_SUPPORT
#   define CGILIB_STATUS_CODE_TEXT 1
#endif
#ifndef CGILIB_STATUS_CODE_TEXT
#   define CGILIB_STATUS_CODE_TEXT 0
#endif

#ifndef CGILIB_DEBUG
#  define CGILIB_DEBUG 0
#endif

#ifndef CGILIB_NONE
#   define CGILIB_NONE ""
#endif

#define sys$getmsg SYS$GETMSG

/**************/
/* prototypes */
/**************/

char* CgiLibVar (char*);
char* CgiLibVarNull (char*);

/* for backward-compatibility */
char* CgiVar (char*);

char* CgiLibHttpStatusCodeText (int);
int CgiLibUrlDecode (char*);

#if CGILIB_CGIPLUS_SUPPORT
   void CgiLibCgiPlusEOF ();
   void CgiLibCgiPlusEOT ();
   void CgiLibCgiPlusESC ();
   void CgiLibCgiPlusInGets (char*, int);
   void CgiLibCgiPlusSetVarRecord ();
   void CgiLibCgiPlusSetVarStruct ();
#endif

#if CGILIB_ENVIRONMENT_SUPPORT
   void CgiLib__ApacheFixBg ();
   int CgiLib__ApacheFixBgHandler ();
   void CgiLibEnvironmentBinaryOut ();
   void CgiLibEnvironmentInit (int, char*[], int);
   int CgiLibEnvironmentIsApache ();
   int CgiLibEnvironmentIsCgi ();
   int CgiLibEnvironmentIsCgiPlus ();
   int CgiLibEnvironmentIsOsu ();
   int CgiLibEnvironmentIsPurveyor ();
   int CgiLibEnvironmentIsWasd ();
   char* CgiLibEnvironmentName ();
   int CgiLibEnvironmentSetDebug (int);
   void CgiLibEnvironmentRecordOut ();
   /* for backward compatibility */
   void CgiLibEnvironmentStandardOut ();
   char* CgiLibEnvironmentVersion ();
#endif

#if CGILIB_POST_SUPPORT
   char* CgiLibReadRequestBody (char**, int*);
   int CgiLibFormRequestBody (char*, int);
#endif

#if CGILIB_OSU_SUPPORT
   void CgiLibOsuInit (int, char*[]);
   void CgiLibOsuStdoutCgi ();
   void CgiLibOsuStdoutRaw ();
   void CgiLibOsuStdoutText ();
#endif

#if CGILIB_GENERAL_SUPPORT
   int CgiLibAnchorHtmlEscape (char*, int, char*, int, int);
   char* CgiLibFormEncodedParse (char*, int*);
   int CgiLibHtmlEscape (char*, int, char*, int);
   int CgiLibUrlEncode (char*, int, char*, int);
   int CgiLibUrlEncodeFileName (char*, char*, int, int, int);
#endif

#if CGILIB_RESPONSE_SUPPORT
   int CgiLibResponseHeader (int, char*, ...);
   int CgiLibResponseError (char*, int, int, char*, ...);
   int CgiLibResponseRedirect (char*, ...);
   int CgiLibResponseSuccess (char*, ...);
   char* CgiLibResponseSetBody (char*);
   char* CgiLibResponseSetCharset (char*);
   char* CgiLibResponseSetDefaultCharset (char*);
   char* CgiLibResponseSetErrorMessage (char*);
   int CgiLibResponseSetErrorStatus (int);
   char* CgiLibResponseSetErrorTitle (char*);
   char* CgiLibResponseSetErrorInfo (char*);
   char* CgiLibResponseSetSoftwareID (char*);
   char* CgiLibResponseSetSuccessMessage (char*);
   int CgiLibResponseSetSuccessStatus (int);
   char* CgiLibResponseSetSuccessTitle (char*);
#endif

/*****************************************************/
/* these functions are for INTERNAL CGILIB USE only! */
/*****************************************************/

void CgiLib__SetEnvironment ();
char* CgiLib__GetVar (char*, char*);
char* CgiLib__GetKey (char*, char*);
char* CgiLib__GetForm (char*, char*);
char* CgiLib__GetPathTranslated (char*);
char* CgiLib__VarList (char*, char*, char*);
int CgiLib__BodyFormUrlEncoded (char*, int);
int CgiLib__BodyMultipartFormData (char*, int, char*);

#if CGILIB_OSU_SUPPORT
   void CgiLib__OsuExitCgi ();
   void CgiLib__OsuExitRaw ();
   void CgiLib__OsuExitText ();
   char* CgiLib__OsuQueryNetLink (char*, int);
#endif

#ifdef __ALPHA
#   pragma member_alignment __restore
#endif

#endif /* CGILIB_H_LOADED */

/*****************************************************************************/

