/*****************************************************************************/
/*
                             HyperSpi.h

Header file for Hypertext System Performance Information facility.


VERSION HISTORY
---------------
20-JUN-95  MGD  v1.0.0, initial development
*/
/*****************************************************************************/

#define HyperSpiDataDirectory  "HYPERSPI$DATA:"
#define HyperSpiRefreshDataDirectory  "HYPERSPI$DATA_REFRESH:"
#define HyperSpiDataVersion "2"

#define K_HyperSpiCpuModeCount 6

#define K_HyperSpiInterruptMode 0
#define K_HyperSpiMultiProcMode 1
#define K_HyperSpiKernelMode 2
#define K_HyperSpiExecutiveMode 3
#define K_HyperSpiSupervisorMode 4
#define K_HyperSpiUserMode 5

#ifdef __ALPHA
#   pragma member_alignment __save
#   pragma nomember_alignment
#endif

/* size, as of 22-Sep-2000, 111 bytes */

struct HyperSpiData
{
   unsigned char  Minute;
   unsigned char  Hour;
   unsigned char  Day;
   unsigned char  Month;
   unsigned short  Year;
   unsigned char  NumberOfCPUs;
   unsigned short  SystemMemoryMBytes;
   unsigned char  SystemMemoryPercentInUse;
   unsigned short  PageSpaceMBytes;
   unsigned char  PageSpacePercentInUse;
   unsigned short  NumberOfProcesses;
   unsigned char  PercentCPU;
   unsigned char  PeakPercentCPU;
   unsigned char  PercentUserModeCPU;
   unsigned char  PeakPercentUserModeCPU;
   unsigned long  PageFaults;
   unsigned short  PeakPageFaults;
   unsigned long  HardPageFaults;
   unsigned short  PeakHardPageFaults;
   unsigned long  BufferedIO;
   unsigned short  PeakBufferedIO;
   unsigned long  DirectIO;
   unsigned short  PeakDirectIO;
   unsigned long  MscpIO;
   unsigned short  PeakMscpIO;
   unsigned long  Computable;
   unsigned char  PercentModeCPU[K_HyperSpiCpuModeCount];
   unsigned long  LckLoc;
   unsigned long  LckIn;
   unsigned long  LckOut;
   unsigned char  Rfu[40];
};

#ifdef __ALPHA
#   pragma member_alignment __restore
#endif

/****************************************************************************/

