#	Descrip.mms for OpenVMS MMS (or MMK)
#
#	Build file for GD (v1.8.1) on OpenVMS/Alpha using Compaq's MMS (DECset)
#	or the free MadGoat MMK clone.
#
#       Add shareable  by Jean-Francois Pieronne <jfp@altavista.net>
#	Written by: Rick Dyson (rick-dyson@uiowa.edu)  7-APR-2000
#
#	This was crudely put together to work with the required JPEG, Z,
#	and PNG libraries in adjacent locations.  If you have them elsewhere, 
#	you need to change the logical name pointers below.

.ifdef MMS
.else
MMS = MMK
.endif

.ifdef SCNDCALL

OPTIMIZE = /Optimize
DEBUG = /NoDebug
DEFS = /Define = (HAVE_LIBJPEG, HAVE_LIBPNG)
INCS = /Include = ([], LibJPEG:, LibPNG:, LibZ:)

CFLAGS = $(CFLAGS) $(OPTIMIZE) $(DEBUG) $(DEFS) $(INCS) /Prefix = All
LINKFLAGS = $(LINKFLAGS) $(DEBUG)

.first 
	@ If (F$TrnLnm ("LibGD") .eqs. "") Then Define LibGD Sys$Disk:[-.GD-1_8_1]
	@ If (F$TrnLnm ("LibJPEG") .eqs. "") Then Define LibJPEG Sys$Disk:[-.JPEG-6b]
	@ If (F$TrnLnm ("LibPNG") .eqs. "")  Then Define LibPNG  Sys$Disk:[-.PNG-1_0_3]
	@ If (F$TrnLnm ("LibZ") .eqs. "")    Then Define LibZ    Sys$Disk:[-.ZLib-1_1_3]
.ifdef AXP
	@ If (F$TrnLnm ("LibGDSHR") .eqs. "") Then Define LibGDSHR libGD:libGDSHR
        @ If (F$TrnLnm ("LibZSHR") .eqs. "")   Then Define LibZSHR libZ:LiZSHR
        @ If (F$TrnLnm ("LibJPEGSHR") .eqs. "") Then Define LibJPEGSHR libJPEG:libJPEGSHR
        @ If (F$TrnLnm ("LibPNGSHR") .eqs. "") Then Define LibPNGSHR libPNG:libPNGSHR
.endif

.ifdef AXP
share : libgdshr.exe
	@ Write Sys$Output "Shareable LibGDSHR build complete..."

libgdshr.exe : libgd.olb libgd.opt
        $(LINK) $(LINKFLAGS) /share=libgdshr.exe libgd.opt/opt
.endif

lib :	libgd.olb
	@ Write Sys$Output "LibGD build complete..."

libgd.olb :	gd.obj gd_gd.obj gd_gd2.obj gd_io.obj gd_io_dp.obj \
		gd_io_file.obj gd_ss.obj gd_io_ss.obj gd_png.obj gd_jpeg.obj \
		gdxpm.obj gdfontt.obj gdfonts.obj gdfontmb.obj gdfontl.obj \
		gdfontg.obj gdtables.obj gdttf.obj gdcache.obj gdkanji.obj \
		gdhelpers.obj gd_wbmp.obj wbmp.obj
	@ Library /Create $*.olb $+

gdkanji.obj :	gdkanji.c
	$(CC) $(CFLAGS) /NoWarnings $*

gdcache.obj :	gdcache.c
	$(CC) $(CFLAGS) /NoWarnings $*

gd_jpeg.obj :	gd_jpeg.c
	$(CC) $(CFLAGS) /Warnings = NoInformationals $*

gd_helpers.obj : gd_helpers.c
	$(CC) $(CFLAGS) /Warnings = NoInformationals $*

clean :
	- Purge /NoLog /NoConfirm *.mms, *.obj, *.olb

clobber :	clean
	- Delete /NoLog /NoConfirm *.obj;,*.olb;

.else   !------------------- first call ------------

say = write sys$output

? $(mmstargets) : default
        @ !

default :
        @ $(say) ""
        @ param = "/macro=(scndcall=1)"
        @ if f$getsyi("arch_type") .ne. 1 then \
          param = "/macro=(scndcall=1,axp=1)"
        @ $(mms)/ignore=warning 'param' $(mmstargets)   ! second call

.endif  ! scndcall
