#   Descrip.mms for Alpha/OpenVMS MMS
#
#   For use with the Compaq DECSet, MMS, or the free MadGoat MMK clone.
#
#   Written: 12-SEP-2000 Jean-Franois Pironne (jfp@altavista.net)
#
#   This was quickly thrown together to use the required libraries in
#   adjacent directories.  If you have the somewhere else, change the
#   logical name pointers.
#

.ifdef MMS
.else
MMS = MMK
.endif

.ifdef SCNDCALL

OPTIMIZE = /Optimize
DEBUG = /NoDebug
INCS = /Include = ([], [-...], LibJPEG:, LibPNG:, LibZ:, LibGD:, python_include:) 
WARN = /Prefix = All /Warnings = (Informationals = PTRMISMATCH1, NoInformationals)

DEFS = 

CFLAGS = $(CFLAGS) $(OPTIMIZE) $(DEBUG) $(DEFS) $(INCS) $(WARN)
LINKFLAGS = $(LINKFLAGS) $(DEBUG)

HEAD = gdc.h gdchart.h gdcpie.h
OBJS = gdc.obj  gdchart.obj gdc_pie.obj price_conv.obj gifencode.obj defvar.obj
LIBS = libgdchart.olb/Library,LibGD:LibGD.olb/Library, -
       LibPNG:LibPNG.olb/Library, LibJPEG:LibJPEG.olb/Library,-
       LibZ:LibZ.olb/Library

.first 
	@ If (F$TrnLnm ("LibJPEG") .eqs. "") Then Define LibJPEG Sys$Disk:[-.JPEG-6b]
	@ If (F$TrnLnm ("LibPNG") .eqs. "")  Then Define LibPNG  Sys$Disk:[-.PNG-1_0_3]
	@ If (F$TrnLnm ("LibZ") .eqs. "")    Then Define LibZ    Sys$Disk:[-.ZLIB-1_1_3]
	@ If (F$TrnLnm ("LibGD") .eqs. "")   Then Define LibGD   Sys$Disk:[-.GD-1_8_1]
	@ If (F$TrnLnm ("LibGDCHART") .eqs. "")   Then Define LibGDCHART   Sys$Disk:[-.GDCHART0_94B]
.ifdef AXP
	@ If (F$TrnLnm ("LibJPEGSHR") .eqs. "") Then Define LibJPEGSHR LibJPEG:LibJPEGSHR
	@ If (F$TrnLnm ("LibPNGSHR") .eqs. "")  Then Define LibPNGSHR LibPNG:LibPNGSHR
	@ If (F$TrnLnm ("LibZSHR") .eqs. "")    Then Define LibZSHR LibZ:LibZSHR
	@ If (F$TrnLnm ("LibGDSHR") .eqs. "")   Then Define LibGDSHR LibGD:LibGDSHR
	@ If (F$TrnLnm ("LibGDCHARTSHR") .eqs. "")  Then Define LibGDCHARTSHR LibGDCHART:LibGDCHARTSHR
.endif

.ifdef AXP
all : share samples
	@ Write Sys$Output "build complete..."
.else
all : lib samples
	@ Write Sys$Output "build complete..."
.endif

lib : libgdchart.olb
	@ Write Sys$Output "LibGDCHART build complete..."

share : libgdchartshr.exe
	@ Write Sys$Output "Shareable LibGDCHART build complete..."

libgdchartshr.exe : libgdchart.olb libgdchart.opt
	$(LINK) $(LINKFLAGS) /share=libgdchartshr.exe libgdchart.opt/opt

samples : gdc_samp1.exe gdc_samp2.exe gdc_pie_samp.exe
	@ Write Sys$Output "Demo build complete..."

libgdchart.olb : $(OBJS)
	@ Library /Create $*.olb $+

gdc_python : gdc_py.obj
	@ Library /Replace libgdchart.olb $+

.ifdef AXP
gdc_samp1.exe : gdc_samp1.obj
        - $(LINK) $(LINKFLAGS) $+, libgdchartshr.opt/opt

gdc_samp2.exe : gdc_samp2.obj
        - $(LINK) $(LINKFLAGS) $+, libgdchartshr.opt/opt

gdc_pie_samp.exe : gdc_pie_samp.obj
        - $(LINK) $(LINKFLAGS) $+, libgdchartshr.opt/opt
.else
gdc_samp1.exe : gdc_samp1.obj
        - $(LINK) $(LINKFLAGS) $+, $(LIBS)

gdc_samp2.exe : gdc_samp2.obj
        - $(LINK) $(LINKFLAGS) $+, $(LIBS)

gdc_pie_samp.exe : gdc_pie_samp.obj
        - $(LINK) $(LINKFLAGS) $+, $(LIBS)
.endif

clean :
	- Purge /NoLog /NoConfirm *.exe, *.obj, *.mms

clobber :	clean
	- Delete /NoLog /NoConfirm *.obj;, *.exe;

$(OBJS) :	$(HEAD)

.else   !------------------- first call ------------

say = write sys$output

? $(mmstargets) : default
        @ !

default :
        @ $(say) ""
        @ param = "/macro=(scndcall=1)"
        @ if f$getsyi("arch_type") .ne. 1 then \
          param = "/macro=(scndcall=1,axp=1)"
        @ $(mms)/ignore=warning 'param' $(mmstargets)   ! second call

.endif  ! scndcall
