#   Descrip.mms makefile for ZLib on OpenVMS
#
#   Add shareable  by Jean-Francois Pieronne <jfp@altavista.net>
#   Modified:  7-APR-2000 Rick Dyson (rick-dyson@uiowa.edu)

.ifdef MMS
.else
MMS = MMK
.endif

.ifdef SCNDCALL

ZLIB = libz:

OPTIMIZE = /Optimize
DEBUG = /NoDebug
DEFS =
INCS = /Include = $(ZLIB)
PREF = /Prefix = All

CFLAGS = $(CFLAGS) $(DEBUG) $(OPTIMIZE) $(INCS) $(DEFS) $(PREF)
LINKFLAGS = $(LINKFLAGS) $(DEBUG)

OBJS =  png.obj pngset.obj pngget.obj pngrutil.obj pngtrans.obj \
	pngwutil.obj pngread.obj pngmem.obj pngwrite.obj pngrtran.obj \
	pngwtran.obj pngrio.obj pngwio.obj pngerror.obj pngpread.obj

.first
	@- Define /NoLog Sys Sys$Library
        @ If (F$TrnLnm ("LibPNG") .eqs. "") Then Define LibPNG Sys$Disk:[-.PNG-1_0_3]
        @ If (F$TrnLnm ("LibZ") .eqs. "")    Then Define LibZ Sys$Disk:[-.ZLib-1_1_3]
.ifdef AXP
        @ If (F$TrnLnm ("LibZSHR") .eqs. "")    Then Define LibZSHR libZ:LibZSHR
        @ If (F$TrnLnm ("LibPNGSHR") .eqs. "") Then Define LibPNGSHR libPNG:LibPNGSHR
.endif

all :	libpng.olb pngtest.exe 
	@ write sys$output "PNGtest available"

lib : 	libpng.olb
	@ write sys$output "LibPNG build complete..."

libpng.olb :	libpng.olb($(OBJS))
	@ Continue

.ifdef AXP
pngtest.exe :	pngtest.obj libpngshr.exe
	$(LINK) $(LINKFLAGS) pngtest,LibPNGshr.opt/opt

libpngshr.exe : libpng.olb libpng.opt
	$(LINK) $(LINKFLAGS) /share=libpngshr.exe libpng.opt/opt
.else
pngtest.exe :	pngtest.obj libpng.olb
	$(LINK) $(LINKFLAGS) pngtest,LibPNG.olb/Library,$(ZLIB)LibZ.olb/Library
.endif

test :	pngtest.exe
	Run PNGtest

clean :
	- Purge /NoLog /NoConfirm *.mms,*.obj

clobber :	clean
	- Delete /NoLog /NoConfirm *.olb;,*.obj;

# Other dependencies.
png.obj : png.h, pngconf.h
pngpread.obj : png.h, pngconf.h
pngset.obj : png.h, pngconf.h
pngget.obj : png.h, pngconf.h
pngread.obj : png.h, pngconf.h
pngrtran.obj : png.h, pngconf.h
pngrutil.obj : png.h, pngconf.h
pngerror.obj : png.h, pngconf.h
pngmem.obj : png.h, pngconf.h
pngrio.obj : png.h, pngconf.h
pngwio.obj : png.h, pngconf.h
pngtest.obj : png.h, pngconf.h
pngtrans.obj : png.h, pngconf.h
pngwrite.obj : png.h, pngconf.h
pngwtran.obj : png.h, pngconf.h
pngwutil.obj : png.h, pngconf.h

.else   !------------------- first call ------------

say = write sys$output

? $(mmstargets) : default
        @ !

default :
        @ $(say) ""
        @ param = "/macro=(scndcall=1)"
        @ if f$getsyi("arch_type") .ne. 1 then \
          param = "/macro=(scndcall=1,axp=1)"
        @ $(mms)/ignore=warning 'param' $(mmstargets)   ! second call

.endif  ! scndcall
