# descrip.mms: MMS description file for building zlib on VMS
# written by Martin P.J. Zinser <m.zinser@gsi.de>
# Add shareable  by Jean-Francois Pieronne <jfp@altavista.net>

.ifdef MMS
.else
MMS = MMK
.endif

.ifdef SCNDCALL

cc_defs = 
c_deb = 

.ifdef __DECC__
pref = /prefix=all
.endif

OBJS = adler32.obj, compress.obj, crc32.obj, gzio.obj, uncompr.obj,\
       deflate.obj, trees.obj, zutil.obj, inflate.obj, infblock.obj,\
       inftrees.obj, infcodes.obj, infutil.obj, inffast.obj

CFLAGS= $(CFLAGS) $(C_DEB) $(CC_DEFS) $(PREF)

.first
        @ If (F$TrnLnm ("LibZ") .eqs. "")    Then Define LibZ   Sys$Disk:[-.ZLib-1_1_3]
.ifdef AXP
        @ If (F$TrnLnm ("LibZSHR") .eqs. "")    Then Define LibZSHR libZ:LibZSHR
.endif

all : example.exe minigzip.exe
        @ write sys$output " Example applications available"

libz.olb : libz.olb($(OBJS))
	@ write sys$output " libz available"

.ifdef AXP
example.exe : example.obj libzshr.exe
              link example,libzshr.opt/opt

minigzip.exe : minigzip.obj libzshr.exe
              link minigzip,libzshr.opt/opt !,x11vms:xvmsutils.olb/lib

libzshr.exe : libz.olb, libz.opt
	link/share=libzshr.exe/notrace libz.opt/opt

.else
example.exe : example.obj libz.olb
              link example,libz.olb/lib

minigzip.exe : minigzip.obj libz.olb
              link minigzip,libz.olb/lib !,x11vms:xvmsutils.olb/lib
.endif

clean : 
	delete *.obj;*,libz.olb;*,*.exe;*


# Other dependencies.
adler32.obj : zutil.h zlib.h zconf.h
compress.obj : zlib.h zconf.h
crc32.obj : zutil.h zlib.h zconf.h
deflate.obj : deflate.h zutil.h zlib.h zconf.h
example.obj : zlib.h zconf.h
gzio.obj : zutil.h zlib.h zconf.h
infblock.obj : zutil.h zlib.h zconf.h infblock.h inftrees.h infcodes.h infutil.h
infcodes.obj : zutil.h zlib.h zconf.h inftrees.h infutil.h infcodes.h inffast.h
inffast.obj : zutil.h zlib.h zconf.h inftrees.h infutil.h inffast.h
inflate.obj : zutil.h zlib.h zconf.h infblock.h
inftrees.obj : zutil.h zlib.h zconf.h inftrees.h
infutil.obj : zutil.h zlib.h zconf.h inftrees.h infutil.h
minigzip.obj : zlib.h zconf.h
trees.obj : deflate.h zutil.h zlib.h zconf.h
uncompr.obj : zlib.h zconf.h
zutil.obj : zutil.h zlib.h zconf.h


.else   !------------------- first call ------------

say = write sys$output

? $(mmstargets) : default
        @ !

default :
        @ $(say) ""
        @ param = "/macro=(scndcall=1)"
        @ if f$getsyi("arch_type") .ne. 1 then \
          param = "/macro=(scndcall=1,axp=1)"
        @ $(mms)/ignore=warning 'param' $(mmstargets)   ! second call

.endif  ! scndcall

