#ifndef SPIDEF_H
#define SPIDEF_H

#ifdef __cplusplus
    extern "C" {
#define __unknown_params ...
#define __optional_params ...
#else
#define __unknown_params
#define __optional_params ...
#endif

#pragma member_alignment save
#pragma nomember_alignment

/* EXE types */
#define SPI$_MODES  0x00001000  /* All modes counters on all CPU's */
#define SPI$_INTERRUPT  0x00001001      /* time on interrupt stack -- primary */
#define SPI$_KERNEL  0x00001002 /* time in kernel mode -- primary */
#define SPI$_EXEC  0x00001003   /* time in exec mode -- primary */
#define SPI$_SUPER  0x00001004  /* time in supervisor mode -- primary */
#define SPI$_USER  0x00001005   /* time in user mode -- primary */
#define SPI$_COMPAT  0x00001006 /* time in compat. mode -- primary */
#define SPI$_INTERRUPT_BUSY  0x00001007 /* Time spent spinning on the interrupt stack */
#define SPI$_KERNEL_BUSY  0x00001008    /* Time spent spinning on the kernel stack */
#define SPI$_IDLE  0x00001009   /* idle time -- primary */
#define SPI$_CPUBUSY  0x0000100A        /* RETIRED ITEM - RETURNS 0 */
#define SPI$_COLPG  0x0000100B  /* collided page wait */
#define SPI$_MWAIT  0x0000100C  /* memory wait [?? who wrote these comments?!] */
#define SPI$_CEF  0x0000100D    /* common event flag wait */
#define SPI$_PFW  0x0000100E    /* page wait */
#define SPI$_LEF  0x0000100F    /* local event flag wait */
#define SPI$_LEFO  0x00001010   /* lef wait out of bal. set */
#define SPI$_HIB  0x00001011    /* hibernating */
#define SPI$_HIBO  0x00001012   /* hibernating outswapped */
#define SPI$_SUSP  0x00001013   /* suspended */
#define SPI$_SUSPO  0x00001014  /* suspended outswapped */
#define SPI$_FPG  0x00001015    /* free page wait */
#define SPI$_COM  0x00001016    /* computable */
#define SPI$_COMO  0x00001017   /* computable outswapped */
#define SPI$_CUR  0x00001018    /* current */
#define SPI$_OTHSTAT  0x00001019        /* RETIRED ITEM - RETURNS 0 */
#define SPI$_PROCS  0x0000101A  /* process count for SYSTEM class */
#define SPI$_PROC  0x0000101B   /* collect all process infomation */
#define SPI$_FRLIST  0x0000101C /* size of free list */
#define SPI$_MODLIST  0x0000101D        /* size of modified list */
#define SPI$_FAULTS  0x0000101E /* page fault count */
#define SPI$_PREADS  0x0000101F /* page reads */
#define SPI$_PWRITES  0x00001020        /* page writes */
#define SPI$_PWRITIO  0x00001021        /* physical page write I/O's */
#define SPI$_PREADIO  0x00001022        /* physical page read I/O's */
#define SPI$_GVALFLTS  0x00001023       /* global valid faults */
#define SPI$_WRTINPROG  0x00001024      /* faults from write in progress */
#define SPI$_FREFLTS  0x00001025        /* faults from free list */
#define SPI$_MFYFLTS  0x00001026        /* faults from modified list */
#define SPI$_DZROFLTS  0x00001027       /* demand zero faults */
#define SPI$_SYSFAULTS  0x00001028      /* system page faults */
#define SPI$_LRPCNT  0x00001029 /* number of LRP packets available */
#define SPI$_LRPINUSE  0x0000102A       /* number of LRP's in use */
#define SPI$_IRPCNT  0x0000102B /* number of IRP packets available */
#define SPI$_IRPINUSE  0x0000102C       /* number of IRP's in use */
#define SPI$_SRPCNT  0x0000102D /* number of SRP packets available */
#define SPI$_SRPINUSE  0x0000102E       /* number of SRP's in use */
#define SPI$_HOLECNT  0x0000102F        /* number of blocks in dyn. memory */
#define SPI$_BIGHOLE  0x00001030        /* largest hole */
#define SPI$_SMALLHOLE  0x00001031      /* smallest hole */
#define SPI$_HOLESUM  0x00001032        /* total space in dyn. memory available */
#define SPI$_DYNINUSE  0x00001033       /* dynamic memory space in use */
#define SPI$_SMALLCNT  0x00001034       /* number of blocks < 32 bytes in size */
#define SPI$_ISWPCNT  0x00001035        /* total inswaps */
#define SPI$_DIRIO  0x00001036  /* count of direct I/O's */
#define SPI$_BUFIO  0x00001037  /* count of buffered I/O's */
#define SPI$_MBREADS  0x00001038        /* total mailbox reads */
#define SPI$_MBWRITES  0x00001039       /* total mailbox writes */
#define SPI$_LOGNAM  0x0000103A /* logical name translations */
#define SPI$_FCPCALLS  0x0000103B       /* total fcp calls */
#define SPI$_FCPREAD  0x0000103C        /* number of disk reads by FCP */
#define SPI$_FCPWRITE  0x0000103D       /* number of disk writes by FCP */
#define SPI$_FCPCACHE  0x0000103E       /* number of FCP cache hits */
#define SPI$_FCPCPU  0x0000103F /* number of CPU tics by FCP */
#define SPI$_FCPHIT  0x00001040 /* number of window hits */
#define SPI$_FCPSPLIT  0x00001041       /* number of split transfers */
#define SPI$_FCPFAULT  0x00001042       /* number of FCP page faults */
#define SPI$_ENQNEW  0x00001043 /* number of ENQ's (new) */
#define SPI$_ENQCVT  0x00001044 /* number of ENQ's (conversions) */
#define SPI$_DEQ  0x00001045    /* number of DEQ's */
#define SPI$_BLKAST  0x00001046 /* number of blocking AST's */
#define SPI$_ENQWAIT  0x00001047        /* number of ENQ's forced to wait */
#define SPI$_ENQNOTQD  0x00001048       /* number of ENQ's not queued */
#define SPI$_DLCKSRCH  0x00001049       /* number of deadlock searches */
#define SPI$_DLCKFND  0x0000104A        /* number of deadlocks found */
#define SPI$_NUMLOCKS  0x0000104B       /* total locks */
#define SPI$_NUMRES  0x0000104C /* total resources */
#define SPI$_ARRLOCPK  0x0000104D       /* arriving local packets */
#define SPI$_DEPLOCPK  0x0000104E       /* departing local packets */
#define SPI$_ARRTRAPK  0x0000104F       /* arriving transit packets */
#define SPI$_TRCNGLOS  0x00001050       /* transit congestion loss */
#define SPI$_RCVBUFFL  0x00001051       /* receiver buffer failures */
#define SPI$_RESERVED1  0x00001052
#define SPI$_RESERVED2  0x00001053
#define SPI$_RESERVED3  0x00001054
#define SPI$_RESERVED4  0x00001055
#define SPI$_RESERVED5  0x00001056
#define SPI$_RESERVED6  0x00001057
#define SPI$_RESERVED7  0x00001058
#define SPI$_RESERVED8  0x00001059
#define SPI$_RESERVED9  0x0000105A
#define SPI$_RESERVED10  0x0000105B
#define SPI$_RESERVED11  0x0000105C
#define SPI$_RESERVED12  0x0000105D
#define SPI$_RESERVED13  0x0000105E
#define SPI$_RESERVED14  0x0000105F
#define SPI$_RESERVED15  0x00001060
#define SPI$_RESERVED16  0x00001061
#define SPI$_RESERVED17  0x00001062
#define SPI$_RESERVED18  0x00001063
#define SPI$_FID_TRIES  0x00001064      /* count of File Id cache attempts */
#define SPI$_FILHDR_TRIES  0x00001065   /* count of File header cache attempts */
#define SPI$_DIRFCB_TRIES  0x00001066   /* count of directory block cache attempts */
#define SPI$_DIRDATA_TRIES  0x00001067  /* count of directory data cache attempts */
#define SPI$_EXT_TRIES  0x00001068      /* count of Extent cache attempts */
#define SPI$_QUO_TRIES  0x00001069      /* count of Quota cache attempts */
#define SPI$_STORAGMAP_TRIES  0x0000106A        /* count of storage bitmap cache attempts */
#define SPI$_DISKS  0x0000106B  /* all disk data */
#define SPI$_TOTAL_LOCKS  0x0000106C    /* Total of all locking activity - NOT COLLECTED BY SPI - COMPUTED BY MONITOR */
#define SPI$_ENQNEWLOC  0x0000106D      /* new lock requests (local) */
#define SPI$_ENQNEWIN  0x0000106E       /* new lock requests (incoming) */
#define SPI$_ENQNEWOUT  0x0000106F      /* new lock requests (outgoing) */
#define SPI$_ENQCVTLOC  0x00001070      /* lock conversion requests (local) */
#define SPI$_ENQCVTIN  0x00001071       /* lock conversion requests (incoming) */
#define SPI$_ENQCVTOUT  0x00001072      /* lock conversion requests (outgoing) */
#define SPI$_DEQLOC  0x00001073 /* dequeues (local) */
#define SPI$_DEQIN  0x00001074  /* deques (incoming) */
#define SPI$_DEQOUT  0x00001075 /* dequeues (outgoing) */
#define SPI$_BLKLOC  0x00001076 /* blocking AST's queued (local) */
#define SPI$_BLKIN  0x00001077  /* blocking AST's queued (incoming) */
#define SPI$_BLKOUT  0x00001078 /* blocking AST's queued (outgoing) */
#define SPI$_DIRIN  0x00001079  /* directory operations (incoming) */
#define SPI$_DIROUT  0x0000107A /* directory operations (outgoing) */
#define SPI$_DLCKMSGS  0x0000107B       /* deadlock detection messages (in & out) */
#define SPI$_SCS  0x0000107C    /* all SCS information */
#define SPI$_SYSTIME  0x0000107D        /* current system time */
#define SPI$_MSCP_REQUEST  0x0000107E   /* IO request rate to the MSCP server */
#define SPI$_MSCP_READ  0x0000107F      /* Read request rate to the MSCP server */
#define SPI$_MSCP_WRITE  0x00001080     /* Write request rate to the MSCP server */
#define SPI$_MSCP_FRAGMENT  0x00001081  /* Rate at which I/O's are fragmented */
#define SPI$_MSCP_SPLIT  0x00001082     /* Rate at which I/O's are split */
#define SPI$_MSCP_BUFWAIT  0x00001083   /* Rate at which incoming requests have to wait for a buffer */
#define SPI$_MSCP_SIZE1  0x00001084     /* I/O rate for sizes 1-2 blocks */
#define SPI$_MSCP_SIZE2  0x00001085     /* I/O rate for sizes 2-3 blocks */
#define SPI$_MSCP_SIZE3  0x00001086     /* I/O rate for sizes 4-7 blocks */
#define SPI$_MSCP_SIZE4  0x00001087     /* I/O rate for sizes 8-15 blocks */
#define SPI$_MSCP_SIZE5  0x00001088     /* I/O rate for sizes 16-31 blocks */
#define SPI$_MSCP_SIZE6  0x00001089     /* I/O rate for sizes 32-63 blocks */
#define SPI$_MSCP_SIZE7  0x0000108A     /* I/O rate for sizes 64-127 blocks */
#define SPI$_MSCP_ALL  0x0000108B       /* dummy item to collect all MSCP server class items */
#define SPI$_RESERVEDEXE1  0x0000108C
/* reservedexe2 through reservedexe99 ... not real necessary eh? */
#define SPI$_RESERVEDEXE100  0x000010EF

/* These next items are located in an executive writable page in memory */
#define SPI$_ACCESS  0x000020F0 /* number of file accesses */
#define SPI$_ALLOC  0x000020F1  /* number of file extends */
#define SPI$_FCPCREATE  0x000020F2      /* number of file creations */
#define SPI$_VOLWAIT  0x000020F3        /* # of times XQP waited for volume lock */
#define SPI$_FCPTURN  0x000020F4        /* number of window turns */
#define SPI$_FCPERASE  0x000020F5       /* number of erase calls */
#define SPI$_OPENS  0x000020F6  /* number of file opens */
#define SPI$_FIDHIT  0x000020F7 /* count of File Id cache hits */
#define SPI$_FIDMISS  0x000020F8        /* count of File Id cache misses */
#define SPI$_FILHDR_HIT  0x000020F9     /* count of File header cache hits */
#define SPI$_DIRFCB_HIT  0x000020FA     /* count of Directory block cache hits */
#define SPI$_DIRFCB_MISS  0x000020FB    /* count of Directory block cache misses */
#define SPI$_DIRDATA_HIT  0x000020FC    /* count of Directory data cache hit */
#define SPI$_EXTHIT  0x000020FD /* count of Extent cache hits */
#define SPI$_EXTMISS  0x000020FE        /* count of Extent cache misses */
#define SPI$_QUOHIT  0x000020FF /* count of Quota cache hits */
#define SPI$_QUOMISS  0x00002100        /* count of Quota cache misses */
#define SPI$_STORAGMAP_HIT  0x00002101  /* count of storage bitmap cache hits */
#define SPI$_VOLLCK  0x00002102 /* Volume synch locks */
#define SPI$_SYNCHLCK  0x00002103       /* directory and file synch locks */
#define SPI$_SYNCHWAIT  0x00002104      /* # of times XQP waited for a directory or file synch lock */
#define SPI$_ACCLCK  0x00002105 /* access locks */
#define SPI$_XQPCACHEWAIT  0x00002106   /* # of times XQP had to wait for free space in a cache */
#define SPI$_RESERVEDEWS1  0x00002107   /* Reserved EWS items */
/* reservedews2 through reservedews99 ... not real necessary eh? */
#define SPI$_RESERVEDEWS100  0x0000216A

/* begin monitor specific data items. The items listed */
/* below are NOT collected by the SPI as individual items. */
/* Some are NOT collected at all, but are computed */
/* by MONITOR */
#define SPI$_FIDHITPCNT  0x0000316B     /* percentage of file id cache hits/hits+misses */
#define SPI$_FILHDR_HITPCNT  0x0000316C /* percentage of file header cache hits/hits+misses */
#define SPI$_DIRFCB_HITPCNT  0x0000316D /* percentage of directory block cache hits/hits+misses */
#define SPI$_DIRDATA_HITPCNT  0x0000316E        /* percentage of directory data cache hits/hits+misses */
#define SPI$_EXTHITPCNT  0x0000316F     /* percentage of extent cache hits/hits+misses */
#define SPI$_QUOHITPCNT  0x00003170     /* percentage of quota cache hits/hits+misses */
#define SPI$_STORAGMAP_HITPCNT  0x00003171      /* percent ot storage map cache hits/hits+misses */
#define SPI$_OPCNT  0x00003172  /* disk io operation count */
#define SPI$_IOQUELEN  0x00003173       /* disk io queue length */
#define SPI$_IOAQUELEN  0x00003174      /* Accurate disk io queue length */
#define SPI$_DISKRESPTIM  0x00003175    /* disk io response time */
#define SPI$_JNLIOCNT  0x00003176       /* journaling io operation count (for disks) */
#define SPI$_JDNQLEN  0x00003177        /* jdevice normal io queue length */
#define SPI$_JDWQLEN  0x00003178        /* jdevice wait irp queue length */
#define SPI$_JDFQLEN  0x00003179        /* jdevice force io queue length */
#define SPI$_JDEXCNT  0x0000317A        /* jdevice extend count */
#define SPI$_JNLWRTSS  0x0000317B       /* obsolete */
#define SPI$_JNLBUFWR  0x0000317C       /* obsolete */
#define SPI$_DGSENT  0x0000317D /* SCS application datagrams sent */
#define SPI$_DGRCVD  0x0000317E /* SCS application datagrams received */
#define SPI$_DGDISCARD  0x0000317F      /* SCS application datagrams discarded */
#define SPI$_MSGSENT  0x00003180        /* SCS application messages sent */
#define SPI$_MSGRCVD  0x00003181        /* SCS application messages received */
#define SPI$_SNDATS  0x00003182 /* SCS block send datas initiated */
#define SPI$_KBYTSENT  0x00003183       /* SCS kbytes sent via send datas */
#define SPI$_REQDATS  0x00003184        /* SCS block request datas initiated */
#define SPI$_KBYTREQD  0x00003185       /* SCS kbytes received via request datas */
#define SPI$_KBYTMAPD  0x00003186       /* SCS kbytes mapped for block transfer */
#define SPI$_QCR_CNT  0x00003187        /* SCS times connection queued for send credit */
#define SPI$_QBDT_CNT  0x00003188       /* SCS times connection queued for buffer descriptor */
#define SPI$_DIRLOOK  0x00003189        /* directory lookups */
#define SPI$_DIRINS  0x0000318A /* directory inserts */
#define SPI$_DIRDEL  0x0000318B /* directory deletes */
#define SPI$_PACKETS  0x0000318C        /* ethernet packets/second */
#define SPI$_KBYTES  0x0000318D /* kbytes/second */
#define SPI$_PACKETSIZE  0x0000318E     /* packets size (bytes) */
#define SPI$_MPACKETS  0x0000318F       /* Multicast packets/second */
#define SPI$_MKBYTES  0x00003190        /* Multicast kbytes/second */
#define SPI$_MPACKETSIZE  0x00003191    /* Multicast packets size (bytes) */
#define SPI$_SINGLECOLL  0x00003192     /* Transmit single collisions detected */
#define SPI$_MULTICOLL  0x00003193      /* Transmit multi collision detected */
#define SPI$_INITDEFER  0x00003194      /* Transmit initially deferred */
#define SPI$_INTERNALBUFERR  0x00003195 /* receive internal buffer error */
#define SPI$_LOCBUFERR  0x00003196      /* receive local buffer error */
#define SPI$_BUFFUNAVAIL  0x00003197    /* system buffer unavailable */
#define SPI$_FILLER  0x00003198 /* dummy pad item */
#define SPI$_RESERVEDMON1  0x00003199   /*  */
/* reservedmon2 through reservedmon99 ... not real necessary eh? */
#define SPI$_RESERVEDMON100  0x000031FC

/* Begin items specific to the Monitor RMS class. These items */
/* are maintained by RMS and collected from a global section with */
/* the following naming scheme: */
/* RMS$xxxxxxxxyyyyyy where x is the volume lock id and */
/* y is the fid of the file being monitored. */
#define SPI$_RMS_STATS  0x000041FD      /* All of the following rms statistics */
#define SPI$_SEQGETS  0x000041FE        /* Total # of sequential gets */
#define SPI$_KEYGETS  0x000041FF        /* Total # of keyed gets */
#define SPI$_RFAGETS  0x00004200        /* Total @ of gets by RFA */
#define SPI$_GETBYTES  0x00004201       /* total size in bytes of all GETS */
#define SPI$_SEQPUTS  0x00004202        /* Total # of sequential puts */
#define SPI$_KEYPUTS  0x00004203        /* Total # of puts by key */
#define SPI$_PUTBYTES  0x00004204       /* Total # of bytes put to file */
#define SPI$_UPDATES  0x00004205        /* Total # of updates to the file */
#define SPI$_UPDATEBYTES  0x00004206    /* Total # of bytes updated in the file */
#define SPI$_DELETES  0x00004207        /* Total # of deletes to the file */
#define SPI$_TRUNCATES  0x00004208      /* Total # of times file has been truncated */
#define SPI$_TRUNCBLKS  0x00004209      /* Total number of blocks file has been truncated */
#define SPI$_SEQFINDS  0x0000420A       /* Total # of sequential finds */
#define SPI$_KEYFINDS  0x0000420B       /* Total # of keyed finds */
#define SPI$_RFAFINDS  0x0000420C       /* Total # of RFA finds */
#define SPI$_READS  0x0000420D  /* total # of $READs */
#define SPI$_READBYTES  0x0000420E      /* Total # of bytes read from $READ */
#define SPI$_CONNECTS  0x0000420F       /* Total connect requests */
#define SPI$_DISCONNECTS  0x00004210    /* Total disconnect requests */
#define SPI$_EXTENDS  0x00004211        /* Total extends */
#define SPI$_EXTBLOCKS  0x00004212      /* Total number of blocks file has been extended */
#define SPI$_FLUSHES  0x00004213        /* Total number of calls to flush */
#define SPI$_REWINDS  0x00004214        /* Total number of calls to REWIND */
#define SPI$_WRITES  0x00004215 /* Total number of calls to $WRITE */
#define SPI$_WRITEBYTES  0x00004216     /* Total bytes written using $WRITE */
#define SPI$_FLCKENQS  0x00004217       /* Total number of file lock ENQ's */
#define SPI$_FLCKDEQS  0x00004218       /* Total number of file lock DEQ's */
#define SPI$_FLCKCNVS  0x00004219       /* Total number of file lock conversions */
#define SPI$_LBLCKENQS  0x0000421A      /* Total number of local buffer lock ENQ's */
#define SPI$_LBLCKDEQS  0x0000421B      /* Total number of local buffer lock DEQ's */
#define SPI$_LBLCKCNVS  0x0000421C      /* Total number of local buffer lock conversions */
#define SPI$_GBLCKENQS  0x0000421D      /* Total number of global buffer lock ENQ's */
#define SPI$_GBLCKDEQS  0x0000421E      /* Total number of global buffer lock DEQ's */
#define SPI$_GBLCKCNVS  0x0000421F      /* Total number of global buffer lock conversions */
#define SPI$_GSLCKENQS  0x00004220      /* Total number of global section lock ENQ's */
#define SPI$_GSLCKDEQS  0x00004221      /* Total number of global section lock DEQ's */
#define SPI$_GSLCKCNVS  0x00004222      /* Total number of global section lock conversions */
#define SPI$_RLCKENQS  0x00004223       /* Total number of record lock ENQ's */
#define SPI$_RLCKDEQS  0x00004224       /* Total number of record lock DEQ's */
#define SPI$_RLCKCNVS  0x00004225       /* Total number of record lock conversions */
#define SPI$_APPLCKENQS  0x00004226     /* Total number of append lock ENQ's */
#define SPI$_APPLCKDEQS  0x00004227     /* Total number of append lock DEQ's */
#define SPI$_APPLCKCNVS  0x00004228     /* Total number of append lock conversions */
#define SPI$_FLBLKASTS  0x00004229      /* Total number of file lock blocking ASTs */
#define SPI$_LBLBLKASTS  0x0000422A     /* Total number of local buffer lock blocking ASTs */
#define SPI$_GBLBLKASTS  0x0000422B     /* Total number of global buffer lock blocking ASTs */
#define SPI$_APPBLKASTS  0x0000422C     /* Total number of shared append lock blocking ASTs */
#define SPI$_LCACHEHITS  0x0000422D     /* Total cache hits on buckets in local buffers */
#define SPI$_LCACHETRIES  0x0000422E    /* Total cache attempts on buckets in local buffers */
#define SPI$_GCACHEHITS  0x0000422F     /* Total cache hits on buckets in global buffers */
#define SPI$_GCACHETRIES  0x00004230    /* Total cache attempts on buckets in global buffers */
#define SPI$_GBRDIRIOS  0x00004231      /* Total direct IO's caused by global buffer cache reads */
#define SPI$_GBWDIRIOS  0x00004232      /* Total direct IO's caused by global buffer cache writes */
#define SPI$_LBRDIRIOS  0x00004233      /* Total direct IO's caused by local buffer cache reads */
#define SPI$_LBWDIRIOS  0x00004234      /* Total direct IO's caused by local buffer cache writes */
#define SPI$_BKTSPLT  0x00004235        /* Total number of 2 bucket splits done for this file */
#define SPI$_MBKTSPLT  0x00004236       /* Total number of multi-bucket splits done for this file */
#define SPI$_RMSOPENS  0x00004237       /* Total number of times file has been opened */
#define SPI$_CLOSES  0x00004238 /* Total number of times file has been closed */
#define SPI$_GSBLKASTS  0x00004239      /* Global section blocking ASTs */
#define SPI$_FLWAITS  0x0000423A        /* File lock ENQs forced to wait */
#define SPI$_LBWAITS  0x0000423B        /* Local buffer ENQs forced to wait */
#define SPI$_GBWAITS  0x0000423C        /* Global buffer ENQs forced to wait */
#define SPI$_GSWAITS  0x0000423D        /* Global section ENQs forced to wait */
#define SPI$_RLWAITS  0x0000423E        /* Record lock ENQs forced to wait */
#define SPI$_APWAITS  0x0000423F        /* append lock ENQs forced to wait */
#define SPI$_TOTWAITS  0x00004240       /* Total ENQs forced to wait */
#define SPI$_OUTBUFQUO  0x00004241      /* Number of times a process runs out of buffer quota */
#define SPI$_RMSDEV1  0x00004242        /* Reserved for RMS development private monitoring */
#define SPI$_RMSDEV2  0x00004243
#define SPI$_RMSDEV3  0x00004244
#define SPI$_RMSDEV4  0x00004245
#define SPI$_RMSDEV5  0x00004246
#define SPI$_RMSDEV6  0x00004247
#define SPI$_RMSDEV7  0x00004248
#define SPI$_RMSDEV8  0x00004249
#define SPI$_RMSDEV9  0x0000424A
#define SPI$_RMSDEV10  0x0000424B
#define SPI$_RMSDEV11  0x0000424C
#define SPI$_RMSDEV12  0x0000424D
#define SPI$_RMSDEV13  0x0000424E
#define SPI$_RMSDEV14  0x0000424F
#define SPI$_RMSDEV15  0x00004250
#define SPI$_XQPQIOS  0x00004251        /* Number of XQP operations for this file by RMS */
#define SPI$_LCACHEHITPCNT  0x00004252  /* Local RMS buffer hit percent */
#define SPI$_GCACHEHITPCNT  0x00004253  /* Global RMS buffer hit percent */
#define SPI$_TOTALGET  0x00004254       /* Total $GET call rate */
#define SPI$_TOTALPUT  0x00004255       /* Total $PUT call rate */
#define SPI$_TOTALFIND  0x00004256      /* Total $FIND rate */
#define SPI$_BYTESGET  0x00004257       /* Bytes per $GET */
#define SPI$_BYTESPUT  0x00004258       /* Bytes per $PUT */
#define SPI$_BYTESUPDATE  0x00004259    /* Bytes per $UPDATE */
#define SPI$_BYTESREAD  0x0000425A      /* Bytes per $READ */
#define SPI$_BYTESWRITE  0x0000425B     /* Bytes per $WRITE */
#define SPI$_BLOCKSTRUNCATE  0x0000425C /* Bytes per $TRUNCATE [I bet they meant blocks] */
#define SPI$_BLOCKSEXTEND  0x0000425D   /* Bytes per $EXTENT [I bet the meant blocks] */
#define SPI$_ACTIVE_STREAMS  0x0000425E /* Active connects to file */
#define SPI$_TOTAL_ENQS  0x0000425F     /* Total new ENQs */
#define SPI$_TOTAL_DEQS  0x00004260     /* Total DEQs */
#define SPI$_TOTAL_CNVS  0x00004261     /* Total ENQ conversions */
#define SPI$_TOTAL_BLKAST  0x00004262   /* Total blocking ASTs */
#define SPI$_RMS_ORG  0x00004263        /* RMS File Org */
#define SPI$_RESERVEDRMS1  0x00004264   /* Reserved RMS items */
/* reservedrms2 through reservedrms99 ... not real necessary eh? */
#define SPI$_RESERVEDRMS100  0x000042C7

#define SPI$K_MAX_PACKET 0x000001F4
#define SPI$K_POOL_OVF 0x80000001

#define SPI$L_PROC_IPID 0x00000000
#define SPI$L_PROC_UIC 0x00000004
#define SPI$W_PROC_STATE 0x00000008
#define SPI$B_PROC_PRI 0x0000000A
#define SPI$O_PROC_LNAME 0x0000000B
#define SPI$L_PROC_GPGCNT 0x0000001B
#define SPI$L_PROC_PPGCNT 0x0000001F
#define SPI$L_PROC_STS 0x00000023
#define SPI$L_PROC_DIOCNT 0x00000027
#define SPI$L_PROC_PAGEFLTS 0x0000002B
#define SPI$L_PROC_CPUTIM 0x0000002F
#define SPI$L_PROC_BIOCNT 0x00000033
#define SPI$L_PROC_EPID 0x00000037
#define SPI$L_PROC_EFWM 0x0000003B

/* note, PROC returns a longword count of processes, followed by an
   array of struct spi_proc's */
#define SPI$C_PROC_MINSIZE 0x0000003F
struct spi_proc
{
  long spi$l_proc_ipid;
  long spi$l_proc_uic;
  short spi$w_proc_state;
  char spi$b_proc_pri;
  char spi$o_proc_lname[16];    /* ascii counted string */
  long spi$l_proc_gpgcnt;
  long spi$l_proc_ppgcnt;
  long spi$l_proc_sts;
  long spi$l_proc_diocnt;
  long spi$l_proc_pageflts;
  long spi$l_proc_cputim;
  long spi$l_proc_biocnt;
  long spi$l_proc_epid;
  long spi$l_proc_efwm;
#ifndef PREVMS6
  long rfu; /* JFP 11-Mar-1996 */
#endif
};

#define SPI$Q_SCS_NODENAME 0x00000000
#define SPI$L_SCS_DGSENT 0x00000008
#define SPI$L_SCS_DGRCVD 0x0000000C
#define SPI$L_SCS_DGDISCARD 0x00000010
#define SPI$L_SCS_MSGSENT 0x00000014
#define SPI$L_SCS_MSGRCVD 0x00000018
#define SPI$L_SCS_SNDDATS 0x0000001C
#define SPI$L_SCS_KBYTSENT 0x00000020
#define SPI$L_SCS_REQDATS 0x00000024
#define SPI$L_SCS_KBYTREQD 0x00000028
#define SPI$L_SCS_KBYTMAPD 0x0000002C
#define SPI$L_SCS_QCR_CNT 0x00000030
#define SPI$L_SCS_QBDT_CNT 0x00000034

/* note, SCS returns a longword count of systems, followed by an
   array of struct spi_scs's */
#define SPI$C_SCS_MINSIZE 0x00000038
struct spi_scs
{
  char spi$q_scs_nodename[8];   /* ascii counted string */
  long spi$l_scs_dgsent;
  long spi$l_scs_dgrcvd;
  long spi$l_scs_dgdiscard;
  long spi$l_scs_msgsent;
  long spi$l_scs_msgrcvd;
  long spi$l_scs_snddats;
  long spi$l_scs_kbytsent;
  long spi$l_scs_reqdats;
  long spi$l_scs_kbytreqd;
  long spi$l_scs_kbytmapd;
  long spi$l_scs_qcr_cnt;
  long spi$l_scs_qbdt_cnt;
};

/* the following structures were made by hand,
   these symbols don't really exist, so far as I can tell */

/* note, DISK returns a longword count of disks, followed by an
   array of struct spi_disk's */
#define SPI$C_DISK_MINSIZE 0x00000024   /* this symbol is legit... */
struct spi_disk
{
  char spi$b_disk_allocls;      /* allocation class (from ddb$l_allocls) */
  char spi$t_disk_name[4];      /* device name (from ddb$t_name) (ascic) */
  short spi$w_disk_unit;        /* unit number (from ucb$w_unit) */
  char spi$b_disk_local;        /* 1 if local, 0 if remote */
  char spi$t_disk_nodename[8]; /* node name (ascic) */
  char spi$t_disk_volname[12]; /* volume name (space padded) */
  long spi$l_disk_opcnt;        /* operation count */
  long spi$l_disk_qlenacc;      /* queue length accumulator */
};

/* the following is returned for RMS_STATS */
/* it has NOT been tested */
struct spi_rms
{
  long spi$l_rms_org;   /* rms file org */
  long spi$l_rms_active_streams; /* future item, currently 0 */
  long spi$l_rms_seqgets; /* # of sequential gets to file */
  long spi$l_rms_keygets; /* # of keyed gets to file */
  long spi$l_rms_rfagets; /* # of gets by RFA to file */
  long spi$q_rms_getbytes[2]; /* Total size of all gets in bytes */
  long spi$l_rms_seqputs; /* # of sequential puts */
  long spi$l_rms_keyputs; /* # of puts by key */
  long spi$q_rms_putbytes[2]; /* Total size of all puts in bytes */
  long spi$l_rms_updates; /* # of updates */
  long spi$q_rms_updatebytes[2]; /* Total size of all updates in bytes */
  long spi$l_rms_deletes; /* # of deletes */
  long spi$l_rms_truncates; /* # of truncates */
  long spi$l_rms_truncblks; /* Total size in blocks of all truncates */
  long spi$l_rms_seqfinds; /* # of sequential finds */
  long spi$l_rms_keyfinds; /* # of keyed finds */
  long spi$l_rms_rfafinds; /* # of finds by RFA */
  long spi$l_rms_reads; /* # of $READs to file */
  long spi$q_rms_readbytes[2]; /* # of bytes of all $READs */
  long spi$l_rms_connects; /* # of connects to this file */
  long spi$l_rms_disconnects; /* # of disconnects from file */
  long spi$l_rms_extends; /* # of extends of file */
  long spi$l_rms_extblocks; /* # of blocks file has been extended */
  long spi$l_rms_flushes; /* # of flushes of file */
  long spi$l_rms_rewinds; /* # of rewinds of file */
  long spi$l_rms_writes; /* # of $WRITEs to file */
  long spi$q_rms_writebytes[2]; /* # of bytes of all $WRITEs to file */
  long spi$l_rms_flckenqs; /* # of file lock ENQ's */
  long spi$l_rms_flckdeqs; /* # of file lock DEQ's */
  long spi$l_rms_flckcnvs; /* # of file lock conversions */
  long spi$l_rms_lblckenqs; /* # of local buffer lock ENQ's */
  long spi$l_rms_lblckdeqs; /* # of local buffer lock DEQ's */
  long spi$l_rms_lblckcnvs; /* # of local buffer lock conversions */
  long spi$l_rms_gblckenqs; /* # of global buffer lock ENQ's */
  long spi$l_rms_gblckdeqs; /* # of global buffer lock DEQ's */
  long spi$l_rms_gblckcnvs; /* # of global buffer lock conversions */
  long spi$l_rms_gslckenqs; /* # of global section lock ENQ's */
  long spi$l_rms_gslckdeqs; /* # of global section lock DEQ's */
  long spi$l_rms_gslckcnvs; /* # of global section lock conversions */
  long spi$l_rms_rlckenqs; /* # of record lock ENQ's */
  long spi$l_rms_rlckdeqs; /* # of record lock DEQ's */
  long spi$l_rms_rlckcnvs; /* # of record lock conversions */
  long spi$l_rms_applckenqs; /* # of append lock ENQ's */
  long spi$l_rms_applckdeqs; /* # of append lock DEQ's */
  long spi$l_rms_applckcnvs; /* # of append lock conversions */
  long spi$l_rms_flblkasts; /* # of file lock blocking ASTs queued */
  long spi$l_rms_lblblkasts; /* # of local buffer lock blocking ASTs queued */
  long spi$l_rms_gblblkasts; /* # of global buffer lock blocking ASTs queued */
  long spi$l_rms_appblkasts; /* # of shared append lock blocking ASTs queued */
  long spi$l_rms_lcachehits; /* # of cache hits on local buffers */
  long spi$l_rms_lcache_attempts; /* # of attempts to use the local buffer cache */
  long spi$l_rms_gcachehits; /* # of cache hits on global buffers */
  long spi$l_rms_gcache_attempts; /* # of attempts to use the global buffer cache */
  long spi$l_rms_gbrdirios; /* # of direct io's due to global buffer reads */
  long spi$l_rms_gbwdirios; /* # of direct io's due to global buffer writes */
  long spi$l_rms_lbrdirios; /* # of direct io's due to local buffer reads */
  long spi$l_rms_lbwdirios; /* # of direct io's due to local buffer writes */
  long spi$l_rms_bktsplt; /* # of 2 bucket splits */
  long spi$l_rms_mbktsplt; /* # of multi-bucket splits */
  long spi$l_rms_opens; /* # of times the file is opened */
  long spi$l_rms_closes; /* # of times the file is closed */
  long spi$l_rms_gsblkasts; /* # of global section lock blocking ASTs queued */
  long spi$l_rms_xqpqios; /* Count of XQP QIOs requested by RMS */
  long spi$l_rms_flwaits; /* # of waits forced by getting the file lock */
  long spi$l_rms_lbwaits; /* # of waits forced by getting local buffer locks */
  long spi$l_rms_gbwaits; /* # of waits forced by getting global buffer locks */
  long spi$l_rms_gswaits; /* # of waits forced by getting the global section lock */
  long spi$l_rms_rlwaits; /* # of waits forced by getting record locks */
  long spi$l_rms_apwaits; /* # of waits forced by getting the Append lock */
  long spi$l_rms_totwaits; /* Total # of waits (or stalls) performed by RMS.  */
  long spi$l_rms_outbufquo; /* Number of times a process runs out of global buffer quota */
  long spi$l_rms_rmsdev1; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev2; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev3; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev4; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev5; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev6; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev7; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev8; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev9; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev10; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev11; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev12; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev13; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev14; /* Reserved for RMS development private monitoring */
  long spi$l_rms_rmsdev15; /* Reserved for RMS development private monitoring */
};

/* note, MODES returns a longword count of cpu's, followed by an
   array of struct spi_modes's */
#define SPI$C_MODES_MINSIZE 0x00000019
struct spi_modes
{
  char spi$_modes_cpu; /* cpu index */
  long spi$_modes_interrupt_ticks;
  long spi$_modes_mp_synch_time;
  long spi$_modes_kernel_ticks;
  long spi$_modes_exec_ticks;
  long spi$_modes_super_ticks;
  long spi$_modes_user_ticks;
  long spi$_modes_compat_ticks;
  long spi$_modes_null_ticks;
};

#pragma member_alignment restore

extern unsigned int exe$getspi(__unknown_params);

#ifdef __cplusplus
}
#endif

#endif
