{
    QBTOTP Translator GNU/GPL Version 0.5.2
     Copyright (C) 2001-2002 by Bla Valek
        Basic SUB's and FUNCTION's unit (unfinished)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
{$A+}{$B-}{$D+}{$E+}{$L+}{$N+}{$P-}{$Q+}{$R+}{$S+}{$T-}{$V+}{$X+}{$Y+}
unit Basic;

interface

const
     Ver = 'MS-DOS QBasic 1.1';

var
   QBdefseg: integer;

function QBcdbl(n: double): double;
function QBcsng(n: double): single;
function QBcvd(s: string): double;
function QBcvi(s: string): integer;
function QBcvl(s: string): longint;
function QBcvs(s: string): single;
function QBdatef: string;
function QBerdev: integer;
function QBerdevs: string;
function QBerr: integer;
function QBfre(n: double): longint;
function QBhex(n: double): string;
function QBinkey: string;
function QBinput(n: double): string;
function QBinstr(n: double; s, z: string): integer;
function QBlcase(s: string): string;
function QBleft(s: string; n: double): string;
function QBltrim(s: string): string;
function QBmidf(s: string; t, l: double): string;
function QBmkd(n: double): string;
function QBmki(n: integer): string;
function QBmkl(n: longint): string;
function QBmks(n: single): string;
function QBoct(n: double): string;
function QBpmap(n, m: double): integer;
function QBpos(n: double): integer;
function QBright(s: string; n: double): string;
function QBrtrim(s: string): string;
function QBscreenf(n, m, o: double): integer;
function QBsgn(n: double): double;
function QBspace(n: double): string;
function QBspc(n: double): string;
function QBstr(n: double): string;
function QBstrig(n: double): integer;
function QBstring(n: double; s: string): string;
function QBucase(s: string): string;
function QBtab(n: double): string;
function QBtan(n: double): double;
function QBtimef: string;
function QBtimer: double;
function QBval(s: string): double;

procedure QBbeep;
procedure QBbload(s: string; n: double);
procedure QBbsave(s: string; n, m: double);
procedure QBchain(s: string);
procedure QBcircle (s: string; x, y, r, c, b, e, a: double);
procedure QBclear(n: double);
procedure QBcls(n: double);
procedure QBcolor(a, b, c: double);
procedure QBdatep(s: string);
procedure QBdraw(s: string);
procedure QBenviron(s: string);
procedure QBerror(n: double);
procedure QBfiles(s: string);
procedure QBkill(s: string);
procedure QBline(s: string; a, b: double; t: string; c, d, e: double; u: string; f: double);
procedure QBlocate(a, b, c, d, e: double);
procedure QBmidp(s: string; t, l: double; r: string);
procedure QBname(s, t: string);
procedure QBpaint(s: string; n, m, a, b, c: double);
procedure QBpcopy(n, m: double);
procedure QBplay(s: string);
procedure QBpset(s: string; n, m, o: double);
procedure QBrandomize(n: double);
procedure QBrun(s: string);
procedure QBscreenp(n, d, m, o: double);
procedure QBshell(s: string);
procedure QBsleep(n: double);
procedure QBsound(n, m: double);
procedure QBswap(n, m: double);
procedure QBtimep(t: string);
procedure QBview(s: string; a, b, c, d, e, f: double);
procedure QBviewprint(n, m: double);
procedure QBwindow(s: string; a, b, c, d: double);

implementation

uses
    Crt, Dos, Graph, Strings;

var
   ScrMode: integer;
   IsView, IsWindow: boolean;
   Win0: string;
   Win1, Win2, Win3, Win4: double;

function QBcdbl(n: double): double;
begin
     QBcdbl := n;
end;

function QBcsng(n: double): single;
begin
     QBcsng := n;
end;

function QBcvd(s: string): double;
var
   n: double;
begin
     Move(s, n, 8);
     QBcvd := n;
end;

function QBcvi(s: string): integer;
var
   n: integer;
begin
     Move(s, n, 2);
     QBcvi := n;
end;

function QBcvl(s: string): longint;
var
   n: longint;
begin
     Move(s, n, 4);
     QBcvl := n;
end;

function QBcvs(s: string): single;
var
   n: single;
begin
     Move(s, n, 4);
     QBcvs := n;
end;

function QBdatef: string;
var
   yw, mw, dw, ww: word;
   ys, ms, ds: string;
begin
     GetDate(yw, mw, dw, ww);
     Str(yw, ys);
     Str(mw, ms);
     Str(dw, ds);
     if Length(ms) = 1 then ms := '0' + ms;
     if Length(ds) = 1 then ds := '0' + ds;
     QBdatef := ms + '-' + ds + '-' + ys;
end;

function QBerdev: integer;
begin
end;

function QBerdevs: string;
begin
end;

function QBerr: integer;
begin
end;

function QBfre(n: double): longint;
var
   nw: integer;
begin
     nw := Round(n);
     case nw of
     0:;
     -1:
     QBfre := MemAvail;
     2:;
     end;
end;

function QBhex(n: double): string;
var
   x, y: integer;
   a, b, l: longint;
   s, t: string;
begin
     l := Round(n);
     for x := 0 to 7 do
     begin
          if l < Exp(Ln(16) * x) then Break;
     end;
     t := '';
     for y := x - 1 downto 0 do
     begin
          a := l div Round(Exp(Ln(16) * y));
          Str(a, s);
          t := s + t;
          l := l mod Round(Exp(Ln(16) * y));
     end;
     QBhex := t;
end;

function QBinkey: string;
begin
     if KeyPressed then ReadKey;
end;

function QBinput(n: double): string;
var
   nw, x: integer;
   s: string;
begin
     s := '';
     nw := Round(n);
     for x := 1 to nw do
     begin
          s := s + readkey;
     end;
     QBinput := s;
end;

function QBinstr(n: double; s, z: string): integer;
var
   t: string;
   c, nw: integer;
begin
     nw := Round(n);
     if nw = -1 then
     begin
          QBinstr := Pos(s, z);
     end
     else
     begin
          c := Length(s);
          t := Copy(s, nw, c);
          QBinstr := Pos(t, z);
     end;
end;

function QBlcase(s: string): string;
var
   p, q: pchar;
begin
     StrPCopy(p, s);
     q := StrLower(p);
     QBlcase := StrPas(q);
end;

function QBleft(s: string; n: double): string;
var
   nw: integer;
begin
     nw := Round(n);
     QBleft := Copy(s, 1, nw);
end;

function QBltrim(s: string): string;
var
   x: integer;
   c: string;
begin
     while Length(s) > 0 do
     begin
          c := Copy(s, 1, 1);
          if c = ' ' then
          begin
               s := Copy(s, 2, Length(s) - 1);
          end
          else Break;
     end;
     QBltrim := s;
end;

function QBmidf(s: string; t, l: double): string;
var
   tw, lw: integer;
begin
     tw := Round(t);
     lw := Round(l);
     if lw = -1 then QBmidf := Copy(s, tw, Length(s))
     else QBmidf := Copy(s, tw, lw);
end;

function QBmkd(n: double): string;
var
   s: string;
begin
     Move(n, s, 8);
     QBmkd := s;
end;

function QBmki(n: integer): string;
var
   s: string;
begin
     Move(n, s, 2);
     QBmki := s;
end;

function QBmkl(n: longint): string;
var
   s: string;
begin
     Move(n, s, 4);
     QBmkl := s;
end;

function QBmks(n: single): string;
var
   s: string;
begin
     Move(n, s, 4);
     QBmks := s;
end;

function QBoct(n: double): string;
var
   x, y: integer;
   a, b, l: longint;
   s, t: string;
begin
     l := Round(n);
     for x := 0 to 11 do
     begin
          if l < Exp(Ln(8) * x) then Break;
     end;
     t := '';
     for y := x - 1 downto 0 do
     begin
          a := l div Round(Exp(Ln(8) * y));
          Str(a, s);
          t := s + t;
          l := l mod Round(Exp(Ln(8) * y));
     end;
     QBoct := t;
end;

function QBpmap(n, m: double): integer;
begin
end;

function QBpos(n: double): integer;
begin
     QBpos := WhereX;
end;

function QBright(s: string; n: double): string;
var
   nw: integer;
begin
     nw := Round(n);
     QBright := Copy(s, Length(s) - nw, nw);
end;

function QBrtrim(s: string): string;
var
   x: integer;
   c: string;
begin
     while Length(s) > 0 do
     begin
          c := Copy(s, Length(s), 1);
          if c = ' ' then
          begin
               s := Copy(s, 1, Length(s) - 1);
          end
          else Break;
     end;
     QBrtrim := s;
end;

function QBscreenf(n, m, o: double): integer;
begin
end;

function QBsgn(n: double): double;
begin
     if n > 0 then QBsgn := 1;
     if n = 0 then QBsgn := 0;
     if n < 0 then QBsgn := -1;
end;

function QBspace(n: double): string;
var
   x, nw: integer;
   s: string;
begin
     s := '';
     for x := 0 to nw do
     begin
          s := s + ' '
     end;
     QBspace := Copy(s, 1, Length(s) - 1);
end;

function QBspc(n: double): string;
var
   x, nw: integer;
   s: string;
begin
     s := '';
     for x := 0 to nw do
     begin
          s := s + ' '
     end;
     QBspc := Copy(s, 1, Length(s) - 1);
end;

function QBstr(n: double): string;
var
   s: string;
begin
     Str(n, s);
     QBstr := s;
end;

function QBstrig(n: double): integer;
begin
end;

function QBstring(n: double; s: string): string;
var
   x, nw: integer;
   t: string;
begin
     nw := Round(n);
     t := '';
     for x := 1 to nw do
     begin
          t := t + s;
     end;
     QBstring := t;
end;

function QBucase(s: string): string;
var
   p, q: pchar;
begin
     StrPCopy(p, s);
     q := StrUpper(p);
     QBucase := StrPas(q);
end;

function QBtab(n: double): string;
var
   x, nw: integer;
   s: string;
begin
     s := '';
     for x := 0 to nw do
     begin
          s := s + ' '
     end;
     QBtab := Copy(s, 1, Length(s) - 1);
end;

function QBtan(n: double): double;
begin
     QBtan := sin(n) / cos(n);
end;

function QBtimef: string;
var
   hw, mw, sw, ew: word;
   hs, ms, ss, es: string;
begin
     GetTime(hw, mw, sw, ew);
     Str(hw, hs);
     Str(mw, ms);
     Str(sw, ss);
     Str(ew, es);
     if Length(hs) = 1 then hs := '0' + hs;
     if Length(ms) = 1 then ms := '0' + ms;
     if Length(ss) = 1 then ss := '0' + ss;
     QBtimef := hs + ':' + ms + ':' + ss;
end;

function QBtimer: double;
var
   h, m, s, e: word;
begin
     GetTime(h, m, s, e);
     QBtimer := (h * 3600) + (m * 60) + s + e;
end;

function QBval(s: string): double;
var
   n: double;
   c: integer;
begin
     Val(s, n, c);
     QBval := n;
end;

procedure QBbeep;
begin
     Write(#7);
{Sound(800); Delay(250); NoSound;}
end;

procedure QBbload(s: string; n: double);
var
   f: file;
begin
     Assign(f, s);
{     BlockRead}
end;

procedure QBbsave(s: string; n, m: double);
var
   f: file;
   p: pointer;
begin
     Assign(f, s);
{     BlockWrite}
end;

procedure QBchain(s: string);
begin
end;

procedure QBcircle (s: string; x, y, r, c, b, e, a: double);
var
   xw, yw, rw, ry, bd, ed, blx, elx, bly, ely: word;
   bi, ei: double;
begin
     c := Round(c);
     rw := Round(r);
     ry := Round(x / a);

     bi := b / Abs(b);
     ei := e / Abs(e);
     bd := Abs(Round(b * 180 / Pi));
     ed := Abs(Round(e * 180 / Pi));
     b := Abs(b);
     e := Abs(e);

     if c = -1 then c := GetColor;
     if s = 'STEP' then
     begin
          xw := GetX + Round(x);
          yw := GetX + Round(x);
     end
     else
     begin
          xw := Round(x);
          yw := Round(x);
     end;
     if (bi >= 0) and (ei >= 0) then Ellipse(xw, yw, bd, ed, rw, ry);
     if (bi < 0) and (ei < 0) then Sector(xw, yw, bd, ed, rw, ry);
     if (bi >= 0) and (ei < 0) then
     begin
          elx := Round(r * Cos(e));
          ely := Round(r * Sin(e));
          Ellipse(xw, yw, bd, ed, rw, ry);
          Line(xw, yw, elx, ely);
     end;
     if (bi < 0) and (ei >= 0) then
     begin
          blx := Round(r * Cos(b));
          bly := Round(r * Sin(b));
          Ellipse(xw, yw, bd, ed, rw, ry);
          Line(xw, yw, blx, bly);
     end;
end;

procedure QBclear(n: double);
begin
end;

procedure QBcls(n: double);
var
   x, nw: integer;
begin
     nw := Round(n);
     case ScrMode of
     0:
     begin
          case nw of
              0: ClrScr;
          -1, 2: ClrScr;
          end;
     end;
     else
     begin
          case nw of
         -1: ClearViewPort;
          0: ClearDevice;
          1: ClearViewPort;
          2: ClearViewPort;
          end;
     end;
     end;
end;

procedure QBcolor(a, b, c: double);
var
   aw, bw, cw: integer;
begin
     aw := Round(a);
     bw := Round(b);
     cw := Round(c);
     case ScrMode of
     0:
     begin
          if aw <> -1 then TextColor(aw);
          if bw <> -1 then TextBackGround(bw);
          if cw <> -1 then {};
     end;
     1: if bw <> -1 then
        begin
             case bw of
             0:
             begin
                  SetPalette(1, 2);
                  SetPalette(2, 4);
                  SetPalette(3, 6);
             end;
             1:
             begin
                  SetPalette(1, 3);
                  SetPalette(2, 5);
                  SetPalette(3, 15);
             end;
             end;
        end;
     7, 8, 9, 10:
     begin
          if aw <> -1 then SetColor(aw);
          if bw <> -1 then SetBkColor(bw);
     end;
     12, 13: if aw <> -1 then SetColor(aw);
     end;
end;

procedure QBdatep(s: string);
var
   yc, mc, dc, x: integer;
   yw, mw, dw: word;
   ys, ms, ds: string;
begin
     if Length(s) = 8 then x := 2 else x := 4;
     ys := Copy(s, 7, x);
     ms := Copy(s, 1, 2);
     ds := Copy(s, 4, 2);
     Val(ys, yw, yc);
     Val(ms, mw, mc);
     Val(ds, dw, dc);
     SetDate(yw, mw, dw);
end;

procedure QBdraw(s: string);
begin
end;

procedure QBenviron(s: string);
begin
end;

procedure QBerror(n: double);
begin
end;

procedure QBfiles(s: string);
var
   f: SearchRec;
begin
     FindFirst(s, $3F, f);
     if f.Name <> '' then Write(f.Name, '        ');
     repeat
           FindNext(f);
           if f.Name <> '' then Write(f.Name, '        ');
     until f.Name = '';
     WriteLn(DiskFree(0), ' Bytes free');
end;

procedure QBkill(s: string);
var
   fp: file;
   f: SearchRec;
begin
     FindFirst(s, $3F, f);
     if f.Name <> '' then
     begin
          assign(fp, f.Name);
          erase(fp);
     end;
     repeat
           FindNext(f);
           if f.Name <> '' then
           begin
                assign(fp, f.Name);
                erase(fp);
           end;
     until f.Name = '';
end;

procedure QBline(s: string; a, b: double; t: string; c, d, e: double; u: string; f: double);
begin
     if u = 'B' then
     begin
{ Bar3D(x,x,x,x,0,true)

}
     end;
     if u = 'BF' then
     begin
{ Bar

}
     end;
     if u = '' then
     begin
{

}
     end;
end;

procedure QBlocate(a, b, c, d, e: double);
begin
end;

procedure QBmidp(s: string; t, l: double; r: string);
var
   tw, lw: integer;
begin
     tw := Round(t);
     lw := Round(l);
     if lw = -1 then
     begin
          Delete(s, tw, Length(s));
          Insert(r, s, tw);
     end
     else
     begin
          Delete(s, tw, lw);
          Insert(r, s, tw);
     end;
end;

procedure QBname(s, t: string);
begin
end;

procedure QBpaint(s: string; n, m, a, b, c: double);
begin
end;

procedure QBpcopy(n, m: double);
begin
end;

procedure QBplay(s: string);
begin
end;

procedure QBpset(s: string; n, m, o: double);
var
   a, b, c: integer;
begin
     if o = -1 then c := GetColor else c := Round(o);
     if s = 'STEP' then
     begin
          a := GetX + Round(n);
          b := GetY + Round(m);
     end
     else
     begin
          a := Round(n);
          b := Round(m);
     end;
     if IsWindow then
     begin
          a := Round((a - Win1) * (GetMaxX / (Win3 - Win1)));
          b := Round((b - Win2) * (GetMaxY / (Win4 - Win2)));
     end;
     PutPixel(a, b, c);
end;

procedure QBrandomize(n: double);
begin
     RandSeed := Round(n);
end;

procedure QBrun(s: string);
begin
end;

procedure QBscreenp(n, d, m, o: double);
var
 grDriver: integer;
 grMode: integer;
begin
     case Round(n) of
     0: CloseGraph;
     1: begin grDriver := 1; grMode := 0; end;
     2: begin grDriver := 1; grMode := 4; end;
     3: begin grDriver := 7; grMode := 0; end;
     4: begin grDriver := 1; grMode := 0; end;
     7: begin grDriver := 2; grMode := 0; end;
     8: begin grDriver := 3; grMode := 0; end;
     9: begin grDriver := 3; grMode := 1; end;
     10:begin grDriver := 1; grMode := 0; end;
     11:begin grDriver := 2; grMode := 5; end;
     12:begin grDriver := 9; grMode := 2; end;
     13:begin grDriver := 2; grMode := 1; end;
     end;
     InitGraph(grDriver, grMode, 'C:\TP\BGI');
     if m = -1 then else SetActivePage(Round(m));
     if o = -1 then else SetVisualPage(Round(o));
end;

procedure QBshell(s: string);
begin
     s := '/C ' + s;
     SwapVectors;
     Exec(GetEnv('COMSPEC'), s);
     SwapVectors;
end;

procedure QBsleep(n: double);
begin
     repeat
     until KeyPressed;
end;

procedure QBsound(n, m: double);
begin
     Sound(Round(n));
     Delay(Round(m / 18.2 * 1000));
     NoSound;
end;

procedure QBswap(n, m: double);
{var
   p, r, d: pointer;}
begin
{     p := @n;
     r := @m;
     New(d);
     d := p;
     p := r;
     r := d;
     Dispose(d);}
end;

procedure QBtimep(t: string);
var
   hc, mc, sc: integer;
   hw, mw, sw: word;
   hs, ms, ss: string;
begin
     if Length(t) = 2 then
     begin
          hs := Copy(t, 1, 2);
          ms := '';
          ss := '';
     end;
     if length(t) = 5 then
     begin
          hs := Copy(t, 1, 2);
          ms := Copy(t, 4, 2);
          ss := '';
     end;
     if Length(t) = 8 then
     begin
          hs := Copy(t, 1, 2);
          ms := Copy(t, 4, 2);
          ss := Copy(t, 7, 2);
     end;
     Val(hs, hw, hc);
     Val(ms, mw, mc);
     Val(ss, sw, sc);
     SetTime(hw, mw, sw, 0);
end;

procedure QBview(s: string; a, b, c, d, e, f: double);
begin
     if s = 'SCREEN' then SetViewPort(Round(a), Round(b), Round(c), Round(d), ClipOff)
     else SetViewPort(Round(a), Round(b), Round(c), Round(d), ClipOn);
end;

procedure QBviewprint(n, m: double);
begin
     Window(1, Round(n), WindMax, Round(m));
end;

procedure QBwindow(s: string; a, b, c, d: double);
begin
     Win0 := s;
     Win1 := a;
     Win2 := b;
     Win3 := c;
     Win4 := d;
     if s = 'DISABLE' then IsWindow := False else IsWindow := True;
end;

begin
     QBdefseg := 0;
     ScrMode := 0;
     Win0 := '';
     Win1 := 0;
     Win2 := 0;
     Win3 := 0;
     Win4 := 0;
     IsView := False;
     IsWindow := False;
end.
