$IF 0
QBtoTP Translator 0.5.2 (GNU/GPL)       Created with PowerBASIC for DOS 3.50
Copyright (C) 2001-2002 by Bla Valek   E-mail: bvalek2@freemail.hu
MS-DOS QBasic 1.1 -> Turbo Pascal 7.0

    Executable translator

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
$ENDIF
$COM 0
$COMPILE EXE
$CPU 8086
$DEBUG MAP OFF
$DEBUG PBDEBUG OFF
$DEBUG PATH OFF
$DEBUG UNIT OFF
$DIM ALL
$ERROR ALL OFF
$FLOAT EMULATE
$LIB ALL OFF
$OPTIMIZE SPEED
$OPTION CNTLBREAK ON
$SOUND 0
$STACK 32766
$STRING 32

DECLARE SUB Analizer (s AS STRING, p AS INTEGER, z AS STRING, r AS INTEGER)
DECLARE FUNCTION ArgCount(arg AS STRING) AS INTEGER
DECLARE SUB Block (s AS STRING)
DECLARE SUB ConstCond (tocond AS STRING)
DECLARE SUB DefMake (s AS STRING)
DECLARE FUNCTION DimCond (tocond AS STRING, vardecl AS INTEGER) AS STRING
DECLARE SUB FileFunc (n AS INTEGER, s AS STRING, m AS INTEGER)
DECLARE SUB GoCreate (f AS STRING)
DECLARE SUB InsMemoList (n AS INTEGER, s AS STRING)
DECLARE SUB InsMemoProc (n AS INTEGER, s AS STRING)
DECLARE SUB MakeLabel (l AS STRING)
DECLARE SUB MakeUses (l AS STRING)
DECLARE SUB Printer (l AS INTEGER)
DECLARE SUB PutMain (s AS STRING)
DECLARE SUB PutPixel (n AS INTEGER)
DECLARE FUNCTION Reader () AS STRING
DECLARE FUNCTION SearchClose (n AS INTEGER, s AS STRING) AS INTEGER
DECLARE FUNCTION SearchComma (n AS INTEGER, s AS STRING) AS INTEGER
DECLARE FUNCTION SearchObj (n AS INTEGER, s AS STRING, w AS STRING) AS INTEGER
DECLARE SUB SearchStat (n AS INTEGER, s AS STRING, z AS STRING, k AS INTEGER)
DECLARE SUB Split (l AS STRING)
DECLARE SUB SubCreate ()
DECLARE SUB SubMake (n AS INTEGER, f AS INTEGER)
DECLARE SUB Translate ()
DECLARE SUB Varias (s AS STRING, v AS STRING)

DIM comline AS STRING

DIM basfile AS STRING
DIM pasfile AS STRING
DIM datfile AS STRING

DIM switch AS BYTE
SHARED switch

DIM x AS INTEGER
DIM y AS INTEGER
DIM d AS INTEGER
DIM t AS INTEGER

DIM dummystr AS STRING

IF NOT CONSOUT THEN PRINT "QBtoTP Translator 0.5.2 (GNU/GPL)       Created with PowerBASIC for DOS 3.50"
IF NOT CONSOUT THEN PRINT "Copyright (C) 2001-2002 by Bla Valek   E-mail: bvalek2@freemail.hu"
IF NOT CONSOUT THEN PRINT "MS-DOS QBasic 1.1 -> Turbo Pascal 7.0"
IF NOT CONSOUT THEN PRINT
STDOUT "QBtoTP Translator 0.5.2 (GNU/GPL)       Created with PowerBASIC for DOS 3.50"
STDOUT "Copyright (C) 2001-2002 by Bla Valek   E-mail: bvalek2@freemail.hu"
STDOUT "MS-DOS QBasic 1.1 -> Turbo Pascal 7.0"
STDOUT

switch = &B11001001

IF LEN(COMMAND$) THEN
    comline = RTRIM$(COMMAND$)
    FOR x = 1 TO LEN(comline)
        IF MID$(comline, x, 1) = " " THEN d = d + 1
    NEXT x
    REDIM param(d) AS STRING
    d = 0
    FOR x = 1 TO LEN(comline)
        IF MID$(comline, x, 1) = " " THEN d = d + 1 ELSE param(d) = param(d) + MID$(comline, x, 1)
    NEXT x

    basfile = param(0)

    IF UCASE$(basfile) = "/D" THEN
        STDOUT "DOS exit codes:"
        STDOUT
        STDOUT "  0 - Successful translation"
        STDOUT "... - Run-time error (PowerBASIC for DOS 3.50)"
        STDOUT "100 - Information request (QBtoPas was started with /D, /I, /H, or /?)"
        STDOUT "(101 - Translation finished, unspecified error (Refer the translation report))"
        STDOUT "102 - Not enough memory for memory-using translation"
        STDOUT "103 - Input file not found"
        STDOUT "104 - No .BAS file found"
        STDOUT "(105 - Translation aborted by user)"
        STDOUT "(106 - Syntax error translation aborted (QBtoPas was started with /E+))"
        STDOUT "(107 - Syntax warning translation aborted (QBtoPas was started with /W+))"
        END 100
    ELSEIF UCASE$(basfile) = "/H" OR basfile = "/?" THEN
        STDOUT "Usage:
        STDOUT "QBtoTP[.EXE] FILENAME[.BAS] [parameters]"
        STDOUT
        STDOUT "QBtoTP command line parameters:"
        STDOUT "/A+  ask before overwriting (default)   /A-  don't ask"
        STDOUT "/C+  smart compiler directives (def.)   /C-  create QBasic environment"
        STDOUT "/E+  stop if error                      /E-  don't stop (default)"
        STDOUT "/M+  use memory arrays                  /M-  use temporal files (default)"
        STDOUT "(/S+  use strings (default))            (/S-  use pchars or ansistrings)"
        STDOUT "/R+  replace CASE's with IF's           /R-  don't replace (default)"
        STDOUT "/R+  rename TP reserved word            /R-  don't rename (default)"
        STDOUT "     rename convention: Tpreservedword -> _Tpreservedword"
        STDOUT "/W+  stop if warning                    /W-  don't stop (default)"
        STDOUT "/Z+  zeroing variables (default)        /Z-  no zeroing"
        STDOUT
        STDOUT "/D   display DOS exit codes"
        STDOUT "/H   display this help                  /?   display this help"
        STDOUT "/I   important informations about unsolved translation problems"
        END 100
    ELSEIF UCASE$(basfile) = "/I" THEN
        STDOUT "Important informations about unsolved translation problems:"
        STDOUT
        STDOUT "- QBtoTP 0.5.2 does not trace variables. It cannot determine the variable's"
        STDOUT "  type or value. Procedures with both numeric and string arguments are not"
        STDOUT "  properly translated. File I/O with variable referred filenumbers is not"
        STDOUT "  translated."
        STDOUT "  User defined SUBs's output variables are not recognized. They must be"
        STDOUT "  altered per hand."
        STDOUT "- QBtoTP 0.5.2 does not trace structures. QB's DO..LOOP WHILE, DO UNTIL..LOOP,"
        STDOUT "  DO..LOOP structures are not properly translated."
        STDOUT "- QBtoTP 0.5.2 does not rename identifiers. Do not use TP reserved words; a TP"
        STDOUT "  identifier cannot represent a program name, a constant, a variable, a type,"
        STDOUT "  a procedure, or a function declared within the current block at the same"
        STDOUT "  time."
        STDOUT "- In general QBtoTP 0.5.2 cannot translate: dynamic arrays, event trapping,"
        STDOUT "  several machine-related procedures, statements with USING, FIELD, FREEFILE,"
        STDOUT "  GOSUB..RETURN, WIDTH and other specific QB features"
        STDOUT "- QB has IMP and EQV operators; TP has not. Replace them with followings:"
        STDOUT "      a EQV b = NOT (a XOR b)"
        STDOUT "      a IMP b = NOT (a XOR (a AND b))"
        STDOUT "- The length of a TP string must be in the range 1..255."
        STDOUT "- The TP case selector expression must be of an ordinal type. A case consists"
        STDOUT "  of one or more constants or ranges."
        STDOUT "- QB has line numbers greater than 9999. The TP label number must be in the"
        STDOUT "  range 0..9999."
        STDOUT "- TP limits the size of a statement part to about 24K."
        STDOUT "- QB and TP error codes are different; there is no general one to one"
        STDOUT "  comparison between the two error types, QBerror and QBerr do not work in"
        STDOUT "  most cases."
        END 100
    END IF

    IF d > 0 THEN
        FOR x = 1 TO d
            SELECT CASE UCASE$(param(x))
                CASE "/A+": BIT SET switch, 0
                CASE "/A-": BIT RESET switch, 0
                CASE "/C+": BIT SET switch, 1
                CASE "/C-": BIT RESET switch, 1
                CASE "/E+": BIT SET switch, 2
                CASE "/E-": BIT RESET switch, 2
                CASE "/M+": BIT SET switch, 3
                CASE "/M-": BIT RESET switch, 3
                CASE "/S+": BIT SET switch, 4
                CASE "/S-": BIT RESET switch, 4
                CASE "/R+": BIT SET switch, 5
                CASE "/R-": BIT RESET switch, 5
                CASE "/W+": BIT SET switch, 6
                CASE "/W-": BIT RESET switch, 6
                CASE "/Z+": BIT SET switch, 7
                CASE "/Z-": BIT RESET switch, 7
            END SELECT
        NEXT x
    END IF
    ERASE param
ELSE
    INPUT "enter filename: ", basfile
END IF

IF INSTR(basfile, ".") THEN ELSE basfile = basfile + ".BAS"
d = -1
dummystr = DIR$(basfile)
IF dummystr <> "" THEN d = d + 1
DO UNTIL dummystr = ""
    dummystr = DIR$
    IF dummystr <> "" THEN d = d + 1
LOOP

IF d = -1 THEN
    PRINT
    PRINT "ERROR: input file not found"
    PRINT "RESOLUTION: make sure that the path and/or name are correct"
    END 103
ELSE
    IF NOT CONSOUT THEN PRINT d + 1; "files found"
    STDOUT STR$(d + 1) + " files found"
    DIM bassources(d) AS STRING
    d = 0
    bassources(0) = DIR$(basfile)
    dummystr = "dummy"
    DO UNTIL dummystr = ""
        dummystr = DIR$
        IF dummystr <> "" THEN
            d = d + 1
            bassources(d) = dummystr
        END IF
    LOOP
END IF

IF BIT(switch, 3) THEN

IF FRE(-1) < 300000 THEN
    PRINT "ERROR: out of memory"
    PRINT "RESOLUTION: turn /M switch off"
    END 102
END IF

REDIM memofile(32759) AS STRING
REDIM memoproc(32759) AS STRING
REDIM memodata(32759) AS STRING
REDIM memolist(32759) AS STRING

SHARED memofile()
SHARED memoproc()
SHARED memodata()
SHARED memolist()

DIM fileptr AS INTEGER
REDIM procptr(13) AS INTEGER
'0: meta, 1: head, 2: uses, 3: label, 4: const, 5: type, 6: var, 7: proc
'8: head, 9: label, 10: const, 11: type, 12: var, 13: main
DIM dataptr AS INTEGER
REDIM listptr(3) AS INTEGER
'0: dm, 1: array, 2: subdm, 3: subarray

SHARED fileptr
SHARED procptr()
SHARED dataptr
SHARED listptr()

ELSE

DIM file4 AS STRING
DIM file5 AS STRING
DIM file6 AS STRING
DIM file7 AS STRING
DIM file9 AS STRING
DIM file11 AS STRING
DIM file12 AS STRING

SHARED file4
SHARED file5
SHARED file6
SHARED file7
SHARED file9
SHARED file11
SHARED file12

file4 = "PASLABEL.TMP"
file5 = "PASCONST.TMP"
file6 = "PASTYPE.TMP"
file7 = "PASVAR.TMP"
file9 = "PASMAIN.TMP"
file11 = "PASDMVAR.TMP"
file12 = "PASARRAY.TMP"

END IF

DIM enabled AS INTEGER
DIM basic AS STRING
DIM a AS INTEGER
DIM filsiz AS LONG
DIM tlen AS DOUBLE

DIM validline AS STRING:   SHARED validline
DIM expression AS STRING:  SHARED expression
DIM bline AS INTEGER:      SHARED bline
DIM bsize AS LONG:         SHARED bsize
DIM eversub AS INTEGER:    SHARED eversub
DIM submaking AS INTEGER:  SHARED submaking
DIM isN AS INTEGER:        SHARED isN
DIM isX AS INTEGER:        SHARED isX
DIM casevar AS INTEGER:    SHARED casevar
DIM optionbase AS INTEGER: SHARED optionbase
DIM typevar AS INTEGER:    SHARED typevar

DIM defaultvar(25) AS STRING: SHARED defaultvar()
DIM ifstack AS INTEGER:       SHARED ifstack

FOR x = 0 TO d
IF RIGHT$(bassources(x), 4) = ".BAS" THEN

pasfile = LEFT$(bassources(x), INSTR(bassources(x), ".")) + "PAS"
datfile = LEFT$(bassources(x), INSTR(bassources(x), ".")) + "DAT"

ifstack = 0
typevar = 0
casevar = 0

optionbase = 0
submaking = 0
isN = 0
isX = 0

enabled = 0
DO
IF DIR$(pasfile) <> "" AND BIT(switch, 0) THEN
    INPUT "Output file already exists. Overwrite/Skip/Rename [O/S/R]? ", dummystr
    SELECT CASE UCASE$(RTRIM$(dummystr))
        CASE "O": enabled = -1
        CASE "R"
        INPUT "enter filename: ", pasfile
        IF INSTR(pasfile, ".") THEN ELSE pasfile = pasfile + ".PAS"
    CASE ELSE: ITERATE FOR
    END SELECT
ELSE
    enabled = -1
END IF
LOOP UNTIL enabled

IF BIT(switch, 2) THEN

enabled = 0
DO
IF DIR$(datfile) <> "" AND BIT(switch, 0) THEN
    INPUT "Data file already exists. Overwrite/Skip/Rename [O/S/R]? ", dummystr
    SELECT CASE UCASE$(RTRIM$(dummystr))
        CASE "O": enabled = -1
        CASE "R"
        INPUT "enter filename: ", datfile
        IF INSTR(datfile, ".") THEN ELSE datfile = datfile + ".DAT"
    CASE ELSE
        BIT RESET switch, 2
        enabled = -1
    END SELECT
ELSE
    enabled = -1
END IF
LOOP UNTIL enabled

END IF

t = t + 1

FOR y = 0 TO 25
    defaultvar(y) = "single"
NEXT y

IF BIT(switch, 3) THEN
REDIM memofile(32759)
REDIM memoproc(32759)
REDIM memodata(32759)
REDIM memolist(32759)
fileptr = 0
REDIM procptr(13)
dataptr = 0
REDIM listptr(3)
    IF BIT(switch, 1) THEN Insmemoproc 0, "{$A+}{$B-}" ELSE Insmemoproc 0, "{$A+}{$B-}{$D+}{$E+}{$L+}{$N+}{$P-}{$Q+}{$R+}{$S+}{$T-}{$V+}{$X+}{$Y+}"
    memofile(0) = "begin"
    fileptr = 1
ELSE

OPEN "PASMETA.TMP" FOR OUTPUT AS #1
    IF BIT(switch, 1) THEN PRINT #1, "{$A+}{$B-}" ELSE PRINT #1, "{$A+}{$B-}{$D+}{$E+}{$L+}{$N+}{$P-}{$Q+}{$R+}{$S+}{$T-}{$V+}{$X+}{$Y+}"
CLOSE #1
OPEN "PASHEAD.TMP" FOR OUTPUT AS #2:  CLOSE #2
OPEN "PASUSES.TMP" FOR OUTPUT AS #3:  CLOSE #3
OPEN file4 FOR OUTPUT AS #4:          CLOSE #4
OPEN file5 FOR OUTPUT AS #5:          CLOSE #5
OPEN file6 FOR OUTPUT AS #6:          CLOSE #6
OPEN file7 FOR OUTPUT AS #7:          CLOSE #7
OPEN "PASPROC.TMP" FOR OUTPUT AS #8:  CLOSE #8
OPEN "PASMAIN.TMP" FOR OUTPUT AS #9:  PRINT #9, "begin"
OPEN "PASDATA.TMP" FOR OUTPUT AS #10: CLOSE #10
OPEN file11 FOR OUTPUT AS #11:        CLOSE #11
OPEN file12 FOR OUTPUT AS #12:        CLOSE #12

END IF

IF NOT CONSOUT THEN PRINT "translating "; bassources(x)
IF NOT CONSOUT THEN PRINT
STDOUT "translating " + bassources(x)
PRINT
MTIMER
OPEN bassources(x) FOR INPUT AS #13
filsiz = LOF(13)
bline = 0
bsize = 0
DO UNTIL EOF(13)
    LINE INPUT #13, basic
    bline = bline + 1
    bsize = bsize + LEN(basic) + 2
    LOCATE CSRLIN - 1, POS: PRINT "reading"; bline; "lines,"; CEIL(100 * bsize / filsiz); "% completed"
    DO WHILE RIGHT$(RTRIM$(basic), 1) = "_"
        LINE INPUT #13, dummystr
        bline = bline + 1
        bsize = bsize + LEN(dummystr) + 2
        LOCATE CSRLIN - 1, POS: PRINT "reading"; bline; "lines,"; CEIL(100 * bsize / filsiz); "% completed"
        basic = RTRIM$(RTRIM$(RTRIM$(basic), "_")) + " " + LTRIM$(dummystr)
    LOOP
    Split TRIM$(basic)
LOOP
CLOSE #13

IF NOT CONSOUT THEN STDOUT "reading" + STR$(bline) + " lines," + STR$(CEIL(100 * bsize / filsiz)) + " % completed"

IF BIT(switch, 3) THEN
    memofile(fileptr) = "end."
    fileptr = fileptr + 1
    IF BIT(switch, 1) THEN
        IF IsN THEN InsMemoProc 0, "{$N+}"
        IF IsX THEN InsMemoProc 0, "{$X+}"
    END IF
    IF procptr(2) > procptr(1) THEN memoproc(procptr(2) - 1) = memoproc(procptr(2) - 1) + ";"
    IF procptr(3) > procptr(2) THEN memoproc(procptr(3) - 1) = memoproc(procptr(3) - 1) + ";"
ELSE
    PRINT #9, "end."
    CLOSE #9
IF BIT(switch, 1) THEN
    IF IsN THEN
        OPEN "PASMETA.TMP" FOR APPEND AS #1
            PRINT #1, "{$N+}"
        CLOSE #1
    END IF
    IF IsX THEN
        OPEN "PASMETA.TMP" FOR APPEND AS #1
            PRINT #1, "{$X+}"
        CLOSE #1
    END IF
END IF
    OPEN "PASUSES.TMP" FOR APPEND AS #3
        IF LOF(3) <> 0 THEN PRINT #3, ";"
    CLOSE #3
    OPEN "PASLABEL.TMP" FOR APPEND AS #4
        IF LOF(4) <> 0 THEN PRINT #4, ";"
    CLOSE #4
END IF

OPEN pasfile FOR OUTPUT AS #14

IF BIT(switch, 3) THEN
    FOR a = 0 TO procptr(13) - 1
        PRINT #14, memoproc(a)
    NEXT a
    FOR a = 0 TO fileptr - 1
        PRINT #14, memofile(a)
    NEXT a
    IF BIT(switch, 2) THEN
        FOR a = 0 TO dataptr - 1
            PRINT #14, memodata(a)
        NEXT a
    ELSE
        OPEN datfile FOR OUTPUT AS #15
        FOR a = 0 TO dataptr - 1
            PRINT #15, memodata(a)
        NEXT a
        CLOSE #15
    END IF
ELSE
    GoCreate "PASMETA.TMP"
    GoCreate "PASHEAD.TMP"
    GoCreate "PASUSES.TMP"
    GoCreate "PASLABEL.TMP"
    GoCreate "PASCONST.TMP"
    GoCreate "PASTYPE.TMP"
    GoCreate "PASVAR.TMP"
    GoCreate "PASPROC.TMP"
    GoCreate "PASMAIN.TMP"
    IF BIT(switch, 2) THEN GoCreate "PASDATA.TMP" ELSE NAME "PASDATA.TMP" AS datfile
END IF

CLOSE #14
tlen = MTIMER
IF NOT CONSOUT THEN PRINT "translated in"; tlen / 1000000; "seconds"
STDOUT "translated in" + STR$(tlen / 1000000) + " seconds"
END IF
NEXT x

IF t = 0 THEN
    PRINT "ERROR: no .BAS files found, no translation"
    PRINT "RESOLUTION: make sure that the path and/or name are correct"
    END 104
ELSE

IF BIT(switch, 3) THEN
ELSE
KILL "PASMETA.TMP":  KILL "PASHEAD.TMP":  KILL "PASUSES.TMP"
KILL "PASLABEL.TMP": KILL "PASCONST.TMP": KILL "PASTYPE.TMP"
KILL "PASVAR.TMP":   KILL "PASPROC.TMP":  KILL "PASMAIN.TMP"
KILL "PASDMVAR.TMP": KILL "PASARRAY.TMP"
IF BIT(switch, 2) THEN KILL "PASDATA.TMP"

IF eversub THEN
KILL "SUBHEAD.TMP":  KILL "SUBLABEL.TMP": KILL "SUBCONST.TMP"
KILL "SUBTYPE.TMP":  KILL "SUBVAR.TMP":   KILL "SUBMAIN.TMP"
KILL "SUBDMVAR.TMP": KILL "SUBARRAY.TMP"
END IF

END IF
    IF NOT CONSOUT THEN PRINT t; "files translated"
    STDOUT STR$(t) + " files translated"
    END 0
END IF

SUB Analizer (s AS STRING, p AS INTEGER, z AS STRING, r AS INTEGER)
DIM lo AS INTEGER
DIM hi AS INTEGER
DIM x AS INTEGER
DIM brak AS INTEGER
DIM yesarray AS INTEGER

DIM a AS STRING
DIM d AS STRING
DIM cs AS STRING
DIM bs AS STRING

r = 0
SELECT CASE UCASE$(s)
CASE "": z = ""
CASE "ABS": z = "Abs"
CASE "AND": z = "and"
CASE "ASC": z = "Ord"
CASE "ATN": z = "ArcTan"
CASE "CDBL"
    isN = -1
    MakeUses "Basic"
    z = "QBcdbl"
CASE "CHR$": z = "Chr"
CASE "CINT": z = "Round"
CASE "CLNG": z = "Round"
CASE "COS": z = "Cos"
CASE "CSNG"
    isN = -1
    MakeUses "Basic"
    z = "QBcsng"
CASE "CSRLIN"
    MakeUses "Crt"
    z = "WhereY"
CASE "CVD"
    isN = -1
    MakeUses "Basic"
    z = "QBcvd"
CASE "CVDMBF"
    isN = -1
    MakeUses "Basic"
    z = "QBcvd"
CASE "CVI"
    MakeUses "Basic"
    z = "QBcvi"
CASE "CVL"
    MakeUses "Basic"
    z = "QBcvl"
CASE "CVS"
    isN = -1
    MakeUses "Basic"
    z = "QBcvs"
CASE "CVSMBF"
    isN = -1
    MakeUses "Basic"
    z = "QBcvs"
CASE "DATE$"
    MakeUses "Basic"
    z = "QBdatef"
CASE "ENVIRON$"
    MakeUses "Dos"
    z = "EnvStr"
CASE "EOF"
    Filefunc p, d, r
    r = r + 1
    z = "Eof(" + d
CASE "EQV": z = "{" + s + "}"
CASE "ERDEV"
    MakeUses "Basic"
    z = "QBerdev"
CASE "ERDEV$"
    MakeUses "Basic"
    z = "QBerdevs"
CASE "ERL": z = "{" + s + "}"
CASE "ERR"
    MakeUses "Basic"
    z = "QBerr"
CASE "EXP": z = "Exp"
CASE "FILEATTR": z = "{" + s + "}"
CASE "FIX": z = "Int"
CASE "FRE"
    isN = -1
    MakeUses "Basic"
    z = "QBfre"
CASE "FREEFILE": z = "{" + s + "}"
CASE "HEX$"
    isN = -1
    MakeUses "Basic"
    z = "QBhex"
CASE "IMP": z = "{" + s + "}"
CASE "INKEY$"
    MakeUses "Basic"
    z = "QBinkey"
CASE "INP"
    z = "Port"
    IF INSTR(p, expression, "(") THEN MID$(expression, INSTR(p, expression, "("), 1) = "["
    MID$(expression, SearchClose(p + 1, expression), 1) = "]"
CASE "INPUT$"
    MakeUses "Basic"
    z = "QBinput"
CASE "INSTR"
    MakeUses "Basic"
d = MID$(expression, p + 1, SearchClose(p + 1, expression) - p - 1)
IF ArgCount(d) = 2 THEN
    z = "QBinstr"
ELSE
    z = "QBinstr"
    cs = LEFT$(expression, p - 1)
    bs = MID$(expression, p + 1)
    expression = cs + "(-1, " + bs
END IF
CASE "IOCTL$": z = "{" + s + "}"
CASE "INT": z = "Int"
CASE "LBOUND": z = "{" + s + "}"
CASE "LCASE$"
    isX = -1
    MakeUses "Basic"
    z = "QBlcase"
CASE "LEFT$"
    MakeUses "Basic"
    z = "QBleft"
CASE "LEN": z = "Length"
CASE "LOC"
    Filefunc p, d, r
    r = r + 1
    z = "Filepos(" + d
CASE "LOF"
    Filefunc p, d, r
    r = r + 1
    z = "Filesize(" + d
CASE "LOG": z = "Ln"
CASE "LPOS": z = "{" + s + "}"
CASE "LTRIM$"
    MakeUses "Basic"
    z = "QBltrim"

CASE "MID$"
    MakeUses "Basic"
d = TRIM$(MID$(expression, p + 1, SearchClose(p + 1, expression) - p - 1))
IF ArgCount(d) = 2 THEN
    z = "QBmidf"
ELSE
    z = "QBmidf"
    cs = LEFT$(expression, SearchClose(p + 1, expression) - 1)
    bs = MID$(expression, SearchClose(p + 1, expression) + 1)
    expression = cs + ", -1)" + bs
END IF

CASE "MKD"
    isN = -1
    MakeUses "Basic"
    z = "QBmkd"
CASE "MKDMBF"
    isN = -1
    MakeUses "Basic"
    z = "QBmkd"
CASE "MKI"
    MakeUses "Basic"
    z = "QBmki"
CASE "MKL"
    MakeUses "Basic"
    z = "QBmkl"
CASE "MKS"
    isN = -1
    MakeUses "Basic"
    z = "QBmks"
CASE "MKSMBF"
    isN = -1
    MakeUses "Basic"
    z = "QBmks"
CASE "MOD": z = "mod"
CASE "NOT": z = "not"
CASE "OCT$"
    isN = -1
    MakeUses "Basic"
    z = "QBoct"
CASE "OR": z = "or"
CASE "PEEK"
    MakeUses "Basic"
    z = "Mem[QBdefseg:"
    IF INSTR(p, expression, "(") THEN MID$(expression, INSTR(p, expression, "("), 1) = " "
    MID$(expression, SearchClose(p + 1, expression), 1) = "]"
CASE "PEN": z = "{" + s + "}"
CASE "PLAY": z = "{" + s + "}"
CASE "PMAP"
    isN = -1
    MakeUses "Basic"
    z = "QBpmap"
CASE "POINT"
    MakeUses "Graph"
    z = "GetPixel"
CASE "POS"
    MakeUses "Basic"
    z = "QBpos"
CASE "RIGHT$"
    MakeUses "Basic"
    z = "QBright"
CASE "RND": z = "Random"
CASE "RTRIM$"
    MakeUses "Basic"
    z = "QBrtrim"
CASE "SCREEN"
    MakeUses "Basic"
    z = "QBscreenf"
CASE "SEEK"
    Filefunc p, d, r
    r = r + 1
    z = "Filepos(" + d
CASE "SGN"
    isN = -1
    MakeUses "Basic"
    z = "QBsgn"
CASE "SIN": z = "Sin"
CASE "SPACE$"
    MakeUses "Basic"
    z = "QBspace"
CASE "SPC"
    MakeUses "Basic"
    z = "QBspc"
CASE "SQR": z = "Sqrt"
CASE "STICK": z = "{" + s + "}"
CASE "STR$"
    MakeUses "Basic"
    z = "QBstr"
CASE "STRIG"
    MakeUses "Basic"
    z = "QBstrig"
CASE "STRING$"
    MakeUses "Basic"
    z = "QBstring"
CASE "UBOUND": z = "{" + s + "}"
CASE "UCASE$"
    isX = -1
    MakeUses "Basic"
    z = "QBucase"
CASE "TAB"
    MakeUses "Basic"
    z = "QBtab"
CASE "TAN"
    isN = -1
    MakeUses "Basic"
    z = "QBtan"
CASE "TIME$"
    MakeUses "Basic"
    z = "QBtimef"
CASE "TIMER"
    MakeUses "Basic"
    z = "QBtimer"
CASE "TO": z = ".."
CASE "XOR": z = "xor"
CASE "VAL"
    MakeUses "Basic"
    z = "QBval"
CASE "VARPTR": z = "Ofs"
CASE "VARPTR$": z = "Ofs"
CASE "VARSEG": z = "Seg"

CASE ELSE

IF LEFT$(s, 2) = "&H" THEN
    z = "$" + MID$(s, 3)
ELSEIF LEFT$(s, 2) = "&O" THEN
    z = "{" + s + "}"
ELSEIF (ASC(LEFT$(s, 1)) > 47) AND (ASC(LEFT$(s, 1)) < 58) THEN
    z = s
ELSEIF UCASE$(LEFT$(s, 10)) = "BASFILENUM" THEN
    z = s
ELSEIF INSTR(s, ".") THEN
    z = s
ELSE
    IF BIT(switch, 3) THEN
        IF submaking THEN
            lo = 2
            hi = 3
        ELSE
            lo = 0
            hi = 1
        END IF
        FOR x = listptr(lo) TO listptr(hi) - 1
            IF UCASE$(memolist(x)) = UCASE$(RTRIM$(s, ANY "%&!#$")) THEN
                yesarray = -1
                EXIT FOR
            END IF
        NEXT x
    ELSE
        OPEN file12 FOR INPUT AS #12
        DO UNTIL EOF(12)
            INPUT #12, a
            IF UCASE$(RTRIM$(s, ANY "%&!#$")) = UCASE$(a) THEN
                yesarray = -1
                EXIT DO
            END IF
        LOOP
        CLOSE #12
    END IF
    IF yesarray THEN
        FOR x = p TO LEN(expression)
            a = MID$(expression, x, 1)
            IF a = "(" OR a = "[" THEN
                IF brak = 0 THEN lo = x
                brak = brak + 1
            ELSEIF a = ")" OR a = "]" THEN
                brak = brak - 1
                IF brak = 0 THEN
                    hi = x
                    EXIT FOR
                END IF
            END IF
        NEXT x
        IF lo = 0 THEN lo = 1
        IF hi = 0 THEN hi = 1
        MID$(expression, lo, 1) = "["
        MID$(expression, hi, 1) = "]"
    END IF
    IF BIT(switch, 3) THEN
        IF submaking THEN
            brak = listptr(1)
            hi = 2
        ELSE
            brak = 0
            hi = 0
        END IF
        FOR x = brak TO listptr(hi) - 1
            IF UCASE$(memolist(x)) = UCASE$(RTRIM$(s, ANY "%&!#$")) THEN
                yesarray = -1
                EXIT FOR
            END IF
        NEXT x
    ELSE
        OPEN file11 FOR INPUT AS #11
        DO UNTIL EOF(11)
            INPUT #11, a
            IF UCASE$(RTRIM$(s, ANY "%&!#$")) = UCASE$(a) THEN
                yesarray = -1
                EXIT DO
            END IF
        LOOP
        CLOSE #11
    END IF
    IF ASC(UCASE$(LEFT$(s, 1))) >= 65 AND ASC(UCASE$(LEFT$(s, 1))) <= 90 THEN
        IF yesarray THEN
        ELSE
            Varias s, ""
        END IF
    ELSE
        z = "{" + s + "}"
    END IF

    z = RTRIM$(s, ANY "%&!#$")
END IF

END SELECT

END SUB

FUNCTION ArgCount(arg AS STRING) AS INTEGER
DIM x AS INTEGER
DIM a AS STRING
DIM brak AS INTEGER
DIM d AS INTEGER

FOR x = 1 TO LEN(arg)
    a = MID$(arg, x, 1)
    IF a = "(" THEN
        brak = brak + 1
    ELSEIF a = ")" THEN
        brak = brak - 1
    ELSEIF (a = ",") AND (brak = 0) THEN
        d = d + 1
    END IF
NEXT x
FUNCTION = d
END FUNCTION

SUB Block (s AS STRING)
DIM x AS INTEGER

DIM a AS STRING
DIM filnum AS STRING
DIM pasexpr AS STRING

a = LTRIM$(MID$(validline, 4))
SELECT CASE LEFT$(a, 1)
    CASE "#"
x = INSTR(validline, ",")
IF x = 0 THEN x = LEN(a) + 1
filnum = TRIM$(MID$(a, 2, x - 2))
filnum = "BasFileNum" + STRING$(2 - LEN(HEX$(VAL(filnum))), "0") + HEX$(VAL(filnum))
x = SearchComma(x + 1, a)
expression = LTRIM$(MID$(a, x + 1))
PutMain s + "(" + filnum + ", " + Reader + ", 1);"
    CASE "("
        PutMain "{" + validline + "}"
    CASE ELSE
        PutMain "{" + validline + "}"
END SELECT

END SUB

SUB ConstCond (tocond AS STRING)
DIM x AS INTEGER
DIM y AS INTEGER
DIM a AS STRING
DIM b AS STRING
DIM d AS INTEGER
DIM n AS STRING
DIM m AS STRING
DIM t AS STRING

REDIM constant(ArgCount(tocond)) AS STRING
FOR x = 1 TO LEN(tocond)
    a = MID$(tocond, x, 1)
    IF a = "," THEN
        y = y + 1
    ELSE
        constant(y) = constant(y) + a
    END IF
NEXT x
FOR x = 0 TO y
    constant(x) = TRIM$(constant(x))
    FOR d = 1 TO LEN(constant(x))
        b = MID$(constant(x), d, 1)
        IF b = "=" THEN
            n = RTRIM$(LEFT$(constant(x), d - 1))
            m = LTRIM$(MID$(constant(x), d + 1))
        END IF
    NEXT d
    SELECT CASE RIGHT$(n, 1)
        CASE "%": t = ": integer"
        CASE "&": t = ": longint"
        CASE "!": t = ": single"
        CASE "#": t = ": double"
        CASE "$": t = ": string"
        CASE ELSE: t = ""
    END SELECT
    IF t = ": single" OR t = ": double" THEN IsN = -1
    n = RTRIM$(n, ANY "%&!#$")
IF BIT(switch, 3) THEN
    IF submaking THEN d = 10 ELSE d = 4
    IF procptr(d) = procptr(d - 1) THEN
        InsMemoProc d, "const"
        InsMemoProc d, "     " + n + t + " = " + m + ";"
    ELSE
        InsMemoProc d, "     " + n + t + " = " + m + ";"
    END IF
    IF submaking THEN InsMemoList 2, n ELSE InsMemoList 0, n
ELSE
    OPEN file11 FOR APPEND AS #11
        PRINT #11, n
    CLOSE #11
    OPEN file5 FOR APPEND AS #5
        IF LOF(5) = 0 THEN
            PRINT #5, "const"
            PRINT #5, "     "; n; t; " = "; m; ";"
        ELSE
            PRINT #5, "     "; n; t; " = "; m; ";"
        END IF
    CLOSE #5
END IF
NEXT x
END SUB

SUB DefMake (s AS STRING)
DIM x AS INTEGER
DIM p AS STRING

p = UCASE$(LTRIM$(MID$(validline, 7)))
IF LEN(p) = 1 THEN
    defaultvar(ASC(p) - 65) = s
ELSE
    FOR x = ASC(LEFT$(p, 1)) - 65 TO ASC(RIGHT$(p, 1)) - 65
        defaultvar(x) = s
    NEXT x
END IF
END SUB

FUNCTION DimCond (tocond AS STRING, vardecl AS INTEGER) AS STRING
DIM ifnotarray AS INTEGER
DIM brak AS INTEGER
DIM dmnum AS INTEGER
DIM x AS INTEGER
DIM y AS INTEGER
DIM d AS INTEGER
DIM z AS INTEGER
DIM a AS STRING
DIM b AS STRING
DIM dmname AS STRING
DIM arrdm AS STRING
DIM pastyp AS STRING
DIM zorro AS STRING
DIM zero AS INTEGER
DIM outstr AS STRING

IF tocond = "" THEN
    FUNCTION = ""
    EXIT FUNCTION
END IF

REDIM declarat(ArgCount(tocond)) AS STRING
REDIM pasdecl(ArgCount(tocond)) AS STRING

FOR x = 1 TO LEN(tocond)
    a = MID$(tocond, x, 1)
    IF a = "(" THEN
        brak = brak + 1
        declarat(dmnum) = declarat(dmnum) + a
    ELSEIF a = ")" THEN
        brak = brak - 1
        declarat(dmnum) = declarat(dmnum) + a
    ELSEIF (a = ",") AND (brak = 0) THEN
        dmnum = dmnum + 1
    ELSE
        declarat(dmnum) = declarat(dmnum) + a
    END IF
NEXT x
FOR x = 0 TO dmnum
    declarat(x) = TRIM$(declarat(x))
    IF declarat(x) = "" THEN ITERATE FOR
    SearchStat 1, declarat(x), dmname, z
    IF BIT(switch, 3) THEN
        IF submaking THEN zero = 2
        InsMemoList zero, RTRIM$(dmname, ANY "%&!#$")
    ELSE
        OPEN file11 FOR APPEND AS #11
            PRINT #11, RTRIM$(dmname, ANY "%&!#$")
        CLOSE #11
    END IF
    pastyp = LTRIM$(MID$(declarat(x), z))
    IF LEFT$(pastyp, 1) = "(" THEN
        IF BIT(switch, 3) THEN
            IF submaking THEN zero = 3 ELSE zero = 1
            InsMemoList zero, RTRIM$(dmname, ANY "%&!#$")
        ELSE
            OPEN file12 FOR APPEND AS #12
                PRINT #12, RTRIM$(dmname, ANY "%&!#$")
            CLOSE #12
        END IF
        b = TRIM$(RTRIM$(LTRIM$(LEFT$(pastyp, SearchClose(1, pastyp) - 1), "("), ")"))
        pastyp = LTRIM$(MID$(pastyp, SearchClose(1, pastyp) + 1))
    ELSE
        ifnotarray = -1
    END IF
    IF LEN(b) THEN
        REDIM bounds(ArgCount(b)) AS STRING
        brak = 0
        d = 0
        FOR y = 1 TO LEN(b)
             a = MID$(b, y, 1)
             IF a = "(" THEN
                 brak = brak + 1
                 bounds(d) = bounds(d) + a
             ELSEIF a = ")" THEN
                 brak = brak - 1
                 bounds(d) = bounds(d) + a
             ELSEIF (a = ",") AND (brak = 0) THEN
                 d = d + 1
             ELSE
                 bounds(d) = bounds(d) + a
             END IF
        NEXT y
        FOR y = 0 TO d
            IF INSTR(UCASE$(bounds(y)), "TO") THEN
                REPLACE "TO" WITH ".." IN bounds(y)
                REPLACE "to" WITH ".." IN bounds(y)
                REPLACE "tO" WITH ".." IN bounds(y)
                REPLACE "To" WITH ".." IN bounds(y)
            ELSE
                bounds(y) = "0 .. " + LTRIM$(bounds(y))
            END IF
            arrdm = arrdm + TRIM$(bounds(y)) + ", "
        NEXT y
        arrdm = "array[" + RTRIM$(RTRIM$(arrdm), ",") + "] of "
    END IF
    SELECT CASE RIGHT$(dmname, 1)
        CASE "%": pastyp = "integer"
        CASE "&": pastyp = "longint"
        CASE "!": pastyp = "single"
        CASE "#": pastyp = "double"
        CASE "$": pastyp = "string"
    CASE ELSE
        IF LEN(pastyp) THEN
            IF SearchObj(1, UCASE$(pastyp), "INTEGER") THEN
                pastyp = "integer"
            ELSEIF SearchObj(1, UCASE$(pastyp), "LONG") THEN
                pastyp = "longint"
            ELSEIF SearchObj(1, UCASE$(pastyp), "SINGLE") THEN
                pastyp = "single"
            ELSEIF SearchObj(1, UCASE$(pastyp), "DOUBLE") THEN
                pastyp = "double"
            ELSEIF SearchObj(1, UCASE$(pastyp), "STRING") THEN
                IF INSTR(SearchObj(1, UCASE$(pastyp), "STRING"), pastyp, "*") THEN
                    expression = LTRIM$(MID$(pastyp, INSTR(SearchObj(1, UCASE$(pastyp), "STRING"), pastyp, "*") + 1))
                    pastyp = "string[" + Reader + "]"
                ELSE
                    pastyp = "string"
                END IF
            ELSE
                pastyp = LTRIM$(MID$(pastyp, SearchObj(1, UCASE$(pastyp), "AS")))
                ifnotarray = 0
            END IF
        ELSE
            pastyp = defaultvar(ASC(UCASE$(LEFT$(dmname, 1))) - 65)
        END IF
    END SELECT
    dmname = RTRIM$(dmname, ANY "%&!#$")
    IF LEFT$(pastyp, 6) = "string" THEN zorro = "''" ELSE zorro = "0"
    IF pastyp = "single" OR pastyp = "double" THEN IsN = -1
    pasdecl(x) = dmname + ": " + arrdm + pastyp + ";"
    IF vardecl AND (NOT LEN(arrdm)) AND BIT(switch, 7) THEN
        IF ifnotarray THEN PutMain dmname + " := " + zorro + ";"
    END IF
    ifnotarray = 0
NEXT x
IF vardecl THEN
    IF BIT(switch, 3) THEN
        IF submaking THEN d = 12 ELSE d = 6
        FOR x = 0 TO dmnum
            IF procptr(d) = procptr(d - 1) THEN
                InsMemoProc d, "var"
                InsMemoProc d, "   " + pasdecl(x)
            ELSE
                InsMemoProc d, "   " + pasdecl(x)
            END IF
        NEXT x
    ELSE
        OPEN file7 FOR APPEND AS #7
            FOR x = 0 TO dmnum
                IF LOF(7) = 0 THEN
                    PRINT #7, "var"
                    PRINT #7, "   "; pasdecl(x)
                ELSE
                    PRINT #7, "   "; pasdecl(x)
                END IF
            NEXT x
        CLOSE #7
    END IF
    FUNCTION = ""
ELSE
    FOR x = 0 TO dmnum
        outstr = outstr + pasdecl(x)
    NEXT x
    FUNCTION = RTRIM$(outstr, ";")
END IF
END FUNCTION

SUB Filefunc (n AS INTEGER, s AS STRING, m AS INTEGER)
DIM w AS INTEGER
DIM z AS INTEGER
DIM b AS STRING
DIM filnum AS STRING

FOR z = n + 1 TO LEN(expression)
     b = MID$(expression, z, 1)
     IF b = "(" THEN
         w = w + 1
     ELSEIF b = ")" THEN
         IF w = 0 THEN EXIT FOR
         w = w - 1
         IF w = 0 THEN EXIT FOR
     END IF
NEXT z
filnum = TRIM$(MID$(expression, n + 1, z - n - 1))
m = LEN(filnum)
s = "BasFileNum" + STRING$(2 - LEN(HEX$(VAL(filnum))), "0") + _
    HEX$(VAL(filnum))
END SUB

SUB GoCreate (f AS STRING)
DIM pascal AS STRING

OPEN f FOR INPUT AS #16
    DO UNTIL EOF(16)
        LINE INPUT #16, pascal
        PRINT #14, pascal
    LOOP
CLOSE #16

END SUB

SUB Insmemolist (n AS INTEGER, s AS STRING)
DIM x AS INTEGER

FOR x = 0 TO 3
    IF x < n THEN
    ELSEIF x = n THEN
        ARRAY INSERT memolist(listptr(x)), s
        listptr(x) = listptr(x) + 1
    ELSEIF x > n THEN
        listptr(x) = listptr(x) + 1
    END IF
NEXT x

END SUB

SUB Insmemoproc (n AS INTEGER, s AS STRING)
DIM x AS INTEGER

FOR x = 0 TO 13
    IF x < n THEN
    ELSEIF x = n THEN
        ARRAY INSERT memoproc(procptr(x)), s
        procptr(x) = procptr(x) + 1
    ELSEIF x > n THEN
        procptr(x) = procptr(x) + 1
    END IF
NEXT x

END SUB

SUB Makelabel (l AS STRING)
DIM x AS INTEGER
DIM lulu AS INTEGER
DIM lo AS INTEGER
DIM hi AS INTEGER
DIM vname AS STRING

IF BIT(switch, 3) THEN
    IF submaking THEN
        lo = 8
        hi = 9
    ELSE
        lo = 2
        hi = 3
    END IF
    IF procptr(lo) = procptr(hi) THEN
        Insmemoproc hi, "label"
        Insmemoproc hi, "     " + l
    ELSE
        FOR x = procptr(lo) TO procptr(hi) - 1
            IF SearchObj(1, UCASE$(memoproc(x)), UCASE$(l)) THEN EXIT SUB
        NEXT x
        IF LEN(memoproc(procptr(hi) - 1)) > 122 THEN
            memoproc(procptr(hi) - 1) = memoproc(procptr(hi) - 1) + ","
            Insmemoproc hi, "     " + l
        ELSE
            memoproc(procptr(hi) - 1) = memoproc(procptr(hi) - 1) + ", " + l
        END IF
    END IF
ELSE
OPEN file4 FOR APPEND AS #4
    IF LOF(4) = 0 THEN
        PRINT #4, "label"
        PRINT #4, "     "; l;
    ELSE
        CLOSE #4
        OPEN file4 FOR INPUT AS #4
            DO UNTIL EOF(4)
                LINE INPUT #4, vname
                IF SearchObj(1, UCASE$(vname), UCASE$(l)) THEN
                    CLOSE #4
                    EXIT SUB
                END IF
            LOOP
        CLOSE #4
        OPEN file4 FOR APPEND AS #4
            IF LEN(vname + ", " + l + ",") > 122 THEN
                PRINT #4, ","
                PRINT #4, "     "; l;
            ELSE
                PRINT #4, ", "; l;
            END IF
    END IF
CLOSE #4
END IF

END SUB

SUB MakeUses (l AS STRING)
DIM x AS INTEGER
DIM lulu AS INTEGER
DIM uno AS STRING

IF BIT(switch, 3) THEN
    FOR x = procptr(1) TO procptr(2) - 1
        IF INSTR(memoproc(x), l) THEN lulu = -1
    NEXT x
    IF NOT lulu THEN
        IF procptr(1) = procptr(2) THEN
            Insmemoproc 2, "uses"
            Insmemoproc 2, "    " + l
        ELSE
            memoproc(procptr(2) - 1) = memoproc(procptr(2) - 1) + ", " + l
        END IF
    END IF
ELSE
    OPEN "PASUSES.TMP" FOR INPUT AS #3
        DO UNTIL EOF(3)
            LINE INPUT #3, uno
            IF INSTR(uno, l) THEN lulu = -1
        LOOP
    CLOSE #3
    IF NOT lulu THEN
        OPEN "PASUSES.TMP" FOR APPEND AS #3
            IF LOF(3) = 0 THEN
                PRINT #3, "uses"
                PRINT #3, "    "; l;
            ELSE
                PRINT #3, ", "; l;
            END IF
        CLOSE #3
    END IF
END IF

END SUB

SUB Printer (l AS INTEGER)
DIM filnum AS STRING
DIM lbord AS STRING
DIM rbord AS STRING

IF l = 6 THEN
    lbord = "'" + CHR$(34) + "', "
    rbord = ", '" + CHR$(34) + "'"
    l = 5
END IF

IF LEN(validline) = l THEN
    IF lbord = "" THEN PutMain "WriteLn;" ELSE PutMain "WriteLn('" + CHR$(34, 34) + "');"
ELSE
    expression = LTRIM$(MID$(validline, l + 1))
    filnum = ""
    IF LEFT$(expression, 1) = "#" THEN
        filnum = TRIM$(MID$(validline, INSTR(validline, "#") + 1, INSTR(validline, ",") - INSTR(validline, "#") - 1))
        expression = LTRIM$(MID$(expression, INSTR(expression, ",") + 1))
        filnum = "BasFileNum" + STRING$(2 - LEN(HEX$(VAL(filnum))), _
        "0") + HEX$(VAL(filnum)) + ", "
    END IF
    IF RIGHT$(expression, 1) = ";" THEN
        expression = RTRIM$(RTRIM$(expression, ";"))
        REPLACE ";" WITH "," IN expression
        PutMain "Write(" + filnum + lbord + Reader + rbord + ");"
    ELSE
        REPLACE ";" WITH "," IN expression
        PutMain "WriteLn(" + filnum + lbord + Reader + rbord + ");"
    END IF
END IF
END SUB

SUB PutMain (s AS STRING)
IF BIT(switch, 3) THEN
    IF submaking THEN
        Insmemoproc 12, s
    ELSE
        memofile(fileptr) = s
        fileptr = fileptr + 1
    END IF
ELSE
    PRINT #9, s
END IF
END SUB

SUB PutPixel (n AS INTEGER)
DIM x AS INTEGER
DIM filnum AS STRING
DIM pasexpr AS STRING

MakeUses "Basic"
SearchStat n, validline, filnum, x
IF UCASE$(filnum) = "STEP" THEN
    pasexpr = "QBpset('STEP', "
ELSE
    pasexpr = "QBpset('', "
    x = n
END IF
expression = TRIM$(LTRIM$(LTRIM$(MID$(validline, x, SearchClose(x, validline) - x)), "("))
pasexpr = pasexpr + Reader
IF SearchClose(1, validline) = LEN(validline) THEN
    PutMain pasexpr + ", -1);"
ELSE
    expression = LTRIM$(LTRIM$(LTRIM$(MID$(validline, SearchClose(1, validline) + 1)), ","))
    PutMain pasexpr + ", " + Reader + ");"
END IF
END SUB

FUNCTION Reader () AS STRING
DIM gamma AS INTEGER
DIM omega AS INTEGER
DIM tf AS INTEGER
DIM uppa AS INTEGER
DIM ignorediv AS INTEGER
DIM brak AS INTEGER
DIM d AS INTEGER

DIM astart AS INTEGER
DIM bend AS INTEGER
DIM lef AS STRING
DIM rig AS STRING
DIM alin AS STRING
DIM blin AS STRING

DIM dummystr AS STRING
DIM a AS STRING
DIM object AS STRING
DIM subject AS STRING

IF expression = "" THEN
    FUNCTION = ""
    EXIT FUNCTION
END IF

omega = LEN(expression)
DO UNTIL gamma = omega
gamma = gamma + 1
    a = MID$(expression, gamma, 1)
    IF a = CHR$(34) THEN
        tf = tf + 1
        a = "'"
    ELSE
        IF tf / 2 <> tf \ 2 THEN
            IF a = "'" THEN a = "''"
        ELSEIF tf / 2 = tf \ 2 THEN
            IF a = "\" THEN
                a = "div"
                Analizer object, gamma, dummystr, d
                object = dummystr
                gamma = gamma + d
                a = RTRIM$(object) + " " + a + " "
                object = ""
            ELSEIF a = "^" OR a = "[" OR a = "]" OR a = "," OR a = ">" OR _
            a = "<" OR a = "=" OR a = "(" OR a = ")" OR a = "+" OR a = "*" _
            OR a = "/" OR a = "\" OR a = " " OR a = "-" OR a = CHR$(34) THEN
                Analizer object, gamma, dummystr, d
                gamma = gamma + d
                a = MID$(expression, gamma, 1)
                object = dummystr
                a = object + a
                object = ""
            ELSEIF gamma = LEN(expression) THEN
                object = object + a
                Analizer object, gamma, dummystr, d
                object = dummystr
                gamma = gamma + d
                a = object
            ELSE
                object = object + a
                a = ""
            END IF
        END IF
    END IF
    subject = subject + a
omega = LEN(expression)
LOOP

DO
FOR gamma = 1 TO LEN(subject)
    IF MID$(subject, gamma, 1) = "^" THEN
        brak = 0
        uppa = -1
        ignorediv = -1
        FOR tf = gamma TO LEN(subject)
            a = MID$(subject, tf, 1)
            IF a = "(" OR a = "[" THEN
                brak = brak + 1
                ignorediv = 0
            ELSEIF a = ")" OR a = "]" THEN
                IF brak = 0 THEN
                    bend = tf - 1
                    EXIT FOR
                ELSE
                    brak = brak - 1
                    ignorediv = 0
                END IF
            ELSEIF (ignorediv = -1) AND (brak = 0) AND (a = "^" OR a = "[" _
            OR a = "]" OR a = "," OR a = ">" OR a = "<" OR a = "=" OR _
            a = "(" OR a = ")" OR a = "+" OR a = "-" OR a = "*" OR a = "/" _
            OR a = "\" OR a = " " OR a = CHR$(34)) THEN
            ELSEIF (ignorediv = 0) AND (brak = 0) AND (a = "^" OR a = "[" _
            OR a = "]" OR a = "," OR a = ">" OR a = "<" OR a = "=" OR _
            a = "(" OR a = ")" OR a = "+" OR a = "-" OR a = "*" OR a = "/" _
            OR a = "\" OR a = " " OR a = CHR$(34)) THEN
                bend = tf - 1
                EXIT FOR
            ELSE
                ignorediv = 0
            END IF
            bend = tf
        NEXT tf
        ignorediv = -1
        FOR tf = gamma TO 1 STEP -1
            a = MID$(subject, tf, 1)
            IF a = ")" OR a = "]" THEN
                brak = brak + 1
                ignorediv = 0
            ELSEIF a = "(" OR a = "[" THEN
                IF brak = 0 THEN
                    astart = tf + 1
                    EXIT FOR
                ELSE
                    brak = brak - 1
                    ignorediv = 0
                END IF
            ELSEIF (ignorediv = -1) AND (brak = 0) AND (a = "^" OR a = "[" _
            OR a = "]" OR a = "," OR a = ">" OR a = "<" OR a = "=" OR _
            a = "(" OR a = ")" OR a = "+" OR a = "-" OR a = "*" OR a = "/" _
            OR a = "\" OR a = " " OR a = CHR$(34)) THEN
            ELSEIF (ignorediv = 0) AND (brak = 0) AND (a = "^" OR a = "[" _
            OR a = "]" OR a = "," OR a = ">" OR a = "<" OR a = "=" OR _
            a = "(" OR a = ")" OR a = "+" OR a = "-" OR a = "*" OR a = "/" _
            OR a = "\" OR a = " " OR a = CHR$(34)) THEN
                astart = tf + 1
                EXIT FOR
            ELSE
                ignorediv = 0
            END IF
            astart = tf
        NEXT tf
        lef = LEFT$(subject, astart - 1)
        rig = RIGHT$(subject, LEN(subject) - bend)
        alin = MID$(subject, astart, gamma - astart)
        blin = MID$(subject, gamma + 1, bend - gamma)
        subject = RTRIM$(lef) + "Exp(Ln(" + TRIM$(alin) + ") * " + TRIM$(blin) + ")" + LTRIM$(rig)
        EXIT FOR
    END IF
    IF gamma = LEN(subject) THEN uppa = 0
NEXT gamma
LOOP UNTIL uppa = 0

FUNCTION = subject
END FUNCTION

FUNCTION SearchClose (n AS INTEGER, s AS STRING) AS INTEGER
DIM x AS INTEGER
DIM brak AS INTEGER
DIM a AS STRING

IF n = 0 THEN n = 1
FOR x = n TO LEN(s)
    a = MID$(s, x, 1)
    IF a = "(" THEN
        brak = brak + 1
    ELSEIF a = ")" THEN
        IF brak = 0 THEN EXIT FOR
        brak = brak - 1
        IF brak = 0 THEN EXIT FOR
    END IF
NEXT x

FUNCTION = x
END FUNCTION

FUNCTION SearchComma (n AS INTEGER, s AS STRING) AS INTEGER
DIM x AS INTEGER
DIM brak AS INTEGER
DIM a AS STRING

IF n = 0 THEN n = 1
FOR x = n TO LEN(s)
    a = MID$(s, x, 1)
    IF a = "(" THEN
        brak = brak + 1
    ELSEIF a = ")" THEN
        brak = brak - 1
    END IF
    IF a = "," AND brak = 0 THEN
        FUNCTION = x
        EXIT FUNCTION
    END IF
NEXT x

FUNCTION = x
END FUNCTION

FUNCTION SearchObj (n AS INTEGER, s AS STRING, w AS STRING) AS INTEGER
DIM x AS INTEGER
DIM a AS STRING
DIM b AS STRING

IF s = "" THEN
    FUNCTION = 0
    EXIT FUNCTION
END IF
IF w = "" THEN
    FUNCTION = 0
    EXIT FUNCTION
END IF
FOR x = n TO LEN(s)
    a = MID$(s, x, 1)
    IF a = "^" OR a = "[" OR a = "]" OR a = "," OR a = ">" OR a = "<" OR _
    a = "=" OR a = "(" OR a = ")" OR a = "+" OR a = "*" OR a = "/" OR _
    a = "\" OR a = " " OR a = "-" OR a = CHR$(34) THEN
        IF UCASE$(b) = UCASE$(w) THEN
            FUNCTION = x
            EXIT FUNCTION
        ELSE
            b = ""
        END IF
    ELSEIF a = "%" OR a = "&" OR a = "!" OR a = "#" OR a = "$" THEN
        b = b + a
        IF UCASE$(b) = UCASE$(w) THEN
            x = x + 1
            FUNCTION = x
            EXIT FUNCTION
        ELSE
            b = ""
        END IF
    ELSEIF x = LEN(s) THEN
        b = b + a
        IF UCASE$(b) = UCASE$(w) THEN
            x = x + 1
            FUNCTION = x
            EXIT FUNCTION
        ELSE
            FUNCTION = 0
        END IF
    ELSE
        b = b + a
    END IF
NEXT x

END FUNCTION

SUB SearchStat (n AS INTEGER, s AS STRING, z AS STRING, k AS INTEGER)
DIM alpha AS INTEGER
DIM ke AS INTEGER
DIM a AS STRING
DIM state AS STRING

IF n = 0 THEN n = 1
FOR alpha = n TO LEN(s)
    a = MID$(s, alpha, 1)
    IF a = "^" OR a = "[" OR a = "]" OR a = "," OR a = ">" OR a = "<" OR _
    a = "=" OR a = "(" OR a = ")" OR a = "+" OR a = "*" OR a = "/" OR _
    a = "\" OR a = " " OR a = "-" OR a = CHR$(34) THEN
        IF ke THEN EXIT FOR
    ELSEIF a = "%" OR a = "&" OR a = "!" OR a = "#" OR a = "$" THEN
        state = state + a
        alpha = alpha + 1
        EXIT FOR
    ELSE
        state = state + a
        ke = -1
    END IF
NEXT alpha

z = state
k = alpha
END SUB

SUB Split (l AS STRING)
DIM ch AS INTEGER
DIM tf AS INTEGER
DIM pp AS INTEGER
DIM remvar AS INTEGER
DIM basic AS STRING
DIM label AS STRING
DIM a AS STRING

basic = l
IF basic = "" THEN
    PutMain ""
    EXIT SUB
ELSE
    ch = ASC(LEFT$(LTRIM$(basic), 1))
END IF

IF ch > 47 AND ch < 58 THEN
    FOR tf = 1 TO LEN(basic)
        a = MID$(basic, tf, 1)
        IF ASC(a) > 47 AND ASC(a) < 58 THEN
            label = label + a
        ELSE
            EXIT FOR
        END IF
    NEXT tf
    Makelabel label
    basic = LTRIM$(MID$(basic, tf))
    IF BIT(switch, 3) THEN
        IF submaking THEN
            Insmemoproc 12, label + ":"
        ELSE
            memofile(fileptr) = label + ":"
            fileptr = fileptr + 1
        END IF
    ELSE
        PRINT #9, label; ":"
    END IF
    IF basic = "" THEN EXIT SUB
END IF

tf = 0
FOR ch = 1 TO LEN(basic)
    a = MID$(basic, ch, 1)
    IF NOT remvar THEN
        IF a = CHR$(34) THEN tf = tf + 1
        IF a = "'" AND (tf / 2 = tf \ 2) THEN
            pp = pp + 1
            remvar = -1
        END IF
        IF a = ":" AND (tf / 2 = tf \ 2) THEN pp = pp + 1
    END IF
NEXT ch

REDIM lin(pp) AS STRING
tf = 0
pp = 0
remvar = 0

FOR ch = 1 TO LEN(basic)
    a = MID$(basic, ch, 1)
    IF remvar = 1 THEN
        lin(pp) = lin(pp) + a
    ELSE
        IF a = CHR$(34) THEN tf = tf + 1
        IF a = "'" AND (tf / 2 = tf \ 2) THEN
            pp = pp + 1
            lin(pp) = a
            remvar = 1
        END IF
        IF a = ":" AND (tf / 2 = tf \ 2) THEN
            pp = pp + 1
        ELSE
            lin(pp) = lin(pp) + a
        END IF
    END IF
NEXT ch

FOR ch = 0 TO pp
    IF lin(ch) = "" THEN
        PutMain ""
    ELSE
        validline = TRIM$(lin(ch))
        Translate
    END IF
NEXT ch

END SUB

$SEGMENT

SUB SubCreate ()
DIM x AS INTEGER

PutMain "end;"
IF BIT(switch, 3) THEN
    FOR x = 7 TO 12
        procptr(x) = procptr(13)
    NEXT x
ELSE
CLOSE #9
OPEN "PASPROC.TMP" FOR APPEND AS #14
GoCreate "SUBHEAD.TMP"
GoCreate "SUBLABEL.TMP"
GoCreate "SUBCONST.TMP"
GoCreate "SUBTYPE.TMP"
GoCreate "SUBVAR.TMP"
GoCreate "SUBMAIN.TMP"
CLOSE #14
file4 = "PASLABEL.TMP"
file5 = "PASCONST.TMP"
file6 = "PASTYPE.TMP"
file7 = "PASVAR.TMP"
file9 = "PASMAIN.TMP"
file11 = "PASDMVAR.TMP"
file12 = "PASARRAY.TMP"
OPEN "PASMAIN.TMP" FOR APPEND AS #9
END IF

submaking = 0
END SUB

SUB SubMake (n AS INTEGER, f AS INTEGER)
DIM x AS INTEGER
DIM c AS INTEGER

DIM s AS STRING
DIM pasexpr AS STRING
DIM ft AS STRING
DIM funcbody AS STRING

IF submaking THEN
    PutMain "{" + validline + "}"
    EXIT SUB
END IF
c = ASC(UCASE$(LEFT$(LTRIM$(MID$(validline, n + 1)), 1)))
IF c < 65 OR c > 90 THEN
    PutMain "{" + validline + "}"
    EXIT SUB
END IF
submaking = -1
eversub = -1
IF BIT(switch, 3) THEN
ELSE
    CLOSE #9
    OPEN "SUBLABEL.TMP" FOR OUTPUT AS #4: CLOSE #4
    OPEN "SUBCONST.TMP" FOR OUTPUT AS #5: CLOSE #5
    OPEN "SUBTYPE.TMP" FOR OUTPUT AS #6: CLOSE #6
    OPEN "SUBVAR.TMP" FOR OUTPUT AS #7: CLOSE #7
    OPEN "SUBMAIN.TMP" FOR OUTPUT AS #9
    OPEN "SUBDMVAR.TMP" FOR OUTPUT AS #11: CLOSE #11
    OPEN "SUBARRAY.TMP" FOR OUTPUT AS #12: CLOSE #12
    file4 = "SUBLABEL.TMP"
    file5 = "SUBCONST.TMP"
    file6 = "SUBTYPE.TMP"
    file7 = "SUBVAR.TMP"
    file9 = "SUBMAIN.TMP"
    file11 = "SUBDMVAR.TMP"
    file12 = "SUBARRAY.TMP"
END IF
SearchStat n + 1, validline, s, x
pasexpr = LTRIM$(MID$(validline, x))
IF INSTR(pasexpr, "(") THEN
    pasexpr = TRIM$(RTRIM$(LTRIM$(LEFT$(pasexpr, SearchClose(1, pasexpr)), "("), ")"))
    pasexpr = DimCond(pasexpr, 0)
ELSE
    pasexpr = ""
END IF
IF f THEN
IF BIT(switch, 3) THEN
    InsMemoList 2, RTRIM$(s, ANY "%&!#$")
ELSE
    OPEN "SUBDMVAR.TMP" FOR APPEND AS #11
        PRINT #11, RTRIM$(s, ANY "%&!#$")
    CLOSE #11
END IF
    SELECT CASE RIGHT$(s, 1)
        CASE "%": ft = ": integer"
        CASE "&": ft = ": longint"
        CASE "!": ft = ": single"
        CASE "#": ft = ": double"
        CASE "$": ft = ": string"
    CASE ELSE: ft = ": " + defaultvar(ASC(UCASE$(LEFT$(s, 1))) - 65)
    END SELECT
    IF ft = ": single" OR ft = ": double" THEN IsN = -1

IF INSTR(validline, "=") THEN
    expression = LTRIM$(MID$(validline, INSTR(validline, "=") + 1))
    funcbody = Reader
    IF BIT(switch, 3) THEN
        IF pasexpr = "" THEN
            InsMemoProc 8, "function " + s + ft + ";"
        ELSE
            InsMemoProc 8, "function " + s + "(" + pasexpr + ")" + ft + ";"
        END IF
        Insmemoproc 8, "begin"
        Insmemoproc 8, s + " := " + funcbody + ";"
    ELSE
        OPEN "PASPROC.TMP" FOR APPEND AS #8
            IF pasexpr = "" THEN
                PRINT #8, "function "; s; ft; ";"
            ELSE
                PRINT #8, "function "; s; "("; pasexpr; ")"; ft; ";"
            END IF
            PRINT #8, "begin"
            PRINT #8, s; " := "; funcbody; ";"
        CLOSE #8
    END IF
    IF BIT(switch, 3) THEN
    ELSE
        OPEN "SUBHEAD.TMP" FOR OUTPUT AS #2
        CLOSE #2
    END IF
    SubCreate
    EXIT SUB
END IF

    s = "function " + RTRIM$(s, ANY "%&!#$")
ELSE
    ft = ""
    s = "procedure " + s
END IF
PutMain "begin"
IF BIT(switch, 3) THEN
    IF pasexpr = "" THEN
        InsMemoProc 8, s + ft + ";"
    ELSE
        InsMemoProc 8, s + "(" + pasexpr + ")" + ft + ";"
    END IF
ELSE
    OPEN "SUBHEAD.TMP" FOR OUTPUT AS #2
    IF pasexpr = "" THEN
        PRINT #2, s; ft; ";"
    ELSE
        PRINT #2, s; "("; pasexpr; ")"; ft; ";"
    END IF
    CLOSE #2
END IF

END SUB

SUB Translate ()
DIM x AS INTEGER
DIM y AS INTEGER
DIM hi AS INTEGER
DIM lo AS INTEGER
DIM c AS INTEGER
DIM cicc AS INTEGER

DIM a AS STRING
DIM statement AS STRING
DIM pasexpr AS STRING
DIM filnum AS STRING
DIM prompt AS STRING
DIM openmode AS STRING
DIM elsestr AS STRING

SearchStat 1, validline, statement, x

IF typevar THEN

IF statement = "END" THEN
    typevar = 0
    a = "end;"
    SearchStat 4, validline, filnum, x
    IF UCASE$(filnum) = "TYPE" THEN
    ELSE
        PutMain "{" + validline + "}"
    END IF
ELSE
    y = SearchObj(1, UCASE$(validline), "AS")
    SearchStat y, validline, filnum, x
    SELECT CASE UCASE$(filnum)
    CASE "INTEGER": pasexpr = "integer"
    CASE "LONG": pasexpr = "longint"
    CASE "SINGLE": pasexpr = "single"
    CASE "DOUBLE": pasexpr = "double"
    CASE "STRING"
        expression = LTRIM$(MID$(validline, INSTR(validline, "*")))
        pasexpr = "string[" + Reader + "]"
    CASE ELSE
        pasexpr = filnum
    END SELECT
    a = statement + ": " + pasexpr + ";"
END IF

IF BIT(switch, 3) THEN
    IF submaking THEN x = 5 ELSE x = 11
    InsMemoProc x, a
ELSE
    OPEN file6 FOR APPEND AS #6
        PRINT #6, a
    CLOSE #6
END IF

ELSE

SELECT CASE UCASE$(statement)

CASE "?"
    Printer 1

CASE "BEEP"
    MakeUses "Basic"
    PutMain "QBbeep;"

CASE "BLOAD"
    expression = LTRIM$(MID$(validline, 5))
    IF ArgCount(expression) THEN PutMain "QBbload(" + Reader + ");" ELSE _
    PutMain "QBbload(" + Reader + ", -1);"

CASE "BSAVE"
    expression = LTRIM$(MID$(validline, 5))
    PutMain "QBbsave(" + Reader + ");"

CASE "CALL"
    SearchStat 5, validline, filnum, x
    IF UCASE$(filnum) = "ABSOLUTE" THEN
        PutMain "{" + validline + "}"
    ELSE
        expression = MID$(validline, x)
        PutMain filnum + Reader + ";"
    END IF

CASE "CASE"
    IF casevar THEN PutMain "end;"
    IF SearchObj(1, validline, "ELSE") THEN
        PutMain "else"
    ELSE
        expression = LTRIM$(MID$(validline, 5))
        PutMain Reader + ":"
    END IF
    PutMain "begin"
    casevar = -1

CASE "CHAIN"
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, 6))
    PutMain "QBchain(" + Reader + ");"

CASE "CHDIR"
    expression = LTRIM$(MID$(validline, 6))
    PutMain "ChDir(" + Reader + ");"

CASE "CIRCLE"
    MakeUses "Basic"
    IsN = -1
    SearchStat 7, validline, filnum, x
    IF UCASE$(filnum) = "STEP" THEN
        pasexpr = "QBcircle('STEP', "
    ELSE
        pasexpr = "QBcircle('', "
        x = 7
    END IF
    expression = TRIM$(LTRIM$(LTRIM$(MID$(validline, x, SearchClose(x, validline) - x)), "("))
    pasexpr = pasexpr + Reader
    filnum = LTRIM$(LTRIM$(LTRIM$(MID$(validline, SearchClose(1, validline) + 1)), ","))
    FOR x = 1 TO 5
        y = SearchComma(1, filnum)
        expression = RTRIM$(LEFT$(filnum, y - 1))
        filnum = LTRIM$(MID$(filnum, y + 1))
        IF LEN(expression) THEN
            pasexpr = pasexpr + ", " + Reader
        ELSE
            SELECT CASE x
            CASE 1: PutMain "{" + validline + "}"
            CASE 2: pasexpr = pasexpr + ", -1"
            CASE 3: pasexpr = pasexpr + ", 0"
            CASE 4: pasexpr = pasexpr + ", 2 * Pi"
            CASE 5: pasexpr = pasexpr + ", 1"
            END SELECT
        END IF
    NEXT x
    PutMain pasexpr + ");"

CASE "CLEAR"
    IF LEN(validline) = 5 THEN
        MakeUses "Basic"
        PutMain "QBclear;"
    ELSE
        x = SearchComma(1, validline)
        x = SearchComma(x + 1, validline)
        expression = LTRIM$(MID$(validline, x + 1))
        PutMain "{$M " + Reader + ", 0, 655360}"
    END IF

CASE "CLOSE"
    IF LEN(validline) = 5 THEN
        PutMain "{" + validline + "}"
    ELSE
        FOR x = 6 TO LEN(validline)
            a = MID$(validline, x, 1)
            IF a = "," THEN
                pasexpr = TRIM$(LTRIM$(LTRIM$(pasexpr), "#"))
                IF VAL(pasexpr) THEN
                    filnum = "BasFileNum" + _
                    STRING$(2 - LEN(HEX$(VAL(pasexpr))), "0") + _
                    HEX$(VAL(pasexpr))
                    PutMain "Close(" + filnum + ");"
                ELSE
                    PutMain "{" + pasexpr + "}"
                END IF
                pasexpr = ""
            ELSE
                pasexpr = pasexpr + a
            END IF
        NEXT x
        pasexpr = TRIM$(LTRIM$(LTRIM$(pasexpr), "#"))
        IF VAL(pasexpr) THEN
            filnum = "BasFileNum" + _
            STRING$(2 - LEN(HEX$(VAL(pasexpr))), "0") + _
            HEX$(VAL(pasexpr))
            PutMain "Close(" + filnum + ");"
        ELSE
            PutMain "{" + pasexpr + "}"
        END IF
    END IF

CASE "CLS"
    MakeUses "Basic"
    IF LEN(validline) = 3 THEN
        PutMain "QBcls(-1);"
    ELSE
        expression = LTRIM$(MID$(validline, 4))
        PutMain "QBcls(" + Reader + ");"
    END IF

CASE "COLOR"
    MakeUses "Basic"
    IF LEN(validline) = 5 THEN
        PutMain "QBcolor(-1, -1, -1);"
    ELSE
        a = LTRIM$(MID$(validline, 6))
        FOR y = 1 TO 3
            x = SearchComma(1, a)
            expression = RTRIM$(LEFT$(a, x - 1))
            IF LEN(expression) THEN pasexpr = pasexpr + Reader + ", " ELSE pasexpr = pasexpr + "-1, "
            a = LTRIM$(MID$(a, x + 1))
        NEXT y
        pasexpr = RTRIM$(RTRIM$(pasexpr), ",")
        PutMain "QBcolor(" + pasexpr + ");"
    END IF

CASE "COM"
    PutMain "{" + validline + "}"

CASE "COMMON"
    SearchStat 7, validline, filnum, x
    IF UCASE$(filnum) = "SHARED" THEN _
    pasexpr = DimCond(LTRIM$(MID$(validline, x)), -1) ELSE _
    pasexpr = DimCond(LTRIM$(MID$(validline, 7)), -1)

CASE "CONST"
    ConstCond LTRIM$(MID$(validline, 6))

CASE "DATA"
    IF BIT(switch, 3) THEN
        memodata(dataptr) = LTRIM$(MID$(validline, 5))
        dataptr = dataptr + 1
    ELSE
        OPEN "PASDATA.TMP" FOR APPEND AS #10
            PRINT #10, LTRIM$(MID$(validline, 5))
        CLOSE #10
    END IF

CASE "DATE$"
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, INSTR(validline, "=") + 1))
    PutMain "QBdatep(" + Reader + ");"

CASE "DECLARE"
    SearchStat 8, validline, filnum, x
    SearchStat x, validline, filnum, y
    IF BIT(switch, 3) THEN
        InsMemoList 0, RTRIM$(filnum, ANY "%&!#$")
    ELSE
        OPEN "PASDMVAR.TMP" FOR APPEND AS #11
            PRINT #11, RTRIM$(filnum, ANY "%&!#$")
        CLOSE #11
    END IF

CASE "DEF"
    SearchStat 4, validline, filnum, x
    IF UCASE$(filnum) = "SEG" THEN
        MakeUses "Basic"
        IF INSTR(validline, "=") THEN
            expression = LTRIM$(MID$(validline, INSTR(validline, "=") + 1))
            pasexpr = Reader
            PutMain "QBdefseg := " + pasexpr + ";"
        ELSE
            PutMain "QBdefseg := 0;"
        END IF
    ELSEIF UCASE$(LEFT$(filnum, 2)) = "FN" THEN
        SubMake 3, -1
    ELSE
        PutMain "{" + validline + "}"
    END IF

CASE "DEFDBL": DefMake "double"
CASE "DEFINT": DefMake "integer"
CASE "DEFLNG": DefMake "longint"
CASE "DEFSNG": DefMake "single"
CASE "DEFSTR": DefMake "string"

CASE "DIM"
    SearchStat 4, validline, filnum, x
    IF UCASE$(filnum) = "SHARED" THEN _
    pasexpr = DimCond(LTRIM$(MID$(validline, x)), -1) ELSE _
    pasexpr = DimCond(LTRIM$(MID$(validline, 4)), -1)

CASE "DO"
    IF LEN(validline) = 2 THEN
        PutMain "repeat"
    ELSE
        SearchStat 3, UCASE$(validline), filnum, x
        IF UCASE$(filnum) = "WHILE" THEN
            expression = LTRIM$(MID$(validline, x))
            PutMain "while " + Reader + " do"
            PutMain "begin"
        ELSE
            PutMain "{" + validline + "}"
        END IF
    END IF

CASE "DRAW"
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, 5))
    PutMain "QBdraw(" + Reader + ");"

CASE "ELSE"
    IF LEN(validline) = 4 THEN
        PutMain "end"
        PutMain "else"
        PutMain "begin"
    ELSE
        PutMain "end"
        PutMain "else"
        PutMain "begin"
        validline = LTRIM$(MID$(validline, 5))
        Translate
    END IF

CASE "ELSEIF"
    ifstack = ifstack + 1
    x = SearchObj(7, UCASE$(validline), "THEN")
    IF x THEN
        expression = TRIM$(MID$(validline, 7, x - 11))
        PutMain "if " + Reader + " then"
        PutMain "begin"
        IF LEN(validline) >= x THEN
            y = SearchObj(x, UCASE$(validline), "ELSE")
            IF y THEN
                PutMain "{" + validline + "}"
            ELSE
                validline = LTRIM$(MID$(validline, x))
                Translate
            END IF
        END IF
    ELSE
        PutMain "{" + validline + "}"
    END IF

CASE "END"
    IF UCASE$(RIGHT$(validline, 3)) = " IF" THEN
        FOR x = 0 TO ifstack
            PutMain "end;"
        NEXT x
        ifstack = 0
    ELSEIF UCASE$(RIGHT$(validline, 9)) = " FUNCTION" _
    OR UCASE$(RIGHT$(validline, 4)) = " SUB" _
    OR UCASE$(RIGHT$(validline, 4)) = " DEF" THEN
        IF submaking THEN
            SubCreate
        ELSE
            PutMain "{" + validline + "}"
        END IF
    ELSEIF UCASE$(RIGHT$(validline, 7)) = " SELECT" THEN
        PutMain "end;"
        PutMain "end;"
        casevar = 0
    ELSE
        expression = LTRIM$(MID$(validline, 4))
        pasexpr = Reader
        PutMain "Halt(" + pasexpr + ");"
    END IF

CASE "ENVIRON"
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, 8))
    PutMain "QBenviron(" + Reader + ");"

CASE "ERASE"
    PutMain "{" + validline + "}"

CASE "ERROR"
    IsN = -1
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, 6))
    PutMain "QBerror(" + Reader + ");"

CASE "EXIT"
    SearchStat 5, validline, filnum, x
    SELECT CASE UCASE$(filnum)
    CASE "DO", "FOR": PutMain "Break;"
    CASE "DEF", "SUB", "FUNCTION": PutMain "Exit;"
    CASE ELSE
        PutMain "{" + validline + "}"
    END SELECT

CASE "FIELD"
    PutMain "{" + validline + "}"

CASE "FILES"
    MakeUses "Basic"
    IF LEN(validline) = 5 THEN
        PutMain "QBfiles('*.*');"
    ELSE
        expression = LTRIM$(MID$(validline, 6))
        PutMain "QBfiles(" + Reader + ");"
    END IF

CASE "FOR"
    x = INSTR(validline, "=")
    IF x = 0 THEN x = 4
    expression = TRIM$(MID$(validline, 4, x - 4))
    pasexpr = Reader
    y = SearchObj(4, UCASE$(validline), "TO")
    IF y = 0 THEN y = 8
    expression = TRIM$(MID$(validline, x + 1, y - x - 3))
    a = Reader
    x = SearchObj(y, UCASE$(validline), "STEP")
    IF x THEN
        expression = TRIM$(MID$(validline, y, x - y - 4))
        openmode = Reader
        filnum = MID$(validline, x)
        REPLACE " " WITH "" IN filnum
        IF filnum = "-1" THEN
            PutMain "for " + pasexpr + " := " + a + " downto " + openmode + " do"
            PutMain "begin"
        ELSE
            expression = LTRIM$(MID$(validline, x))
            filnum = Reader
            PutMain "while Abs(" + pasexpr + " - " + openmode + ") >= 0 do"
            PutMain "begin"
            PutMain pasexpr + " := " + pasexpr + " + " + filnum + ";"
        END IF
    ELSE
        expression = LTRIM$(MID$(validline, y))
        PutMain "for " + pasexpr + " := " + a + " to " + Reader + " do"
        PutMain "begin"
    END IF

CASE "FUNCTION"
    SubMake 8, -1

CASE "GET"
    Block "BlockRead"

CASE "GOSUB"
    PutMain "{" + validline + "}"

CASE "GOTO"
    MakeLabel LTRIM$(MID$(validline, 5))
    PutMain "goto " + LTRIM$(MID$(validline, 5)) + ";"

CASE "IF"
    x = SearchObj(3, UCASE$(validline), "THEN")
    IF x THEN
        expression = TRIM$(MID$(validline, 3, x - 7))
        PutMain "if " + Reader + " then"
        PutMain "begin"
        IF LEN(validline) >= x THEN
            y = SearchObj(x, UCASE$(validline), "ELSE")
            IF y THEN
                elsestr = LTRIM$(MID$(validline, y))
                validline = TRIM$(MID$(validline, x, y - x - 4))
                FOR c = 1 TO LEN(validline)
                    a = MID$(validline, c, 1)
                    IF ASC(a) > 47 OR ASC(a) < 58 THEN cicc = -1
                NEXT c
                IF cicc THEN
                    Translate
                ELSE
                    MakeLabel validline
                    PutMain "goto " + validline + ";"
                END IF
                PutMain "end"
                PutMain "else"
                PutMain "begin"
                validline = elsestr
                cicc = 0
                FOR c = 1 TO LEN(validline)
                    a = MID$(validline, c, 1)
                    IF ASC(a) > 47 OR ASC(a) < 58 THEN cicc = -1
                NEXT c
                IF cicc THEN
                    Translate
                ELSE
                    MakeLabel validline
                    PutMain "goto " + validline + ";"
                END IF
                PutMain "end;"
            ELSE
                validline = LTRIM$(MID$(validline, x))
                FOR c = 1 TO LEN(validline)
                    a = MID$(validline, c, 1)
                    IF ASC(a) > 47 OR ASC(a) < 58 THEN cicc = -1
                NEXT c
                IF cicc THEN
                    Translate
                ELSE
                    MakeLabel validline
                    PutMain "goto " + validline + ";"
                END IF
                PutMain "end;"
            END IF
        END IF
    ELSE
        PutMain "{" + validline + "}"
    END IF

CASE "INPUT"
    a = LTRIM$(MID$(validline, 6))
    IF LEFT$(a, 1) = ";" THEN
        a = LTRIM$(LTRIM$(a, ";"))
        pasexpr = "Read("
    ELSE
        pasexpr = "ReadLn("
    END IF
    SELECT CASE LEFT$(a, 1)
    CASE CHR$(34)
        prompt = MID$(a, 2, INSTR(2, a, CHR$(34)) - 2)
        a = MID$(a, INSTR(2, a, CHR$(34)) + 1)
        IF LEFT$(a, 1) = ";" THEN
            prompt = prompt + "?"
        ELSEIF LEFT$(a, 1) = "," THEN
        ELSE
            PutMain "{" + validline + "}"
        END IF
        expression = LTRIM$(LTRIM$(a, ANY ";,"))
    CASE "#"
        filnum = TRIM$(MID$(a, 2, SearchComma(1, a) - 2))
        filnum = "BasFileNum" + STRING$(2 - LEN(HEX$(VAL(filnum))), "0") + HEX$(VAL(filnum)) + ", "
        expression = LTRIM$(MID$(a, SearchComma(1, a) + 1))
    CASE ELSE
        prompt = "?"
        expression = a
    END SELECT
    IF LEN(prompt) THEN PutMain "Write('" + prompt + "');"
    PutMain pasexpr + filnum + Reader + ");"

CASE "IOCTL"
    PutMain "{" + validline + "}"

CASE "KEY"
    PutMain "{" + validline + "}"

CASE "KILL"
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, 5))
    PutMain "QBkill(" + Reader + ");"

CASE "LET"
    validline = LTRIM$(MID$(validline, 4))
    Translate

CASE "LINE"
    SearchStat 5, validline, filnum, x
    SELECT CASE UCASE$(filnum)
    CASE "INPUT"
        validline = LTRIM$(MID$(validline, 5))
        Translate
        EXIT SUB
    CASE "STEP": pasexpr = "QBline('STEP', "
    CASE ELSE
        pasexpr = "QBline('', "
        x = 5
    END SELECT
    IsN = -1
    MakeUses "Basic"
    a = LTRIM$(MID$(validline, x))
    y = SearchClose(1, a)
    expression = TRIM$(LTRIM$(LEFT$(a, y - 1), "("))
    pasexpr = pasexpr + Reader + ", "
    SearchStat y + 1, a, filnum, x
    IF UCASE$(filnum) = "STEP" THEN
        pasexpr = pasexpr + "'STEP', "
    ELSE
        pasexpr = pasexpr + "'', "
        x = INSTR(y + 1, a, "-") + 1
    END IF
    a = LTRIM$(MID$(a, x))
    y = SearchClose(1, a)
    expression = TRIM$(LTRIM$(LEFT$(a, y - 1), "("))
    pasexpr = pasexpr + Reader
    a = LTRIM$(LTRIM$(LTRIM$(MID$(a, y + 1)), ","))
    FOR x = 1 TO 3
        y = SearchComma(1, a)
        expression = RTRIM$(LEFT$(a, y - 1))
        a = LTRIM$(MID$(a, y + 1))
        SELECT CASE x
        CASE 1
            IF LEN(expression) THEN pasexpr = pasexpr + ", " + Reader _
            ELSE pasexpr = pasexpr + ", -1"
        CASE 2
            IF LEN(expression) THEN pasexpr = pasexpr + ", '" + expression + "'" _
            ELSE pasexpr = pasexpr + ", ''"
        CASE 3
            IF LEN(expression) THEN pasexpr = pasexpr + ", " + Reader _
            ELSE pasexpr = pasexpr + ", -1"
        END SELECT
    NEXT x
    PutMain pasexpr + ");"

CASE "LOCATE"
    IF LEN(validline) = 6 THEN
        PutMain "{" + validline + "}"
    ELSE
        y = SearchComma(7, validline)
        y = SearchComma(y + 1, validline)
        IF MID$(validline, y, 1) = "," THEN
            IsN = -1
            MakeUses "Basic"
            a = LTRIM$(MID$(validline, 7))
            FOR y = 1 TO 5
                x = SearchComma(1, a)
                expression = RTRIM$(LEFT$(a, x - 1))
                IF LEN(expression) THEN pasexpr = pasexpr + Reader + ", " ELSE pasexpr = pasexpr + "-1, "
                a = LTRIM$(MID$(a, x + 1))
            NEXT y
            pasexpr = RTRIM$(RTRIM$(pasexpr), ",")
            PutMain "QBlocate(" + pasexpr + ");"
        ELSE
            MakeUses "Crt"
            y = SearchComma(7, validline)
            expression = TRIM$(MID$(validline, 7, y - 7))
            pasexpr = Reader
            expression = LTRIM$(MID$(validline, y + 1))
            PutMain "GotoXY(" + Reader + ", " + pasexpr + ");"
        END IF
    END IF

CASE "LOCK"
    PutMain "{" + validline + "}"

CASE "LOOP"
    IF LEN(validline) = 4 THEN
        PutMain "end;"
    ELSE
        SearchStat 5, validline, filnum, x
        IF UCASE$(filnum) = "UNTIL" THEN
            expression = LTRIM$(MID$(validline, x))
            PutMain "until " + Reader + ";"
        ELSE
            PutMain "{" + validline + "}"
        END IF
    END IF

CASE "LPRINT"
    IF RIGHT$(validline, 1) = ";" THEN x = -1
    MakeUses "Printer"
    expression = LTRIM$(MID$(validline, 7))
    REPLACE ";" WITH "," IN expression
    IF x THEN PutMain "Write(Lst, " + Reader + ");" ELSE PutMain "WriteLn(Lst, " + Reader + ");"

CASE "LSET"
    PutMain "{" + validline + "}"

CASE "MID$"
    IsN = -1
    MakeUses "Basic"
    x = SearchClose(5, validline)
    expression = LTRIM$(LTRIM$(TRIM$(MID$(validline, 5, x - 5)), "("))
    SELECT CASE ArgCount(expression)
    CASE 1: pasexpr = "QBmidp(" + Reader + ", -1, "
    CASE 2: pasexpr = "QBmidp(" + Reader + ", "
    CASE ELSE
        PutMain "{" + validline + "}"
    END SELECT
    expression = LTRIM$(MID$(validline, INSTR(x, validline, "=") + 1))
    PutMain pasexpr + Reader + ");"

CASE "MKDIR"
    expression = LTRIM$(MID$(validline, 6))
    PutMain "MkDir(" + Reader + ");"

CASE "NAME"
    y = SearchObj(5, UCASE$(validline), "AS")
    expression = TRIM$(MID$(validline, x, y - x - 2))
    pasexpr = Reader
    expression = LTRIM$(MID$(validline, y))
    PutMain "QBname(" + pasexpr + ", " + Reader + ");"

CASE "NEXT"
    PutMain "end;"

CASE "ON"
    PutMain "{" + validline + "}"

CASE "OPEN"
    x = SearchObj(1, UCASE$(validline), "AS")
    IF x THEN
        y = SearchObj(x, UCASE$(validline), "LEN")
        IF y THEN
            filnum = LTRIM$(LTRIM$(TRIM$(MID$(validline, x, y - x - 3)), "#"))
            expression = LTRIM$(MID$(validline, y))
            a = ", " + Reader
        ELSE
            filnum = LTRIM$(LTRIM$(LTRIM$(MID$(validline, x)), "#"))
        END IF
        IF VAL(filnum) THEN
            filnum = "BasFileNum" + STRING$(2 - LEN(HEX$(VAL(filnum))), "0") + HEX$(VAL(filnum))
        ELSE
            PutMain "{" + validline + "}"
        END IF
        y = SearchObj(5, UCASE$(validline), "FOR")
        IF y THEN
            IF SearchObj(y, UCASE$(validline), "APPEND") THEN
                openmode = "A"
                prompt = "text"
            ELSEIF SearchObj(y, UCASE$(validline), "BINARY") THEN
                openmode = "B"
                prompt = "file"
            ELSEIF SearchObj(y, UCASE$(validline), "INPUT") THEN
                openmode = "I"
                prompt = "text"
            ELSEIF SearchObj(y, UCASE$(validline), "OUTPUT") THEN
                openmode = "O"
                prompt = "text"
            ELSEIF SearchObj(y, UCASE$(validline), "RANDOM") THEN
                openmode = "R"
                prompt = "file"
            ELSE
                PutMain "{" + validline + "}"
                openmode = "D"
                prompt = "file"
            END IF
            expression = TRIM$(MID$(validline, 5, y - 8))
            pasexpr = Reader
        ELSE
            openmode = "R"
            expression = TRIM$(MID$(validline, 5, x - 8))
            pasexpr = Reader
            prompt = "file"
        END IF
    ELSE
        a = LTRIM$(MID$(validline, 5))
        y = SearchComma(1, a)
        openmode = RTRIM$(LEFT$(a, y - 1))
        a = LTRIM$(MID$(a, y + 1))
        IF RIGHT$(openmode, 1) = CHR$(34) THEN
            openmode = UCASE$(MID$(openmode, 2, 1))
        ELSE
            openmode = "R"
            PutMain "{" + validline + "}"
        END IF
        SELECT CASE openmode
        CASE "A": prompt = "text"
        CASE "B": prompt = "file"
        CASE "I": prompt = "text"
        CASE "O": prompt = "text"
        CASE "R": prompt = "file"
        END SELECT
        y = SearchComma(1, a)
        filnum = LTRIM$(LTRIM$(RTRIM$(LEFT$(a, y - 1)), "#"))
        a = LTRIM$(MID$(a, y + 1))
        IF VAL(filnum) THEN
            filnum = "BasFileNum" + STRING$(2 - LEN(HEX$(VAL(filnum))), "0") + HEX$(VAL(filnum))
        ELSE
            PutMain "{" + validline + "}"
        END IF
        y = SearchComma(1, a)
        IF y THEN
            expression = RTRIM$(LEFT$(a, y - 1))
            pasexpr = Reader
            expression = LTRIM$(MID$(a, y + 1))
            a = ", " + Reader
        ELSE
            expression = a
            pasexpr = Reader
        END IF
    END IF
    Varias filnum, prompt
    SELECT CASE openmode
    CASE "A"
        PutMain "Assign(" + filnum + ", " + pasexpr + ");"
        PutMain "Append(" + filnum + ");"
    CASE "B"
        PutMain "Assign(" + filnum + ", " + pasexpr + ");"
        PutMain "Reset(" + filnum + ");"
    CASE "I"
        PutMain "Assign(" + filnum + ", " + pasexpr + ");"
        PutMain "Reset(" + filnum + ");"
    CASE "O"
        PutMain "Assign(" + filnum + ", " + pasexpr + ");"
        PutMain "ReWrite(" + filnum + ");"
    CASE "R"
        PutMain "Assign(" + filnum + ", " + pasexpr + ");"
        PutMain "Reset(" + filnum + a + ");"
    CASE ELSE
        PutMain "{" + validline + "}"
    END SELECT

CASE "OPTION"
    SearchStat 7, validline, filnum, x
    IF UCASE$(filnum) = "BASE" THEN
        pasexpr = LTRIM$(MID$(validline, x))
        SELECT CASE pasexpr
        CASE "0": optionbase = 0
        CASE "1": optionbase = 1
        CASE ELSE
            PutMain "{" + validline + "}"
        END SELECT
    ELSE
        PutMain "{" + validline + "}"
    END IF

CASE "OUT"
    x = SearchComma(4, validline)
    expression = TRIM$(MID$(validline, 4, x - 4))
    pasexpr = Reader
    expression = LTRIM$(MID$(validline, x + 1))
    PutMain "Port[" + pasexpr + "] := " + Reader + ";"

CASE "PAINT"
    IsN = -1
    MakeUses "Basic"
    SearchStat 6, validline, filnum, x
    IF UCASE$(filnum) = "STEP" THEN
        pasexpr = "QBpaint('STEP', "
    ELSE
        pasexpr = "QBpaint('', "
        x = 6
    END IF
    y = SearchClose(x, validline)
    expression = LTRIM$(LTRIM$(TRIM$(MID$(validline, x, y - x)), "("))
    pasexpr = pasexpr + Reader
    a = LTRIM$(LTRIM$(LTRIM$(MID$(validline, y + 1)), ","))
    y = 0
    FOR x = 1 TO 3
        y = SearchComma(y + 1, a)
        expression = RTRIM$(LEFT$(a, y - 1))
        a = LTRIM$(MID$(a, y + 1))
        SELECT CASE x
        CASE 1
            IF LEN(expression) THEN pasexpr = pasexpr + ", " + Reader _
            ELSE pasexpr = pasexpr + ", -1"
        CASE 2
            IF LEN(expression) THEN pasexpr = pasexpr + ", " + expression _
            ELSE pasexpr = pasexpr + ", -1"
        CASE 3
            IF LEN(expression) THEN pasexpr = pasexpr + ", " + Reader _
            ELSE pasexpr = pasexpr + ", -1"
        END SELECT
    NEXT x
    PutMain pasexpr + ");"

CASE "PALETTE"
    IF LEN(validline) = 7 THEN
        PutMain "{" + validline + "}"
    ELSE
        MakeUses "Graph"
        expression = LTRIM$(MID$(validline, 8))
        PutMain "SetPalette(" + Reader + ");"
    END IF

CASE "PCOPY"
    IsN = -1
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, 6))
    PutMain "QBpcopy(" + Reader + ");"

CASE "PEN"
    PutMain "{" + validline + "}"

CASE "PLAY"
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, 5))
    PutMain "QBplay(" + Reader + ");"

CASE "POKE"
    MakeUses "Basic"
    x = SearchComma(5, validline)
    expression = TRIM$(MID$(validline, 5, x - 5))
    pasexpr = Reader
    expression = LTRIM$(MID$(validline, x + 1))
    PutMain "Mem[QBdefseg: " + pasexpr + "] := " + Reader + ";"

CASE "PRESET"
    PutPixel 7

CASE "PRINT"
    Printer 5

CASE "PSET"
    PutPixel 5

CASE "PUT"
    Block "BlockWrite"

CASE "RANDOMIZE"
    IF LEN(validline) THEN
        PutMain "Write('Random-number seed (-32768 to 32767)? ');"
        PutMain "ReadLn(RandSeed);"
    ELSE
        SearchStat 10, validline, filnum, x
        IF UCASE$(filnum) = "TIMER" AND x = LEN(validline) - 1 THEN
            PutMain "Randomize;"
        ELSE
            IsN = -1
            MakeUses "Basic"
            expression = LTRIM$(MID$(validline, 10))
            PutMain "QBrandomize(" + Reader + ");"
        END IF
    END IF

CASE "READ"
    PutMain "{" + validline + "}"

CASE "REDIM"
    SearchStat 6, validline, filnum, x
    IF UCASE$(filnum) = "SHARED" THEN _
    pasexpr = DimCond(LTRIM$(MID$(validline, x)), -1) ELSE _
    pasexpr = DimCond(LTRIM$(MID$(validline, 6)), -1)

CASE "REM"
    pasexpr = LTRIM$(MID$(validline, 4))
    IF LEFT$(pasexpr, 1) = "$" THEN
        PutMain "{{" + pasexpr + "}"
        IF SearchObj(1, UCASE$(validline), "$DYNAMIC") THEN
            PutMain "{" + validline + "}"
        ELSEIF SearchObj(1, UCASE$(validline), "$STATIC") THEN
            PutMain "{" + validline + "}"
        ELSE
            PutMain "{" + validline + "}"
        END IF
    ELSE
        PutMain "{" + pasexpr + "}"
    END IF

CASE "RESET"
    PutMain "{" + validline + "}"

CASE "RESTORE"
    PutMain "{" + validline + "}"

CASE "RESUME"
    PutMain "{" + validline + "}"

CASE "RETURN"
    PutMain "{" + validline + "}"

CASE "RMDIR"
    expression = LTRIM$(MID$(validline, 6))
    PutMain "RmDir(" + Reader + ");"

CASE "RSET"
    PutMain "{" + validline + "}"

CASE "RUN"
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, 4))
    PutMain "QBrun(" + Reader + ");"

CASE "SCREEN"
    IsN = -1
    MakeUses "Basic"
    IF LEN(validline) = 6 THEN
        PutMain "QBscreenp(-1, -1, -1, -1);"
    ELSE
        a = LTRIM$(MID$(validline, 7))
        FOR y = 1 TO 4
            x = SearchComma(1, a)
            expression = RTRIM$(LEFT$(a, x - 1))
            IF LEN(expression) THEN pasexpr = pasexpr + Reader + ", " ELSE pasexpr = pasexpr + "-1, "
            a = LTRIM$(MID$(a, x + 1))
        NEXT y
        pasexpr = RTRIM$(RTRIM$(pasexpr), ",")
        PutMain "QBscreenp(" + pasexpr + ");"
    END IF

CASE "SEEK"
    expression = LTRIM$(MID$(validline, 5))
    IF LEFT$(expression, 1) = "#" THEN
        filnum = TRIM$(LTRIM$(LEFT$(expression, INSTR(expression, ",") - 1), "#"))
        filnum = "BasFileNum" + STRING$(2 - LEN(HEX$(VAL(filnum))), _
        "0") + HEX$(VAL(filnum))
        expression = LTRIM$(MID$(expression, INSTR(expression, ",") + 1))
        PutMain "Seek(" + filnum + ", " + Reader + ");"
    ELSE
        PutMain "{" + validline + "}"
    END IF

CASE "SELECT"
    expression = LTRIM$(MID$(validline, SearchObj(1, UCASE$(validline), "CASE")))
    pasexpr = Reader
    PutMain "case " + pasexpr + " of"

CASE "SHARED"
    PutMain "{" + validline + "}"

CASE "SHELL"
    MakeUses "Basic"
    IF LEN(validline) = 5 THEN
        PutMain "QBshell('');"
    ELSE
        expression = LTRIM$(MID$(validline, 6))
    END IF
    PutMain "QBshell(" + Reader + ");"

CASE "SLEEP"
    IsN = -1
    MakeUses "Basic"
    IF LEN(validline) = 5 THEN
        PutMain "QBsleep(-1);"
    ELSE
        expression = LTRIM$(MID$(validline, 6))
    END IF
    PutMain "QBsleep(" + Reader + ");"

CASE "SOUND"
    IsN = -1
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, 6))
    PutMain "QBsound(" + Reader + ");"

CASE "STATIC"
    PutMain "{" + validline + "}"

CASE "STOP"
    PutMain "Halt;"

CASE "STRIG"
    PutMain "{" + validline + "}"

CASE "SWAP"
    IsN = -1
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, 5))
    PutMain "QBswap(" + Reader + ");"

CASE "SYSTEM"
    PutMain "Halt;"

CASE "SUB"
    SubMake 3, 0

CASE "TIME$"
    MakeUses "Basic"
    expression = LTRIM$(MID$(validline, INSTR(validline, "=") + 1))
    PutMain "QBtimep(" + Reader + ");"

CASE "TIMER"
    PutMain "{" + validline + "}"

CASE "TROFF"
    PutMain "{" + validline + "}"

CASE "TRON"
    PutMain "{" + validline + "}"

CASE "TYPE"
    typevar = -1
    SearchStat 5, validline, filnum, x
    a = "type " + filnum + " = record"
    IF BIT(switch, 3) THEN
        IF submaking THEN x = 5 ELSE x = 11
        InsMemoProc x, a
    ELSE
        OPEN file6 FOR APPEND AS #6
            PRINT #6, a
        CLOSE #6
    END IF

CASE "UNLOCK"
    PutMain "{" + validline + "}"

CASE "VIEW"
    IsN = -1
    MakeUses "Basic"
    IF LEN(validline) = 4 THEN
        MakeUses "Graph"
        PutMain "QBview('', 0, 0, GetMaxX, GetMaxY, -1, -1);"
    ELSE
        SearchStat 5, validline, filnum, x
        SELECT CASE UCASE$(filnum)
        CASE "PRINT"
            y = SearchObj(x, UCASE$(validline), "TO")
            expression = TRIM$(MID$(validline, x, y - x - 2))
            pasexpr = Reader
            expression = LTRIM$(MID$(validline, y))
            PutMain "QBviewprint(" + pasexpr + ", " + Reader + ");"
            EXIT SUB
        CASE "SCREEN"
            pasexpr = "QBview('SCREEN', "
        CASE ELSE
            pasexpr = "QBview('', "
            x = 5
        END SELECT
        a = LTRIM$(MID$(validline, x - 1))
        x = SearchClose(1, a)
        expression = TRIM$(LTRIM$(LEFT$(a, x - 1), "("))
        pasexpr = pasexpr + Reader + ", "
        a = LTRIM$(MID$(a, INSTR(x, a, "(") + 1))
        x = SearchClose(1, a)
        expression = RTRIM$(LEFT$(a, x - 1))
        pasexpr = pasexpr + Reader
        a = MID$(a, x + 1)
        FOR x = 1 TO 2
            y = SearchComma(1, a)
            expression = RTRIM$(LEFT$(a, y - 1))
            a = LTRIM$(MID$(a, y + 1))
            SELECT CASE x
            CASE 1
                IF LEN(expression) THEN pasexpr = pasexpr + ", " + Reader _
                ELSE pasexpr = pasexpr + ", -1"
            CASE 2
                IF LEN(expression) THEN pasexpr = pasexpr + ", " + Reader _
                ELSE pasexpr = pasexpr + ", -1"
            END SELECT
        NEXT x
        PutMain pasexpr + ");"
    END IF

CASE "WEND"
    PutMain "end;"

CASE "WHILE"
    expression = LTRIM$(MID$(validline, 6))
    PutMain "while " + Reader + " do"
    PutMain "begin"

CASE "WIDTH"
    PutMain "{" + validline + "}"

CASE "WINDOW"
    IsN = -1
    MakeUses "Basic"
    IF LEN(validline) = 6 THEN
        PutMain "QBwindow('DISABLE', 0, 0, 0, 0);"
    ELSE
        SearchStat 7, validline, filnum, x
        IF UCASE$(filnum) = "SCREEN" THEN
            pasexpr = "QBwindow('SCREEN', "
        ELSE
            pasexpr = "QBwindow('', "
            x = 7
        END IF
        a = LTRIM$(MID$(validline, x))
        x = SearchClose(1, a)
        expression = TRIM$(LTRIM$(LEFT$(a, x - 1), "("))
        pasexpr = pasexpr + Reader + ", "
        expression = TRIM$(RTRIM$(MID$(a, INSTR(x, a, "(") + 1), ")"))
        PutMain pasexpr + Reader + ");"
    END IF

CASE "WRITE"
    Printer 6

CASE ELSE

    IF LEFT$(statement, 1) = "'" THEN
        pasexpr = LTRIM$(MID$(validline, 3))
        IF LEFT$(pasexpr, 1) = "$" THEN
            PutMain "{{" + pasexpr + "}"
            IF SearchObj(1, UCASE$(pasexpr), "$DYNAMIC") THEN
                PutMain "{" + validline + "}"
            ELSEIF SearchObj(1, UCASE$(pasexpr), "$STATIC") THEN
                PutMain "{" + validline + "}"
            ELSE
                PutMain "{" + validline + "}"
            END IF
        ELSE
            PutMain "{" + pasexpr + "}"
        END IF
    ELSEIF LEN(validline) = LEN(statement) THEN

    IF BIT(switch, 3) THEN
        IF submaking THEN
            FOR x = listptr(1) TO listptr(2) - 1
                IF UCASE$(memolist(x)) = UCASE$(RTRIM$(statement, ANY "%&!#$")) THEN
                    y = -1
                    EXIT FOR
                END IF
            NEXT x
        ELSE
            FOR x = 0 TO listptr(0) - 1
                IF UCASE$(memolist(x)) = UCASE$(RTRIM$(statement, ANY "%&!#$")) THEN
                    y = -1
                    EXIT FOR
                END IF
            NEXT x
        END IF
    ELSE
        OPEN file11 FOR INPUT AS #11
        DO UNTIL EOF(11)
            INPUT #11, a
            IF UCASE$(RTRIM$(statement, ANY "%&!#$")) = UCASE$(a) THEN
                y = -1
                EXIT DO
            END IF
        LOOP
        CLOSE #11
    END IF
    IF NOT y THEN MakeLabel statement
    PutMain statement + ":"

    ELSEIF LEFT$(LTRIM$(MID$(validline, x)), 1) = "=" THEN
        expression = statement
        pasexpr = Reader
        expression = LTRIM$(MID$(validline, INSTR(validline, "=") + 1))
        PutMain pasexpr + " := " + Reader + ";"
    ELSEIF LEFT$(LTRIM$(MID$(validline, x)), 1) = "(" THEN
        a = LTRIM$(MID$(validline, x))
        x = SearchClose(1, a)
        IF LEFT$(LTRIM$(MID$(a, x + 1)), 1) = "=" THEN
            expression = statement + LEFT$(a, x)
            pasexpr = Reader
            expression = LTRIM$(MID$(validline, INSTR(validline, "=") + 1))
            PutMain pasexpr + " := " + Reader + ";"
        END IF
    ELSE
        expression = LTRIM$(MID$(validline, x))
        PutMain statement + "(" + Reader + ");"
    END IF

END SELECT

END IF

END SUB

SUB Varias (s AS STRING, v AS STRING)
DIM n AS INTEGER
DIM m AS INTEGER
DIM z AS STRING
DIM vt AS STRING

IF v = "" THEN

SELECT CASE RIGHT$(s, 1)
CASE "%": vt = "integer"
CASE "&": vt = "longint"
CASE "!": vt = "single"
CASE "#": vt = "double"
CASE "$": vt = "string"
CASE ELSE
    vt = defaultvar(ASC(UCASE$(LEFT$(LTRIM$(s), 1))) - 65)
END SELECT
IF vt = "single" OR vt = "double" THEN IsN = -1
IF vt = "string" THEN z = "''" ELSE z = "0"

ELSE
    vt = v
END IF
s = RTRIM$(s, ANY "%&!#$")

IF BIT(switch, 3) THEN
    IF submaking THEN
        n = 2
        m = 12
    ELSE
        n = 0
        m = 6
    END IF
    Insmemolist n, s
    IF procptr(m - 1) = procptr(m) THEN
        Insmemoproc m, "var"
        Insmemoproc m, "   " + s + ": " + vt + ";"
    ELSE
        Insmemoproc m, "   " + s + ": " + vt + ";"
    END IF
ELSE

OPEN file11 FOR APPEND AS #11
    PRINT #11, s
CLOSE #11
OPEN file7 FOR APPEND AS #7
    IF LOF(7) = 0 THEN
        PRINT #7, "var"
        PRINT #7, "   "; s; ": "; vt; ";"
    ELSE
        PRINT #7, "   "; s; ": "; vt; ";"
    END IF
CLOSE #7

END IF

IF v = "" AND BIT(switch, 7) THEN PutMain s + " := " + z + ";"
END SUB