/*
	Copyright (C) 2004 Jonas Lindholm

	This software was developed by Jonas Lindholm, jlhm@usa.net

	History

	V1.0		Jonas Lindholm	2004-05-14

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <string.h>
#include <stdlib.h>

#include <starlet.h>
#include <ssdef.h>
#include <stsdef.h>
#include <psldef.h>
#include <prcdef.h>
#include <jpidef.h>
#include <descrip.h>


#include "lgi.h"
#include "lgildap.h"
#include "private.h"


/*
	Description:

	This routine allocate private storage and initialize communication with the LGI LDAP Server.
	If the LGI LDAP Server is unreachable (e.g. not running) the flag dolocal is set if
	logical name LGI_LDAP_ALLOW_LOCAL_AUTH is defined.
	Without that logical name login verified against local SYSUAF is allowed only for users
	with SYSPRV.

	INPUT:		LGI argument vector
			pointer to private data

	OUTPUT:		pointer to private data is initialized with allocated memory.
			LGI$_SKIPRELATED is returned if LGI LDAP Server us reachable
			SS$_NORMAL is retuned for everything else.
*/

int cb_init(struct LGI$ARG_VECTOR *av, CTX_T **ctx) {

        if (!(*av->LGI$A_ICR_CREPRC_FLAGS & PRC$M_INTER) &&
            !(*av->LGI$A_ICR_CREPRC_FLAGS & PRC$M_NETWRK)) return(SS$_NORMAL);  /* Not interactive nor network, do normal processing */

        if (*av->LGI$A_ICR_CREPRC_FLAGS & PRC$M_NOPASSWORD) return(SS$_NORMAL);  /* Invoked as logged in, don't prompt */

        if (*av->LGI$A_ICR_SUBPROCESS != 0) return(SS$_NORMAL);  /* Don't prompt on subprocesses */

	*ctx = NULL;

	if ((*ctx = (CTX_T  *)malloc(sizeof(CTX_T))) != NULL) {
		char		dummy[256];

		memset(*ctx, 0, sizeof(CTX_T));
		(*ctx)->flags.localauthok = $VMS_STATUS_SUCCESS(do_trnlnm("LGI_LDAP_ALLOW_LOCAL_AUTH", dummy, sizeof(dummy) - 1, PSL$C_EXEC));

		if ($VMS_STATUS_SUCCESS(ipc_init(&((*ctx)->hndl)))) {
			LGI_IPC_MSG		lim;

			lim.cmd = IPC_CMD_INIT;
                        if ($VMS_STATUS_SUCCESS(ipc_command((*ctx)->hndl, &lim))) {

		 		return LGI$_SKIPRELATED;

			}
		}

		(*ctx)->flags.dolocal = (*ctx)->flags.localauthok;
	} 

	return SS$_NORMAL;
}
