/*
	Copyright (C) 2004 Jonas Lindholm

	This software was developed by Jonas Lindholm, jlhm@usa.net

	History

	V1.0		Jonas Lindholm	2004-05-14


	This program add LDAP authentication to OpenVMS LOGINOUT.EXE
	It is using the external LOGINOUT callback, LGI, to implement
	password verification against a LDAP server with posix accounts.

	You compile it with:

		cc lgildap.c

	You link it with:

		link/share=sys$common[syslib]lgildap.exe,sys$input/options
		lgildap.obj
		symbol_vector=(LGI$LOGINOUT_CALLOUTS=DATA)
		<ctrl-Z>

	You must install this program with INSTALL ADD SYS$SHARE:LGILDAP.EXE
	You also must install the LDAP$SHR.EXE in the same way. There should be no
	security problem with this as long you only install it as share and/or open.

	You must define the following logical name:

		define/system/executive	lgi$loginout_callouts	lgildap

	Finally you enable the callouts in SYSGEN:

		SYSGEN> set LGI_CALLOUTS 1

	If you also want LDAP verifications for DEcnet logins:

		SYSGEN> set NET_CALLOUTS 255

	Finally you active it:

		SYSGEN> write active

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "lgi.h"
#include "lgildap.h"
#include "private.h"


globaldef struct LGI$CALLOUT_VECTOR LGI$LOGINOUT_CALLOUTS =
                {
                9,
                cb_init,		/* init */
                0,			/* iact_start */
                0,			/* decwinit */
                cb_identify,		/* identify */
                cb_authenticate,	/* authenticate */
                0,			/* chkrestrict */
                0,			/* finish */
           	0,			/* logout */
                0,			/* jobstep */
                };

