/*
	Copyright (C) 2004 Jonas Lindholm

	This software was developed by Jonas Lindholm, jlhm@usa.net

	History

	V1.0		Jonas Lindholm	2004-05-14

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <string.h>

#include <starlet.h>
#include <ssdef.h>
#include <stsdef.h>
#include <lnmdef.h>
#include <descrip.h>

#include "lgi.h"
#include "lgildap.h"
#include "private.h"

int do_trnlnm(char *lnm, char *trn, int trnlen, int accmode) {
	int			stat;
	int unsigned		mask = LNM$M_CASE_BLIND;
	short unsigned		retlen = 0;
	ITEM3			itmlst[2] = { { trnlen, LNM$_STRING, trn, &retlen }, { 0, 0, 0, 0 } };

	$DESCRIPTOR(tbldsc, "LNM_LGI_LDAP");
	$DESCRIPTOR(lnmdsc, lnm);

	lnmdsc.dsc$w_length = strlen(lnm);

	if (($VMS_STATUS_SUCCESS(stat = sys$trnlnm(&mask, &tbldsc, &lnmdsc, &accmode, &itmlst)))) {

		trn[retlen] = 0;

	}

	return stat;	
}
