/**/
/******************************************************************************/
/**                                                                          **/
/**  Copyright (c) 2001                                                      **/
/**  by DIGITAL Equipment Corporation, Maynard, Mass.                        **/
/**  All rights reserved.                                                    **/
/**                                                                          **/
/**  This software is furnished under a license and may be used and  copied  **/
/**  only  in  accordance  with  the  terms  of  such  license and with the  **/
/**  inclusion of the above copyright notice.  This software or  any  other  **/
/**  copies  thereof may not be provided or otherwise made available to any  **/
/**  other person.  No title to and ownership of  the  software  is  hereby  **/
/**  transferred.                                                            **/
/**                                                                          **/
/**  The information in this software is subject to change  without  notice  **/
/**  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  **/
/**  Corporation.                                                            **/
/**                                                                          **/
/**  DIGITAL assumes no responsibility for the use or  reliability  of  its  **/
/**  software on equipment which is not supplied by DIGITAL.                 **/
/**                                                                          **/
/******************************************************************************/
/********************************************************************************************************************************/
/* Created: 16-MAR-2001 22:27:01 by OpenVMS SDL EV1-60     */
/* Source:  10-MAR-1998 14:08:12 $64$DKC203:[LIB_H.SRC]UAFDEF.SDL;1 */
/********************************************************************************************************************************/
/*** MODULE $UAFDEF ***/
#ifndef __UAFDEF_LOADED
#define __UAFDEF_LOADED 1
 
#pragma __nostandard			 /* This file uses non-ANSI-Standard features */
#pragma __member_alignment __save
#pragma __nomember_alignment
#ifdef __INITIAL_POINTER_SIZE			 /* Defined whenever ptr size pragmas supported */
#pragma __required_pointer_size __save		 /* Save the previously-defined required ptr size */
#pragma __required_pointer_size __short		 /* And set ptr size default to 32-bit pointers */
#endif
 
#ifdef __cplusplus
    extern "C" {
#define __unknown_params ...
#define __optional_params ...
#else
#define __unknown_params
#define __optional_params ...
#endif
 
#ifndef __struct
#if !defined(__VAXC)
#define __struct struct
#else
#define __struct variant_struct
#endif
#endif
 
#ifndef __union
#if !defined(__VAXC)
#define __union union
#else
#define __union variant_union
#endif
#endif
 
/*++                                                                        */
/* User authorization file format                                           */
/* Note: With the exception of the username and account name,               */
/* all strings are blank padded counted strings. Username and               */
/* account name are uncounted, blank padded.                                */
/*--                                                                        */
#define UAF$C_USER_ID 1                 /* main user ID record              */
#define UAF$C_VERSION1 1                /* this version                     */
#define UAF$C_KEYED_PART 52             /* ISAM keys come this far          */
#define UAF$C_MAX_PWD_LENGTH 32         /* maximum plaintext password length */
#define UAF$K_MAX_PWD_LENGTH 32         /* maximum plaintext password length */
#define UAF$C_AD_II 0                   /* AUTODIN-II 32 bit crc code       */
#define UAF$C_PURDY 1                   /* Purdy polynomial over salted input */
#define UAF$C_PURDY_V 2                 /* Purdy polynomial + variable length username */
#define UAF$C_PURDY_S 3                 /* PURDY_V folded into password length */
#define UAF$K_CURRENT_ALGORITHM 3       /* current DEC algorithm number     */
#define UAF$C_CURRENT_ALGORITHM 3       /* current DEC algorithm number     */
#define UAF$C_PREFERED_ALGORITHM 127
#define UAF$K_PREFERED_ALGORITHM 127
#define UAF$C_PREFERRED_ALGORITHM 127   /* preferred hash algorithm - use current */
#define UAF$K_PREFERRED_ALGORITHM 127   /* preferred hash algorithm - use current */
#define UAF$C_CUST_ALGORITHM 128        /* customer algorithm division      */
#define UAF$K_CUST_ALGORITHM 128        /* customer algorithm division      */
#define UAF$K_FIXED 644                 /* length of fixed portion          */
#define UAF$C_FIXED 644                 /* length of fixed portion          */
#define UAF$K_LENGTH 1412
#define UAF$C_LENGTH 1412
#define UAF$S_UAFDEF 1412               /* Old size name, synonym for  UAF$S_UAF */
	
typedef struct _uaf {
    unsigned char uaf$b_rtype;          /* UAF record type                  */
    unsigned char uaf$b_version;        /* UAF format version               */
    unsigned short int uaf$w_usrdatoff; /* offset of counted string of user data */
    __union  {
        char uaf$t_username [32];       /* username                         */
        __struct  {
            char uaf$t_fill_0 [31];
            char uaf$t_username_tag;    /* tag to differentiate records     */
            } uaf$r_fill_1_;
        } uaf$r_fill_0_;
    __union  {
        unsigned int uaf$l_uic;         /* user ID code                     */
        __struct  {
            unsigned short int uaf$w_mem; /* member subfield                */
            unsigned short int uaf$w_grp; /* group subfield                 */
            } uaf$r_fill_3_;
        } uaf$r_fill_2_;
    unsigned int uaf$l_sub_id;          /* user sub-identifier              */
    unsigned __int64 uaf$q_parent_id;   /* identifier of owner of this account */
    char uaf$t_account [32];            /* account name                     */
    char uaf$t_owner [32];              /* owner's name                     */
    char uaf$t_defdev [32];             /* default device                   */
    char uaf$t_defdir [64];             /* default directory                */
    char uaf$t_lgicmd [64];             /* login command file               */
    char uaf$t_defcli [32];             /* default command interpreter      */
    char uaf$t_clitables [32];          /* user CLI tables                  */
    __union  {
        unsigned __int64 uaf$q_pwd;     /* hashed password                  */
        __struct  {
            unsigned int uaf$l_pwd;     /* 32 bit subfield                  */
            } uaf$r_fill_5_;
        } uaf$r_fill_4_;
    unsigned __int64 uaf$q_pwd2;        /* second password                  */
    unsigned short int uaf$w_logfails;  /* count of login failures          */
    unsigned short int uaf$w_salt;      /* random password salt             */
    unsigned char uaf$b_encrypt;        /* primary password hash algorithm  */
/* known hash algorithm indices                                             */
    unsigned char uaf$b_encrypt2;       /* secondary password hash algorithm */
    unsigned char uaf$b_pwd_length;     /* minimum password length          */
    char uaf$$$_fill_1 [1];
    unsigned __int64 uaf$q_expiration;  /* expiration date for account      */
    unsigned __int64 uaf$q_pwd_lifetime; /* password lifetime               */
    unsigned __int64 uaf$q_pwd_date;    /* date of password change          */
    unsigned __int64 uaf$q_pwd2_date;   /* date of 2nd password change      */
    unsigned __int64 uaf$q_lastlogin_i; /* date of last interactive login   */
    unsigned __int64 uaf$q_lastlogin_n; /* date of last non-interactive login */
    unsigned __int64 uaf$q_priv;        /* process privilege vector         */
    unsigned __int64 uaf$q_def_priv;    /* default process privileges       */
    __struct  {                         /* minimum security class           */
        char uaf$b_fill_2 [20];
        } uaf$r_min_class;
    __struct  {                         /* maximum security class           */
        char uaf$b_fill_3 [20];
        } uaf$r_max_class;
    __union  {
        unsigned int uaf$l_flags;       /* user flags longword              */
        __struct  {
            unsigned uaf$v_disctly : 1; /* no user control-y                */
            unsigned uaf$v_defcli : 1;  /* only allow user default CLI      */
            unsigned uaf$v_lockpwd : 1; /* disable SET PASSWORD command     */
            unsigned uaf$v_restricted : 1; /* restricted account (pre-V5.2 CAPTIVE) */
            unsigned uaf$v_disacnt : 1; /* no interactive login             */
            unsigned uaf$v_diswelcom : 1; /* skip welcome message           */
            unsigned uaf$v_dismail : 1; /* skip new mail message            */
            unsigned uaf$v_nomail : 1;  /* disable mail delivery            */
            unsigned uaf$v_genpwd : 1;  /* passwords must be generated      */
            unsigned uaf$v_pwd_expired : 1; /* password has expired         */
            unsigned uaf$v_pwd2_expired : 1; /* 2nd password has expired    */
            unsigned uaf$v_audit : 1;   /* audit all actions                */
            unsigned uaf$v_disreport : 1; /* skip last login messages       */
            unsigned uaf$v_disreconnect : 1; /* inhibit reconnections       */
            unsigned uaf$v_autologin : 1; /* auto-login only                */
            unsigned uaf$v_disforce_pwd_change : 1; /* disable forced password change */
            unsigned uaf$v_captive : 1; /* captive account (no overrides)   */
            unsigned uaf$v_disimage : 1; /* disable arbitrary image activation */
            unsigned uaf$v_dispwddic : 1; /* disable password dictionary search */
            unsigned uaf$v_dispwdhis : 1; /* disable password history search */
            unsigned uaf$v_defclsval : 1; /* default classification is valid */
            unsigned uaf$v_extauth : 1; /* external authentication enabled  */
            unsigned uaf$v_migratepwd : 1; /* migrate UAF pwd to external auth */
            unsigned uaf$v_vmsauth : 1; /* VMS alternative is allowed       */
            unsigned uaf$v_dispwdsynch : 1; /* no ACME password sharing     */
            unsigned uaf$v_fill_10_ : 7;
            } uaf$r_fill_7_;
        } uaf$r_fill_6_;
    unsigned char uaf$b_network_access_p [3]; /* hourly network access, primary */
    unsigned char uaf$b_network_access_s [3]; /* hourly network access, secondary */
    unsigned char uaf$b_batch_access_p [3]; /* hourly batch access, primary */
    unsigned char uaf$b_batch_access_s [3]; /* hourly batch access, secondary */
    unsigned char uaf$b_local_access_p [3]; /* hourly local access, primary */
    unsigned char uaf$b_local_access_s [3]; /* hourly local access, secondary */
    unsigned char uaf$b_dialup_access_p [3]; /* hourly dialup access, primary */
    unsigned char uaf$b_dialup_access_s [3]; /* hourly dialup access, secondary */
    unsigned char uaf$b_remote_access_p [3]; /* hourly remote access, primary */
    unsigned char uaf$b_remote_access_s [3]; /* hourly remote access, secondary */
    char uaf$$$_fill_4 [12];            /* space for 2 more access types    */
    __union  {
        unsigned char uaf$b_primedays;  /* bits representing primary days   */
        __struct  {
            unsigned uaf$v_monday : 1;  /* bit clear means this is a primary day */
            unsigned uaf$v_tuesday : 1; /* bit set means this is an off day */
            unsigned uaf$v_wednesday : 1;
            unsigned uaf$v_thursday : 1;
            unsigned uaf$v_friday : 1;
            unsigned uaf$v_saturday : 1;
            unsigned uaf$v_sunday : 1;
            unsigned uaf$v_fill_11_ : 1;
            } uaf$r_fill_9_;
        } uaf$r_fill_8_;
    char uaf$$$_fill_5 [1];
    unsigned char uaf$b_pri;            /* base process priority            */
    unsigned char uaf$b_quepri;         /* maximum job queuing priority     */
    unsigned short int uaf$w_maxjobs;   /* maximum jobs for UIC allowed     */
/* 0 means no limit                                                         */
    unsigned short int uaf$w_maxacctjobs; /* maximum jobs for account allowed */
/* 0 means no limit                                                         */
    unsigned short int uaf$w_maxdetach; /* maximum detached processes for UIC */
/* 0 means no limit                                                         */
    unsigned short int uaf$w_prccnt;    /* subprocess creation limit        */
    unsigned short int uaf$w_biolm;     /* buffered I/O limit               */
    unsigned short int uaf$w_diolm;     /* direct I/O limit                 */
    unsigned short int uaf$w_tqcnt;     /* timer queue entry limit          */
    unsigned short int uaf$w_astlm;     /* AST queue limit                  */
    unsigned short int uaf$w_enqlm;     /* enqueue limit                    */
    unsigned short int uaf$w_fillm;     /* open file limit                  */
    unsigned short int uaf$w_shrfillm;  /* shared file limit                */
    unsigned int uaf$l_wsquota;         /* working set size quota           */
    unsigned int uaf$l_dfwscnt;         /* default working set size         */
    unsigned int uaf$l_wsextent;        /* working set size limit           */
    unsigned int uaf$l_pgflquota;       /* page file quota                  */
    unsigned int uaf$l_cputim;          /* CPU time quota                   */
    unsigned int uaf$l_bytlm;           /* buffered I/O byte count limit    */
    unsigned int uaf$l_pbytlm;          /* paged buffer I/O byte count limit */
    unsigned int uaf$l_jtquota;         /* job-wide logical name table creation quota */
    unsigned short int uaf$w_proxy_lim; /* number of proxies user can grant */
    unsigned short int uaf$w_proxies;   /* number of proxies granted        */
    unsigned short int uaf$w_account_lim; /* number of sub-accounts allowed */
    unsigned short int uaf$w_accounts;  /* number of sub-accounts in use    */
    __struct  {                         /* default security class           */
        char uaf$b_fill_6 [20];
        } uaf$r_def_class;
    char uaf$$$_fill_99 [44];           /* spare space                      */
    char uaf$$$_fill_100 [768];         /* user-extensible area             */
    } UAF;
 
#if !defined(__VAXC)
#define uaf$t_username uaf$r_fill_0_.uaf$t_username
#define uaf$t_username_tag uaf$r_fill_0_.uaf$r_fill_1_.uaf$t_username_tag
#define uaf$l_uic uaf$r_fill_2_.uaf$l_uic
#define uaf$w_mem uaf$r_fill_2_.uaf$r_fill_3_.uaf$w_mem
#define uaf$w_grp uaf$r_fill_2_.uaf$r_fill_3_.uaf$w_grp
#define uaf$q_pwd uaf$r_fill_4_.uaf$q_pwd
#define uaf$l_pwd uaf$r_fill_4_.uaf$r_fill_5_.uaf$l_pwd
#define uaf$l_flags uaf$r_fill_6_.uaf$l_flags
#define uaf$v_disctly uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_disctly
#define uaf$v_defcli uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_defcli
#define uaf$v_lockpwd uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_lockpwd
#define uaf$v_restricted uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_restricted
#define uaf$v_disacnt uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_disacnt
#define uaf$v_diswelcom uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_diswelcom
#define uaf$v_dismail uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_dismail
#define uaf$v_nomail uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_nomail
#define uaf$v_genpwd uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_genpwd
#define uaf$v_pwd_expired uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_pwd_expired
#define uaf$v_pwd2_expired uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_pwd2_expired
#define uaf$v_audit uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_audit
#define uaf$v_disreport uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_disreport
#define uaf$v_disreconnect uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_disreconnect
#define uaf$v_autologin uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_autologin
#define uaf$v_disforce_pwd_change uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_disforce_pwd_change
#define uaf$v_captive uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_captive
#define uaf$v_disimage uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_disimage
#define uaf$v_dispwddic uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_dispwddic
#define uaf$v_dispwdhis uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_dispwdhis
#define uaf$v_defclsval uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_defclsval
#define uaf$v_extauth uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_extauth
#define uaf$v_migratepwd uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_migratepwd
#define uaf$v_vmsauth uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_vmsauth
#define uaf$v_dispwdsynch uaf$r_fill_6_.uaf$r_fill_7_.uaf$v_dispwdsynch
#define uaf$b_primedays uaf$r_fill_8_.uaf$b_primedays
#define uaf$v_monday uaf$r_fill_8_.uaf$r_fill_9_.uaf$v_monday
#define uaf$v_tuesday uaf$r_fill_8_.uaf$r_fill_9_.uaf$v_tuesday
#define uaf$v_wednesday uaf$r_fill_8_.uaf$r_fill_9_.uaf$v_wednesday
#define uaf$v_thursday uaf$r_fill_8_.uaf$r_fill_9_.uaf$v_thursday
#define uaf$v_friday uaf$r_fill_8_.uaf$r_fill_9_.uaf$v_friday
#define uaf$v_saturday uaf$r_fill_8_.uaf$r_fill_9_.uaf$v_saturday
#define uaf$v_sunday uaf$r_fill_8_.uaf$r_fill_9_.uaf$v_sunday
#endif		/* #if !defined(__VAXC) */
 
 
#pragma __member_alignment __restore
#ifdef __INITIAL_POINTER_SIZE			 /* Defined whenever ptr size pragmas supported */
#pragma __required_pointer_size __restore		 /* Restore the previously-defined required ptr size */
#endif
#ifdef __cplusplus
    }
#endif
#pragma __standard
 
#endif /* __UAFDEF_LOADED */
 
