/**/
/******************************************************************************/
/**                                                                          **/
/**  Copyright (c) 2001                                                      **/
/**  by DIGITAL Equipment Corporation, Maynard, Mass.                        **/
/**  All rights reserved.                                                    **/
/**                                                                          **/
/**  This software is furnished under a license and may be used and  copied  **/
/**  only  in  accordance  with  the  terms  of  such  license and with the  **/
/**  inclusion of the above copyright notice.  This software or  any  other  **/
/**  copies  thereof may not be provided or otherwise made available to any  **/
/**  other person.  No title to and ownership of  the  software  is  hereby  **/
/**  transferred.                                                            **/
/**                                                                          **/
/**  The information in this software is subject to change  without  notice  **/
/**  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  **/
/**  Corporation.                                                            **/
/**                                                                          **/
/**  DIGITAL assumes no responsibility for the use or  reliability  of  its  **/
/**  software on equipment which is not supplied by DIGITAL.                 **/
/**                                                                          **/
/******************************************************************************/
/********************************************************************************************************************************/
/* Created: 16-MAR-2001 22:26:42 by OpenVMS SDL EV1-60     */
/* Source:  27-DEC-1999 10:07:45 $64$DKC203:[LIB_H.SRC]BOOSTATEDEF.SDL;1 */
/********************************************************************************************************************************/
/*** MODULE BOOSTATEDEF ***/
#ifndef __BOOSTATEDEF_LOADED
#define __BOOSTATEDEF_LOADED 1
 
#pragma __nostandard			 /* This file uses non-ANSI-Standard features */
#pragma __member_alignment __save
#pragma __nomember_alignment
#ifdef __INITIAL_POINTER_SIZE			 /* Defined whenever ptr size pragmas supported */
#pragma __required_pointer_size __save		 /* Save the previously-defined required ptr size */
#pragma __required_pointer_size __short		 /* And set ptr size default to 32-bit pointers */
#endif
 
#ifdef __cplusplus
    extern "C" {
#define __unknown_params ...
#define __optional_params ...
#else
#define __unknown_params
#define __optional_params ...
#endif
 
#ifndef __struct
#if !defined(__VAXC)
#define __struct struct
#else
#define __struct variant_struct
#endif
#endif
 
#ifndef __union
#if !defined(__VAXC)
#define __union union
#else
#define __union variant_union
#endif
#endif
 
#define BOOSTATE$M_SYSBOOT 0x1
#define BOOSTATE$M_INIT 0x2
#define BOOSTATE$M_SWAPPER 0x4
#define BOOSTATE$M_SYSINIT 0x8
#define BOOSTATE$M_STARTUP 0x10
#define BOOSTATE$M_PFN_INIT 0x20
#define BOOSTATE$M_POOL_INIT 0x40
#define BOOSTATE$M_XQP 0x80
#define BOOSTATE$M_RMS 0x100
#define BOOSTATE$M_CONSOLE 0x200
#define BOOSTATE$M_SPNLCK_AVAIL 0x400
#define BOOSTATE$M_NORDONLY 0x800
#define BOOSTATE$M_EXEC_SLICING 0x1000
#define BOOSTATE$M_OBJREG 0x2000
#define BOOSTATE$M_AUDITING 0x4000
#define BOOSTATE$M_OBJECT_SERVICE 0x8000
#define BOOSTATE$M_FOREIGN_BOOT 0x10000
#define BOOSTATE$M_LANACP 0x20000
#define BOOSTATE$M_QSRV 0x40000
	
#if !defined(__NOBASEALIGN_SUPPORT)  && !defined(__cplusplus)   /* If using pre DECC V4.0 or C++ */
#pragma __nomember_alignment __longword
#else
#pragma __nomember_alignment
#endif
typedef struct _boostate {
#pragma __nomember_alignment
    __union  {
        int boostate$l_bits;
        __struct  {
            unsigned boostate$v_sysboot : 1; /* SYSBOOT is executing        */
            unsigned boostate$v_init : 1; /* INIT is executing              */
            unsigned boostate$v_swapper : 1; /* The SWAPPER process is executing */
            unsigned boostate$v_sysinit : 1; /* The SYSINIT process is executing */
            unsigned boostate$v_startup : 1; /* The STARTUP process is executing */
            unsigned boostate$v_pfn_init : 1; /* The PFN database is initialized */
            unsigned boostate$v_pool_init : 1; /* Nonpaged pool is available */
            unsigned boostate$v_xqp : 1; /* The XQP has been mapped         */
            unsigned boostate$v_rms : 1; /* RMS has been loaded             */
            unsigned boostate$v_console : 1; /* Console routines are connected */
            unsigned boostate$v_spnlck_avail : 1; /* Spinlock database available */
            unsigned boostate$v_nordonly : 1; /* If set, EXEC should not be */
/*         made read only.                                                  */
            unsigned boostate$v_exec_slicing : 1; /* If set, execlets should not  */
/*         sliced during load.                                              */
            unsigned boostate$v_objreg : 1; /* Security Object Registration enabled */
            unsigned boostate$v_auditing : 1; /* Security auditing subsystem initialized */
            unsigned boostate$v_object_service : 1; /* Security object service initialized */
            unsigned boostate$v_foreign_boot : 1; /* If set, system disk is foreign to VMS */
            unsigned boostate$v_lanacp : 1; /* If set, LANACP is started    */
            unsigned boostate$v_qsrv : 1; /* If set, SYSINIT must wait for QIO$CONFIGURE  */
            unsigned boostate$v_fill_2_ : 5;
            } boostate$r_fill_1_;
        } boostate$r_fill_0_;
    } BOOSTATE;
 
#if !defined(__VAXC)
#define boostate$v_sysboot boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_sysboot
#define boostate$v_init boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_init
#define boostate$v_swapper boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_swapper
#define boostate$v_sysinit boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_sysinit
#define boostate$v_startup boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_startup
#define boostate$v_pfn_init boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_pfn_init
#define boostate$v_pool_init boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_pool_init
#define boostate$v_xqp boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_xqp
#define boostate$v_rms boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_rms
#define boostate$v_console boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_console
#define boostate$v_spnlck_avail boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_spnlck_avail
#define boostate$v_nordonly boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_nordonly
#define boostate$v_exec_slicing boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_exec_slicing
#define boostate$v_objreg boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_objreg
#define boostate$v_auditing boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_auditing
#define boostate$v_object_service boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_object_service
#define boostate$v_foreign_boot boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_foreign_boot
#define boostate$v_lanacp boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_lanacp
#define boostate$v_qsrv boostate$r_fill_0_.boostate$r_fill_1_.boostate$v_qsrv
#endif		/* #if !defined(__VAXC) */
 
#define BOOSTATE$S_BOOSTATEDEF 4
 
#pragma __member_alignment __restore
#ifdef __INITIAL_POINTER_SIZE			 /* Defined whenever ptr size pragmas supported */
#pragma __required_pointer_size __restore		 /* Restore the previously-defined required ptr size */
#endif
#ifdef __cplusplus
    }
#endif
#pragma __standard
 
#endif /* __BOOSTATEDEF_LOADED */
 
