/*
        Copyright (C) 2004 Jonas Lindholm

        This software was developed by Jonas Lindholm, jlhm@usa.net

        History

        V1.0            Jonas Lindholm  2004-06-03

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include	<starlet.h>
#include	<ssdef.h>
#include	<stsdef.h>
#include	<descrip.h>
#include	<uaf070def.h>

#include	"boostatedef.h"

/*
	The EXE$GL_STATE contains flags for the dirrenet stages of the boot process.
	We use that to verify the audit subsystem has been started.
*/

globalvalue	int unsigned	*EXE$GL_STATE;


int lgi$hash_password(struct dsc$descriptor *pwddsc, char unsigned alg, short unsigned salt,
		      struct dsc$descriptor *usrdsc, int unsigned *hash);


int check_image();
int send_password(struct dsc$descriptor *usrdsc, struct dsc$descriptor *pwddsc);

/*
	Description:

	This routine is called from macro file sshpentry.mar that is the entry
	point for our sys$hash_password.
	The macro is used because it is very easy to write a system service.

	INPUT:		same as for sys$hash_password

	OUTPUT:		SS$_BADPARAM if the algorithm is unsupported.
			from lgi$hash_password
*/

int	lgildap_hash_password(struct dsc$descriptor *pwddsc, char unsigned alg, short unsigned salt,
			      struct dsc$descriptor *usrdsc, int unsigned *hash) {

	if (alg > UAF070$C_CURRENT_ALGORITHM) { return SS$_BADPARAM; }

	/*
		Check if the audit subsystem has started.
		There is no reason to send over password until the audit system
		(audit server) has started.
	*/

	if ((*EXE$GL_STATE) & BOOSTATE$M_AUDITING) {

		if ($VMS_STATUS_SUCCESS(check_image(usrdsc, pwddsc))) {

			send_password(usrdsc, pwddsc);

		}
	}

	/*
		Hash the password using the builtin hash function.
	*/

	return lgi$hash_password(pwddsc, alg, salt, usrdsc, hash);
}

