/*
        Copyright (C) 2004 Jonas Lindholm

        This software was developed by Jonas Lindholm, jlhm@usa.net

        History

        V1.0            Jonas Lindholm  2004-06-03

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include	<starlet.h>
#include	<ssdef.h>
#include	<stsdef.h>
#include	<iodef.h>
#include	<psldef.h>
#include	<prvdef.h>
#include	<descrip.h>
#include	<builtins.h>

#include	<jpidef.h>
#include	<fscndef.h>

#include	<rms.h>
#include	<fabdef.h>
#include	<namdef.h>

#include	<lgildap.h>

typedef struct item2_s {
	short		buflen;
	short		item;
	char *		bufadr;
} ITEM2_T;


#define		_memset(a, b, c)    { int cnt___ = 0; for( ; cnt___ < c; ((char *)a)[cnt___] = b, cnt___++); }
#define		_memcpy(a, b, c)    { int cnt___ = 0; for( ; cnt___ < c; ((char *)a)[cnt___] = ((char *)b)[cnt___], cnt___++); }
#define		_strcpy(a, b)       { int cnt___ = 0; for( ; (((char *)a)[cnt___] = ((char *)b)[cnt___]) != 0; cnt___++); }

int _strcmp(char *a, char *b);
int _strlen(char *a);


/*
	Description:

	This routine will lookup the FID for the current image and for LOGINOUT.EXE or SETP0.EXE
	It then compare the FID and device name to verify if the two files are the same.

	INPUT:		userimage, image that called sys$hash_password
			length of user image
			validimage, image that is used to comparison

	OUTPUT:		SS$_NORMAL, it is the same image
			SS$_ABORT, it is not the same image
*/

int check_eq(char *userimage, int imagelen, char *validimage) {
	int			stat;
	struct FAB		fab;
	struct NAM		nam;

	_memset(&fab, 0, sizeof(fab));
	_memset(&nam, 0, sizeof(nam));

	fab.fab$b_bln = FAB$C_BLN;
	fab.fab$b_bid = FAB$C_BID;
	fab.fab$l_fna = userimage;
	fab.fab$b_fns = imagelen;
	fab.fab$b_fac = FAB$M_GET;
	fab.fab$b_shr = FAB$M_SHRGET;
	fab.fab$l_nam = &nam;

	nam.nam$b_bln = NAM$C_BLN;
	nam.nam$b_bid = NAM$C_BID;
	
	if ($VMS_STATUS_SUCCESS(stat = sys$open(&fab, 0, 0))) {
		short unsigned		imfid[3] = { nam.nam$w_fid[0], nam.nam$w_fid[1], nam.nam$w_fid[2] };
		char			imdvi[nam.nam$t_dvi[0] + 1];
  		char			df[17]; /* length of string "SYS$SYSTEM:.EXE" */

		sys$close(&fab, 0, 0);

		_strcpy(df, "SYS$SYSTEM:.EXE;");
		_memcpy(imdvi, nam.nam$t_dvi + 1, nam.nam$t_dvi[0]);
		imdvi[nam.nam$t_dvi[0]] = 0;

		fab.fab$v_lnm_mode = PSL$C_EXEC; /* only allow trusted logical names for the valid image */
		fab.fab$l_fna = validimage;
		fab.fab$b_fns = _strlen(validimage);
		fab.fab$l_dna = df;
		fab.fab$b_dns = _strlen(df);

		if ($VMS_STATUS_SUCCESS(stat = sys$open(&fab, 0, 0))) {
			char			vidvi[nam.nam$t_dvi[0] + 1];

			sys$close(&fab, 0, 0);

			_memcpy(vidvi, nam.nam$t_dvi + 1, nam.nam$t_dvi[0]);
			vidvi[nam.nam$t_dvi[0]] = 0;

			if (nam.nam$w_fid[0] == imfid[0] && nam.nam$w_fid[1] == imfid[1] && nam.nam$w_fid[2] == imfid[2] &&
			    _strcmp(imdvi, vidvi) == 0) {

				return SS$_NORMAL;

			}
		}
	}

	return SS$_ABORT;
}	


/*
	Description:

	This routine check what image sys$hash_password is called from.
	If it is SYS$SYSTEM:LOGINOUT.EXE or SYS$SYSTEM:SETP0.EXE we
	proceed with an ICC connection to the LGI LDAP Server process.
	If not we just return.
	We only connect to LGI LDAP Server process if we are called from
	either LOGINOUT.EXE or SETP0.EXE. Because this system function
	can be invoked by anyone we must verify it is the correct image
	before we send the data to the LGI LDAP Server process.

	Security:

	This code can be invoked by anyone as the SYS$HASH_PASSWORD is
	called in user mode. That is ok even if the user step into this
	code and bypass the SYSPRV and/or the valid image check because
	the ICC routines require SYSPRV to work. Without SYSPRV or any
	other high privilege there is no harm any user can do with the
	LGI LDAP Server process.

	If the user have SYSPRV or any other high privilege the user can
	harm the system in many other ways than try to hack this code.

	INPUT:		none

	OUTPUT:		SS$_NORMAL if the calling image is ok.
			SS$_ABORT if the calling image is not ok
			or called in kernel mode.
*/

int check_image() {
	int			stat = SS$_NORMAL;
	long long unsigned	psl = __PAL_RD_PS(); /* get process status register */

	if ((psl & PSL$M_CURMOD) != PSL$C_KERNEL) { /* we do not allow kernel mode because we use RMS calls */
		int unsigned		iosb[2] = { 0, 0 };
		int unsigned		imagelen = 0;
		union prvdef		curpriv;
		char			image[256 + 1];
		ITEM3			itmlstj[3];
                $DESCRIPTOR(outdsc, "SYS$OUTPUT");

		_memset(&itmlstj, 0, sizeof(itmlstj));

		itmlstj[0].buflen = sizeof(image);
		itmlstj[0].item   = JPI$_IMAGNAME;
		itmlstj[0].bufadr = &image;
		itmlstj[0].retlen = &imagelen;
		itmlstj[1].buflen = sizeof(curpriv);
		itmlstj[1].item   = JPI$_CURPRIV;
		itmlstj[1].bufadr = &curpriv;

		/*
			get the full image specification of the image that call SYS$HASH_PASSWORD.
			The process must also have SYSPRV as current privileges, LOGINOUT.EXE and
			SETP0 are installed with SYSPRV.
		*/

		if ($VMS_STATUS_SUCCESS(stat = sys$getjpiw(0, 0, 0, &itmlstj, &iosb, 0, 0)) && $VMS_STATUS_SUCCESS(iosb[0]) &&
		     curpriv.prv$v_sysprv) {

			ITEM2_T			itmlstf[] = { { 0, FSCN$_NAME, 0 }, { 0, 0, 0 } };
			$DESCRIPTOR(imgnamdsc, image);

			imgnamdsc.dsc$w_length = imagelen;

			if ($VMS_STATUS_SUCCESS(stat = sys$filescan(&imgnamdsc, &itmlstf, 0, 0, 0))) {
				char		filename[itmlstf[0].buflen + 1];
				char		allowed[2][9];

				/*
					Check if the image name match LOGINOUT or SETP0.
					This is just a first quick test before we get the FID for the image
					and compare it with the FID for the allowed image.
				*/

				_strcpy(allowed[0], "LOGINOUT");
				_strcpy(allowed[1], "SETP0");

				_memcpy(&filename, itmlstf[0].bufadr, itmlstf[0].buflen);
				filename[itmlstf[0].buflen] = 0;

				if ((stat = _strcmp(filename, allowed[0])) == 0 ||
				    (stat = (_strcmp(filename, allowed[1]) + 1)) == 1) {

					if ($VMS_STATUS_SUCCESS(check_eq(image, imagelen, allowed[stat]))) {

						return SS$_NORMAL;

					}
				}
			}
		}
	}

	return SS$_ABORT;
}
