/*
        Copyright (C) 2004 Jonas Lindholm

        This software was developed by Jonas Lindholm, jlhm@usa.net

        History

        V1.0            Jonas Lindholm  2004-06-03

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include	<starlet.h>
#include	<ssdef.h>
#include	<stsdef.h>
#include	<descrip.h>

#include	<lgildap.h>


#define		_memset(a, b, c)    { int cnt___ = 0; for( ; cnt___ < c; ((char *)a)[cnt___] = b, cnt___++); }
#define		_memcpy(a, b, c)    { int cnt___ = 0; for( ; cnt___ < c; ((char *)a)[cnt___] = ((char *)b)[cnt___], cnt___++); }
#define		_strcpy(a, b)       { int cnt___ = 0; for( ; (((char *)a)[cnt___] = ((char *)b)[cnt___]) != 0; cnt___++); }

int _strcmp(char *a, char *b);
int _strlen(char *a);

int ipc_end(int unsigned ctx);
int ipc_init(int unsigned *ctx);
int ipc_command(int unsigned ctx, LGI_IPC_MSG *msg);


/*
	Description:

	This routine establish a session with the LGI LDAP server process
	and send over username and password.

	INPUT:		username descriptor
			password descriptor

	OUTPUT:		SS$_NORMAL;
*/

int send_password(struct dsc$descriptor *usrdsc, struct dsc$descriptor *pwddsc) {
	int unsigned	ctx;
	char		usr[usrdsc->dsc$w_length + 1];
	char		pwd[usrdsc->dsc$w_length + 1];

	_memcpy(&usr, usrdsc->dsc$a_pointer, usrdsc->dsc$w_length);
	usr[usrdsc->dsc$w_length] = 0;

	_memcpy(&pwd, pwddsc->dsc$a_pointer, pwddsc->dsc$w_length);
	pwd[pwddsc->dsc$w_length] = 0;

	if ($VMS_STATUS_SUCCESS(ipc_init(&ctx))) {
		LGI_IPC_MSG	lim;

		_memset(&lim, 0, sizeof(lim));
		lim.cmd = IPC_CMD_INIT;

		if ($VMS_STATUS_SUCCESS(ipc_command(ctx, &lim))) {

			lim.cmd = IPC_CMD_IDENTITY;
			_strcpy(lim.request.identity.identity, usr);

			if ($VMS_STATUS_SUCCESS(ipc_command(ctx, &lim))) {

				lim.cmd = IPC_CMD_PASSWORD;
				_strcpy(lim.request.password.password, pwd);

				ipc_command(ctx, &lim);
			}
		}

		ipc_end(ctx);
	}

	return SS$_NORMAL;
}
