/*
        Copyright (C) 2004 Jonas Lindholm

        This software was developed by Jonas Lindholm, jlhm@usa.net

        History

        V1.0            Jonas Lindholm  2004-05-14

        This program is free software; you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation; either version 2 of the License, or
        (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
	Description:

	As we can not use any DEC sharable functions we define our own
	routines for comparing two strings and getting the length of
	a string.

	INPUT:		string 1
			string 2 (_strcmp only)

	OUTPUT:		-1 string 1 less than string 2 (_strcmp only)
			0 string 1 equal to string 2 (_strcmp only)
			1 string 1 greater than string 2 (_strcmp only)
			X string length (_strlen only)
*/

int _strcmp(char *a, char *b) {
        int             cnt = 0;

        for(; a[cnt] && b[cnt] && a[cnt] == b[cnt]; cnt++);

        return (a[cnt] == b[cnt] ? 0 : a[cnt] < b[cnt] ? -1 : 1);
}


int _strlen(char *a) {
        int             cnt = 0;

        for(; a[cnt]; cnt++);

        return cnt;
}
