$!-----------------------------------------------------------------------------
$! BUILD_PHPWASD.COM
$!
$! Copyright (C) 2002-2004 Mark G.Daniel.
$! This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
$! This is free software, and you are welcome to redistribute it
$! under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
$!
$! Build the WASD CGI/CGIplus/RTE interface for PHP.
$! There are default locations for both of the following resources, but
$!
$! to link against your own PHP sharable image or location
$!
$!   $ DEFINE /SYSTEM PHPWASDSHR device:[directory]image_name.exe
$!
$! to compile against your own CSWS PHP source kit location
$!
$!   $ DEFINE /SYSTEM /TRANSLATION=CONCEALED CSWS_PHP_ROOT device:[directory.]
$!
$! before invoking this build procedure.
$!
$! P1 == LINK (empty) or BUILD
$! A build (compile+link) will only work when executed within David Jones'
$! build directory structure and environment or equivalent.  Outside of that
$! only linking is available.
$!
$! 14-FEB-2004  MGD  modified for building against CSWS PHP v1.2 source
$! 26-DEC-2002  MGD  modified for building against CSWS PHP v1.1 source
$! 28-JAN-2002  MGD  corrected
$! 14-JAN-2002  MGD  initial
$!-----------------------------------------------------------------------------
$!
$ SAY = "WRITE SYS$OUTPUT"
$!
$ SAY ""
$ SAY "Building ""PHPWASD"" for ""''F$GETSYI("ARCH_NAME")'"" architecture"
$!
$ IF P1 .EQS. "BUILD" .OR. P1 .EQS. "COMPILE"
$ THEN
$!   (need header files)
$    IF F$SEARCH("HT_ROOT:[SRC.PHP]PHP.DIR") .NES. ""
$    THEN
$!      (CSWS PHP directory as subdirectory of HT_ROOT:[SRC.PHP])
$       HT_ROOT = F$TRNLNM("HT_ROOT",,"NO_CONCEAL") - "][" - ".]"
$       CSWS_PHP_ROOT = "''HT_ROOT'.SRC.PHP.PHP.]"
$       DEFINE /PROCESS /TRANSLATION=CONCEALED CSWS_PHP_ROOT 'CSWS_PHP_ROOT'
$    ELSE
$!      (CSWS PHP directory located somewhere site-dependent)
$       IF F$TRNLNM("CSWS_PHP_ROOT") .EQS. ""
$       THEN
$          TYPE SYS$INPUT

                  ***********************************************
                  *  LOGICAL NAME 'CSWS_PHP_ROOT' NOT DEFINED!  *
                  ***********************************************

This logical locates the CSWS PHP sources used for header files during
compilation.  This can be defined as follows

  $ DEFINE /PROCESS /TRANSLATION=CONCEALED CSWS_PHP_ROOT device:[dir.]

$          EXIT
$       ENDIF
$    ENDIF
$    SAY "Using CSWS_PHP_ROOT defined as ''f$TRNLNM("CSWS_PHP_ROOT")'"
$ ENDIF
$!
$ PHPSHR = F$TRNLNM("PHPSHR","LNM$SYSTEM")
$ PHPWASDSHR = F$TRNLNM("PHPWASDSHR","LNM$SYSTEM")
$ IF PHPSHR .EQS. "" .AND. PHPWASDSHR .EQS. ""
$ THEN
$    TYPE SYS$INPUT

        ************************************************************
        *  NEITHER LOGICAL NAME 'PHPSHR' OR 'PHPWASDSHR' DEFINED!  *
        ************************************************************

Either one of these logical names needs to be available to locate the PHP
sharable image.  Please read build instructions and execute PHP_STARTUP.COM
procedure before attempting to build.

$    EXIT
$ ENDIF
$!
$ PHP_ROOT = F$TRNLNM("PHP_ROOT","LNM$PROCESS")
$ IF PHP_ROOT .NES. "" THEN DEASSIGN /PROCESS PHP_ROOT
$!
$ IF PHPWASDSHR .NES. "" .AND. F$SEARCH("PHPWASDSHR") .EQS. ""
$ THEN
$    TYPE SYS$INPUT

               **********************************************
               *  CANNOT FIND 'PHPWASDSHR' SHAREABLE IMAGE  *
               **********************************************

Check definition of logical name PHPWASDSHR.

$    SHOW LOGICAL PHPWASDSHR
$    SAY ""
$    EXIT
$ ENDIF
$!
$ IF PHPSHR .NES. "" .AND. F$SEARCH("PHPSHR") .EQS. ""
$ THEN
$    TYPE SYS$INPUT

                 ******************************************
                 *  CANNOT FIND 'PHPSHR' SHAREABLE IMAGE  *
                 ******************************************

Check definition of logical name PHPSHR.

$    SHOW LOGICAL PHPWASDSHR
$    SAY ""
$    EXIT
$ ENDIF
$!
$ IF PHP_ROOT .NES. "" -
     THEN DEFINE /PROCESS /TRANSLATION=CONCEALED PHP_ROOT 'PHP_ROOT'
$!
$ ARCH_NAME = F$EDIT(F$GETSYI("ARCH_NAME"),"UPCASE")
$ IF ARCH_NAME .EQS. "ALPHA" THEN ARCH_NAME = "AXP"
$!
$ CC_OPTIONS = "/DECC /OPTIMIZE /PREFIX=ALL"
$!
$ PREVIOUS_DEFAULT = F$ENVIRONMENT("DEFAULT")
$ SET DEFAULT HT_ROOT:[SRC.PHP]
$!
$ IF F$SEARCH("OBJ_''ARCH_NAME'.DIR") .EQS. "" -
     THEN CREATE /DIR [.OBJ_'ARCH_NAME']
$ OBJECT_DIR = "[.OBJ_''ARCH_NAME']"
$!
$ IF P1 .EQS. "BUILD" .OR. P1 .EQS. "COMPILE"
$ THEN
$!
$    DEFINE /PROCESS TSRM CSWS_PHP_ROOT:[TSRM]
$    DEFINE /PROCESS MAIN CSWS_PHP_ROOT:[MAIN]
$    DECC_USER_INCLUDE = "CSWS_PHP_ROOT:[EXT.STANDARD], " +-
        "CSWS_PHP_ROOT:[000000], CSWS_PHP_ROOT:[MAIN], " +-
        "CSWS_PHP_ROOT:[ZEND], CSWS_PHP_ROOT:[TSRM]"
$    DEFINE /PROCESS DECC$USER_INCLUDE 'DECC_USER_INCLUDE'
$    DEFINE /PROCESS DECC$SYSTEM_INCLUDE CSWS_PHP_ROOT:[OPENVMS]
$!
$    IF F$SEARCH("DECC$USER_INCLUDE:PHP.H") .EQS. ""
$    THEN
$       TYPE SYS$INPUT

                  *****************************************
                  *  CANNOT FIND 'PHP.H' IN INCLUDE PATH  *
                  *****************************************

$       SHOW LOGICAL DECC$USER_INCLUDE
$       SAY ""
$       EXIT
$    ENDIF
$    SAY ""
$    SET NOON
$    SET VERIFY
$ CC 'CC_OPTIONS' /OBJECT='OBJECT_DIR' PHPWASD
$!   'F$VERIFY(0)
$    CC_STATUS = $STATUS
$    CC_SEVERITY = $SEVERITY
$    IF .NOT. CC_SEVERITY THEN EXIT 'CC_STATUS'
$    SET ON
$!
$    IF F$TRNLNM("PHP_INCLUDE_DIR","LNM$PROCESS") .NES. "" -
        THEN DEASSIGN /PROCESS PHP_INCLUDE_DIR
$!
$ ENDIF
$!
$ IF P1 .EQS. "" .OR. P1 .EQS. "BUILD" .OR. P1 .EQS. "LINK"
$ THEN
$!
$    SET NOON
$    IF PHPWASDSHR .EQS. "" THEN PHPWASDSHR = PHPSHR
$    DEFINE /PROCESS PHPWASDSHR 'PHPWASDSHR'
$    SAY "Linking against shareable image ''F$TRNLNM("PHPSHR")'"
$    SET VERIFY
$ LINK /EXECUTABLE=HT_EXE:PHPWASD.EXE -
[.OBJ_'ARCH_NAME']PHPWASD.OBJ, -
SYS$INPUT:/OPTIONS 
IDENTIFICATION="PHPWASD121"
PHPWASDSHR/SHARE
$!   'F$VERIFY(0)
$    DEASSIGN /PROCESS PHPWASDSHR
$    SET ON
$!
$ ENDIF
$!
$ PURGE /NOLOG 'OBJECT_DIR'
$ SAY ""
$!
$ IF F$TRNLNM("TSRM","LNM$PROCESS") .NES. "" THEN DEASSIGN /PROCESS TSRM
$ IF F$TRNLNM("MAIN","LNM$PROCESS") .NES. "" THEN DEASSIGN /PROCESS MAIN
$ IF F$TRNLNM("DECC$USER_INCLUDE","LNM$PROCESS") .NES. "" THEN DEASSIGN /PROCESS DECC$USER_INCLUDE
$ IF F$TRNLNM("DECC$SYSTEM_INCLUDE","LNM$PROCESS") .NES. "" THEN DEASSIGN /PROCESS DECC$SYSTEM_INCLUDE
$!
$ IF F$TYPE(CSWS_PHP_ROOT) .NES. "" THEN DEASSIGN /PROCESS CSWS_PHP_ROOT
$!
$ SET DEFAULT 'PREVIOUS_DEFAULT'
$!-----------------------------------------------------------------------------
