/*
 *	Spider
 *
 *	(c) Copyright 1989, Donald R. Woods and Sun Microsystems, Inc.
 *	(c) Copyright 1990, David Lemke and Network Computing Devices Inc.
 *
 *	See copyright.h for the terms of the copyright.
 *
 *	@(#)globals.h	2.1	90/04/25
 *
 */

/*
 * spider global variables
 */
Display	*dpy;
int	screen;
Window	table;
#ifdef 	KITLESS
Window	message_win;
XFontStruct	*message_font;
#endif	/* KITLESS */
Pixmap	greenmap;
Pixmap	redmap;
Pixmap	logomap;

unsigned long	blackpixel;
unsigned long	whitepixel;
unsigned long	borderpixel;
unsigned long	greenpixel;

Bool	is_color;

CardList	deck;
CardList	stack[NUM_STACKS];		/* tableau */
CardList	piles[NUM_PILES];		/* full suits */

int		table_height;
int		table_width;

int		deck_index;

int		draw_count;

Bool		restart;
int		deal_number;

extern char	*version;
extern char	*build_date;

/* function decls */
char	*rank_name();
char	*rnk_name();
char	*suit_name();
#ifdef	DEBUG
char	*type_name();
#endif	/* DEBUG */
char	*get_selection();
char	*remove_newlines();

Bool	can_move();
Bool	can_move_to();

CardList	best_card_move();
CardPtr	last_card();

int	replay();

void	best_list_move();
void	move_to_list();
void	move_to_pile();
void	recompute_list_deltas();

void	show_message();
void	card_message();
void	card2_message();
void	clear_message();
void	print_version();

void	show_play();
void	locate();

void	advise_best_move();
void	delay();
void	force_redraw();

#ifndef KITLESS
void	key_press();
void	redraw_table();
void	button_press();
void	button_release();
void	do_expand();
#endif /*KITLESS*/

#ifdef XAW
Bool	can_get_help_files();
int     xaw_init(int argc, char **argv);
#endif

#ifndef VMS
extern char	*malloc();
extern char	*calloc();
extern char	*realloc();
#endif

/* Function Prototypes */
int  add_card(CardPtr new, CardPtr old, int location, CardList list);
int  card_init();
int  compute_score();
int  deal_cards();
int  deal_next_hand(Bool log);
int  display_init();
int  draw_center_pip();
int  draw_did();
int  draw_eight_pips();
int  draw_four_pips();
int  draw_jack();
int  draw_king();
int  draw_pip();
int  draw_queen();
int  draw_rank();
int  draw_six_pips();
int  draw_two_pips();
int  event_loop();
int  expand(CardList list);
int  flip_bits(unsigned char *src, unsigned char *dst, int W, int H);
int  flip_card();
int  flush_message();
int  gfx_init(Display *d, int scr);
int  init_cache();
int  make_card_maps();
int  make_deck_cache();
int  paint_card();
int  paint_cardback(int x, int y, int delta);
int  read_file(char *fname);
int  read_file_or_selection(char *fname);
int  read_selection(char *buf);
int  record(int form, int dest, int num_cards, Bool exposed);
int  redraw_card_piles(int x, int y, int w, int h);
int  redraw_card_stacks(int x, int y, int w, int h);
int  redraw_deck(int x, int y, int w, int h);
int  remove_all_cards(CardPtr cache[NUM_CARDS]);
int  remove_card(CardPtr card);
int  rot_180(unsigned char *src, unsigned char *dst, int W, int H);
int  show_list(CardList list, CardPtr card);
int  show_card(CardPtr card);
int  show_full_suits();
Bool show_play_events();
int  shuffle_cards();
int  spider_bell(Display *d, int level);
int  table_init(Window win);
int  undo();
int  undo_deal();
int  undo_normal(int from, int dest, int num_cards, Bool exposed);
int  undo_suit(int from, Bool exposed);
int  window_init(int ac, char **av, char *geom);
int  write_file(char *fname, Bool (*confirmer)());
int  write_human(FILE *fp);
