$! make spider under VMS
$!
$! In case of problems with the install you might contact me at 
$! zinser@decus.de (preferred) or zinser@sysdev.exchange.de
$!
$!
$! Check for MMK/MMS
$!
$ Make = ""
$ If F$Search ("Sys$System:MMS.EXE") .nes. "" Then Make = "MMS"
$ If F$Type (MMK) .eqs. "STRING" Then Make = "MMK"
$!
$! Setup standard Compile options
$!
$ v7 = f$extract(1,1,f$getsyi("version")) .ges. "7"
$ if v7
$ then
$   strdup = ""
$ else
$   strdup = ",local_strdup" 
$   if f$search("x11vms:vmsutil.h").eqs.""
$   then
$     type sys$input:
It seems you do not have a copy of the xvmsutils installed at your site
(at least I can't find x11vms:vmsutil.h). Since you are on a VMS system
prior to 7.x you'll need to get a copy of these from 
http://www.decus.de:8080/www/vms/sw/xvmsutils.htmlx
before you can build spider to compensate for some missing C functions.

Exiting now
$     exit
$   endif
$ endif
$ if f$search("x11:[xaw]command.h").eqs.""
$ then
$   type sys$input:
To compile Spider you need a copy of the Xaw widgetset installed on your 
system. This was either not done or the x11 logical is not defined 
properly (at least I can't find x11:[xaw]command.h). To get Xaw check
http://www.decus.de:8080/www/vms/sw/xaw.htmlx
For instructions how to setup the X11 logical for use with Xaw check 
http://www.decus.de:8080/www/vms/sw/notes/xaw.htmlx

Exiting now
$   exit
$ endif

$ ccopt = - 
  "/def=(xaw,date=""""""""""""''F$TIME()'"""""""""""",HELPDIR=""""""""""""SPIDER_DIR:""""""""""""''strdup')"
$!
$! Look for the compiler used
$!
$ if f$getsyi("HW_MODEL").ge.1024
$ then
$  ccopt = "/prefix=all/ext=common"+ccopt
$  if f$trnlnm("SYS").eqs."" then define sys sys$library:
$ else
$  if f$search("SYS$SYSTEM:DECC$COMPILER.EXE").eqs.""
$   then
$    if f$trnlnm("SYS").eqs."" then define sys sys$library:
$   else
$    if f$trnlnm("SYS").eqs."" then define sys decc$library_include:
$    ccopt = "/decc/prefix=all/ext=common"+ccopt
$  endif
$ endif
$!
$!      Build the option-file
$!
$ open/write optf spider.opt
$ write optf "events"
$ write optf "gfx"
$ write optf "movelog"
$ write optf "spider"
$ write optf "util"
$ write optf "version"
$ write optf "windows"
$ write optf "xaw_stubs"
$ write optf "xaw_ui"
$ write optf "Identification=""Spider 1.1"""
$ if .not. v7 then write optf "x11vms:xvmsutils.olb/lib"
$!
$!  Find out which X-Version we're running.  This will fail for older
$!  VMS versions (i.e., v5.5-1).  Therefore, choose DECWindows XUI for
$!  default.
$!
$ On Error Then GoTo XUI
$ @sys$update:decw$get_image_version sys$share:decw$xlibshr.exe decw$version
$ if f$extract(4,3,decw$version).eqs."1.0"
$ then
$   write optf "Sys$share:DECW$DWTLIBSHR.EXE/Share"
$ endif
$ if f$extract(4,3,decw$version).eqs."1.1"
$ then
$   write optf "sys$share:decw$xtshr.exe/share"
$ endif
$ if f$extract(4,3,decw$version).ges."1.2"
$ then
$   write optf "sys$share:decw$xtlibshrr5.exe/share"
$ endif
$ GoTo MAIN
$!
$ XUI:
$!
$   write optf "Sys$share:DECW$DWTLIBSHR.EXE/Share"
$ MAIN:
$ On Error Then exit
$ write optf "sys$share:decw$xlibshr.exe/share"
$ write optf "xmulibshr/share"
$ write optf "xaw3dlibshr/shar"
$ close optf
$!
$! Build the thing plain or with MMS/MMK
$!
$ write sys$output "Compiling Spider sources ..."
$ If (Make .eqs. "")
$  then
$   CALL MAKE events.OBJ "CC ''CCOPT' events" -
              events.c defs.h globals.h
$   CALL MAKE gfx.OBJ "CC ''CCOPT' gfx" -
              gfx.c  defs.h globals.h
$   CALL MAKE movelog.OBJ "CC ''CCOPT' movelog" -
              movelog.c  defs.h globals.h
$   CALL MAKE spider.OBJ "CC ''CCOPT' spider" -
              spider.c  defs.h globals.h
$   CALL MAKE util.OBJ "CC ''CCOPT' util" -
              util.c  defs.h globals.h xaw_ui.h
$   CALL MAKE version.OBJ "CC ''CCOPT' version" -
              version.c  defs.h globals.h
$   CALL MAKE windows.OBJ "CC ''CCOPT' windows" -
              windows.c  defs.h globals.h
$   CALL MAKE xaw_stubs.OBJ "CC ''CCOPT' xaw_stubs" -
              xaw_stubs.c  defs.h globals.h xaw_ui.h
$   CALL MAKE xaw_ui.OBJ "CC ''CCOPT' xaw_ui" -
              xaw_ui.c  defs.h globals.h xaw_ui.h
$   write sys$output "Linking Spider..."
$   call make spider.exe "LINK spider.opt/opt" *.obj
$  else
$   'make'/macro=(cflags="''ccopt'")
$  endif
$ write sys$output "Spider build completed"
$ exit
$!
$!
$MAKE: SUBROUTINE   !SUBROUTINE TO CHECK DEPENDENCIES
$ V = 'F$Verify(0)
$! P1 = What we are trying to make
$! P2 = Command to make it
$! P3 - P8  What it depends on
$
$ If F$Search(P1) .Eqs. "" Then Goto Makeit
$ Time = F$CvTime(F$File(P1,"RDT"))
$arg=3
$Loop:
$       Argument = P'arg
$       If Argument .Eqs. "" Then Goto Exit
$       El=0
$Loop2:
$       File = F$Element(El," ",Argument)
$       If File .Eqs. " " Then Goto Endl
$       AFile = ""
$Loop3:
$       OFile = AFile
$       AFile = F$Search(File)
$       If AFile .Eqs. "" .Or. AFile .Eqs. OFile Then Goto NextEl
$       If F$CvTime(F$File(AFile,"RDT")) .Ges. Time Then Goto Makeit
$       Goto Loop3
$NextEL:
$       El = El + 1
$       Goto Loop2
$EndL:
$ arg=arg+1
$ If arg .Le. 8 Then Goto Loop
$ Goto Exit
$
$Makeit:
$ VV=F$VERIFY(0)
$ write sys$output P2
$ 'P2
$ VV='F$Verify(VV)
$Exit:
$ If V Then Set Verify
$ENDSUBROUTINE
