$!-----------------------------------------------------------------------------
$! BUILD_PERLRTE.COM
$! Perl Run-Time Environment.
$!
$! P1 == LINK or BUILD or empty (builds)
$! P2 == 5.8 (default) for Perl 5.8
$! P2 == 5.6 for Perl 5.6
$!
$! 06-JAN-2002  MGD  try to determine/verify version of Perl
$! 27-JUL-2002  MGD  cater for 5.8 and previous versions (5.6),
$!                   CGILIB no longer required
$! 28-OCT-2000  MGD  use CGILIB object library
$! 23-MAY-2000  MGD  initial
$!-----------------------------------------------------------------------------
$!
$ ON CONTROLY THEN EXIT 44
$ SAY = "WRITE SYS$OUTPUT"
$!
$ IF P1 .EQS. "DIST"
$ THEN
$!   (build two versions on my development system only)
$    PERL = "$PERL_ROOT:[000000]PERL.EXE"
$    DEFINE /NOLOG /PROCESS /TRANSLATION=(CONCEALED,TERMINAL) -
            PERL_ROOT $1$DKA0:[PERL.PERL-5_8_0.]
$    @BUILD_PERLRTE BUILD 5.8 NOCHECK
$    DEFINE /NOLOG /PROCESS /TRANSLATION=(CONCEALED,TERMINAL) -
            PERL_ROOT $1$DKA0:[PERL.PERL-5_6_0.]
$    @BUILD_PERLRTE BUILD 5.6 NOCHECK
$    DEASSIGN /PROCESS PERL_ROOT
$    EXIT
$ ENDIF
$!
$ SAY ""
$ SAY "Building ""PERLRTE"" for ""''F$GETSYI("ARCH_NAME")'"" architecture"
$ SAY "Using PERL_ROOT of " + f$trnlnm("PERL_ROOT") - ".]" + "]"
$!
$ ARCH_NAME = F$EDIT(F$GETSYI("ARCH_NAME"),"UPCASE")
$ IF ARCH_NAME .EQS. "ALPHA" THEN ARCH_NAME = "AXP"
$!
$ IF P2 .NES. "" .AND. P2 .NES. "5.6" .AND. P2 .NES. "5.8"
$ THEN
$    WRITE SYS$OUTPUT "''P2' is an unknown version of Perl!"
$    EXIT
$ ENDIF
$ RTENG = ""
$ IF P1 .EQS. "5.6" .OR. P2 .EQS. "5.6" THEN RTENG = "56"
$ IF P1 .EQS. "5.8" .OR. P2 .EQS. "5.8" THEN RTENG = "58"
$!
$ IF P3 .EQS. "NOCHECK" THEN GOTO BUILD_PERLRTE
$!
$ SET NOON
$ PERLV = ""
$ PERL -v > SYS$SCRATCH:BUILD_PERLRTE.TXT
$ DEFINE /USER SYS$OUTPUT NL:
$ DEFINE /USER SYS$ERROR NL:
$ SEARCH SYS$SCRATCH:BUILD_PERLRTE.TXT "v5.8"
$ IF $SEVERITY .EQS. "1" THEN PERLV = "58"
$ DEFINE /USER SYS$OUTPUT NL:
$ DEFINE /USER SYS$ERROR NL:
$ SEARCH SYS$SCRATCH:BUILD_PERLRTE.TXT "v5.6"
$ IF $SEVERITY .EQS. "1" THEN PERLV = "56"
$ DEFINE /USER SYS$OUTPUT NL:
$ DEFINE /USER SYS$ERROR NL:
$ SEARCH SYS$SCRATCH:BUILD_PERLRTE.TXT "v5.6.0"
$ IF $SEVERITY .EQS. "1"
$ THEN
$    SAY ""
$    SAY "There are some issues with Perl 5.6.0 and CGI.pm!"
$    SAY ""
$ ENDIF
$ IF PERLV .EQS. ""
$ THEN
$    SAY ""
$    SAY "COULD NOT DETERMINE CURRENT VERSION OF PERL!"
$    SAY ""
$    EXIT
$ ENDIF
$ DELETE = "DELETE/NOLOG/NOCONFIRM"
$ DELETE SYS$SCRATCH:BUILD_PERLRTE.TXT;*
$ SET ON
$!
$ IF PERLV .EQS. "58" .AND. RTENG .EQS. "" THEN RTENG = "58"
$ IF PERLV .EQS. "56" .AND. RTENG .EQS. "" THEN RTENG = "56"
$ IF PERLV .NES. "58" .AND. RTENG .EQS. "58"
$ THEN
$    SAY ""
$    SAY "A BUILD FOR 5.8 HAS BEEN REQUESTED, BUT PERL REPORTS A DIFFERENT VERSION!"
$    PERL -v
$    EXIT
$ ENDIF
$ IF PERLV .NES. "56" .AND. RTENG .EQS. "56"
$ THEN
$    SAY ""
$    SAY "A BUILD FOR 5.6 HAS BEEN REQUESTED, BUT PERL REPORTS A DIFFERENT VERSION!"
$    PERL -v
$    EXIT
$ ENDIF
$!
$ BUILD_PERLRTE:
$!
$ IF RTENG .EQS. "56"
$    THEN DEFINES = "/DEFINE=(CGILIB_OBJECT_MODULE,PERLRTENG_56)"
$    ELSE DEFINES = "/DEFINE=(CGILIB_OBJECT_MODULE)"
$ ENDIF
$ WARNINGS = "/WARNING=(DISABLE=(PREOPTW))"
$ INCLUDES = "/INCLUDE=(HT_ROOT:[SRC.MISC])"
$ PERL_INCLUDES = "/INCLUDE=(PERL_ROOT:[000000])"
$!
$ IF F$SEARCH("OBJ_''ARCH_NAME'.DIR") .EQS. "" -
     THEN CREATE /DIR [.OBJ_'ARCH_NAME']
$ OBJECT_DIR = "[.OBJ_''ARCH_NAME']"
$!
$ IF F$EDIT(F$GETSYI("ARCH_NAME"),"UPCASE") .EQS. "VAX"
$ THEN
$    CC_OPTIONS = "/DECC /OPTIMIZE /STANDARD=RELAXED" + WARNINGS + DEFINES
$ ELSE
$    CC_OPTIONS = "/DECC /OPTIMIZE /STANDARD=RELAXED" + WARNINGS + DEFINES
$ ENDIF
$!
$ IF P1 .EQS. "" .OR. P1 .EQS. "BUILD" .OR. P1 .EQS. "COMPILE"
$ THEN
$!
$    IF F$INTEGER(F$EXTRACT(1,1,F$GETSYI("NODE_SWVERS"))) .LT. 7
$    THEN
$       WRITE SYS$OUTPUT "Build requires at least VMS V7.n"
$       EXIT
$    ENDIF
$    IF F$TRNLNM("PERL_ROOT") .EQS. ""
$    THEN
$       WRITE SYS$OUTPUT "Cannot compile, ""PERL_ROOT"" not detected."
$       EXIT
$    ENDIF
$    IF F$SEARCH("PERL_ROOT:[000000]PERL.H") .EQS. "" .OR. -
        F$SEARCH("PERL_ROOT:[000000]EXTERN.H") .EQS. ""
$    THEN
$       WRITE SYS$OUTPUT "Cannot build, required header files are not available."
$       EXIT
$    ENDIF
$!
$    SET NOON
$    SET VERIFY
$    CC 'CC_OPTIONS''INCLUDES' /OBJECT='OBJECT_DIR'PERLRTE PERLRTE
$    CC 'CC_OPTIONS''PERL_INCLUDES' /OBJECT='OBJECT_DIR'PERLRTENG'RTENG' PERLRTENG
$!   'F$VERIFY(0)
$    SET ON
$ ENDIF
$!
$ IF P1 .EQS. "" .OR. P1 .EQS. "BUILD" .OR. P1 .EQS. "LINK"
$ THEN
$!
$    IF F$TRNLNM("PERLSHR") .EQS. ""
$    THEN
$       WRITE SYS$OUTPUT "Cannot link, ""PERLSHR"" not detected."
$       EXIT
$    ENDIF
$!
$    CGILIB_OLB = "HT_ROOT:[SRC.MISC.OBJ_''ARCH_NAME']CGILIB.OLB"
$    SET NOON
$    SET VERIFY
$    LINK /NOTRACEBACK /EXECUTABLE=HT_EXE:PERLRTE.EXE -
     'OBJECT_DIR'PERLRTE,'OBJECT_DIR'PERLRTENG'RTENG', -
     'CGILIB_OLB'/LIBRARY, -
     SYS$INPUT:/OPTIONS
PERLSHR/Share
$!   'F$VERIFY(0)
$    SET ON
$ ENDIF
$ PURGE /NOLOG 'OBJECT_DIR'
$!
$!-----------------------------------------------------------------------------
