# CGIplusPM_example1.pl
#
# Simple example that just prints the CGI variables, then demonstrates how
# to retrive variable values using the CGIplus module 'var' subroutine.
# May be invoked using either /cgi-bin/cpipluspm_example1 for standard CGI
# environment or using /CGIplus-bin/cpipluspm_example1 for CGIplus environment.
#
# COPYRIGHT
# ---------
# Copyright (C) 2000-2003 Mark G.Daniel
# This program, comes with ABSOLUTELY NO WARRANTY.
# This is free software, and you are welcome to redistribute it
# under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
# 
# VERSION HISTORY
# ----------------
# 04-JAN-2003  MGD  CGI variables now (also) available from $ENV
# 31-MAY-2000  MGD  initial
#------------------------------------------------------------------------------

require "HT_ROOT:[SRC.PERL]CGIplus.PM";

# change this to false to retain (any) "WWW_" on CGI variable names
#CGIplus::stripWWW(1);

# change this to true to coerce all CGIplus::var() to have a leading "WWW_"
#CGIplus::usingWWW(0);

# pass the reference of the example function to the CGIplus processor
CGIplus::process(\&exampleScript);

#------------------------------------------------------------------------------
# all the work is done in this function

sub exampleScript
{
   printf ("Content-Type: text/plain
Expires: Fri, 13 Jan 1978 14:00:00 GMT

");

   if (CGIplus::isCGIplus())
   {
      if ($ENV{'QUERY_STRING'} eq "eoj")
      {
         printf ("Bye! (after %d requests)\n", CGIplus::usageCount());
         exit;
      }
   }

   CGIplus::varPrint();

   # show that the $ENV associative array and CGIPlus::var() are identical
   printf ("\nDemonstrate that the CGIplus::var() function and \$ENV associative array contents are identical ...\n");
   printf ("\n\$ENV{'SCRIPT_NAME'}  |%s|\n", $ENV{'SCRIPT_NAME'});
   printf ("CGIplus::var('SCRIPT_NAME')  |%s|\n", CGIplus::var('SCRIPT_NAME'));
   printf ("\n\$ENV{'PATH_INFO'}    |%s|\n", $ENV{'PATH_INFO'});
   printf ("CGIplus::var('PATH_INFO'}    |%s|\n", CGIplus::var('PATH_INFO'));
   printf ("\n\$ENV{'QUERY_STRING'} |%s|\n", $ENV{'QUERY_STRING'});
   printf ("CGIplus::var('QUERY_STRING') |%s|\n\n", CGIplus::var('QUERY_STRING'));

   if ($ENV{'SERVER_SOFT'} eq undef) {
      printf ("SERVER_SOFT does not exist and looks like an empty string ...\n");
   }
   printf ("SERVER_SOFT |%s|\n\n", $ENV{'SERVER_SOFT'});

   if ($ENV{'SERVER_SOFTWARE'} ne undef) {
      printf ("SERVER_SOFTWARE should exist ...\n");
   }
   printf ("SERVER_SOFTWARE |%s|\n", $ENV{'SERVER_SOFTWARE'});
}

#------------------------------------------------------------------------------

