/*****************************************************************************/
/*
                                 AddrList.c

Module supporting the yahMAIL address list functionality.  Public address lists
are flat files (VMS mailing lists) located by configuration file directive. 
Private address lists are flat files located in the user's profile mail
directory.


COPYRIGHT
---------
Copyright (C) 1999-2003 Mark G.Daniel
This program, comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.


VERSION HISTORY
---------------
25-MAR-2002  MGD  bugfix; language specific refinements
19-FEB-2000  MGD  unbundled from YAHMAIL.C for v1.3
*/

/*****************************************************************************/

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

/* standard C header files */
#include <ctype.h>
#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stat.h>

/* VMS related header files */
#include <descrip.h>
#include <fscndef.h>
#include <rmsdef.h>
#include <ssdef.h>
#include <stsdef.h>

/* application header file */
#include "yahmail.h"
#include "externs.h"

#define FI_LI __FILE__, __LINE__

/*****************************************************************************/
/*
Address list selection page.  A <SELECT><SELECT> list is generated from the
newline-separated entries text pointed at by 'ConfigAddrListPtr' and by
searching the user's mail directory for files ending in ".DIS".  Address list
files, quite deliberately, must be located in the user's mail directory and may
only end with ".DIS".  These helps prevent wholesale access to any old file.
*/

AddrListSelect ()
       
{
   int  status,
        FileCount;
   unsigned long  FindFileCtx;
   unsigned short  NameLength;
   char  *cptr, *sptr,
         *NamePtr;
   char  FileName [256],
         FileSpec [256],
         ListName [256];
   $DESCRIPTOR (FileSpecDsc, FileSpec);
   $DESCRIPTOR (FileNameDsc, FileName);
   struct
   {
      short int  com_len;
      short int  item;
      void  *com_addr;
   } FileScanItem [] = {
      { 0, FSCN$_NAME, 0 },
      { 0, 0, 0 }
   };

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "AddrListSelect()\n");

   CgiLibResponseHeader (200, "text/html");
   fprintf (stdout,
"<HTML>\n\
<HEAD>\n\
<META NAME=\"generator\" CONTENT=\"%s\">\n\
<META NAME=\"environment\" CONTENT=\"%s\">\n\
<META NAME=\"language\" CONTENT=\"%s %s\">\n\
<TITLE>yahMAIL ... %s: %s</TITLE>\n\
</HEAD>\n\
<BODY onLoad=\"self.focus()\" %s>\n\
%s\
<B><FONT SIZE=+1><U>%s: &nbsp;%s</FONT></U></B>\n\
<BR>&nbsp;<FONT SIZE=-1>yahMAIL<SUP>*</SUP></FONT>\n\
<FORM ACTION=\"%s\">\n\
<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR><TD>\n\
&nbsp;<SELECT NAME=lse SIZE=5>\n",
      SoftwareID, CgiEnvironmentPtr, lang_Language, lang_LanguageAuthor,
      lang_ListAddressPlural, MailUserName,
      ConfigBodyTagPtr, PostMasterWarningPtr,
      lang_ListAddressPlural, MailUserName,
      ActionPathInfo);

   /* lists specified as part of the configuration */
   cptr = ConfigAddrListPtr;
   while (*cptr)
   {
      while (*cptr && isspace(*cptr)) cptr++;
      if (!*cptr) break;
      sptr = ListName;
      while (*cptr && !isspace(*cptr)) *sptr++ = tolower(*cptr++);
      *sptr = '\0';
      fprintf (stdout, "<OPTION VALUE=\"!%s\">&nbsp;%s&nbsp;</A>\n",
               ListName, ListName);
      while (*cptr && *cptr != '\n') cptr++;
      if (*cptr) cptr++;
   }

   /* files ending in ".DIS" in the user's mail directory */
   strcpy (FileSpec, VmsMailUserFullDirectory);
   strcat (FileSpec, "*.DIS;0");
   FileSpecDsc.dsc$w_length = strlen(FileSpec);
   if (Debug) fprintf (stdout, "|%s|\n", FileSpec);

   FindFileCtx = FileCount = 0;
   for (;;)
   {
      FileNameDsc.dsc$w_length = sizeof(FileName)-1;
      status = lib$find_file (&FileSpecDsc, &FileNameDsc, &FindFileCtx,
                              0, 0, 0, 0);
      if (Debug) fprintf (stdout, "lib$find_file() %%X%08.08X\n", status);
      if (VMSnok (status)) break;

      FileCount++;

      FileName[FileNameDsc.dsc$w_length] = '\0';
      for (cptr = FileName; *cptr && !isspace(*cptr); cptr++);
      FileNameDsc.dsc$w_length = cptr - FileName;
      FileName[FileNameDsc.dsc$w_length] = '\0';
      if (Debug) fprintf (stdout, "|%s|\n", FileNameDsc.dsc$a_pointer);

      status = sys$filescan (&FileNameDsc, &FileScanItem, 0, 0, 0);
      if (Debug) fprintf (stdout, "sys$filescan() %%X%08.08X\n", status);
      if (VMSnok (status)) break;
      strncpy (ListName, FileScanItem[0].com_addr, FileScanItem[0].com_len);
      ListName[FileScanItem[0].com_len] = '\0';
      if (Debug) fprintf (stdout, "|%s|\n", ListName);

      fprintf (stdout, "<OPTION VALUE=\"%s\">&nbsp;%s&nbsp;</A>\n",
               ListName, ListName);
   }
   lib$find_file_end (&FindFileCtx);

   /* if no user address list files the "suggest" 'YAHMAIL' :^) */
   if (!FileCount)
      fprintf (stdout,
"<OPTION VALUE=\"YAHMAIL\">&nbsp;YAHMAIL&nbsp;</A>\n");

   fprintf (stdout,
"</SELECT>\n\
<BR>&nbsp;<INPUT TYPE=text SIZE=20 NAME=lte>\
&nbsp;<I>%s</I>\n\
</TD></TR>\n\
</TABLE>\n\
<P><INPUT TYPE=hidden NAME=wha VALUE=\"lis\">\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\">&nbsp;&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"location.reload(true)\">&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"window.close()\">\n\
</FORM>\n\
<P>%s\n\
</BODY>\n\
</HTML>\n",
      lang_ListName, lang_BtnAccess, lang_BtnRefresh, lang_BtnClose,
      ConfigAddrListFooterPtr);
}

/*****************************************************************************/
/*
Display the contents of an address list file in a <TEXTAREA></TEXTAREA> tag. 
This allows changes to be made and updated as well as all or selected addresses
to be edit/copied, then edit/pasted elsewhere (e.g. into the "To:" field when
sending).
*/

AddrListAccess ()
       
{
   boolean  UserList;
   int  status,
        ListLength;
   char  ConfigListName [256],
         FileName [256],
         ListFileName [256],
         ListName [256];
   char  *cptr, *sptr,
         *EscapedListPtr,
         *NewListPtr,
         *ListNamePtr,
         *ListPtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "AddrListAccess()\n");

   ListNamePtr = CgiLibVar ("WWW_FORM_LTE");
   if (!ListNamePtr[0])
      ListNamePtr = CgiLibVar ("WWW_FORM_LSE");
   if (!ListNamePtr[0])
   {
      CgiLibResponseError (FI_LI, 0,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"window.close()\">\n\
</FORM>",
         lang_ErrListNotSpecified, lang_BtnGoBack, lang_BtnClose);
      return;
   }

   if (ListNamePtr[0] == '!')
   {
      /* configuration (global) address list */
      UserList = false;

      FileName[0] = '\0';
      cptr = ConfigAddrListPtr;
      while (*cptr)
      {
         while (*cptr && isspace(*cptr)) cptr++;
         if (!*cptr) break;
         sptr = ConfigListName;
         while (*cptr && !isspace(*cptr)) *sptr++ = *cptr++;
         *sptr = '\0';
         if (Debug) fprintf (stdout, "ConfigListName |%s|\n", ConfigListName);
         if (strsame (ListNamePtr+1, ConfigListName, -1))
         {
            while (*cptr && isspace(*cptr)) cptr++;
            sptr = FileName;
            while (*cptr && !isspace(*cptr)) *sptr++ = *cptr++;
            *sptr = '\0';
         }
         while (*cptr && *cptr != '\n') cptr++;
         if (*cptr) cptr++;
      }
   }
   else
   {
      /* user (private) address list */
      UserList = true;

      sptr = ListName;
      for (cptr = ListNamePtr; *cptr; cptr++)
      {
         if (isalnum(*cptr) || *cptr == '-' || *cptr == '_' || *cptr == '$')
            *sptr++ = toupper(*cptr);
         else
            *sptr++ = '_';
      }
      *sptr = '\0';

      strcpy (FileName, VmsMailUserFullDirectory);
      strcat (FileName, ListName);
      strcat (FileName, ".DIS");
   }

   status = ReadFileIntoMemory (FileName, &ListPtr, &ListLength);
   NewListPtr = "";
   if (VMSnok (status))
   {
      if (status == SS$_NOSUCHFILE || status == RMS$_FNF)
      {
         if (UserList)
         {
            NewListPtr =
"&nbsp;&nbsp;&nbsp;<FONT COLOR=\"#ff0000\">%s</FONT>\n";
            ListPtr = "";
            ListLength = 0;
         }
         else
         {
            CgiLibResponseError (FI_LI, 0,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"window.close()\">\n\
</FORM>",
               lang_ErrListNotFound, lang_BtnGoBack, lang_BtnClose);
            return;
         }
      }
      else
      {
         CgiLibResponseError (FI_LI, status,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"window.close()\">\n\
</FORM>",
         FileName, lang_BtnGoBack, lang_BtnClose);
         return;
      }
   }

   EscapedListPtr = (char*)CgiLibHtmlEscape (ListPtr, -1, NULL, -1);
   free (ListPtr);

   CgiLibResponseHeader (200, "text/html");
   fprintf (stdout,
"<HTML>\n\
<HEAD>\n\
<META NAME=\"generator\" CONTENT=\"%s\">\n\
<META NAME=\"environment\" CONTENT=\"%s\">\n\
<META NAME=\"language\" CONTENT=\"%s %s\">\n\
<TITLE>yahMAIL ... %s: %s / %s</TITLE>\n\
</HEAD>\n\
<BODY %s>\n\
%s\
<B><FONT SIZE=+1><U>%s: &nbsp;%s / %s</FONT></U>%s</B>\n\
<BR>&nbsp;<FONT SIZE=-1>yahMAIL<SUP>*</SUP></FONT>\n\
<FORM ACTION=\"%s\" METHOD=POST>\n\
<INPUT TYPE=hidden NAME=lse VALUE=\"%s\">\n\
<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR><TD>\n\
<TEXTAREA NAME=txt ROWS=16 COLS=48 WRAP=off>\n\
%s\
</TEXTAREA>\n\
</TD></TR>\n\
</TABLE>\n",
      SoftwareID, CgiEnvironmentPtr, lang_Language, lang_LanguageAuthor,
      lang_ListAddressSingular, UserList ? MailUserName : "yahMAIL",
                                UserList ? ListName : ListNamePtr+1,
      ConfigBodyTagPtr, PostMasterWarningPtr,
      lang_ListAddressSingular, UserList ? MailUserName : "yahMAIL",
                                UserList ? ListName : ListNamePtr+1,
      NewListPtr, ActionPathInfo, ListName,
      EscapedListPtr);

   if (UserList)
      fprintf (stdout,
"<P><INPUT TYPE=hidden NAME=wha VALUE=\"lis\">\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\">&nbsp;\n\
<INPUT TYPE=reset VALUE=\"%s\">\
<I> ... %s</I>&nbsp;\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\">\n",
         lang_BtnUpdate, lang_BtnReset, lang_ResetCaution, lang_BtnRemove);

   fprintf (stdout,
"<P><INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"window.close()\">\n\
</FORM>\n\
<P>%s\n\
</BODY>\n\
</HTML>\n",
      lang_BtnGoBack, lang_BtnClose,
      ConfigAddrListFooterPtr);

   free (EscapedListPtr);
}

/*****************************************************************************/
/*
Write the contents of the address list sent from AddrListAccess() into the
appropriate file in the user's mail directory.
*/

AddrListUpdate ()
       
{
   int  status,
        PostBufferCount;
   char  FileName [256],
         ListName [256];
   char  *cptr, *sptr,
         *ListNamePtr,
         *ListTextPtr,
         *PostBufferPtr;
   FILE  *FilePtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "AddrListUpdate()\n");

   CgiLibReadRequestBody (&PostBufferPtr, &PostBufferCount);
   CgiLibFormRequestBody (PostBufferPtr, PostBufferCount);
   free (PostBufferPtr);
   if (Debug)
      while ((cptr = CgiLibVarNull ("*")) != NULL)
         fprintf (stdout, "|%s|\n", cptr);

   ListNamePtr = CgiLibVar ("WWW_FORM_LTE");
   if (!ListNamePtr[0])
      ListNamePtr = CgiLibVar ("WWW_FORM_LSE");

   sptr = ListName;
   for (cptr = ListNamePtr; *cptr; cptr++)
   {
      if (isalnum(*cptr) || *cptr == '_' || *cptr == '_' || *cptr == '$')
         *sptr++ = toupper(*cptr);
      else
         *sptr++ = '_';
   }
   *sptr = '\0';

   strcpy (FileName, VmsMailUserFullDirectory);
   strcat (FileName, ListNamePtr);
   strcat (FileName, ".DIS");

   ListTextPtr = CgiLibVar ("WWW_FORM_TXT");

   FilePtr = fopen (FileName, "w", "shr=nil");
   if (FilePtr == NULL)
   {
      status = vaxc$errno;
      if (Debug) fprintf (stdout, "fopen() %%X%08.08X\n", status);
      return;
   }

   if (fputs (ListTextPtr, FilePtr) == EOF)
   {
      status = vaxc$errno;
      CgiLibResponseError (FI_LI, status,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"window.close()\">\n\
</FORM>",
      FileName, lang_BtnGoBack, lang_BtnClose);
   }
   else
   {
      /* purge the versions back to a maximum of 3 */
      strcat (FileName, ";-3");
      while (!remove (FileName));

      CgiLibResponseSuccess (
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"window.close()\">\n\
</FORM>",
         lang_ListUpdated, lang_BtnGoBack, lang_BtnClose);
   }

   fclose (FilePtr);
}

/*****************************************************************************/
/*
Delete the address list file from the user's mail directory.
*/

AddrListRemove ()
       
{
   int  status;
   char  FileName [256],
         ListName [256];
   char  *cptr, *sptr,
         *ListNamePtr,
         *ListTextPtr;
   FILE  *FilePtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "AddrListRemove()\n");

   ListNamePtr = CgiLibVar ("WWW_FORM_LTE");
   if (!ListNamePtr[0])
      ListNamePtr = CgiLibVar ("WWW_FORM_LSE");

   sptr = ListName;
   for (cptr = ListNamePtr; *cptr; cptr++)
   {
      if (isalnum(*cptr) || *cptr == '_' || *cptr == '_' || *cptr == '$')
         *sptr++ = toupper(*cptr);
      else
         *sptr++ = '_';
   }
   *sptr = '\0';

   strcpy (FileName, VmsMailUserFullDirectory);
   strcat (FileName, ListNamePtr);
   strcat (FileName, ".DIS;*");

   if (remove (FileName))
   {
      status = vaxc$errno;
      CgiLibResponseError (FI_LI, status,
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"window.close()\">\n\
</FORM>",
      FileName, lang_BtnGoBack, lang_BtnClose);
   }
   else
   {
      CgiLibResponseSuccess (
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"window.close()\">\n\
</FORM>",
         lang_ListRemoved, lang_BtnGoBack, lang_BtnClose);
   }
}

/*****************************************************************************/

                                                                                                                                                       G         DECC$STRLEN     4 \              b#         DECC$STRLEN     4 [              @         DECC$STRLEN     4 [            G   $      DECC$STRLEN     4 \              b#         DECC$STRLEN     4 [               @   $      DECC$STRLEN     4 [      0      G   H      DECC$STRLEN     4 \      4        b#         DECC$STRLEN     4 [      D        @   H      DECC$STRLEN     4 [      T      G   t      DECC$STRLEN     4 \      X        b#         DECC$STRLEN     4 [      p        @   t      DECC$STRLEN      4 [            G         DECC$STRLEN     4 \              b#         DECC$STRLEN     4 [              @         DECC$STRLEN     4 [            G         DECC$STRLEN     4 \              b#         DECC$STRLEN     4 [              @         DECC$STRLEN     4 [      ȇ      G         DECC$STRLEN     4 \      ̇        b#         DECC$STRLEN     4 [              @         DECC$STRLEN     4 [            G         DECC$STRLEN     4 \              b#         DECC$STRLEN     4 [              @         DECC$STRLEN     4 [            G   ,      DECC$STRLEN     4 \              b#         DECC$STRLEN     4 [      (        @   ,      DECC$STRLEN     4 c      ,      G   D      DECC$INET_ADDR  4 d      <        b#         DECC$INET_ADDR  4 c      @        @   D    