/*****************************************************************************/
/*
                                 lang.h

This header file essentially just provide external references for all the
language-specific text.  See LANG_EN.C for further detail and instructions on
creating a different language specific module.


VERSION HISTORY
---------------
08-FEB-2003  MGD  v1.6.4, add lang_BrowseReplyTo, lang_MsgReplyTo 
15-JUN-2002  MGD  v1.6.3, add lang_NoCc, lang_NoSubject,
                              lang_BrowseEncoding88, lang_BrowseEncoding8Q,
                              lang_BrowseEncodingIQ, lang_BrowseEncodingI8
25-MAR-2002  MGD  v1.5.4, add lang_Bottom, lang_Top, lang_ListName,
                              lang_ProDisabled, lang_ProEnabled
03-NOV-2000  MGD  v1.4.0, add lang_BtnReload, lang_WrapLongLines
14-JUN-2000  MGD  v1.3.1, add lang_ErrSendSubjBody
09-APR-2000  MGD  v1.3.0, add lang_ResponseErrorMessage,
                              lang_ResponseSuccessMessage,
                          remove lang_ResponseReportedByServer
19-FEB-2000  MGD  v1.3.0B2, add lang_AttachmentsMax,
                                lang_BrowseCreateTextArea,
                                lang_BrowseCreateTextAreaRows,
                                lang_BtnGoBackToFolder,
                                lang_ErrPreEditedNotText,
                                lang_PreEditedMessage,
                                lang_SoAndSoWrote
19-FEB-2000  MGD  v1.3.0, add lang_AttachmentsMax,
                              lang_BrowseCreateTextArea,
                              lang_BrowseCreateTextAreaRows,
                              lang_BtnGoBackToFolder,
                              lang_PreEditedMessage,
                              lang_SoAndSoWrote
27-JAN-2000  MGD  v1.2.0, add lang_ChkAllId
22-DEC-1999  MGD  v1.1.0, add lang_BtnToNewMail
                              lang_BtnEmptyWasteBasket, lang_BtnToSent,
                              lang_BtnToMail, lang_BtnToWasteBasket,
                              lang_BrowseCreateSendButton,
                              lang_BrowseFolderButtons,
                              lang_BrowseMailFolderButtons,
                              lang_BrowsePickFields,
                              lang_BrowseUserFolderButtons
29-AUG-1999  MGD  v1.0.B3, add lang_Response...
                           add lang_MimeAlternative
19-AUG-1999  MGD  v1.0.B2, initial development
*/

/*****************************************************************************/

#ifndef LANG_H_LOADED
#define LANG_H_LOADED

extern char

   lang_Language [],
   lang_LanguageName [],
   lang_LanguageAuthor [],
   lang_Charset [],
   
   /****************/
   /* message read */
   /****************/
   
   lang_MsgCc [],
   lang_MsgDate [],
   lang_MsgFrom [],
   lang_MsgMessage [],
   lang_MsgReplyTo [],
   lang_MsgStatus [],
   lang_MsgSubj [],
   lang_MsgTo [],
   
   /*****************/
   /* folder browse */
   /*****************/

   lang_BrowseAllItems [],
   lang_BrowseCreateSendButton [],
   lang_BrowseCreateTextArea [],
   lang_BrowseCreateTextAreaRows [],
   lang_BrowseEncoding [],
   lang_BrowseEncoding88 [],
   lang_BrowseEncoding8Q [],
   lang_BrowseEncodingIQ [],
   lang_BrowseEncodingI8 [],
   lang_BrowseItem [],
   lang_BrowseFolder [],
   lang_BrowseFolderButtons [],
   lang_BrowseFolderName [],
   lang_BrowseNewMailCheck [],
   lang_BrowseNewMailDisabled [],
   lang_BrowseNewMailMinutes [],
   lang_BrowsePick [],
   lang_BrowsePickFields [],
   lang_BrowseRelated [],
   lang_BrowseReplyTo [],
   lang_BrowseMailFolderButtons [],
   lang_BrowseUserFolderButtons [],
   lang_BrowseWindow [],

   /***********/
   /* buttons */
   /***********/
   
   lang_BtnAccess [],
   lang_BtnBinary [],
   lang_BtnChangeProfile [],
   lang_BtnClear [],
   lang_BtnClose [],
   lang_BtnCopy [],
   lang_BtnCreateSend [],
   lang_BtnCreateUserProfile [],
   lang_BtnDeleteUserProfile [],
   lang_BtnDelete [],
   lang_BtnEmptyWasteBasket [],
   lang_BtnForeign [],
   lang_BtnForward [],
   lang_BtnGoBack [],
   lang_BtnGoBackToFolder [],
   lang_BtnAddressLists [],
   lang_BtnMove [],
   lang_BtnToMail [],
   lang_BtnToNewMail [],
   lang_BtnToSent [],
   lang_BtnToWasteBasket [],
   lang_BtnNext [],
   lang_BtnPrevious [],
   lang_BtnOpen [],
   lang_BtnRefresh [],
   lang_BtnReload [],
   lang_BtnRemove [],
   lang_BtnReply [],
   lang_BtnReset [],
   lang_BtnSend [],
   lang_BtnSet [],
   lang_BtnSetupHide [],
   lang_BtnSetupShow [],
   lang_BtnText [],
   lang_BtnUpdate [],
   
   /*******************/
   /* checkbox labels */
   /*******************/
   
   lang_ChkAllId [],
   lang_ChkInclude [],
   lang_ChkQuote [],
   lang_ChkSaveAsFile [],
   lang_ChkMessage [],
   
   /****************/
   /* user profile */
   /****************/
   
   lang_ProUserProfile [],
   lang_ProUserProfileList [],
   lang_ProAutoPurge [],
   lang_ProCcPrompt [],
   lang_ProCopyFwd [],
   lang_ProCopyReply [],
   lang_ProCopySend [],
   lang_ProDisabled [],
   lang_ProEditor [],
   lang_ProEnabled [],
   lang_ProForwarding [],
   lang_ProPersonalName [],
   lang_ProPrintQueue [],
   lang_ProPrintForm [],
   lang_ProSignatureFile [],
   lang_ProNewMessages [],
   lang_ProfileCreated [],
   lang_ProfileDeleted [],
   lang_ProfileUpdated [],
   lang_SigFileUpdated [],
   
   /****************/
   /* address list */
   /****************/

   lang_ListAddressPlural [],
   lang_ListAddressSingular [],
   lang_ListName [],
   lang_ListNotFound [],
   lang_ListNotSpecified [],
   lang_ListRemoved [],
   lang_ListUpdated [],

   /*********/
   /* error */
   /*********/
   
   lang_ErrBinStdout [],
   lang_ErrCgiPlusMunpack [],
   lang_ErrConfigRestriction [],
   lang_ErrCurrentMessageCount [],
   lang_ErrFoldersIdentical [],
   lang_ErrGenerateFolderList [],
   lang_ErrGenerateMessageList [],
   lang_ErrGenerateUserList [],
   lang_ErrGetUserInfo [],
   lang_ErrInternalLimit [],
   lang_ErrListNotFound [],
   lang_ErrListNotSpecified [],
   lang_ErrMailIllegalPersonal [],
   lang_ErrMailMessageNotFound [],
   lang_ErrMailNoSuchUser [],
   lang_ErrMailNoSuchFolder [],
   lang_ErrMailOpening [],
   lang_ErrMessageDelete [],
   lang_ErrMessageForeign [],
   lang_ErrMessageMove [],
   lang_ErrMessageNotSelected [],
   lang_ErrMessageRead [],
   lang_ErrPreEditedNotText [],
   lang_ErrOpenMail [],
   lang_ErrSanityCheck [],
   lang_ErrSendInvalidUser [],
   lang_ErrSendMailAddressOvf [],
   lang_ErrSendNetworkLink [],
   lang_ErrSendNoSuchUser [],
   lang_ErrSendParsing [],
   lang_ErrSendRecipient [],
   lang_ErrSendSubjBody [],
   lang_ErrSendTransport [],
   lang_ErrSetUserAutoPurge [],
   lang_ErrSetUserCcPrompt [],
   lang_ErrSetUserCopyForward [],
   lang_ErrSetUserCopyReply [],
   lang_ErrSetUserCopySend [],
   lang_ErrSetUserEditor [],
   lang_ErrSetUserForm [],
   lang_ErrSetUserForwarding [],
   lang_ErrSetUserNewMessages [],
   lang_ErrSetUserPersonalName [],
   lang_ErrSetUserQueue [],
   lang_ErrSetUserSigFile [],
   lang_ErrSigFileNoName [],
   lang_ErrSigFileOpen [],
   lang_ErrUserCreate [],
   lang_ErrUserCreateForward [],
   lang_ErrUserDelete [],
   lang_ErrUserNoName [],

   /*********/
   /* other */
   /*********/

   lang_AddressLists [],
   lang_AttachmentsMax [],
   lang_AttachmentPlural [],
   lang_AttachmentSingular [],
   lang_AsAtDateTime [],
   lang_AutoWrap [],
   lang_CcSelf [],
   lang_CreateNew [],
   lang_PreEditedMessage [],
   lang_CurrentlyUnavailable [],
   lang_Entries [],
   lang_Header [],
   lang_NewMailBiff [],
   lang_NewMailBiffTitle [],
   lang_NoCc [],
   lang_NoSubject [],
   lang_NoMessages [],
   lang_NoMessagesSelected [],
   lang_Bottom [],
   lang_None [],
   lang_Top [],
   lang_MessageSent [],
   lang_MessagesCopied [],
   lang_MessagesDeleted [],
   lang_MessagesInNewMailPlural [],
   lang_MessagesInNewMailSingular [],
   lang_MessagesInNewMail [],
   lang_MessagesMoved [],
   lang_PostMaster [],
   lang_PostMasterWarning [],
   lang_ProfileUser [],
   lang_ResponseErrorMessage [],
   lang_ResponseErrorTitle [],
   lang_ResponseSuccessMessage [],
   lang_ResponseSuccessTitle [],
   lang_ResetCaution [],
   lang_SizeBytes [],
   lang_SizeRecords [],
   lang_SoAndSoWrote [],
   lang_WasteBasketPurged [],
   lang_WasteBasketEmpty [],
   lang_WrapLongLines [],

#ifdef YAHMAIL_MUNPACK

   /********/
   /* MIME */
   /********/

   lang_MimeAlternative [],
   lang_MimeAttachmentNotFound [],

#endif /* YAHMAIL_MUNPACK */

   lang_TheEnd [];

#endif /* LANG_H_LOADED */

/*****************************************************************************/

