/* (C) Copyright 1993,1994 by Carnegie Mellon University
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of Carnegie
 * Mellon University not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  Carnegie Mellon University makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/*
Copyright (c) 1991 Bell Communications Research, Inc. (Bellcore)

Permission to use, copy, modify, and distribute this material 
for any purpose and without fee is hereby granted, provided 
that the above copyright notice and this permission notice 
appear in all copies, and that the name of Bellcore not be 
used in advertising or publicity pertaining to this 
material without the specific, prior written permission 
of an authorized representative of Bellcore.  BELLCORE 
MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.  */
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "xmalloc.h"
#include "md5.h"

#ifdef YAHMAIL_MUNPACK

#include <errno.h>
#include <stdlib.h>
#include <string.h>

#define MGD_MODS 1

extern int  MunpackYahmailPutc;
extern int  Debug;

int  Munpack_To64OutBufferSize;
unsigned char  *Munpack_To64OutBufferPtr,
               *Munpack_To64OutBufferEndPtr,
               *Munpack_To64OutBufferStartPtr,
               *Munpack_To64BufferPtr,
               *Munpack_To64BufferEndPtr;
 
char* Munpack_to64 (char *BufferPtr, int BufferLength)
{
   if (Debug) fprintf (stdout, "Munpack_to64() %d\n", BufferLength);

   if (BufferLength <= 0) return ("");

   if (Munpack_To64OutBufferStartPtr != NULL)
      free (Munpack_To64OutBufferStartPtr);

   Munpack_To64OutBufferSize = 0;
   Munpack_To64OutBufferPtr =
      Munpack_To64OutBufferEndPtr =
      Munpack_To64OutBufferStartPtr = NULL,
 
   Munpack_To64BufferPtr = (unsigned char*)BufferPtr;
   Munpack_To64BufferEndPtr = (unsigned char*)BufferPtr + BufferLength;
   to64 (NULL, stdout, 0);
   *Munpack_To64OutBufferPtr = '\0';   
   if (Debug)
      fprintf (stdout, "%d |%s|\n",
               strlen((char*)Munpack_To64OutBufferStartPtr),
               Munpack_To64OutBufferStartPtr);

   return ((char*)Munpack_To64OutBufferStartPtr);
}

int Munpack_To64_getc (FILE *FilePtr)
{
   if (Munpack_To64BufferPtr >= Munpack_To64BufferEndPtr) return (EOF);
   return (*Munpack_To64BufferPtr++);
}

int Munpack_To64_putc (char ch, FILE *FilePtr)
{
   if (Munpack_To64OutBufferPtr >= Munpack_To64OutBufferEndPtr)
   {
      Munpack_To64OutBufferStartPtr =
          realloc (Munpack_To64OutBufferStartPtr,
                   Munpack_To64OutBufferSize+4096);
      if (Munpack_To64OutBufferStartPtr == NULL) exit (vaxc$errno);
      Munpack_To64OutBufferPtr = Munpack_To64OutBufferStartPtr +
                                 Munpack_To64OutBufferSize;
      Munpack_To64OutBufferSize += 4096;
      Munpack_To64OutBufferEndPtr = Munpack_To64OutBufferStartPtr +
                                    Munpack_To64OutBufferSize;
   }
   *Munpack_To64OutBufferPtr++ = ch;   
   return (ch);
}

/* this is only for to64() */
#undef getc
#undef putc
#define getc Munpack_To64_getc
#define putc Munpack_To64_putc

#endif /* YAHMAIL_MUNPACK */

static char basis_64[] =
   "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

int to64(infile, outfile, limit) 
FILE *infile, *outfile;
long limit;
{
    int c1, c2, c3, ct=0, written=0;

    if (limit && limit < 73) return 1;

    while ((c1 = getc(infile)) != EOF) {
        c2 = getc(infile);
        if (c2 == EOF) {
            output64chunk(c1, 0, 0, 2, outfile);
        } else {
            c3 = getc(infile);
            if (c3 == EOF) {
                output64chunk(c1, c2, 0, 1, outfile);
            } else {
                output64chunk(c1, c2, c3, 0, outfile);
            }
        }
        ct += 4;
        if (ct > 71) {
            putc('\n', outfile);
	    if (limit) {
		limit -= ct + 1;
		if (limit < 73) return 1;
	    }
	    written += 73;
            ct = 0;
        }
    }
    if (ct) {
	putc('\n', outfile);
	ct++;
    }
    return written + ct;
}

output64chunk(c1, c2, c3, pads, outfile)
FILE *outfile;
{
    putc(basis_64[c1>>2], outfile);
    putc(basis_64[((c1 & 0x3)<< 4) | ((c2 & 0xF0) >> 4)], outfile);
    if (pads == 2) {
        putc('=', outfile);
        putc('=', outfile);
    } else if (pads) {
        putc(basis_64[((c2 & 0xF) << 2) | ((c3 & 0xC0) >>6)], outfile);
        putc('=', outfile);
    } else {
        putc(basis_64[((c2 & 0xF) << 2) | ((c3 & 0xC0) >>6)], outfile);
        putc(basis_64[c3 & 0x3F], outfile);
    }
}

#ifdef YAHMAIL_MUNPACK

/* this is only for to64() */
#undef getc
#undef putc

/* the rest */
#define libc_putc putc
#define putc Munpack_putc

#endif /* YAHMAIL_MUNPACK */

char *md5contextTo64(context)
MD5_CTX *context;
{
    unsigned char digest[18];
    char encodedDigest[25];
    int i;
    char *p;

    MD5Final(digest, context);
    digest[sizeof(digest)-1] = digest[sizeof(digest)-2] = 0;

    p = encodedDigest;
    for (i=0; i < sizeof(digest); i+=3) {
	*p++ = basis_64[digest[i]>>2];
	*p++ = basis_64[((digest[i] & 0x3)<<4) | ((digest[i+1] & 0xF0)>>4)];
	*p++ = basis_64[((digest[i+1] & 0xF)<<2) | ((digest[i+2] & 0xC0)>>6)];
	*p++ = basis_64[digest[i+2] & 0x3F];
    }
    *p-- = '\0';
    *p-- = '=';
    *p-- = '=';
    return strsave(encodedDigest);
}    

char *md5digest(infile, len)
FILE *infile;
long *len;
{
    MD5_CTX context;
    char buf[1000];
    long length = 0;
    int nbytes;
    
    MD5Init(&context);

#ifdef YAHMAIL_MUNPACK

    while (nbytes = Munpack_fread(buf, 1, sizeof(buf))) {
	length += nbytes;
	MD5Update(&context, buf, nbytes);
    }
    Munpack_rewind();

#else /* YAHMAIL_MUNPACK */

    while (nbytes = fread(buf, 1, sizeof(buf), infile)) {
	length += nbytes;
	MD5Update(&context, buf, nbytes);
    }
    rewind(infile);

#endif /* YAHMAIL_MUNPACK */

    if (len) *len = length;
    return md5contextTo64(&context);
}
