/* (C) Copyright 1993,1994 by Carnegie Mellon University
 * All Rights Reserved.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of Carnegie
 * Mellon University not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  Carnegie Mellon University makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * CARNEGIE MELLON UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS, IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING
 * OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#ifdef YAHMAIL_MUNPACK

#define MGD_MODS 1

#endif /* YAHMAIL_MUNPACK */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>

#ifdef MGD_MODS

#  include <types.h>
#  include <unistd.h>

#ifdef YAHMAIL_MUNPACK
#  include <descrip.h>
#  include "./lang.h"
#endif /* YAHMAIL_MUNPACK */

#else /* MGD_MODS */

#  include <sys/types.h>
#  include <sys/param.h>

#endif /* MGD_MODS */

#include <netdb.h>
#include "xmalloc.h"
#include "common.h"

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

extern int errno;
extern char *malloc();
extern char *getenv();

int overwrite_files = 0;
int didchat;

/* The name of the file we're writing */
static char *output_fname = 0;

/* Characters that shouldn't be in filenames */
#define BADCHARS "!$&*()|\'\";<>[]{}?/`\\ \t"

#ifdef MGD_MODS

#ifdef YAHMAIL_MUNPACK

extern int  Debug,
            MunpackAttachmentCount,
            MunpackDoProcess,
            VmsMailMessageId;

extern char  *CgiHttpUserAgentPtr,
             *MunpackDescTextPtr,
             *MunpackMimeContentTypePtr,
             *MunpackNamePtr,
             *MunpackPartsTextPtr;

extern char  ActionPathInfo[],
             ActionQueryString[],
             MunpackCharset [];

#else /* YAHMAIL_MUNPACK */

extern int  Debug;
extern char  *SourceFileNamePtr;

#endif /* YAHMAIL_MUNPACK */

#endif /* MGD_MODS */


/* Generate a message-id */
char *os_genid()
{
    static int pid = 0;
    static time_t curtime;
    static char hostname[MAXHOSTNAMELEN+1];
    char *result;
    struct hostent *hp;
    

    if (pid == 0) {
	pid = getpid();
	time(&curtime);
	gethostname(hostname, sizeof(hostname));

	/* If we don't have a FQDN, try canonicalizing with gethostbyname */
	if (!strchr(hostname, '.')) {
	    hp = gethostbyname(hostname);
	    if (hp) {
		strcpy(hostname, hp->h_name);
	    }
	}
    }

    result = malloc(25+strlen(hostname));
    sprintf(result, "%d.%d@%s", pid, curtime++, hostname);
    return result;
}

/* Create and return directory for a message-id */
char *os_idtodir(id)
char *id;
{

#ifdef MGD_MODS
    /* always create in current directory */
    return ("");
#else /* MGD_MODS */

    static char buf[4096];
    char *p;

    if (getenv("TMPDIR")) {
	strcpy(buf, getenv("TMPDIR"));
    }
    else {
	strcpy(buf, "/usr/tmp");
    }
    strcat(buf, "/m-prts-");
    p = getenv("USER");
    if (!p) p = getenv("LOGNAME");
    if (!p) p = "x";
    strcat(buf, p);
    
    (void)mkdir(buf, 0700);

    p = buf + strlen(buf);
    *p++ = '/';
    while (*id && p < buf+sizeof(buf)-10 ) {
	if (isprint(*id) && !strchr(BADCHARS, *id)) *p++ = *id;
	id++;
    }
    *p = '\0';
    if (mkdir(buf, 0700) == -1 && errno != EEXIST) {
	perror(buf);
	return 0;
    }
    *p++ = '/';
    *p = '\0';
    return buf;
#endif /* MGD_MODS */
}

/*
 * We are done with the directory returned by os_idtodir()
 * Remove it
 */
os_donewithdir(dir)
char *dir;
{
#ifdef MGD_MODS
#else /* MGD_MODS */
    char *p;

    /* Remove trailing slash */
    p = dir + strlen(dir) - 1;
    *p = '\0';

    rmdir(dir);
#endif /* MGD_MODS */
}

/*
 * Create a new file, with suggested filename "fname".
 * "fname" may have come from an insecure source, so clean it up first.
 * It may also be null.
 * "contentType" is passed in for use by systems that have typed filesystems.
 * "flags" contains a bit pattern describing attributes of the new file.
 */

FILE *os_newtypedfile(fname, contentType, flags, contentParams)
char *fname;
char *contentType;
int flags;
params contentParams;
{
    char *p;
    static int filesuffix=0;
    char buf[128], *descfname=0;
    FILE *outfile = 0;

#ifdef MGD_MODS

    if (Debug)
       fprintf (stdout, "os_newtypedfile() |%s|%s|%d|\n",
                fname, contentType, flags);

#ifdef YAHMAIL_MUNPACK

    if (!fname && contentType)
    {
       /* handle non-"text/plain" unnamed message parts */
       static int  ContentsNumber = 1;
       static char  ContentsName [256];
       static $DESCRIPTOR (ContentsFaoDsc, "!AZ!UL.!AZ");
       static $DESCRIPTOR (ContentsDsc, ContentsName);
       unsigned short  Length;
       char  *cptr;

       for (cptr = contentType; *cptr && *cptr != '/'; cptr++);
       if (*cptr) cptr++;
       sys$fao (&ContentsFaoDsc, &Length, &ContentsDsc,
                lang_MimeAlternative, ContentsNumber, cptr);
       (fname = ContentsName)[Length] = '\0';
    }

    if (!fname || !contentType)
    {
       /* return "not-interested" in this part! */
       return (NULL);
    }

    fromiso_string (fname);

    if (MunpackDoProcess)
    {
       char  EncodedFname [256],
             EscapedFname [256],
             EscapedContentType [256];

       /* when pre-processing the number of attachments is of interest */
       MunpackAttachmentCount++;

       CgiLibHtmlEscape (fname, -1, EscapedFname, sizeof(EscapedFname));
       CgiLibHtmlEscape (contentType, -1, EscapedContentType,
                                          sizeof(EscapedContentType));

       /* create HTML links to each of the identified parts (in <PRE></PRE>) */
       if (strstr (CgiHttpUserAgentPtr, "MSIE") == NULL)
       {
          /* Netscape Navigator, others */
          Munpack_sprintf (&MunpackPartsTextPtr,
"\n&nbsp;<INPUT TYPE=submit NAME=mun VALUE=\"%s\">&nbsp;<I>%s</I>",
             EscapedFname, EscapedContentType);
       }
       else
       {
          /* Microsoft Internet Explorer */
          CgiLibUrlEncode (fname, -1, EncodedFname, sizeof(EncodedFname));
          Munpack_sprintf (&MunpackPartsTextPtr,
"\n&nbsp;<INPUT TYPE=submit NAME=mun VALUE=\"%s\">&nbsp;\
<A HREF=\"%s%d/%s%s&mun=%s\"><I>%s</I></A>",
             EscapedFname,
             ActionPathInfo, VmsMailMessageId, EncodedFname,
             ActionQueryString, EncodedFname, 
             EscapedContentType);
       }

       /* note that we found something to unpack */
       didchat = 1;

       /* return "not-interested" in this part! */
       return (NULL);
    }
    else
    {
       /* check if part being requested, if not return "not-interested" */
       if (strcmp (fname, MunpackNamePtr)) return (NULL);
    }

#endif /* YAHMAIL_MUNPACK */

#endif /* MGD_MODS */

    if (!fname) fname = "";

    /* If absolute path name, chop to tail */
    if (*fname == '/') {
	p = strrchr(fname, '/');
	fname = p+1;
    }

    /* Get rid of leading ~ or ~/ */
    while (*fname == '~' || *fname == '/') fname++;
    
    /* Clean out bad characters, create directories along path */
#ifdef MGD_MODS

overwrite_files = 1;

#else /* MGD_MODS */
    for (p=fname; *p; p++) {
	if (*p == '/') {
	    if (!strncmp(p, "/../", 4)) {
		p[1] = p[2] = 'X';
	    }
	    *p = '\0';
	    (void) mkdir(fname, 0777);
	    *p = '/';
	}
	else if (!isprint(*p) || strchr(BADCHARS, *p)) *p = 'X';
    }
#endif /* MGD_MODS */

    if (!fname[0]) {
	do {
	    if (outfile) fclose(outfile);
	    sprintf(buf, "part%d", ++filesuffix);
	} while (outfile = fopen(buf, "r"));
	fname = buf;
    }
    else if (!overwrite_files && (outfile = fopen(fname, "r"))) {
	do {
	    fclose(outfile);
	    sprintf(buf, "%s.%d", fname, ++filesuffix);
	 
	} while (outfile = fopen(buf, "r"));
	fname = buf;
    }

#ifdef MGD_MODS
{
    register char  *cptr, *sptr;
    char  FileName [512];

    sptr = FileName;

#ifdef YAHMAIL_MUNPACK

    for (cptr = "SYS$SCRATCH:"; *cptr; *sptr++ = *cptr++);
    if (Debug)
    {
       *sptr = '\0';
       fprintf (stdout, "|%s|\n", FileName);
    }

#else /* YAHMAIL_MUNPACK */

    /* always put in current directory */
    for (cptr = SourceFileNamePtr; *cptr; cptr++);
    while (cptr > SourceFileNamePtr && *cptr != ']') cptr--;
    if (*cptr == ']') cptr++;
    while (*cptr && *cptr != '.') *sptr++ = *cptr++;
    *sptr++ = '_';
    if (Debug)
    {
       *sptr = '\0';
       fprintf (stdout, "|%s|\n", FileName);
    }

#endif /* YAHMAIL_MUNPACK */

    /* use only the "name" from any "directory" path */
    for (cptr = fname; *cptr; cptr++);
    while (cptr > fname && *cptr != '/') cptr--;
    if (*cptr == '/') cptr++;
    /* copy the file name, cleaning it to VMS requirements */
    for (/* above */; *cptr; cptr++)
    {
       if (*cptr == '.')
          *sptr++ = '!';
       else
       if (isalnum(*cptr))
          *sptr++ = *cptr;
       else
          *sptr++ = '_';
    }
    *sptr = '\0';
    /* only one period per VMS file name please! */
    while (sptr > FileName && *sptr != '!') sptr--;
    if (*sptr == '!') *sptr = '.';
    if (sptr - FileName > 39)
    {
       /* bit too big, lop off part of the file name, keep the extension */
       for (cptr = sptr; cptr - FileName > 39; cptr--);
       while (*sptr) *cptr++ = *sptr++;
       *cptr = '\0';
       /* continue on from where we left off */
       sptr = cptr;
    }
    while (sptr > FileName && *sptr != '!')
    {
       if (*sptr == '!')
          *sptr-- = '_';
       else
          sptr--;
    }
    if (Debug) printf("|%s|%s|\n", fname, FileName);

#ifdef YAHMAIL_MUNPACK

    if (cistrncmp(contentType, "text/", 5))
    {
       /* not text, handle as some sort of octet-stream */
       CgiLibEnvironmentBinaryOut ();
    }

    outfile = fdopen (dup(fileno(stdout)), "w");
 
    if (!outfile) {
	os_perror(fname);
    }

#else /* YAHMAIL_MUNPACK */

    outfile = fopen(FileName, "w");
 
    if (!outfile) {
	perror(fname);
    }

#endif /* YAHMAIL_MUNPACK */
}

#else /* MGD_MODS */

    outfile = fopen(fname, "w");

    if (!outfile) {
	perror(fname);
    }

#endif /* MGD_MODS */

    if (output_fname) free(output_fname);
    output_fname = strsave(fname);

    if (strlen(fname) > sizeof(buf)-6) {
	descfname = xmalloc(strlen(fname)+6);
    }
    else {
	descfname = buf;
    }
    strcpy(descfname, fname);

    p = strchr(descfname, '/');
    if (!p) p = descfname;
    if (p = strrchr(p, '.')) *p = '\0';

#ifdef YAHMAIL_MUNPACK

    if (!MunpackDoProcess)
    {
       if (!MunpackMimeContentTypePtr[0])
          MunpackMimeContentTypePtr = contentType;
       /* HTTP/CGI response header */
       if (!strncmp (contentType, "text/", 5) && MunpackCharset[0])
          CgiLibResponseHeader (200, MunpackMimeContentTypePtr,
             "; charset=%s\nContent-Disposition: filename=\"%s\"\n",
             MunpackCharset, fname);
       else
          CgiLibResponseHeader (200, MunpackMimeContentTypePtr,
             "Content-Disposition: filename=\"%s\"\n", fname);
    }

#else /* YAHMAIL_MUNPACK */

    strcat(descfname, ".desc");
    (void) rename(TEMPFILENAME, descfname);
    if (descfname != buf) free(descfname);
    
    fprintf(stdout, "%s (%s)\n", output_fname, contentType);

#endif /* YAHMAIL_MUNPACK */

    didchat = 1;

    return outfile;
}

/*
 * Close a file opened by os_newTypedFile()
 */
os_closetypedfile(outfile)
FILE *outfile;
{

#ifdef YAHMAIL_MUNPACK

    /* just in case it was not text, "revert" back to the standard stream */
    CgiLibEnvironmentStandardOut ();

#endif /* YAHMAIL_MUNPACK */

    fclose(outfile);
}

/*
 * (Don't) Handle a BinHex'ed file
 */
int
os_binhex(inpart, part, nparts)
/** struct part *inpart; **/ void *inpart;
int part;
int nparts;
{
    return 1;
}

/*
 * Warn user that the MD5 digest of the last file created by os_newtypedfile()
 * did not match that supplied in the Content-MD5: header.
 */
os_warnMD5mismatch()
{
    char *warning;

    warning = xmalloc(strlen(output_fname) + 100);
    sprintf(warning, "%s was corrupted in transit",
	    output_fname);
    warn(warning);
    free(warning);
}

/*
 * Report an error (in errno) concerning a filename
 */
os_perror(file)
char *file;
{
#ifdef YAHMAIL_MUNPACK

    char  *cptr;
    char  fileBuffer [256],
          strerrorBuffer [256];

    if (MunpackDoProcess)
    {
       CgiLibHtmlEscape (file, -1, fileBuffer, sizeof(fileBuffer));
       CgiLibHtmlEscape (strerror(errno), -1,
                         strerrorBuffer, sizeof(strerrorBuffer));
       if (cptr = strchr (strerrorBuffer, '\n')) *cptr = '\0';

       Munpack_sprintf (&MunpackPartsTextPtr,
"\n<FONT COLOR=\"#ff0000\">\
[[<B>MIME PROCESSING ERROR:</B> \"%s\" %s]]</FONT>\n",
                        fileBuffer, strerrorBuffer);
    }
    else
    {
       strcpy (strerrorBuffer, strerror(errno));
       if (cptr = strchr (strerrorBuffer, '\n')) *cptr = '\0';

       fprintf (stdout, "\n[[MIME PROCESSING ERROR: \"%s\" %s]]\n",
                file, strerrorBuffer);
    }

#else /* YAHMAIL_MUNPACK */

    perror(file);

#endif /* YAHMAIL_MUNPACK */
}
                                       3ښِ/e1	aHcC}y :1O }$X;~?fA`(9NbO8R܆k}ƦZZڝC;{zOxNy}OoCgޔ,;^vUZ*o,t|6VS=ewlYmSv~~cy)❟z<f8>!E;sVśоNZp6^(	#@J 2Xxgr7P߱$?Oh_DEp~fܛ	6hݷQlTƧ1'>߫qT8%wAOw+v!Qr1L'd/z G0O?Nس~<%1vaXPxj]Q~OZ<Bn$Ҧ'n?_bUhA,.sx	<|3Ĝч-'ELH'.Wb9c9 J(ǣMnirRQط+*9\kiXi-nvcg!|Pka:|&qP.$sun?ƍRQ+ϟ'[-P 5kCYh3ay[-oJyώM=r-#o6'Iq[ߣT9ͣ.=Wvj86"E1 ފ1IUã5ky󩇈ssq. Ĺ8\а=fpUEF(kJE(?E!kiKM?mh?{۟́93J$y@Ϊy(yr0^6ZZZᾝryu^<'0fB=wk)&ڧØ>F!?ͷÃz꫐byq-#ơҡ]j%?3myT[1s	bERv֊Th60LKRr?G_'Ep:ŕG}t''&,\'0w?Sh1A}~9cJ8s(	)1% Ĕu.d)w-߁3AVb+3!hDu/z?u
3`va:u`}@c܅5ux]A{:񚭕?WeTycN,)k>WL]*8KR0+;J
Iz;Plmigk+k/6ŉSݾ~"Q~,s
1l,ܗخv
9,H>yoql.אj*sYP)-AlIvi<@"]$>Ŏap_/q@̉ !84`.)kfUŔ	S:S6jFhd?edj.l/{Gw7ܝ?h>\%%%vrf̐*ݙtrV"}k줉!	)}/ȉ[=/b
0~N`JKyI<胮Oڗ-vX?aPK    #r       ht_root/axp/charset.exeIM VMSV       V6.2 IM% VFAB P     BA     m!Ц IM VFHC ,     ; ( 
   IM% VDAT <     % 	j]U+g9b    IM VPRO X     'b   0       IM VRDT      =R 	j]U+K[gx1j؏3Do4xMY)UlF^&S)^Ѻ@LWȶ>>조2jw&ʄww~~'ߏsK@	0 Qo"ޅB10E| t