/*****************************************************************************/
/*
                                 Other.c

This module provide miscellaneous yahMAIL support functions that are used my
multiple other modules or that didn't really belong in any other specific one.


COPYRIGHT
---------
Copyright (C) 1999-2003 Mark G.Daniel
This program, comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.


VERSION HISTORY
---------------
19-FEB-2000  MGD  unbundled from YAHMAIL.C for v1.3
*/

/*****************************************************************************/

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

/* standard C header files */
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stat.h>

/* VMS related header files */
#include <maildef.h>
#include <mailmsgdef.h>
#include <prvdef.h>
#include <ssdef.h>
#include <stsdef.h>
#include <syidef.h>

/* application header file */
#include "yahmail.h"
#include "externs.h"

#define FI_LI __FILE__, __LINE__

/*****************************************************************************/
/*
Build the request path used in consequent YAHMAIL requests.  Two differing
paths are used.  The authenticated path comprises the script name, a tilde and
the user name (e.g. "/~DANIEL"), the mail file name (just the name, e.g.
"MAIL"), and the folder name.  Non-authenticated (public) paths comprise the
script name, the public name, and the folder name.
*/

BuildActionPathInfo ()
       
{
   char  *cptr, *sptr, *tptr;
   char  Scratch [256];

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "BuildActionPathInfo()\n");

   /* user-based access uses username, mail file name, and folder */
   sptr = ActionPathInfo;
   for (cptr = CgiScriptNamePtr; *cptr; *sptr++ = *cptr++);
   *sptr++ = '/';
   if (ConfigPrivate) *sptr++ = TildeChar;
   tptr = sptr;
   sptr = Scratch;
   for (cptr = MailUserName; *cptr; *sptr++ = *cptr++);
   *sptr++ = '/';
   if (ConfigPrivate)
   {
      for (cptr = MailFileName; *cptr; *sptr++ = *cptr++);
      *sptr++ = '/';
   }
   for (cptr = MailFolderName; *cptr; *sptr++ = *cptr++);
   *sptr++ = '/';
   *sptr = '\0';
   (char*)CgiLibUrlEncode (Scratch, -1, tptr, -1);
   if (Debug) fprintf (stdout, "ActionPathInfo |%s|\n", ActionPathInfo);
}

/*****************************************************************************/
/*
Build a query string with sufficient form elements suitable to carry the
context of the current request into the next one.
*/

BuildActionQueryString ()
       
{
   char  *PickCcPtr,
         *PickFromPtr,
         *PickSubjPtr,
         *PickToPtr,
         *ReplyToPtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "BuildActionQueryString()\n");

   PickFromPtr = (char*)CgiLibUrlEncode (MailSubstringFrom, -1, NULL, 0);
   PickSubjPtr = (char*)CgiLibUrlEncode (MailSubstringSubj, -1, NULL, 0);

   if (ConfigPrivate)
   {
      PickCcPtr = (char*)CgiLibUrlEncode (MailSubstringCc, -1, NULL, 0);
      PickToPtr = (char*)CgiLibUrlEncode (MailSubstringTo, -1, NULL, 0);
      if (CgiFormRtoPtr)
         ReplyToPtr = (char*)CgiLibUrlEncode (CgiFormRtoPtr, -1, NULL, 0);
      else
         ReplyToPtr = "";

      sprintf (ActionQueryString,
"?cmc=%d&anc=%d&pfr=%s&pto=%s&pcc=%s&psu=%s&cnm=%d&win=%d&wra=%d&llw=%d\
&rto=%s&enc=%s&bwm=%s&bwu=%s&bwf=%s&bwc=%s&bwp=%s&sps=%d",
               VmsMailMessageSelectedCount, MakeAnchors,
               PickFromPtr, PickToPtr, PickCcPtr, PickSubjPtr,
               CheckNewMailMinutes, BrowseWindow, WrapAt, LongLineWrap,
               ReplyToPtr,
               CgiFormEncPtr ? CgiFormEncPtr : "",
               CgiFormBwmPtr, CgiFormBwuPtr, CgiFormBwfPtr,
               CgiFormBwcPtr, CgiFormBwpPtr, PrivateSetupShow);

      free (PickCcPtr);
      free (PickToPtr);
      if (ReplyToPtr[0]) free (ReplyToPtr);
   }
   else
   {
      sprintf (ActionQueryString,
               "?cmc=%d&anc=%d&pfr=%s&psu=%s&win=%d",
               VmsMailMessageSelectedCount, MakeAnchors,
               PickFromPtr, PickSubjPtr, BrowseWindow);
   }

   free (PickFromPtr);
   free (PickSubjPtr);

   if (Debug) fprintf (stdout, "ActionQueryString |%s|\n", ActionQueryString);
}

/*****************************************************************************/
/*
Display a list of (possible) replies and replied-to based on the content of the
original's subject field.   Replies are identified by a leading "RE:" or
"RE[n]:" in the reply's subject field followed by the same string.
*/

RelatedList (char *SubjectPtr)

{
   int  ReplyCount;
   char  *cptr,
         *FromPtr;
   struct MessageListStruct  *mlptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "RelatedList() |%s|\n", SubjectPtr);

   ReplyCount = 0;
   while isspace((*SubjectPtr)) SubjectPtr++;

   for (mlptr = MessageListTailPtr; mlptr != NULL; mlptr = mlptr->PrevPtr)
   {
      /** if (Debug) fprintf (stdout, "|%s|\n", mlptr->SubjectPtr); **/
      for (cptr = mlptr->SubjectPtr; *cptr && isspace(*cptr); cptr++);
      if (!*cptr) continue;

      if (toupper(mlptr->SubjectPtr[0]) == 'R' &&
          toupper(mlptr->SubjectPtr[1]) == 'E' &&
          (mlptr->SubjectPtr[2] == ':' ||
           mlptr->SubjectPtr[2] == '[') ||
          strsame(SubjectPtr, mlptr->SubjectPtr, -1))
      {
         cptr = mlptr->SubjectPtr + 3;
         if (*cptr == ':')
            cptr++;
         else
         {
            if (*cptr == '[') cptr++;
            while (*cptr && isdigit(*cptr)) cptr++;
            if (*cptr == ']') cptr++;
         }
         while (isspace(*cptr)) cptr++;
         if (Debug) fprintf (stdout, "|%s|%s|\n", cptr, SubjectPtr);
         if (!SubjectPtr[0] || !strsame (cptr, SubjectPtr, -1)) continue;

         if (ReplyCount++)
            fprintf (stdout, "<BR>");
         else
         {
            fprintf (stdout,
"<TR><TD%s></TD><TD>\n\
<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TH ALIGN=left VALIGN=top>%s:&nbsp;</TH><TD ALIGN=left>\n",
               ConfigPrivate ? " COLSPAN=2" : "",
               lang_BrowseRelated);
         }

         FromPtr = (char*)CgiLibHtmlEscape (mlptr->FromPtr, -1, NULL, 0);

         fprintf (stdout, "[<A HREF=\"%s%d?%s&nnn=%s\">%04d</A>]&nbsp;%s\n",
                  ActionPathInfo, mlptr->MessageId, ActionQueryString,
                  CgiFormNnnPtr, mlptr->MessageId, FromPtr);

         free (FromPtr);
      }
   }

   if (toupper(SubjectPtr[0]) == 'R' &&
       toupper(SubjectPtr[1]) == 'E' &&
       (SubjectPtr[2] == ':' ||
        SubjectPtr[2] == '['))
   {
      cptr = SubjectPtr + 3;
      if (*cptr == ':')
         cptr++;
      else
      {
         if (*cptr == '[') cptr++;
         while (*cptr && isdigit(*cptr)) cptr++;
         if (*cptr == ']') cptr++;
      }
      while (isspace(*cptr)) cptr++;
      SubjectPtr = cptr;
      if (Debug) fprintf (stdout, "|%s|\n", SubjectPtr);

      for (mlptr = MessageListTailPtr; mlptr != NULL; mlptr = mlptr->PrevPtr)
      {
         /** if (Debug) fprintf (stdout, "|%s|\n", mlptr->SubjectPtr); **/
         for (cptr = mlptr->SubjectPtr; *cptr && isspace(*cptr); cptr++);
         if (!*cptr) continue;
   
         if (!SubjectPtr[0] || !strsame (cptr, SubjectPtr, -1)) continue;

         if (ReplyCount++)
            fprintf (stdout, "<BR>");
         else
         {
            fprintf (stdout,
"<TR><TD%s></TD><TD>\n\
<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TH ALIGN=left VALIGN=top>%s:&nbsp;</TH><TD ALIGN=left>\n",
                  ConfigPrivate ? " COLSPAN=2" : "",
                  lang_BrowseRelated);
         }

         FromPtr = (char*)CgiLibHtmlEscape (mlptr->FromPtr, -1, NULL, 0);

         fprintf (stdout, "[<A HREF=\"%s%d?%s&nnn=%s\">%04d</A>]&nbsp;%s\n",
                  ActionPathInfo, mlptr->MessageId, ActionQueryString,
                  CgiFormNnnPtr, mlptr->MessageId, FromPtr);

         free (FromPtr);
      }
   }

   if (ReplyCount)
      fprintf (stdout,
"</TD></TR>\n\
</TABLE>\n\
</TD></TR>\n");
}

/*****************************************************************************/
/*
Provide an HTML selection list containing number of items per browse page.
*/

HtmlSelectBrowseWindow ()

{
   static int  WindowValues[] = { 5, 10, 15, 20, 25, 50, 100, 9999, -1 };

   int  idx;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "HtmlSelectBrowseWindow()\n");

   fprintf (stdout, "<SELECT NAME=win>\n");

   for (idx = 0; WindowValues[idx] != -1; idx++)
   {
      if (WindowValues[idx] == 9999 && BrowseWindow == 9999)
         fprintf (stdout, "<OPTION VALUE=\"9999\" SELECTED>%s\n",
                  lang_BrowseAllItems);
      else
      if (WindowValues[idx] == 9999)
         fprintf (stdout, "<OPTION VALUE=\"9999\">%s\n",
                  lang_BrowseAllItems);
      else
      if (BrowseWindow >= WindowValues[idx] &&
          (BrowseWindow < WindowValues[idx+1] || WindowValues[idx+1] == -1))
         fprintf (stdout, "<OPTION VALUE=\"%d\" SELECTED>%d %s\n",
                          WindowValues[idx], WindowValues[idx],
                          lang_BrowseItem);
      else
         fprintf (stdout, "<OPTION VALUE=\"%d\">%d %s\n",
                          WindowValues[idx], WindowValues[idx],
                          lang_BrowseItem);
   }

   fprintf (stdout, "</SELECT>&nbsp;<I>%s</I>\n", lang_BrowseWindow);
}

/*****************************************************************************/
/*
Write a <SELECT><OPTION>...</SELECT> HTML structure to <stdout>, listing the
folders available in the current mailfile.  Make sure the current folder
('MailFolderName') occurs as the first entry in the list of options.  If folder
MAIL does not exist add a bogus, last entry for it.
*/

FolderListHtmlSelect ()

{
   boolean  FolderFound,
            MailFolderFound,
            NewmailFolderFound;
   char  *cptr;
   struct FolderListStruct  *flptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "FolderListHtmlSelect()\n");

   fprintf (stdout, "<SELECT NAME=fse>\n");

   FolderFound = MailFolderFound = NewmailFolderFound = false;
   for (flptr = FolderListHeadPtr; flptr != NULL; flptr = flptr->NextPtr)
   {
      if (Debug)
         fprintf (stdout, "|%s|%s|\n", MailFolderName, flptr->FolderNamePtr);

      if (!strcmp (flptr->FolderNamePtr, "MAIL"))
         MailFolderFound = true;
      else
      if (!strcmp (flptr->FolderNamePtr, "NEWMAIL"))
         NewmailFolderFound = true;

      cptr = (char*)CgiLibHtmlEscape (flptr->FolderNamePtr, -1, NULL, 0);

      if (!strcmp (flptr->FolderNamePtr, MailFolderName))
      {
         fprintf (stdout, "<OPTION VALUE=\"%s\" SELECTED>%s: %s\n",
                  cptr, lang_BrowseFolder, cptr);
         FolderFound = true;
      }
      else
         fprintf (stdout, "<OPTION VALUE=\"%s\">%s: %s\n",
                  cptr, lang_BrowseFolder, cptr);

      free (cptr);
   }

   if (ConfigPrivate)
   {
      if (!MailFolderFound)
         fprintf (stdout, "<OPTION VALUE=\"MAIL\"%s>%s: MAIL\n",
                 !strcmp (MailFolderName, "MAIL") ? " SELECTED" : "",
                 lang_BrowseFolder);

      if (!NewmailFolderFound)
         fprintf (stdout, "<OPTION VALUE=\"NEWMAIL\"%s>%s: NEWMAIL\n",
                  !strcmp (MailFolderName, "NEWMAIL") ? " SELECTED" : "",
                  lang_BrowseFolder);
   }

   fprintf (stdout, "</SELECT>\n");
}

/****************************************************************************/
/*
Read the file contents specified by 'FileName' into memory, set the pointer
at 'FileTextPtr' to the contents and the file size at 'FileSizePtr'.  Returns a
VMS status value that should be checked.
*/ 

int ReadFileIntoMemory
(
char *FileName,
char **FileTextPtr,
int *FileSizePtr
)
{
   int  status,
        Bytes,
        BytesRemaining,
        BufferCount,
        Length;
   char  *BufferPtr,
         *LinePtr;
   FILE  *FilePtr;
   stat_t  FstatBuffer;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ReadFileIntoMemory() |%s|\n", FileName);

   if (FileTextPtr != NULL) *FileTextPtr = NULL;
   if (FileSizePtr != NULL) *FileSizePtr = 0;

   FilePtr = fopen (FileName, "r", "shr=get");
   if (FilePtr == NULL)
   {
      status = vaxc$errno;
      if (Debug) fprintf (stdout, "fopen() %%X%08.08X\n", status);
      return (status);
   }

   if (fstat (fileno(FilePtr), &FstatBuffer) < 0)
   {
      status = vaxc$errno;
      if (Debug) fprintf (stdout, "fstat() %%X%08.08X\n", status);
      fclose (FilePtr);
      return (status);
   }

   Bytes = FstatBuffer.st_size;
   if (Debug) fprintf (stdout, "%d bytes\n", Bytes);
   /* a little margin for error ;^) */
   Bytes += 32;

   BufferPtr = calloc (Bytes, 1);
   if (BufferPtr == NULL)
   {
      CgiLibResponseError (FI_LI, vaxc$errno, "calloc()");
      exit (SS$_NORMAL);
   }
   BytesRemaining = Bytes;
   LinePtr = BufferPtr;

   BufferCount = 0;
   while (fgets (LinePtr, BytesRemaining, FilePtr) != NULL)
   {
      /** if (Debug) fprintf (stdout, "|%s|\n", LinePtr); **/
      Length = strlen(LinePtr);
      LinePtr += Length;
      BufferCount += Length;
      BytesRemaining -= Length;
   }
   fclose (FilePtr);

   if (Debug) fprintf (stdout, "%d |%s|\n", BufferCount, BufferPtr);

   if (FileTextPtr != NULL) *FileTextPtr = BufferPtr;
   if (FileSizePtr != NULL) *FileSizePtr = BufferCount;

   return (SS$_NORMAL);
}

/*****************************************************************************/
/*
Turn on/off SYSPRV (and optionally, if installed with it) READALL.
*/

EnableAccess (int OnOff)

{
   static unsigned long  ReadAllMask [2] = { 0, /** PRV$M_READALL **/ 0x8 };
   static unsigned long  SysPrvMask [2] = { PRV$M_SYSPRV, 0 };
   static boolean  ReadAll = true;

   int  status;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "EnableAccess() %d\n", OnOff);

   if (OnOff)
   {
      status = sys$setprv (1, &SysPrvMask, 0, 0);
      if (Debug) fprintf (stdout, "sys$setprv() %%X%08.08X\n", status);
      if (VMSnok (status) || status == SS$_NOTALLPRIV) exit (status & ~1);
      if (ReadAll)
      {
         status = sys$setprv (1, &ReadAllMask, 0, 0);
         if (Debug) fprintf (stdout, "sys$setprv() %%X%08.08X\n", status);
         if (status == SS$_NOTALLPRIV) ReadAll = false;
      }
   }
   else
   {
      if (VMSnok (status = sys$setprv (0, &SysPrvMask, 0, 0))) exit (status);
      if (Debug) fprintf (stdout, "sys$setprv() %%X%08.08X\n", status);
      if (ReadAll)
      {
         if (VMSnok (status = sys$setprv (0, &ReadAllMask, 0, 0)))
            exit (status);
         if (Debug) fprintf (stdout, "sys$setprv() %%X%08.08X\n", status);
      }
   }
}

/****************************************************************************/
/*
Copies null-terminated string 'SourcePtr' to 'DestinationPtr'.
Returns length of copied string.
Error exit on overflow!
*/ 

boolean strzcpy
(
char *DestinationPtr,
char *SourcePtr,
int SizeOfDestination
)
{
   char  *cptr, *sptr, *zptr;

   /*********/
   /* begin */
   /*********/

   zptr = (sptr = DestinationPtr) + SizeOfDestination;
   for (cptr = SourcePtr; *cptr && sptr < zptr; *sptr++ = *cptr++);
   if (sptr >= zptr) exit (SS$_RESULTOVF);
   *sptr = '\0';
   return (sptr - DestinationPtr);
}

/****************************************************************************/
/*
Set an integer reflecting the major and minor version of VMS (e.g. 60, 61, 62,
70, 71, 72, etc.)
*/ 

int GetVmsVersion ()

{
   static char  SyiVersion [16];

   static struct {
      short int  buf_len;
      short int  item;
      void  *buf_addr;
      unsigned short  *ret_len;
   }
   SyiItems [] =
   {
      { 8, SYI$_VERSION, &SyiVersion, 0 },
      { 0,0,0,0 }
   };

   int  status,
        version;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "GetVmsVersion()\n");

   if (VMSnok (status = sys$getsyiw (0, 0, 0, &SyiItems, 0, 0, 0)))
      exit (status);
   SyiVersion[8] = '\0';
   version = ((SyiVersion[1]-48) * 10) + (SyiVersion[3]-48);
   if (Debug) fprintf (stdout, "|%s| %d\n", SyiVersion, version);
   return (version);
}

/****************************************************************************/
/*
Does a case-insensitive, character-by-character string compare and returns 
true if two strings are the same, or false if not.  If a maximum number of 
characters are specified only those will be compared, if the entire strings 
should be compared then specify the number of characters as 0.
*/ 

boolean strsame
(
char *sptr1,
char *sptr2,
int  count
)
{
   while (*sptr1 && *sptr2)
   {
      if (toupper (*sptr1++) != toupper (*sptr2++)) return (false);
      if (count)
         if (!--count) return (true);
   }
   if (*sptr1 || *sptr2)
      return (false);
   else
      return (true);
}

/*****************************************************************************/

