/*****************************************************************************/
/*
                                Private.c

This module provides procesing specifically related to private (authenticated)
access to a user's VMS mail.  This includes browsing of and modification of the
contents of mail folders, as well as the creation of outgoing mail.


COPYRIGHT
---------
Copyright (C) 1999-2003 Mark G.Daniel
This program, comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.


VERSION HISTORY
---------------
20-MAR-2003  MGD  remove the "%s/%c",TildeChar from cookie assignments
                  (Mozilla 1.0-1.3 at least cannot handle /~ in cookies),
                  MIME mailing kludge check in lower case as well
11-FEB-2003  MGD  for replies "To:" configurably uses 'VmsMailRfc822ReplyTo',
                  VmsMailRfc822From' and then 'VmsMailSender', in that order
09-FEB-2003  MGD  reply-to
09-JUN-2002  MGD  configurable ISO header and quoted-printable body
25-MAR-2002  MGD  bugfix; language specific refinements
16-JAN-2001  MGD  bugfix; 'WrapLongLines' in CreateMailMessage(),
                  MSIE 5.n when <-back to a POSTed page requires refresh -
                  change "CREATE-SEND" from POST to GET using setMethodGET()
03-NOV-2000  MGD  add 'wrap long lines'
13-JUN-2000  MGD  CreatMailMessage() JavaScript for checking required fields
19-FEB-2000  MGD  unbundled from YAHMAIL.C for v1.3
*/

/*****************************************************************************/

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

/* standard C header files */
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* VMS related header files */
#include <descrip.h>
#include <ssdef.h>
#include <stsdef.h>

/* application header file */
#include "yahmail.h"
#include "externs.h"
#define FI_LI __FILE__, __LINE__

/* declared in SendMsg() */
extern boolean  CompilationIncludesPMDF;

/* required prototypes */

/*****************************************************************************/
/*
The username has been authenticated for this request, and is assumed to be a
VMS account username.
*/

ProcessPrivateRequest ()
       
{
   int  idx,
        len,
        status,
        IdNumber;
   char  *cptr, *sptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ProcessPrivateRequest()\n");

   if (!MailUserName[0])
   {
      CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
      return;
   }

#ifdef YAHMAIL_MUNPACK

   /* establish which (if any) MIME mailing system we can use */
   if (CliMimeSubjectKludge)
      MimeAttachmentSubjectKludge = true;
   else
   if (CliMimeNoSubjectKludge)
      MimeAttachmentSubjectKludge = false;
   else
   {
      if ((cptr = getenv ("MAIL$PROTOCOL_IN")) == NULL)
         if ((cptr = getenv ("MAIL$PROTOCOL_SMTP")) == NULL)
            if ((cptr = getenv ("MX_MAILSHR")) == NULL)
               cptr = "";

      /* PMDF mailing interface */
      if (strstr (cptr, "PMDF") || strstr (cptr, "pmdf"))
      {
         /* the command line can be used to disable PMDF processing */
         if (!CliNoPMDF) MailProtocolIsPMDF = CompilationIncludesPMDF;
      }
      else
      /* MX (MadGoat Message Exchange) */
      if (strstr (cptr, "MX") || strstr (cptr, "mx"))
         MimeAttachmentSubjectKludge = true;
      else
      /* Digital TCP/IP Services (UCX pre-v5.0) */
      if (strstr (cptr, "UCX") || strstr (cptr, "ucx"))
         MimeAttachmentSubjectKludge = true;
      else
      /* Compaq TCP/IP Services (UCX post-v5.0) */
      if (strstr (cptr, "TCPIP") || strstr (cptr, "tcpip"))
         MimeAttachmentSubjectKludge = true;
   }

#endif /* YAHMAIL_MUNPACK */

   if (!MailFileName[0]) strcpy (MailFileName, "MAIL");
   if (!MailFolderName[0]) strcpy (MailFolderName, "NEWMAIL");
   MailUserNameLength = strlen(MailUserName);
   MailFileNameLength = strlen(MailFileName);
   MailFolderNameLength = strlen(MailFolderName);

   if (Debug)
      fprintf (stdout, "|%s|%s|%s|%d|\n",
               MailUserName, MailFileName, MailFolderName, MailMessageId[0]);

   (char*)CgiLibHtmlEscape (MailFolderName, -1,
                     HtmlEscapedMailFolderName,
                     SizeOfHtmlEscapedMailFolderName);

   /* if username was specified an asterisk then generate a list of users */
   if (strchr (MailUserName, '*') != NULL ||
       strchr (MailUserName, '%') != NULL) DoUserList = true;

   BuildActionPathInfo ();

   if (DoMessageSend)
   {
      /******************************/
      /* send message (POST method) */
      /******************************/

      SendMailMessage ();
      return;
   }

   if (DoUserList)
   {
      /*********************/
      /* user profile list */
      /*********************/

      if (!PostMasterAuthenticated)
      {
         CgiLibResponseError (FI_LI, 0, lang_ErrConfigRestriction);
         return;
      }
      status = GenerateUserList();
      if (Debug) fprintf (stdout, "GenerateUserList() %%X%08.08X\n", status);
      if (VMSnok (status))
      {
         ResponseErrorMail (FI_LI, status, lang_ErrGenerateUserList);
         return;
      }
      BrowseUserList();
      return;
   }

   if (DoUserCreate)
   {
      /***********************/
      /* user profile create */
      /***********************/

      if (!PostMasterAuthenticated)
      {
         CgiLibResponseError (FI_LI, 0, lang_ErrConfigRestriction);
         return;
      }
      status = MailCreateUserEntry ();
      if (Debug) fprintf (stdout, "MailCreateUserEntry() %%X%08.08X\n", status);
      if (VMSnok (status)) return;
      CgiLibResponseSuccess (
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
         lang_ProfileCreated, lang_BtnGoBack);
      return;
   }

   if (DoUserDelete)
   {
      /***********************/
      /* user profile delete */
      /***********************/

      if (!PostMasterAuthenticated)
      {
         CgiLibResponseError (FI_LI, 0, lang_ErrConfigRestriction);
         return;
      }
      status = MailDeleteUserEntry();
      if (Debug) fprintf (stdout, "MailDeleteUserEntry() %%X%08.08X\n", status);
      if (VMSnok (status)) return;
      CgiLibResponseSuccess (
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
         lang_ProfileDeleted, lang_BtnGoBack);
      return;
   }

   if (DoUserSet)
   {
      /********************/
      /* user profile set */
      /********************/

      status = MailSetUserInfo();
      if (Debug) fprintf (stdout, "MailSetUserInfo() %%X%08.08X\n", status);
      if (VMSnok (status)) return;
      CgiLibResponseSuccess (
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
         lang_ProfileUpdated, lang_BtnGoBack);
      return;
   }

   /*****************************************************************/
   /* most other actions now require at least some of the user info */
   /*****************************************************************/

   status = MailGetUserInfo ();
   if (Debug) fprintf (stdout, "MailGetUserInfo() %%X%08.08X\n", status);
   if (VMSnok (status))
   {
      ResponseErrorMail (FI_LI, status, lang_ErrGetUserInfo);
      return;
   }

   if (DoUserProfile)
   {
      /************************/
      /* user profile display */
      /************************/

      DisplayUserProfile ();
      return;
   }

   if (DoMessageCreate)
   {
      /**********************/
      /* create new message */
      /**********************/

      CreateMailMessage ();
      return;
   }

   if (DoFolderBrowse)
   {
      /*****************/
      /* folder browse */
      /*****************/

      status = MailFileOpen ();
      if (Debug) fprintf (stdout, "MailFileOpen() %%X%08.08X\n", status);
      if (VMSnok (status))
      {
         ResponseErrorMail (FI_LI, status, lang_ErrOpenMail);
         return;
      }

      status = GenerateFolderList ();
      if (Debug) fprintf (stdout, "GenerateFolderList() %%X%08.08X\n", status);
      if (VMSnok (status))
      {
         ResponseErrorMail (FI_LI, status, lang_ErrGenerateFolderList);
         return;
      }

      status = GenerateMessageList ();
      if (VMSok (status))
         BrowseFolderPrivate ();
      else
         ResponseErrorMail (FI_LI, status, lang_ErrGenerateMessageList);

      MailFileClose ();

      return;
   }

   if (DoMessageRead || DoMessageReply || DoMessageForward)
   {
      /******************************/
      /* message read/reply/forward */
      /******************************/

      status = MailFileOpen ();
      if (Debug) fprintf (stdout, "MailFileOpen() %%X%08.08X\n", status);
      if (VMSnok (status))
      {
         ResponseErrorMail (FI_LI, status, lang_ErrOpenMail);
         return;
      }

      status = MailReadMessage ();
      if (Debug) fprintf (stdout, "MailReadMessage() %%X%08.08X\n", status);
      if (VMSok (status))
      {
         if (DoMessageRead)
            ViewMailMessage ();
         else
         if (DoMessageReply || DoMessageForward)
            CreateMailMessage ();
      }
      else
         ResponseErrorMail (FI_LI, status, lang_ErrMessageRead);

      MailFileClose ();

      return;
   }

   if (DoMessageDelete)
   {
      /******************/
      /* message delete */
      /******************/

      status = MailFileOpen ();
      if (Debug) fprintf (stdout, "MailFileOpen() %%X%08.08X\n", status);
      if (VMSnok (status))
      {
         ResponseErrorMail (FI_LI, status, lang_ErrOpenMail);
         return;
      }

      status = DeleteMessage ();
      if (Debug) fprintf (stdout, "DeleteMessage() %%X%08.08X\n", status);
      if (VMSok (status))
      {
         CgiLibResponseSuccess (
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
            lang_MessagesDeleted, lang_BtnGoBack);
      }
      else
         ResponseErrorMail (FI_LI, status, lang_ErrMessageDelete);

      MailFileClose ();

      return;
   }

   if (DoMessageCopy || DoMessageMove)
   {
      /*********************/
      /* message copy/move */
      /*********************/

      status = MailFileOpen ();
      if (Debug) fprintf (stdout, "MailFileOpen() %%X%08.08X\n", status);
      if (VMSnok (status))
      {
         ResponseErrorMail (FI_LI, status, lang_ErrOpenMail);
         return;
      }

      if (!strcmp (MailFolderName, CopyFolderName))
      {
         CgiLibResponseError (FI_LI, 0, lang_ErrFoldersIdentical);
         return;
      }

      status = CopyMoveMessage ();
      if (Debug) fprintf (stdout, "CopyMoveMessage() %%X%08.08X\n", status);
      if (VMSok (status))
      {
         if (DoMessageCopy)
            cptr = lang_MessagesCopied;
         else
            cptr = lang_MessagesMoved;
         CgiLibResponseSuccess (
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
            cptr, lang_BtnGoBack);
      }
      else
         ResponseErrorMail (FI_LI, status, lang_ErrMessageMove);

      MailFileClose ();

      return;
   }

   if (DoMessageEmptyWasteBasket)
   {
      /*********************/
      /* empty wastebasket */
      /*********************/

      status = MailFileOpen ();
      if (Debug) fprintf (stdout, "MailFileOpen() %%X%08.08X\n", status);
      if (VMSnok (status))
      {
         ResponseErrorMail (FI_LI, status, lang_ErrOpenMail);
         return;
      }

      status = EmptyWasteBasket ();
      if (Debug) fprintf (stdout, "EmptyWasteBasket() %%X%08.08X\n", status);
      if (VMSok (status))
      {
         CgiLibResponseSuccess (
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
            MailFileMessagesDeleted ? lang_WasteBasketPurged :
                                      lang_WasteBasketEmpty,
            lang_BtnGoBack);
      }
      else
         ResponseErrorMail (FI_LI, status, lang_ErrMessageDelete);

      MailFileClose ();

      return;
   }

   if (DoAddrListSelect)
   {
      /**************************/
      /* list all address lists */
      /**************************/

      AddrListSelect ();
      return;
   }

   if (DoAddrListAccess)
   {
      /****************************/
      /* address list access/edit */
      /****************************/

      AddrListAccess ();
      return;
   }

   if (DoAddrListUpdate)
   {
      /*************************************/
      /* update address list (POST method) */
      /*************************************/

      AddrListUpdate ();
      return;
   }

   if (DoAddrListRemove)
   {
      /***********************/
      /* delete address list */
      /***********************/

      AddrListRemove ();
      return;
   }

   if (DoSigFileAccess)
   {
      /***********************/
      /* signature file edit */
      /***********************/

      SigFileAccess ();
      return;
   }

   if (DoSigFileUpdate)
   {
      /***************************************/
      /* update signature file (POST method) */
      /***************************************/

      SigFileUpdate ();
      return;
   }

   CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
}

/*****************************************************************************/
/*
Generate an HTML page listing details of all the selected messages in the
specified folder.  Private folders have a unique number attached to them (the
"nnn=9999999" seen in query strings).  This exists to make each folder-related
request unique, forcing browsers to bypass any local caching when accessing
folders and messages.  Remember, messages to not have a unique identifier, it's
all relative to the folder and it current retinue of messages.

Use JavaScript to enhance behaviour and detect when folders are modified (via
deletes or moves) then they get reloaded.  This is fairly important as VMS mail
messages do not have a unique identifier, just a current number.  Redo an
action on that number and it may operate on an entirely different message.
*/

BrowseFolderPrivate ()

{
   static char  DateTime [32],
                NnnString [32];
   static $DESCRIPTOR (DateTimeDsc, DateTime);
   static $DESCRIPTOR (DateTimeFaoDsc, "!17%D\0");
   static $DESCRIPTOR (NnnStringDsc, NnnString);
   static $DESCRIPTOR (NnnStringFaoDsc, "!UW!UW!UW!UW!UW!UW\0");

   boolean  NewMailBiff;
   int  IdCount,
        IdPage,
        IdFrom,
        IdTo,
        NewMailSeconds;
   unsigned long  BinTime [2];
   unsigned short  NumTime [7];
   char  *cptr,
         *DatePtr,
         *FromPtr,
         *SubjectPtr;
   char  NewMailCheck [64],
         NoneHtmlString [64];
   struct MessageListStruct  *mlptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "BrowseFolderPrivate()\n");

   /* a "number" that makes each folder request unique */
   sys$gettim (&BinTime);
   sys$numtim (&NumTime, &BinTime);
   sys$fao (&NnnStringFaoDsc, 0, &NnnStringDsc,
            NumTime[1], NumTime[2], NumTime[3],
            NumTime[4], NumTime[5], NumTime[6]);

   GetPrivateSetup ();

   BuildActionQueryString ();

   CgiHttpCookiePtr = CgiLibVar ("WWW_HTTP_COOKIE");
   NewMailSeconds = atol(CgiLibVar ("WWW_FORM_NMS"));

   NewMailBiff = false;
   if (CheckNewMailMinutes &&
       !strcmp (MailFolderName, lang_BtnToNewMail))
   {
      if ((mlptr = MessageListTailPtr) == NULL)
         NewMailSeconds = 0;
      else
      {
         if (decc$fix_time(&mlptr->BinaryDate) > NewMailSeconds &&
             strstr (CgiHttpCookiePtr, "YAHMAIL=NEWMAIL") != NULL)
            NewMailBiff = true;
         else
            NewMailSeconds = decc$fix_time(&mlptr->BinaryDate);
      }

      sprintf (NewMailCheck, " &nbsp;(%d %s)",
               CheckNewMailMinutes, lang_BrowseNewMailMinutes);
   }
   else
   {
      NewMailSeconds = 0;
      NewMailCheck[0] = '\0';
   }

   CgiLibResponseHeader (200, "text/html");

   fprintf (stdout,
"<HTML>\n\
<HEAD>\n\
<META NAME=\"generator\" CONTENT=\"%s\">\n\
<META NAME=\"environment\" CONTENT=\"%s\">\n\
<META NAME=\"language\" CONTENT=\"%s %s\">\n",
      SoftwareID, CgiEnvironmentPtr, lang_Language, lang_LanguageAuthor);

   if (NewMailBiff)
      fprintf (stdout, "<TITLE>%s</TITLE>\n", lang_NewMailBiffTitle);
   else
      fprintf (stdout, "<TITLE>yahMAIL ... %s / %s / %s%s</TITLE>\n",
               MailUserName, MailFileName, HtmlEscapedMailFolderName,
               NewMailCheck);

   fprintf (stdout,
"<SCRIPT LANGUAGE=\"JavaScript\">\n\
<!--\n\
\
var formURL = \"\",\n\
    listURL = \"\",\n\
    refreshNewMailMinutes = 0;\n\
\
function doOnLoad (folderName, refreshMinutes) {\n\
   if (document.cookie.indexOf(\"YAHMAIL=RELOAD\") != -1) {\n\
      resetCookie();\n\
      location.reload(true);\n\
   }\n\
   resetCookie();\n\
// undo Mozilla\'s rechecking the ID checkboxes!\n\
   resetAllId();\n\
   if (folderName == \"NEWMAIL\" && refreshMinutes != 0) {\n\
      refreshNewMailMinutes = refreshMinutes;\n\
      refreshNewMailMinutes++;\n\
      refreshNewMail();\n\
   }\n\
}\n\
\
function refreshNewMail () {\n\
   if (--refreshNewMailMinutes > 0) {\n\
      window.defaultStatus = \"%s / %s / %s (\" + \
refreshNewMailMinutes + \" %s)\"\n\
      setTimeout(\"refreshNewMail()\", 60000);\n\
      return;\n\
   }\n\
   buildFormURL(\'NEWMAIL\');\n\
   document.cookie = \"YAHMAIL=NEWMAIL; path=%s/\";\n\
   location.replace(formURL);\n\
}\n\
\
function setReload (actionButton) {\n\
   var reload = false;\n\
   if (actionButton == \"%s\" ||\n\
       actionButton == \"%s\")\n\
      reload = true;\n\
   else {\n\
      for (idx = 0; idx < document.formPage.elements.length; idx++) {\n\
         if (document.formPage.elements[idx].type == \"checkbox\" &&\n\
             document.formPage.elements[idx].checked) {\n\
            elementName = document.formPage.elements[idx].name;\n\
            if (elementName.substring(0,2) == \"id\") reload = true;\n\
         }\n\
      }\n\
   }\n\
   if (reload)\n\
      document.cookie = \"YAHMAIL=RELOAD; path=%s/\";\n\
   else\n\
      buildFormURL(actionButton);\n\
}\n\
\
function resetCookie () {\n\
   document.cookie = \"YAHMAIL=; path=%s/\";\n\
}\n\
\
function doClearPick () {\n\
   document.formPage.pfr.value =\n\
   document.formPage.pto.value =\n\
   document.formPage.pcc.value =\n\
   document.formPage.psu.value = \"\";\n\
}\n\
\
function doSubmit () {\n\
   if (document.formPage.method == \"get\" || \
document.formPage.method == \"GET\") {\n\
      open (formURL, \"_self\");\n\
      return false;\n\
   }\n\
   if (formURL != \"\") {\n\
      location.replace(formURL);\n\
      return false;\n\
   }\n\
   else\n\
   if (listURL != \"\") {\n\
      open (listURL, \"AddrList\", \"%s\");\n\
      listURL = \"\";\n\
      return false;\n\
   }\n\
   else {\n\
      return true;\n\
   }\n\
}\n\
\
function doRange (rangeURL) {\n\
   location.replace(rangeURL);\n\
   return false;\n\
}\n\
\
function doAddrList () {\n\
   listURL = document.formPage.action + \"?\" + \"act=%s\";\n\
}\n\
\
function buildFormURL (actionButton) {\n\
   var elementName, elementValue;\n\
   if (actionButton == \"%s\") document.formPage.method = \"GET\";\n\
   formURL = document.formPage.action + \"?act=\" + escape(actionButton);\n\
   for (idx = 0; idx < document.formPage.elements.length; idx++) {\n\
      if (document.formPage.elements[idx].type == \"hidden\" ||\n\
          document.formPage.elements[idx].type == \"text\") {\n\
         elementName = document.formPage.elements[idx].name;\n\
         elementValue = document.formPage.elements[idx].value;\n\
         formURL += \"&\" + elementName + \"=\" + escape(elementValue);\n\
      }\n\
      else\n\
      if (document.formPage.elements[idx].type == \"checkbox\") {\n\
         if (document.formPage.elements[idx].checked) {\n\
            elementName = document.formPage.elements[idx].name;\n\
            elementValue = document.formPage.elements[idx].value;\n\
            formURL += \"&\" + elementName + \"=\" + escape(elementValue);\n\
         }\n\
      }\n\
      else\n\
      if (document.formPage.elements[idx].type == \"select-one\") {\n\
         elementName = document.formPage.elements[idx].name;\n\
         elementValue = document.formPage.elements[idx].options\
[document.formPage.elements[idx].selectedIndex].value;\n\
         formURL += \"&\" + elementName + \"=\" + escape(elementValue);\n\
      }\n\
   }\n\
   resetCookie();\n\
}\n\
\
function checkAllId () {\n\
   for (idx = 0; idx < document.formPage.elements.length; idx++) {\n\
      if (document.formPage.elements[idx].type == \"checkbox\" &&\n\
          document.formPage.elements[idx].name.substring(0,2) == \"id\")\n\
         document.formPage.elements[idx].checked = \
document.formPage.checkAll.checked;\n\
   }\n\
}\n\
\
function resetAllId () {\n\
   for (idx = 0; idx < document.formPage.elements.length; idx++) {\n\
      if (document.formPage.elements[idx].type == \"checkbox\" &&\n\
          document.formPage.elements[idx].name.substring(0,2) == \"id\")\n\
         document.formPage.elements[idx].checked = false;\
   }\n\
}\n\
\
// -->\n\
</SCRIPT>\n\
</HEAD>\n\
<BODY onLoad=\"doOnLoad(\'%s\',\'%d\')\" %s>\n\
%s\
%s\n\
<FONT SIZE=+1><B><U>%s / %s / %s</U></B></FONT>%s",
      MailUserName, MailFileName, HtmlEscapedMailFolderName,
      lang_BrowseNewMailMinutes,
      CgiScriptNamePtr,
      lang_BtnEmptyWasteBasket, lang_BtnDelete,
      CgiScriptNamePtr,
      CgiScriptNamePtr,
      ADDRESS_LIST_WINDOW,
      (char*)CgiLibUrlEncode (lang_BtnAddressLists, -1, NULL, 0),
      lang_BtnCreateSend,
      HtmlEscapedMailFolderName, CheckNewMailMinutes, ConfigBodyTagPtr,
      PostMasterWarningPtr, ConfigFolderHeaderPtr,
      MailUserName, MailFileName, HtmlEscapedMailFolderName, NewMailCheck);

   if (NewMailBiff)
      fputs (ConfigNewMailPtr == NULL ? lang_NewMailBiff :
                                        ConfigNewMailPtr, stdout);

   fprintf (stdout,
"\n<BR>&nbsp;<FONT SIZE=-1>yahMAIL<SUP>*</SUP></FONT>\n\
<FORM NAME=formPage METHOD=POST ENCTYPE=\"multipart/form-data\" \
ACTION=\"%s\" onSubmit=\"return doSubmit()\">\n\
<INPUT TYPE=hidden NAME=cmc VALUE=\"%d\">\n\
<INPUT TYPE=hidden NAME=anc VALUE=\"%d\">\n\
<INPUT TYPE=hidden NAME=wra VALUE=\"%d\">\n\
<INPUT TYPE=hidden NAME=nms VALUE=\"%d\">\n\
<P>",
      ActionPathInfo, VmsMailMessageSelectedCount,
      MakeAnchors, WrapAt, NewMailSeconds);
                                                                    
   BrowseFolderPrivateButtons ('1');

   IdPage = 1;
   IdFrom = VmsMailMessageSelectedCount;
   while (IdFrom > 0)
   {
      if (IdFrom > BrowseWindow)
         IdTo = IdFrom - BrowseWindow + 1;
      else
         IdTo = 1;

      if (IdPage == BrowsePage)
         fprintf (stdout, "[%04d-%04d]\n", IdFrom, IdTo);
      else
         fprintf (stdout,
"[<A HREF=\"%s%s&pag=%d&nnn=%s\" \
onClick=\"return doRange(\'%s%s&pag=%d&nnn=%s\')\">%04d-%04d</A>]\n",
            ActionPathInfo, ActionQueryString, IdPage, NnnString,
            ActionPathInfo, ActionQueryString, IdPage, NnnString,
            IdFrom, IdTo);

      IdFrom -= BrowseWindow;
      IdPage++;
   }

   sys$fao (&DateTimeFaoDsc, 0, &DateTimeDsc, 0);
   fprintf (stdout, "&nbsp;<NOBR>%s %s</NOBR>",
            lang_AsAtDateTime, DateTime);

   if (VmsMailUserNewMessages &&
       (!strcmp (MailFileName, "MAIL") ||
        !strncmp (MailFileName, "MAIL.", 5)) &&
        strcmp (MailFolderName, "NEWMAIL"))
      fprintf (stdout,
"&nbsp;&nbsp;<NOBR>%d %s %s <FONT SIZE=-1>NEWMAIL</FONT></NOBR>\n",
               VmsMailUserNewMessages,
               VmsMailUserNewMessages == 1 ? lang_MessagesInNewMailSingular :
                                             lang_MessagesInNewMailPlural,
               lang_MessagesInNewMail);

   if (VmsMailMessageSelectedCount) fprintf (stdout, "<BR>\n");

   fprintf (stdout, "<HR ALIGN=left WIDTH=70%% HEIGHT=1 NOSHADE>\n");

   IdCount = 1;
   for (mlptr = MessageListTailPtr; mlptr != NULL; mlptr = mlptr->PrevPtr)
   {
      if (Debug) fprintf (stdout, "id: %d\n", mlptr->MessageId);

      FromPtr = (char*)CgiLibHtmlEscape (mlptr->FromPtr, -1, NULL, 0);

      /* look for and eliminate the VMS Mail MIME subject line kludge */
      if ((cptr = strstr (mlptr->SubjectPtr,
                          "\r\nMIME-version: 1.0\r\n")) != NULL)
         cptr[0] = '\0';

      if (mlptr->SubjectPtr[0])
         SubjectPtr = (char*)CgiLibHtmlEscape (mlptr->SubjectPtr, -1, NULL, 0);
      else
         sprintf (SubjectPtr = NoneHtmlString, "<I>(%s)</I>", lang_NoSubject);

      /* ROWSPAN=3 here meshes quite nicely with RelatedList() COLSPAN=2 */
      fprintf (stdout,
"<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR>\
<TD ROWSPAN=4 VALIGN=top>\
<INPUT TYPE=checkbox NAME=id%d VALUE=%d>\
&nbsp;&nbsp;&nbsp;\
</TD><TD VALIGN=top>\
[<A HREF=\"%s%d%s&nnn=%s\">%04d</A>]\
&nbsp;&nbsp;&nbsp;\
</TD>\
<TH COLSPAN=2 ALIGN=left VALIGN=top><U>%s</U></TH>\
</TR>\n\
<TR><TD COLSPAN=2></TD><TD ALIGN=left VALIGN=top>%s</TD></TR>\n\
<TR><TD COLSPAN=2></TD><TD ALIGN=left VALIGN=top>\
<FONT SIZE=-1>%17.17s</FONT></TD></TR>\n",
         IdCount++, mlptr->MessageId,
         ActionPathInfo, mlptr->MessageId, ActionQueryString, NnnString,
         mlptr->MessageId,
         SubjectPtr, FromPtr, mlptr->DatePtr);

      RelatedList (mlptr->SubjectPtr);

      fprintf (stdout, "<TR><TD HEIGHT=5></TD></TR>\n</TABLE>\n");

      free (FromPtr);
      free (SubjectPtr);
   }

   if (MessageListCount)
   {
      fprintf (stdout,
"<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR>\
<TD VALIGN=bottom>\
<INPUT TYPE=checkbox NAME=checkAll VALUE=0 onClick=\"checkAllId()\">\
&nbsp;&nbsp;&nbsp;</TD>\
<TD COLSPAN=3 VALIGN=bottom><I>%s</I></TD></TR>\n\
</TABLE>\n",
         lang_ChkAllId);
   }
   else
   {
      if (MailSubstringCc[0] || MailSubstringFrom[0] ||
          MailSubstringSubj[0] || MailSubstringTo[0])
         fprintf (stdout, "&nbsp;<I>(%s)</I>\n", lang_NoMessagesSelected);
      else
         fprintf (stdout, "&nbsp;<I>(%s)</I>\n", lang_NoMessages);
   }

   fprintf (stdout, "<HR ALIGN=left WIDTH=70%% HEIGHT=1 NOSHADE>\n");

   BrowseFolderPrivateButtons ('2');

   BrowseFolderPrivateSetup ();

   fprintf (stdout,
"<INPUT TYPE=hidden NAME=nnn VALUE=%s>\n\
</FORM>\n\
</NOBR>\n\
<P>%s\n\
</BODY>\n\
</HTML>\n",
      NnnString,
      ConfigFolderFooterPtr);
}

/*****************************************************************************/
/*
Get and process CGI variables controlling private browse setup.
*/

GetPrivateSetup ()

{
   static char  TextAreaRows [16];

   char  *cptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "GetPrivateSetup()\n");

   if (!(PrivateSetupShow || PrivateSetupHide))
      PrivateSetupShow = atoi(CgiLibVar ("WWW_FORM_SPS"));

   /* standard "mail" folder buttons (default to bottom) */
   cptr = CgiLibVar ("WWW_FORM_BWM");
   if (cptr[0] != '0' && cptr[0] != '1' && cptr[0] != '2') cptr = "2";
   CgiFormBwmPtr = cptr;

   /* "user" (all) folder buttons (default to none) */
   cptr = CgiLibVar ("WWW_FORM_BWU");
   if (cptr[0] != '0' && cptr[0] != '1' && cptr[0] != '2') cptr = "0";
   CgiFormBwuPtr = cptr;

   /* folder selector and open/move/copy buttons (default to bottom) */
   cptr = CgiLibVar ("WWW_FORM_BWF");
   if (cptr[0] != '0' && cptr[0] != '1' && cptr[0] != '2') cptr = "2";
   CgiFormBwfPtr = cptr;

   /* create-send button (default to bottom) */
   cptr = CgiLibVar ("WWW_FORM_BWC");
   if (cptr[0] != '0' && cptr[0] != '1' && cptr[0] != '2') cptr = "2";
   CgiFormBwcPtr = cptr;

   /* "pick" fields (default to none) */
   cptr = CgiLibVar ("WWW_FORM_BWP");
   if (cptr[0] != '0' && cptr[0] != '1' && cptr[0] != '2') cptr = "0";
   CgiFormBwpPtr = cptr;

   /* create-send <TEXTAREA> rows (with default) */
   CgiFormTarPtr = CgiLibVar ("WWW_FORM_TAR");
   if (!CgiFormTarPtr[0])
      sprintf (CgiFormTarPtr = TextAreaRows, "%d", CREATESEND_TEXTAREA_ROWS);
   if (Debug) fprintf (stdout, "CgiFormTarPtr |%s|\n", CgiFormTarPtr);

   /* header and body encoding preferences */
   CgiFormEncPtr = CgiLibVar ("WWW_FORM_ENC");

   /* reply-to preference */
   CgiFormRtoPtr = CgiLibVar ("WWW_FORM_RTO");
}

/*****************************************************************************/
/*
Provide the private folder browse setup fields and buttons.
*/

BrowseFolderPrivateSetup ()

{
   static int  CheckValues[] = { 0, 1, 5, 10, 15, 30, 60, -1 };

   int  idx;
   char  *cptr,
         *ReplyToPtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "BrowseFolderPrivateSetup()\n");

   ReplyToPtr = (char*)CgiLibHtmlEscape (CgiFormRtoPtr, -1, NULL, 0);

   if (PrivateSetupShow)
   {
      /**********************/
      /* setup is displayed */
      /**********************/

      fprintf (stdout,
"<P><TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR WIDTH=90%%><TD>&nbsp;</TD><TD><NOBR>\n");

      HtmlSelectBrowseWindow ();

      fprintf (stdout, "<BR><SELECT NAME=cnm>\n");

      for (idx = 0; CheckValues[idx] != -1; idx++)
      {
         if (CheckValues[idx] == 0)
            fprintf (stdout, "<OPTION VALUE=\"0\"%s>0 %s\n",
                     CheckNewMailMinutes ? "" : " SELECTED",
                     lang_BrowseNewMailDisabled);
         else
         if (CheckNewMailMinutes == CheckValues[idx])
            fprintf (stdout, "<OPTION VALUE=\"%d\" SELECTED>%d %s\n",
                     CheckValues[idx], CheckValues[idx],
                     lang_BrowseNewMailMinutes);
         else
            fprintf (stdout, "<OPTION VALUE=\"%d\">%d %s\n",
                     CheckValues[idx], CheckValues[idx],
                     lang_BrowseNewMailMinutes);

         if (CheckNewMailMinutes > CheckValues[idx] &&
             (CheckNewMailMinutes < CheckValues[idx+1] ||
              CheckValues[idx+1] == -1))
            fprintf (stdout, "<OPTION VALUE=\"%d\" SELECTED>%d %s\n",
                     CheckNewMailMinutes, CheckNewMailMinutes,
                     lang_BrowseNewMailMinutes);
      }

      fprintf (stdout, "</SELECT>&nbsp;<I>%s</I>\n", lang_BrowseNewMailCheck);

      fprintf (stdout,
"<BR><SELECT NAME=bwm>\n\
<OPTION VALUE=0%s>%s\n\
<OPTION VALUE=1%s>%s\n\
<OPTION VALUE=2%s>%s\n\
</SELECT>&nbsp;<I>%s</I>\n",
         CgiFormBwmPtr[0] == '0' ? " SELECTED" : "", lang_None,
         CgiFormBwmPtr[0] == '1' ? " SELECTED" : "", lang_Top,
         CgiFormBwmPtr[0] == '2' ? " SELECTED" : "", lang_Bottom,
         lang_BrowseMailFolderButtons);

      fprintf (stdout,
"<BR><SELECT NAME=bwu>\n\
<OPTION VALUE=0%s>%s\n\
<OPTION VALUE=1%s>%s\n\
<OPTION VALUE=2%s>%s\n\
</SELECT>&nbsp;<I>%s</I>\n",
         CgiFormBwuPtr[0] == '0' ? " SELECTED" : "", lang_None,
         CgiFormBwuPtr[0] == '1' ? " SELECTED" : "", lang_Top,
         CgiFormBwuPtr[0] == '2' ? " SELECTED" : "", lang_Bottom,
         lang_BrowseUserFolderButtons);

      fprintf (stdout,
"<BR><SELECT NAME=bwf>\n\
<OPTION VALUE=0%s>%s\n\
<OPTION VALUE=1%s>%s\n\
<OPTION VALUE=2%s>%s\n\
</SELECT>&nbsp;<I>%s</I>\n",
         CgiFormBwfPtr[0] == '0' ? " SELECTED" : "", lang_None,
         CgiFormBwfPtr[0] == '1' ? " SELECTED" : "", lang_Top,
         CgiFormBwfPtr[0] == '2' ? " SELECTED" : "", lang_Bottom,
         lang_BrowseFolderButtons);

      fprintf (stdout,
"<BR><SELECT NAME=bwc>\n\
<OPTION VALUE=1%s>%s\n\
<OPTION VALUE=2%s>%s\n\
</SELECT>&nbsp;<I>%s</I>\n",
         CgiFormBwcPtr[0] == '1' ? " SELECTED" : "", lang_Top,
         CgiFormBwcPtr[0] == '2' ? " SELECTED" : "", lang_Bottom,
         lang_BrowseCreateSendButton);

      fprintf (stdout,
"<BR><SELECT NAME=tar>\n\
<OPTION VALUE=8%s>8 %s\n\
<OPTION VALUE=12%s>12 %s\n\
<OPTION VALUE=16%s>16 %s\n\
<OPTION VALUE=20%s>20 %s\n\
<OPTION VALUE=24%s>24 %s\n\
<OPTION VALUE=32%s>32 %s\n\
<OPTION VALUE=48%s>48 %s\n\
</SELECT>&nbsp;<I>%s</I>\n",
         *(unsigned short*)CgiFormTarPtr == '8\0' ? " SELECTED" : "",
         lang_BrowseCreateTextAreaRows,
         *(unsigned short*)CgiFormTarPtr == '12' ? " SELECTED" : "",
         lang_BrowseCreateTextAreaRows,
         *(unsigned short*)CgiFormTarPtr == '16' ? " SELECTED" : "",
         lang_BrowseCreateTextAreaRows,
         *(unsigned short*)CgiFormTarPtr == '20' ? " SELECTED" : "",
         lang_BrowseCreateTextAreaRows,
         *(unsigned short*)CgiFormTarPtr == '24' ? " SELECTED" : "",
         lang_BrowseCreateTextAreaRows,
         *(unsigned short*)CgiFormTarPtr == '32' ? " SELECTED" : "",
         lang_BrowseCreateTextAreaRows,
         *(unsigned short*)CgiFormTarPtr == '48' ? " SELECTED" : "",
         lang_BrowseCreateTextAreaRows,
         lang_BrowseCreateTextArea);

      if (!MailProtocolIsPMDF)
      {
         if (CgiFormEncPtr[0])
            cptr = CgiFormEncPtr;
         else
            cptr = ConfigEncodingPtr;

         fprintf (stdout,
"<BR><SELECT NAME=enc>\n\
<OPTION VALUE=88%s>%s\n\
<OPTION VALUE=8Q%s>%s\n\
<OPTION VALUE=IQ%s>%s\n\
<OPTION VALUE=I8%s>%s\n\
</SELECT>&nbsp;<I>%s</I>\n",
           *(unsigned short*)cptr == '88' ? " SELECTED" : "",
              lang_BrowseEncoding88,
           *(unsigned short*)cptr == '8Q' ? " SELECTED" : "",
              lang_BrowseEncoding8Q,
           *(unsigned short*)cptr == 'IQ' ? " SELECTED" : "",
              lang_BrowseEncodingIQ,
           *(unsigned short*)cptr == 'I8' ? " SELECTED" : "",
              lang_BrowseEncodingI8,
            lang_BrowseEncoding);
      }

      fprintf (stdout,
"<BR><SELECT NAME=bwp>\n\
<OPTION VALUE=0%s>%s\n\
<OPTION VALUE=1%s>%s\n\
<OPTION VALUE=2%s>%s\n\
</SELECT>&nbsp;<I>%s</I>\n",
         CgiFormBwpPtr[0] == '0' ? " SELECTED" : "", lang_None,
         CgiFormBwpPtr[0] == '1' ? " SELECTED" : "", lang_Top,
         CgiFormBwpPtr[0] == '2' ? " SELECTED" : "", lang_Bottom,
         lang_BrowsePickFields);

      fprintf (stdout,
"<BR><INPUT TYPE=text SIZE=45 NAME=rto VALUE=\"%s\">&nbsp;<I>%s</I>\n",
               ReplyToPtr, lang_BrowseReplyTo);

      fprintf (stdout,
"<BR><INPUT TYPE=checkbox NAME=llw VALUE=%d%s>&nbsp;<I>%s</I>\n",
               LongLineWrap ? LongLineWrap : 72,
               LongLineWrap ? " CHECKED" : "", lang_WrapLongLines);

      fprintf (stdout,
"</NOBR></TD></TR>\n\
</TABLE>\n\
<P><INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"return buildFormURL(\'%s\')\">\n\
<INPUT TYPE=hidden NAME=sps VALUE=1>\n",
               lang_BtnSetupHide, lang_BtnSetupHide);
   }
   else
   {
      /*******************/
      /* setup is hidden */
      /*******************/

      fprintf (stdout,
"<P><INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"return buildFormURL(\'%s\')\">\n\
<INPUT TYPE=hidden NAME=win VALUE=%d>\n\
<INPUT TYPE=hidden NAME=cnm VALUE=%d>\n\
<INPUT TYPE=hidden NAME=rto VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=llw VALUE=%d>\n\
<INPUT TYPE=hidden NAME=enc VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=bwm VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=bwu VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=bwf VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=bwc VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=bwp VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=tar VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=sps VALUE=0>\n",
          lang_BtnSetupShow, lang_BtnSetupShow,
          BrowseWindow,
          CheckNewMailMinutes,
          ReplyToPtr,
          LongLineWrap,
          CgiFormEncPtr,
          CgiFormBwmPtr,
          CgiFormBwuPtr,
          CgiFormBwfPtr,
          CgiFormBwcPtr,
          CgiFormBwpPtr,
          CgiFormTarPtr);
   }

   fprintf (stdout,
"<BR><INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"return doAddrList()\">\n\
<BR><INPUT TYPE=submit NAME=act VALUE=\"%s\">\n",
      lang_BtnAddressLists,
      lang_BtnChangeProfile);

   free (ReplyToPtr);
}

/*****************************************************************************/
/*
Provide the private browse page appropriate group(s) of buttons, etc.,
depending on "setup" and  whether the function is being called from the top of
bottom of the message listing.
*/

BrowseFolderPrivateButtons (int TopOrBottom)

{
   boolean  DeleteButton;
   int  AttachmentCount,
        SectionCount;
   char  *cptr,
         *PickCcPtr,
         *PickFromPtr,
         *PickSubjPtr,
         *PickToPtr;
   struct FolderListStruct  *flptr;

   /*********/
   /* begin */
   /*********/

   if (Debug)
      fprintf (stdout, "BrowseFolderPrivateButtons() %d\n", TopOrBottom);

   SectionCount = 0;
   DeleteButton = false;

   /* standard "mail" folder buttons */
   if (CgiFormBwmPtr[0] == TopOrBottom)
   {
      if (!SectionCount++)
         fprintf (stdout,
"<P><TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR WIDTH=90%%><TD>&nbsp;</TD><TD>\n");

      fprintf (stdout,
"<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"setReload(\'%s\')\">&nbsp;\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"setReload(\'%s\')\">&nbsp;\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"setReload(\'%s\')\">&nbsp;\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"setReload(\'%s\')\">\
<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"setReload(\'%s\')\">&nbsp;\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"setReload(\'%s\')\">\n",
         lang_BtnToNewMail, lang_BtnToNewMail,
         lang_BtnToMail, lang_BtnToMail,
         lang_BtnToSent, lang_BtnToSent,
         lang_BtnToWasteBasket, lang_BtnToWasteBasket,
         lang_BtnEmptyWasteBasket, lang_BtnEmptyWasteBasket,
         lang_BtnDelete, lang_BtnDelete);
      DeleteButton = true;
   }

   /* "user" (all) folder buttons */
   if (CgiFormBwuPtr[0] == TopOrBottom &&
       FolderListHeadPtr != NULL)
   {
      if (!SectionCount++)
         fprintf (stdout,
"<P><TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR WIDTH=90%%><TD>&nbsp;</TD><TD>\n");
      else
         fprintf (stdout, "<P>");

      for (flptr = FolderListHeadPtr; flptr != NULL; flptr = flptr->NextPtr)
      {
         if (Debug)
            fprintf (stdout, "|%s|%s|\n",
                     MailFolderName, flptr->FolderNamePtr);
         cptr = (char*)CgiLibHtmlEscape (flptr->FolderNamePtr, -1, NULL, 0);
         fprintf (stdout,
"<INPUT TYPE=submit NAME=act VALUE=\"&quot;%s&quot;\" \
onClick=\"setReload(\'&quot;%s&quot;\')\">&nbsp;\n",
                  cptr, cptr);
         free (cptr);
      }
   }

   /* folder selector and open/move/copy buttons */
   if (TopOrBottom == '1' &&
       CgiFormBwfPtr[0] != '1' &&
       CgiFormBwfPtr[0] != '2')
      fprintf (stdout, "<INPUT TYPE=hidden NAME=fse VALUE=\"%s\">\n",
               HtmlEscapedMailFolderName);
   else
   if (CgiFormBwfPtr[0] == TopOrBottom)
   {
      if (!SectionCount++)
         fprintf (stdout,
"<P><TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR WIDTH=90%%><TD>&nbsp;</TD><TD>\n\
<NOBR>\n");
      else
         fprintf (stdout,
"<P>\
<NOBR>\n");

      fprintf (stdout, "<INPUT TYPE=text SIZE=15 NAME=fte>&nbsp;");

      FolderListHtmlSelect ();

      fprintf (stdout,
"&nbsp;<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"buildFormURL(\'%s\')\">&nbsp;\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"setReload(\'%s\')\">&nbsp;\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"setReload(\'%s\')\">&nbsp;\n",
         lang_BtnOpen, lang_BtnOpen,
         lang_BtnMove, lang_BtnMove,
         lang_BtnCopy, lang_BtnCopy);

      if (!DeleteButton)
         fprintf (stdout,
"<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"setReload(\'%s\')\">\n",
            lang_BtnDelete, lang_BtnDelete);

         fprintf (stdout, "</NOBR>\n");
   }

   /* create-send button */
   if (CgiFormBwcPtr[0] == TopOrBottom)
   {
      if (!SectionCount++)
         fprintf (stdout,
"<P><TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR WIDTH=90%%><TD>&nbsp;</TD><TD>\n");
      else
         fprintf (stdout, "<P>");

      fprintf (stdout,
"<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"return buildFormURL(\'%s\')\">&nbsp;&nbsp;\
<INPUT TYPE=checkbox NAME=taw VALUE=%d%s>&nbsp;<I>%s</I>&nbsp;&nbsp;",
         lang_BtnCreateSend, lang_BtnCreateSend,
         WrapAt ? WrapAt : 72, WrapAt ? " CHECKED" : "", lang_AutoWrap);

#ifdef YAHMAIL_MUNPACK

      if (MimeAttachmentSubjectKludge || MailProtocolIsPMDF)
      {
         fprintf (stdout, "<SELECT NAME=atc>\n");
         for (AttachmentCount = 1;
              AttachmentCount <= MAX_ATTACHMENTS;
              AttachmentCount++)
            fprintf (stdout, "<OPTION VALUE=%d%s>%d\n",
                     AttachmentCount,
                     AttachmentCount == 1 ? " SELECTED" : "",
                     AttachmentCount);
         fprintf (stdout, "</SELECT>&nbsp;<NOBR><I>%s</I></NOBR>\n",
                  lang_AttachmentsMax);
      }

#endif /* YAHMAIL_MUNPACK */

      fprintf (stdout,
"<BR><INPUT TYPE=file NAME=pem SIZE=35>&nbsp;<NOBR><I>%s</I></NOBR>\n",
         lang_PreEditedMessage);
   }

   /* "pick" fields */
   if (CgiFormBwpPtr[0] == TopOrBottom)
   {
      if (!SectionCount++)
         fprintf (stdout,
"<P><TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR WIDTH=90%%><TD>&nbsp;</TD><TD>\n");
      else
         fprintf (stdout, "<P>");

      PickCcPtr = (char*)CgiLibHtmlEscape (MailSubstringCc, -1, NULL, 0);
      PickFromPtr = (char*)CgiLibHtmlEscape (MailSubstringFrom, -1, NULL, 0);
      PickSubjPtr = (char*)CgiLibHtmlEscape (MailSubstringSubj, -1, NULL, 0);
      PickToPtr = (char*)CgiLibHtmlEscape (MailSubstringTo, -1, NULL, 0);

      fprintf (stdout,
"<INPUT TYPE=text SIZE=20 NAME=psu VALUE=\"%s\">\
&nbsp;<I>%s &quot;%s:&quot;</I>&nbsp;&nbsp;&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"doClearPick()\">\n\
<BR><INPUT TYPE=text SIZE=20 NAME=pfr VALUE=\"%s\">\
&nbsp;<I>%s &quot;%s:&quot;</I>\n\
<BR><INPUT TYPE=text SIZE=20 NAME=pto VALUE=\"%s\">\
&nbsp;<I>%s &quot;%s:&quot;</I>\n\
<BR><INPUT TYPE=text SIZE=20 NAME=pcc VALUE=\"%s\">\
&nbsp;<I>%s &quot;%s:&quot;</I>\n",
         PickSubjPtr, lang_BrowsePick, lang_MsgSubj, lang_BtnClear,
         PickFromPtr, lang_BrowsePick, lang_MsgFrom,
         PickToPtr, lang_BrowsePick, lang_MsgTo,
         PickCcPtr, lang_BrowsePick, lang_MsgCc);

      free (PickCcPtr);
      free (PickFromPtr);
      free (PickSubjPtr);
      free (PickToPtr);
   }
   else
   if (TopOrBottom == '2' &&
       (CgiFormBwpPtr[0] == '0' || !CgiFormBwpPtr[0]))
   {
      /* provide empty "pick" fields for JavaScript munging */
      fprintf (stdout,
"<INPUT TYPE=hidden NAME=psu VALUE=\"\">\n\
<INPUT TYPE=hidden NAME=pfr VALUE=\"\">\n\
<INPUT TYPE=hidden NAME=pto VALUE=\"\">\n\
<INPUT TYPE=hidden NAME=pcc VALUE=\"\">\n");
   }

   if (SectionCount)
      fprintf (stdout,
"</TD></TR>\n\
</TABLE>\n\
<P>");
}

/*****************************************************************************/
/*
Return a pointer to a "RE:", "RE[n]:", "FW:" or "FW[n]:", subject line as
appropriate.  The pointer should be free()ed after use.
*/

char* CreateMailMessageReFw
(
char *ReFwPtr,
char *SubjectPtr
)
{
   static $DESCRIPTOR (GtOneFaoDsc, "!AZ[!UL]: !AZ");
   static $DESCRIPTOR (OneFaoDsc, "!AZ: !AZ");

   int  InstanceCount;
   unsigned short  Length;
   char  *cptr;
   char  ReFwSubject [256];
   $DESCRIPTOR (ReFwSubjectDsc, ReFwSubject);

   /*********/
   /* begin */
   /*********/

   if (Debug)
      fprintf (stdout, "CreateMailMessageReFw() |%s|%s|\n",
               ReFwPtr, SubjectPtr);

   InstanceCount = 1;
   for (cptr = SubjectPtr; *cptr && isspace(*SubjectPtr); SubjectPtr++);

   if ((strsame (ReFwPtr, "RE", -1) &&
        strsame (cptr, "RE:", 3) || strsame (cptr, "RE[", 3)) ||
       (strsame (ReFwPtr, "FW", -1) &&
        strsame (cptr, "FW:", 3) || strsame (cptr, "FW[", 3)))
   {
      cptr += 2;
      if (*cptr == ':')
      {
         cptr++;
         InstanceCount++;
      }
      else
      {
         if (*cptr == '[') cptr++;
         if (isdigit(*cptr)) InstanceCount = atoi(cptr) + 1;
         while (*cptr && isdigit(*cptr)) cptr++;
         if (*cptr == ']') cptr++;
         if (*cptr == ':') cptr++;
      }
   }

   while (isspace(*cptr)) cptr++;
   if (Debug) fprintf (stdout, "|%s| %d\n", cptr, InstanceCount);

   if (InstanceCount > 1)
      sys$fao (&GtOneFaoDsc, &Length, &ReFwSubjectDsc,
               ReFwPtr, InstanceCount, cptr);
   else
      sys$fao (&OneFaoDsc, &Length, &ReFwSubjectDsc,
               ReFwPtr, cptr);
   ReFwSubject[Length] = '\0';
   if (Debug) fprintf (stdout, "|%s|\n", ReFwSubject);

   cptr = (char*)CgiLibHtmlEscape (ReFwSubject, -1, NULL, 0);

   return (cptr);
}

/*****************************************************************************/
/*
Provide a mail message composition page, the contents of which will be form
POSTed to the facility for VMS Mail sending.  Include the contents of the
original message if a reply or forward (if requested).
*/

CreateMailMessage ()

{
   static $DESCRIPTOR (VmsDateFaoDsc, "!17%D\0");

   boolean  SubjectKludge;
   int  cnt,
        status,
        AttachmentCount,
        CreateSendTextAreaRows,
        Length;
   char  ch;
   char  *cptr, *sptr, *zptr,
         *CopySelfPtr,
         *PersonalPtr,
         *ReFwPtr,
         *ReplyToPtr,
         *SenderPtr,
         *SigFileTextPtr,
         *SubjectPtr,
         *TextPtr;
   char  HtmlEscapedAddressLists,
         Scratch [256],
         VmsDate [32];
   $DESCRIPTOR (VmsDateDsc, VmsDate);

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "CreateMailMessage()\n");

   if (!MailUserName[0])
   {
      CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
      return;
   }

   CgiFormRtoPtr = CgiLibVar ("WWW_FORM_RTO");
   ReplyToPtr = (char*)CgiLibHtmlEscape (CgiFormRtoPtr, -1, NULL, 0);

   /* header and body encoding preferences */
   CgiFormEncPtr = CgiLibVar ("WWW_FORM_ENC");
   if (!CgiFormEncPtr[0]) CgiFormEncPtr = ConfigEncodingPtr;

   /* <TEXTAREA> width and automatic wrap at */
   cptr = CgiLibVar ("WWW_FORM_TAW");
   if (!cptr[0])
      WrapAt = 0;
   else
   {
      WrapAt = atoi(cptr);
      /* let's keep it within the bounds of reason! */
      if (WrapAt < 48) WrapAt = 48;
      if (WrapAt > 255) WrapAt = 255;
   }

   /* <TEXTAREA> rows */
   cptr = CgiLibVar ("WWW_FORM_TAR");
   if (!cptr[0])
      CreateSendTextAreaRows = CREATESEND_TEXTAREA_ROWS;
   else
      CreateSendTextAreaRows = atoi(cptr);
   /* let's keep it within the bounds of reason! */
   if (CreateSendTextAreaRows < 8) CreateSendTextAreaRows = 8;
   if (CreateSendTextAreaRows > 48) CreateSendTextAreaRows = 48;

   sys$fao (&VmsDateFaoDsc, 0, &VmsDateDsc, 0);

   if (VmsMailUserPersonalName[0])
      PersonalPtr =
         (char*)CgiLibHtmlEscape (VmsMailUserPersonalName, -1, NULL, 0);
   else
      PersonalPtr = "";

   /* look for and eliminate the VMS Mail MIME subject line kludge */
   if ((cptr = strstr (VmsMailSubject, "\r\nMIME-version: 1.0\r\n")) != NULL)
   {
      cptr[0] = '\0';
      SubjectKludge = true;
   }
   else
      SubjectKludge = false;

   CopySelfPtr = "";
   if (DoMessageReply)
   {
      if (ConfigReplyUseRfc822)
      {
         if (Debug) fprintf (stdout, "using RFC822\n");
         if (VmsMailRfc822ReplyTo[0])
            SenderPtr = (char*)CgiLibHtmlEscape (VmsMailRfc822ReplyTo, -1, NULL, 0);
         else
         if (VmsMailRfc822From[0])
            SenderPtr = (char*)CgiLibHtmlEscape (VmsMailRfc822From, -1, NULL, 0);
         else
            SenderPtr = (char*)CgiLibHtmlEscape (VmsMailSender, -1, NULL, 0);
      }
      else
         SenderPtr = (char*)CgiLibHtmlEscape (VmsMailSender, -1, NULL, 0);
      if (Debug) fprintf (stdout, "SenderPtr |%s|\n", SenderPtr);
      SubjectPtr = CreateMailMessageReFw ("RE", VmsMailSubject);
      if (VmsMailUserCopyReply) CopySelfPtr = " CHECKED";
   }
   else
   if (DoMessageForward)
   {
      SenderPtr = "";
      SubjectPtr = CreateMailMessageReFw ("FW", VmsMailSubject);
      if (VmsMailUserCopyForward) CopySelfPtr = " CHECKED";
   }
   else
   if (DoMessageCreate)
   {
      SenderPtr = "";
      SubjectPtr = "";
      if (VmsMailUserCopySend) CopySelfPtr = " CHECKED";
   }

   SigFileTextPtr = "";
   if (VmsVersion >= 70 &&
       VmsMailUserSigFile[0])
   {
      ReadSigFile ();
      SigFileTextPtr =
         (char*)CgiLibHtmlEscape (VmsMailSigFileTextPtr, -1, NULL, 0);
   }

#ifdef YAHMAIL_MUNPACK

   cptr = CgiLibVar ("WWW_FORM_ATC");
   AttachmentCount = atoi(cptr);
   if (Debug) fprintf (stdout, "AttachmentCount: %d\n", AttachmentCount);
   if (AttachmentCount <= 0)
      AttachmentCount = 1;
   else
   if (AttachmentCount > MAX_ATTACHMENTS)
      AttachmentCount = MAX_ATTACHMENTS;

#else /* YAHMAIL_MUNPACK */

   AttachmentCount = 0;

#endif /* YAHMAIL_MUNPACK */

   /***************************/
   /* begin writing HTML page */
   /***************************/

   if (VmsMailRfc822MimeCharset[0])
      CgiLibResponseHeader (200, "text/html",
                            "; charset=%s\n", VmsMailRfc822MimeCharset);
   else
      CgiLibResponseHeader (200, "text/html");

   fprintf (stdout,
"<HTML>\n\
<HEAD>\n\
<META NAME=\"generator\" CONTENT=\"%s\">\n\
<META NAME=\"environment\" CONTENT=\"%s\">\n\
<META NAME=\"language\" CONTENT=\"%s %s\">\n\
<TITLE>yahMAIL ... %s</TITLE>\n\
<SCRIPT LANGUAGE=\"JavaScript\">\n\
<!--\n\
var listURL = \"\";\n\
\
function setReload () {\n\
   document.cookie = \"YAHMAIL=RELOAD; path=%s/\"\n\
}\n\
\
function doSubmit () {\n\
   if (listURL == \"\") {\n\
      if (document.formCreate.sto.value == \"\") {\n\
         alert(\"%s\");\n\
         return false;\n\
      }\n\
      if (document.formCreate.ssu.value == \"\" || \
document.formCreate.sbd.value == \"\") {\n\
         return confirm(\"%s\");\n\
      }\n\
      return true;\n\
   }\n\
   open (listURL, \"AddrList\", \"%s\");\n\
   listURL = \"\";\n\
   return false;\n\
}\n\
\
function doAddrList () {\n\
   listURL = document.formCreate.action + \"?\" + \"act=%s\";\n\
}\n\
\
// -->\n\
</SCRIPT>\n\
</HEAD>\n\
<BODY %s>\n\
%s\
<FORM METHOD=POST ENCTYPE=\"multipart/form-data\" ACTION=\"%s/%c%s\" \
NAME=formCreate onSubmit=\"return doSubmit()\">\n\
<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR><TD HEIGHT=10></TD></TR>\n\
<TR><TH ALIGN=right VALIGN=center>%s:&nbsp;&nbsp;</TH><TD>%s</TD></TR>\n\
<TR><TD HEIGHT=5></TD></TR>\n",
      SoftwareID, CgiEnvironmentPtr, lang_Language, lang_LanguageAuthor,
      SubjectPtr[0] ? SubjectPtr : lang_CreateNew,
      CgiScriptNamePtr,
      lang_ErrSendRecipient, lang_ErrSendSubjBody,
      ADDRESS_LIST_WINDOW,
      (char*)CgiLibUrlEncode (lang_BtnAddressLists, -1, NULL, 0),
      ConfigBodyTagPtr, PostMasterWarningPtr,
      CgiScriptNamePtr, TildeChar, MailUserName,
      lang_MsgDate, VmsDate);

   if (PostMasterAuthenticated)
   {
      fprintf (stdout,
"<TR><TH ALIGN=right VALIGN=center>%s:&nbsp;&nbsp;</TH>\
<TD><INPUT TYPE=text SIZE=60 NAME=sfr VALUE=\"%s%s%s%s\"></TD>\
</TR>\n\
<TR><TD HEIGHT=5></TD></TR>\n\
<TR><TH ALIGN=right VALIGN=center>%s:&nbsp;&nbsp;</TH>\
<TD><INPUT TYPE=text SIZE=45 NAME=rto VALUE=\"%s\"></TD></TR>\
<TR><TD HEIGHT=5></TD></TR>\n",
         lang_MsgFrom, MailUserName, PersonalPtr[0] ? " &quot;" : "",
         PersonalPtr, PersonalPtr[0] ? "&quot;" : "",
         lang_MsgReplyTo, ReplyToPtr);
   }
   else
   {
      fprintf (stdout,
"<TR>\
<TH ALIGN=right VALIGN=center>%s:&nbsp;&nbsp;</TH>\
<TD>%s&nbsp;&nbsp;<INPUT TYPE=text SIZE=45 NAME=spn VALUE=\"%s\"></TD>\
</TR>\n\
<TR><TD HEIGHT=5></TD></TR>\n\
<TR><TH ALIGN=right VALIGN=center>%s:&nbsp;&nbsp;</TH>\
<TD><INPUT TYPE=text SIZE=45 NAME=rto VALUE=\"%s\"></TD></TR>\
<TR><TD HEIGHT=5></TD></TR>\n",
         lang_MsgFrom, MailUserName, PersonalPtr,
         lang_MsgReplyTo, ReplyToPtr);
   }

   fprintf (stdout,
"<TR><TH></TH>\
<TR><TH ALIGN=right VALIGN=center>%s:&nbsp;&nbsp;</TH>\
<TD><TEXTAREA ROWS=3 COLS=60 NAME=sto>%s</TEXTAREA></TD>\
<TD>&nbsp;<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"return doAddrList()\"></TD></TR>\n\
<TR><TH ALIGN=right VALIGN=center>%s:&nbsp;&nbsp;</TH>\
<TD><TEXTAREA ROWS=2 COLS=60 NAME=scc></TEXTAREA></TD>\
<TD>&nbsp;<INPUT TYPE=checkbox NAME=scs VALUE=1%s>\
<I>&nbsp;%s</I></TD></TR>\n\
<TR><TH ALIGN=right VALIGN=center>%s:&nbsp;&nbsp;</TH>\
<TD><INPUT TYPE=text SIZE=60 NAME=ssu VALUE=\"%s\"></TD></TR>\n\
</TABLE>\n\
<INPUT TYPE=hidden NAME=enc VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=wra VALUE=%d>\n\
<P><TEXTAREA NAME=sbd ROWS=%d COLS=%d WRAP=%s>\n",
      lang_MsgTo, SenderPtr, lang_BtnAddressLists,
      lang_MsgCc, CopySelfPtr, lang_CcSelf,
      lang_MsgSubj, SubjectPtr,
      CgiFormEncPtr,
      WrapAt,
      CreateSendTextAreaRows,
      WrapAt ? WrapAt : 72, WrapAt ? "on" : "off");

   CgiFormPreEditedMessagePtr = CgiLibVar ("WWW_FORM_PEM");
   CgiFormIncludePtr = CgiLibVar ("WWW_FORM_INC");

   if (CgiFormPreEditedMessagePtr[0])
   {
      cptr = CgiLibVar ("WWW_FORM_PEM_MIME_FILENAME");
      sptr = CgiLibVar ("WWW_FORM_PEM_MIME_CONTENT_TYPE");
      if (!strsame (sptr, "text/", 5))
      {
         /* hmmm, browser has not identified this as "text/..." */
         fprintf (stdout,
"%s\n\
\n\
filename=&quot;%s&quot;\r\n\
content-type=&quot;%s&quot;\n",
            lang_ErrPreEditedNotText, cptr, sptr);
      }
      else
      {
         /* insert the pre-edited/prepared message text */
         CgiLibHtmlDeEntify (CgiFormPreEditedMessagePtr);
         TextPtr = (char*)CgiLibHtmlEscape (CgiFormPreEditedMessagePtr, -1, NULL, 0);
         fputs (TextPtr, stdout);
         free (TextPtr);
      }
   }
   else
   if (CgiFormIncludePtr[0] && (DoMessageReply || DoMessageForward))
   {
      CgiFormQuotePtr = CgiLibVar ("WWW_FORM_QUO");

#ifdef YAHMAIL_MUNPACK

      if (SubjectKludge ||
          (VmsMailRfc822MimeVersion &&
           (!strsame (VmsMailRfc822MimeContentType, "text/plain", -1) ||
            !(VmsMailRfc822MimeContTransEnc[0] == '7' ||
              VmsMailRfc822MimeContTransEnc[0] == '8' ||
              strsame (VmsMailRfc822MimeContTransEnc, "binary", -1)))))
      {
         /* not a simple plain-text MIME message */
         MunpackYahmailProcess (CgiFormQuotePtr[0]);
         MunpackYahmailText (stdout, false, WrapLongLines);

         /* cancel any include that might be done immediately below! */
         CgiFormIncludePtr = "";
      }

#endif /* YAHMAIL_MUNPACK */

      if (CgiFormIncludePtr[0])
      {
         cptr = CgiLibVar("WWW_FORM_HEA");
         if (cptr[0])
         {
            /* include the VMS (and consequently any RFC822) header */
            TextPtr = (char*)CgiLibHtmlEscape (VmsMailTextPtr, -1, NULL, 0);
         }
         else
         {
            cptr = CgiLibVar("WWW_FORM_RFC");
            if (cptr[0])
            {
               /* include from the RFC822 header */
               TextPtr = (char*)CgiLibHtmlEscape (VmsMailTextPtr +
                                                  VmsMailHeaderLength,
                                                  -1, NULL, 0);
            }
            else
            {
               /* exclude both VMS and RFC822 headers */
               TextPtr = (char*)CgiLibHtmlEscape (VmsMailTextPtr +
                                                  VmsMailHeaderLength +
                                                  VmsMailRfc822HeaderLength,
                                                  -1, NULL, 0);
#ifdef YAHMAIL_MUNPACK
               if (MimeQuotedPrintable) fromqp_string (TextPtr, NULL, true);
#endif /* YAHMAIL_MUNPACK */
            }
         }

         if (WrapLongLines) ViewMsgWrapLongLines (TextPtr, WrapLongLines);

         cptr = TextPtr;
         while (*cptr)
         {
            sptr = cptr;
            while (*cptr && *cptr != '\n') cptr++;
            if (*cptr) cptr++;
            if (CgiFormQuotePtr[0]) fputs ("&gt;", stdout);
            fwrite (sptr, cptr-sptr, 1, stdout);
         }
         free (TextPtr);
      }
   }

   if (SigFileTextPtr[0]) fputs (SigFileTextPtr, stdout);

   fprintf (stdout, "</TEXTAREA>\n");

#ifdef YAHMAIL_MUNPACK

   if (MimeAttachmentSubjectKludge || MailProtocolIsPMDF)
   {
      fprintf (stdout,
"<INPUT TYPE=hidden NAME=atc VALUE=\"%d\">\n\
<BR><TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR><TH ROWSPAN=%d>%s:&nbsp;&nbsp;</TH>\n",
	 AttachmentCount, AttachmentCount,
         AttachmentCount == 1 ? lang_AttachmentSingular :
                                lang_AttachmentPlural);

      for (cnt = 1; cnt <= AttachmentCount; cnt++)
      {
         if (cnt > 1) fputs ("<TR>", stdout);
         fprintf (stdout,
                  "<TD><INPUT TYPE=file NAME=att%d SIZE=35></TD></TR>\n",
                  cnt);
      }
   }
   fputs ("</TABLE>\n", stdout);

#endif /* YAHMAIL_MUNPACK */

   /***********/
   /* buttons */
   /***********/

   fprintf (stdout,
"<P><INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"setReload()\">&nbsp;\n\
<INPUT TYPE=reset VALUE=\"%s\"><I> ... %s</I>\n\
<P><INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>\n\
<P>%s\n\
</BODY>\n\
</HTML>\n",
      lang_BtnSend, lang_BtnReset, lang_ResetCaution,
      lang_BtnGoBack,
      ConfigCreateFooterPtr);

   if (DoMessageReply) free (SenderPtr);
   free (PersonalPtr);
   free (ReplyToPtr);
   free (SubjectPtr);
   free (SigFileTextPtr);
}

/*****************************************************************************/

