/*****************************************************************************/
/*
                                 Public.c

This module provides processing to allow the public (non-authenticated)
browsing of VMS mail folders.


COPYRIGHT
---------
Copyright (C) 1999-2003 Mark G.Daniel
This program, comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.


VERSION HISTORY
---------------
19-FEB-2000  MGD  unbundled from YAHMAIL.C for v1.3
*/

/*****************************************************************************/

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

/* standard C header files */
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>

/* VMS related header files */
#include <maildef.h>
#include <mailmsgdef.h>
#include <ssdef.h>
#include <stsdef.h>

/* application header file */
#include "yahmail.h"
#include "externs.h"

#define FI_LI __FILE__, __LINE__

/*****************************************************************************/
/*
An un-authenticated request is allowed limited read access to specifically
configured public area/archive.
*/

ProcessPublicRequest ()
       
{
   int  status;
   char  *cptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ProcessPublicRequest()\n");

   if (MailFileName[0])
   {
      CgiLibResponseError (FI_LI, 0, lang_ErrConfigRestriction);
      return;
   }
   if (MailFolderName[0] && PublicFolderName[0] &&
      strcmp (MailFolderName, PublicFolderName))
   {
      CgiLibResponseError (FI_LI, 0, lang_ErrConfigRestriction);
      return;
   }

   /* ensure these come from the configuration file, nowhere else!! */
   strzcpy (MailUserName, PublicUserName, SizeOfMailFileName);
   strzcpy (MailFileName, PublicFileName, SizeOfMailFileName);
   /* if the configuration specifies a folder then force that, otherwise */
   if (PublicFolderName[0])
      strzcpy (MailFolderName, PublicFolderName, SizeOfMailFolderName);
   else
   if (CgiFormFolderNamePtr != NULL && CgiFormFolderNamePtr[0])
      strzcpy (MailFolderName, CgiFormFolderNamePtr, SizeOfMailFolderName);
   else
   if (!MailFolderName[0])
      strcpy (MailFolderName, "NEWMAIL");

   MailUserNameLength = strlen(MailUserName);
   MailFileNameLength = strlen(MailFileName);
   MailFolderNameLength = strlen(MailFolderName);

   if (Debug)
      fprintf (stdout, "|%s|%s|%s|%d|\n",
               MailUserName, MailFileName, MailFolderName, MailMessageId[0]);

   CgiLibHtmlEscape (MailFolderName, -1,
                     HtmlEscapedMailFolderName,
                     SizeOfHtmlEscapedMailFolderName);

   DoFolderBrowse = DoMessageRead = false;
   if (MailMessageId[0])
      DoMessageRead = true;
   else
      DoFolderBrowse = true;

   BuildActionPathInfo ();

   if (DoFolderBrowse)
   {
      /************************/
      /* public folder browse */
      /************************/

      status = MailFileOpen ();
      if (Debug) fprintf (stdout, "MailFileOpen() %%X%08.08X\n", status);
      if (VMSnok (status))
      {
         ResponseErrorMail (FI_LI, status, lang_ErrOpenMail);
         return;
      }

      if (ConfigPublicBrowseFolders)
      {
         status = GenerateFolderList ();
         if (Debug)
            fprintf (stdout, "GenerateFolderList() %%X%08.08X\n", status);
         if (VMSnok (status))
         {
            ResponseErrorMail (FI_LI, status, lang_ErrGenerateFolderList);
            return;
         }
         if (Debug) fprintf (stdout, "|%s|\n", MailFolderName);
      }

      status = MailReadPublicConfigMessage ();
      if (Debug)
         fprintf (stdout, "MailReadPublicConfigMessage() %%X%08.08X\n", status);

      status = GenerateMessageList ();
      if (Debug) fprintf (stdout, "GenerateMessageList() %%X%08.08X\n", status);

      if (VMSok (status))
         BrowseFolderPublic ();
      else
         ResponseErrorMail (FI_LI, status, lang_ErrGenerateMessageList);

      MailFileClose ();

      return;
   }

   if (DoMessageRead)
   {
      /************************/
      /* public message read */
      /************************/

      status = MailFileOpen ();
      if (Debug) fprintf (stdout, "MailFileOpen() %%X%08.08X\n", status);
      if (VMSnok (status))
      {
         ResponseErrorMail (FI_LI, status, lang_ErrOpenMail);
         return;
      }

      for (;;)
      {
         status = MailReadMessage ();
         if (Debug) fprintf (stdout, "MailReadMessage() %%X%08.08X\n", status);
         if (VMSok (status))
         {
            if (strstr (VmsMailSubject, PublicConfigSubjPtr) != NULL)
            {
               /* woops, bumped into a public folder configuration message */
               if (MessageIncrement)
               {
                  /* next/previous requested, so onto next message */
                  MailMessageId[0] += MessageIncrement;
                  continue;
               }
               else
                  ResponseErrorMail (FI_LI, MAIL$_NOMOREMSG,
                                     lang_ErrMessageRead);
            }
            else
               ViewMailMessage ();
         }
         else
            ResponseErrorMail (FI_LI, status, lang_ErrMessageRead);

         break;
      }

      MailFileClose ();

      return;
   }

   CgiLibResponseError (FI_LI, 0, lang_ErrConfigRestriction);
}

/*****************************************************************************/
/*
Generate an HTML page listing details all the selected messages in the
specified folder.
*/

BrowseFolderPublic ()

{
   int  IdPage,
        IdFrom,
        IdTo,
        FolderCount;
   char  *cptr,
         *DatePtr,
         *FromPtr,
         *PickFromPtr,
         *PickSubjPtr,
         *SubjectPtr;
   char  HtmlFolderName [256],
         NoneString [64];
   struct MessageListStruct  *mlptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "BrowseFolderPublic()\n");

   if (PublicTitlePtr == NULL)
      PublicTitlePtr = PublicUserName;

   /* in-folder message header overrides public, which overrides general */
   if (PublicHeaderPtr == NULL)
      PublicHeaderPtr = ConfigPublicHeaderPtr;
   if (PublicHeaderPtr == NULL)
      PublicHeaderPtr = ConfigFolderHeaderPtr;

   /* in-folder message footer overrides public, which overrides general */
   if (PublicFooterPtr == NULL)
      PublicFooterPtr = ConfigPublicFooterPtr;
   if (PublicFooterPtr == NULL)
      PublicFooterPtr = ConfigFolderFooterPtr;

   PickFromPtr = (char*)CgiLibHtmlEscape (MailSubstringFrom, -1, NULL, 0);
   PickSubjPtr = (char*)CgiLibHtmlEscape (MailSubstringSubj, -1, NULL, 0);

   BuildActionQueryString ();

   CgiLibResponseHeader (200, "text/html");
   fprintf (stdout,
"<HTML>\n\
<HEAD>\n\
<META NAME=\"generator\" CONTENT=\"%s\">\n\
<META NAME=\"environment\" CONTENT=\"%s\">\n\
<META NAME=\"language\" CONTENT=\"%s %s\">\n\
<TITLE>yahMAIL ... %s</TITLE>\n\
<SCRIPT LANGUAGE=\"JavaScript\">\n\
<!--\n\
\
var formURL = \"\";\n\
\
function doRange (rangeURL) {\n\
   location.replace(rangeURL);\n\
   return false;\n\
}\n\
\
function doClearPick () {\n\
   document.formPage.pfr.value =\n\
   document.formPage.psu.value = \"\";\n\
}\n\
\
function doSubmit () {\n\
   if (formURL == \"\") return true;\n\
   location.replace(formURL);\n\
   return false;\n\
}\n\
\
function buildFormURL (actionButton) {\n\
   var elementName, elementValue;\n\
   formURL = document.formPage.action + \"?act=\" + escape(actionButton);\n\
   for (idx = 0; idx < document.formPage.elements.length; idx++) {\n\
      if (document.formPage.elements[idx].type == \"hidden\" ||\n\
          document.formPage.elements[idx].type == \"text\") {\n\
         elementName = document.formPage.elements[idx].name;\n\
         elementValue = document.formPage.elements[idx].value;\n\
         formURL += \"&\" + elementName + \"=\" + escape(elementValue);\n\
      }\n\
      else\n\
      if (document.formPage.elements[idx].type == \"checkbox\") {\n\
         if (document.formPage.elements[idx].checked) {\n\
            elementName = document.formPage.elements[idx].name;\n\
            elementValue = document.formPage.elements[idx].value;\n\
            formURL += \"&\" + elementName + \"=\" + escape(elementValue);\n\
         }\n\
      }\n\
      else\n\
      if (document.formPage.elements[idx].type == \"select-one\") {\n\
         elementName = document.formPage.elements[idx].name;\n\
         elementValue = document.formPage.elements[idx].options\
[document.formPage.elements[idx].selectedIndex].value;\n\
         formURL += \"&\" + elementName + \"=\" + escape(elementValue);\n\
      }\n\
   }\n\
   resetCookie();\n\
}\n\
\
// -->\n\
</SCRIPT>\n\
</HEAD>\n\
<BODY %s>\n\
%s\
<FONT SIZE=+1><B><U>%s</U></B></FONT>\n\
<BR>&nbsp;<FONT SIZE=-1>yahMAIL<SUP>*</SUP></FONT>\n\
<FORM NAME=formPage ACTION=\"%s\" onSubmit=\"return doSubmit()\">\n\
<INPUT TYPE=hidden NAME=cmc VALUE=\"%d\">\n\
<INPUT TYPE=hidden NAME=anc VALUE=\"%d\">\n",
      SoftwareID, CgiEnvironmentPtr, lang_Language, lang_LanguageAuthor,
      PublicTitlePtr, ConfigBodyTagPtr, PublicHeaderPtr, PublicTitlePtr,
      ActionPathInfo, VmsMailMessageSelectedCount, MakeAnchors);

   IdPage = 1;
   IdFrom = VmsMailMessageSelectedCount - PublicConfigSubjCount;
   while (IdFrom > 0)
   {
      if (IdFrom > BrowseWindow)
         IdTo = IdFrom - BrowseWindow + 1;
      else
         IdTo = 1;

      if (IdPage == BrowsePage)
         fprintf (stdout, "[%04d-%04d]\n", IdFrom, IdTo);
      else
         fprintf (stdout,
"[<A HREF=\"%s%s&pag=%d\" \
onClick=\"return doRange(\'%s%s&pag=%d\')\">%04d-%04d</A>]\n",
            ActionPathInfo, ActionQueryString, IdPage,
            ActionPathInfo, ActionQueryString, IdPage,
            IdFrom, IdTo);

      IdFrom -= BrowseWindow;
      IdPage++;
   }
   if (VmsMailMessageSelectedCount - PublicConfigSubjCount)
      fprintf (stdout, "<BR>\n");

   fprintf (stdout, "<HR ALIGN=left WIDTH=70%% HEIGHT=1 NOSHADE>\n");

   for (mlptr = MessageListTailPtr; mlptr != NULL; mlptr = mlptr->PrevPtr)
   {
      if (Debug) fprintf (stdout, "id: %d\n", mlptr->MessageId);

      FromPtr = (char*)CgiLibHtmlEscape (mlptr->FromPtr, -1, NULL, 0);

      /* look for and eliminate the VMS Mail MIME subject line kludge */
      if ((cptr = strstr (mlptr->SubjectPtr,
                          "\r\nMIME-version: 1.0\r\n")) != NULL)
         cptr[0] = '\0';

      if (mlptr->SubjectPtr[0])
         SubjectPtr = (char*)CgiLibHtmlEscape (mlptr->SubjectPtr, -1, NULL, 0);
      else
         sprintf (SubjectPtr = NoneString, "<I>(%s)</I>", lang_NoSubject);

      /* ROWSPAN=3 here meshes quite nicely with RelatedList() COLSPAN=2 */
      fprintf (stdout,
"<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR>\
<TD ROWSPAN=3 VALIGN=top>[<A HREF=\"%s%d%s\">%04d</A>]&nbsp;&nbsp;&nbsp;</TD>\
<TH ALIGN=left VALIGN=top><U>%s</U></TH>\
</TR>\n\
<TR><TD ALIGN=left VALIGN=top>%s</TD></TR>\n\
<TR><TD ALIGN=left VALIGN=top>\
<FONT SIZE=-1>%17.17s</FONT></TD></TR>\n",
         ActionPathInfo, mlptr->MessageId, ActionQueryString, mlptr->MessageId,
         SubjectPtr, FromPtr, mlptr->DatePtr);

      RelatedList (mlptr->SubjectPtr);

      fprintf (stdout, "<TR><TD HEIGHT=5></TD></TR>\n</TABLE>\n");

      free (FromPtr);
      free (SubjectPtr);
   }

   if (!MessageListCount)
   {
      if (MailSubstringFrom[0] || MailSubstringSubj[0])
         fprintf (stdout, "&nbsp;<I>(%s)</I>\n", lang_NoMessagesSelected);
      else
         fprintf (stdout, "&nbsp;<I>(%s)</I>\n", lang_NoMessages);
   }

   fprintf (stdout, "<HR ALIGN=left WIDTH=70%% HEIGHT=1 NOSHADE>\n");

   if (FolderListCount)
   {
      fprintf (stdout, "<P>");

      FolderListHtmlSelect ();

      fprintf (stdout,
"<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"buildFormURL(\'%s\')\">\n",
         lang_BtnOpen, lang_BtnOpen);
   }

   PickFromPtr = (char*)CgiLibHtmlEscape (MailSubstringFrom, -1, NULL, 0);
   PickSubjPtr = (char*)CgiLibHtmlEscape (MailSubstringSubj, -1, NULL, 0);

   fprintf (stdout,
"<P>&nbsp;<INPUT TYPE=text SIZE=20 NAME=psu VALUE=\"%s\">\
&nbsp;<I>%s &quot;%s:&quot;</I>&nbsp;&nbsp;&nbsp;\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"doClearPick()\">\n\
<BR>&nbsp;<INPUT TYPE=text SIZE=20 NAME=pfr VALUE=\"%s\">\
&nbsp;<I>%s &quot;%s:&quot;</I>\n\
<BR>&nbsp;",
      PickSubjPtr, lang_BrowsePick, lang_MsgSubj, lang_BtnClear,
      PickFromPtr, lang_BrowsePick, lang_MsgFrom);

   HtmlSelectBrowseWindow ();

   if (!FolderListCount)
      fprintf (stdout,
"<P><INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"buildFormURL(\'%s\')\">\n",
         lang_BtnOpen, lang_BtnOpen);

   fprintf (stdout,
"</FORM>\n\
<P>%s\n\
</BODY>\n\
</HTML>\n",
      PublicFooterPtr);

   free (PickFromPtr);
   free (PickSubjPtr);
}

/*****************************************************************************/

