/*****************************************************************************/
/*
                                 SendMsg.c

This module receives an HTTP POSTed request containg the detail of a message to
be mailed, by default, via the VMS mail callable interface, or if a complied
option via the PMDF message send API.

The VMS callable mail functionality includes the subject-line kludge to allow
the sending of MIME attachments as described in the description of YAHMAIL.C.

The PMDF API provides a more elegant solution, allowing a legitimate MIME
message to be constructed and sent.


COPYRIGHT
---------
Copyright (C) 1999-2003 Mark G.Daniel
This program, comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.


VERSION HISTORY
---------------
11-FEB-2003  MGD  allow for addresses in '"blah" <address>' format
09-FEB-2003  MGD  reply-to (for MultiNet, MX, PMDF, TCPIP, TCPWARE)
09-JUN-2002  MGD  configurable ISO header and quoted-printable body
02-MAY-2002  MGD  quoted-printable encoding
10-APR-2002  MGD  PMDF remove personal name component from POSTMASTER "From:"
23-MAR-2002  MGD  provide RFC1522 encoded-words in message header
23-JAN-2002  MGD  bugfix; SendMailMessage() inserted mail transport
16-JAN-2001  MGD  local-to-smtp
03-NOV-2000  MGD  'CompilationIncludesPMDF' flag
26-JUL-2000  MGD  bugfix; for PMDF 5.2 PmdfWriteHeader() (worked for 6.0)
04-APR-2000  MGD  correct multiple attachment handling
19-FEB-2000  MGD  unbundled from YAHMAIL.C for v1.3
*/
/*****************************************************************************/

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

/* standard C header files */
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>

/* VMS related header files */
#include <descrip.h>
#include <lnmdef.h>
#include <maildef.h>
#include <mailmsgdef.h>
#include <prvdef.h>
#include <psldef.h>
#include <ssdef.h>
#include <stsdef.h>

/* application header file */
#include "yahmail.h"
#include "externs.h"

#ifdef YAHMAIL_PMDF 

#include "pmdf_com:apidef.h" 

PMDF_nq *PmdfNqCtx; 
PMDF_hdr *PmdfHdrPtr;

/* inform other portions of yahMAIL that PMDF is a compiled option */
boolean  CompilationIncludesPMDF = true;

#else /* YAHMAIL_PMDF */

/* inform other portions of yahMAIL that PMDF is a NOT a compiled option */
boolean  CompilationIncludesPMDF = false;

#endif /* YAHMAIL_PMDF */

#define FI_LI __FILE__, __LINE__

/*****************************************************************************/
/*
Prepare and send a message POSTed from CreateMailMessage() for actual sending
using the generic mailing function VmsEmailMessage().
*/

void SendMailMessage () 

{
   static unsigned long  PslUser = PSL$C_USER;
   static unsigned long  SysPrvMask [2] = { PRV$M_SYSPRV, 0 };
   static unsigned short  UserNameTypeTo = MAIL$_TO,
                          UserNameTypeCc = MAIL$_CC;
   static unsigned short  Length;
   static char  String [256];
   static $DESCRIPTOR (LnmProcessDsc, "LNM$PROCESS");
   static $DESCRIPTOR (MultiNetSmtpReplyToDsc, "MULTINET_SMTP_REPLY_TO");
   static $DESCRIPTOR (MxReplyToDsc, "MX_REPLY_TO");
   static $DESCRIPTOR (ReplyToDsc, "");
   static $DESCRIPTOR (StringDsc, String);
   static $DESCRIPTOR (TcpIpSmtpFromDsc, "TCPIP$SMTP_FROM");
   static $DESCRIPTOR (TcpWareSmtpReplyToDsc, "TCPWARE_SMTP_REPLY_TO");

   static struct  VmsItemStruct

   LnmReplyToItem [] =
   {
      { 0, LNM$_STRING, 0, 0 },
      { 0,0,0,0 }
   };

   static struct  VmsItemLongStruct

   BodyPartItem [] =
   {
      { 0, MAIL$_SEND_RECORD, 0, 0 },
      { 0, MAIL$_NOSIGNAL, 0, 0 },
      {0,0,0,0}
   },
   FromItem [] =
   {
      { 0, MAIL$_SEND_FROM_LINE, 0, 0 },
      { 0, MAIL$_NOSIGNAL, 0, 0 },
      {0,0,0,0}
   },
   SendBeginSigFileItem [] =
   {
      { 0, MAIL$_SEND_NO_SIGFILE, 0, 0 },
      { 0, MAIL$_SEND_NO_PERS_NAME, 0, 0 },
      { 0, MAIL$_NOSIGNAL, 0, 0 },
      {0,0,0,0}
   },
   SendBeginNoSigFileItem [] =
   {
      { 0, MAIL$_SEND_NO_PERS_NAME, 0, 0 },
      { 0, MAIL$_NOSIGNAL, 0, 0 },
      {0,0,0,0}
   },
   SendToItem [] =
   {
      { 0, MAIL$_SEND_USERNAME, 0, 0 },
      { sizeof(UserNameTypeTo), MAIL$_SEND_USERNAME_TYPE, &UserNameTypeTo, 0 },
      { 0, MAIL$_NOSIGNAL, 0, 0 },
      {0,0,0,0}
   },
   SendCcItem [] =
   {
      { 0, MAIL$_SEND_USERNAME, 0, 0 },
      { sizeof(UserNameTypeCc), MAIL$_SEND_USERNAME_TYPE, &UserNameTypeCc, 0 },
      { 0, MAIL$_NOSIGNAL, 0, 0 },
      {0,0,0,0}
   },
   SubjectItem [] =
   {
      { 0, MAIL$_SEND_SUBJECT, 0, 0 },
      { 0, MAIL$_NOSIGNAL, 0, 0 },
      {0,0,0,0}
   },
   NoSignalItem [] =
   {
      { 0, MAIL$_NOSIGNAL, 0, 0 },
      {0,0,0,0}
   },
   NullItem = {0,0,0,0};

   boolean  BodyQuotedPrintable,
            CommercialAtHit,
            EightBitHit,
            HeaderIsoString,
            SendQuotedPrintable,
            SmtpTransportHit;
   int  cnt, idx,
        status,
        AttachmentCount,
        AttachmentTotal,
        MailAddressLength,
        MimeHeaderLength,
        PostBufferCount,
        SmtpTransportLength,
        SubjectLength,
        WrapCount;
   int  CgiFormAttachLength [MAX_ATTACHMENTS+1];
   unsigned long  SendContext = 0;
   unsigned long  PrevPrvMask [2];
   unsigned long  BinTime [2];
   char  *cptr, *sptr, *tptr, *zptr,
         *BodyPtr,
         *CcPtr,
         *CgiFormMimeHeaderPtr,
         *CgiFormSendBodyPtr,
         *CurrentToPtr,
         *FromPtr,
         *MimeHeaderPtr,
         *PersonalPtr,
         *PostBufferPtr,
         *ReplyToPtr,
         *SubjectPtr,
         *ToPtr;
   char  QuoteChar;
   char  *CgiFormAttachPtr [MAX_ATTACHMENTS+1],
         *CgiFormAttachContentTypePtr [MAX_ATTACHMENTS+1],
         *CgiFormAttachFileNamePtr [MAX_ATTACHMENTS+1];
   char  AttFieldName [64],
         AttList [(128*MAX_ATTACHMENTS)+256],
         Boundary [256],
         CcString [512],
         FromString [512],
         IsoCc [256],
         IsoFileName [256],
         IsoFrom [256],
         IsoSubject [256],
         IsoTo [256],
         MailAddress [256],
         MimeHeader [256],
         Scratch [512],
         SmtpAddress [256+64],
         SubjectBuffer [256];

#ifdef YAHMAIL_PMDF 
   char  PmdfContentType [128],
         PmdfXyahMAIL [128];
#endif /* YAHMAIL_PMDF */

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "SendMailMessage()\n");

   if (!MailUserName[0])
   {
      /* gotta be authenticated! */
      CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
      return;
   }

#ifdef YAHMAIL_MUNPACK

   AttachmentTotal = 0;
   HeaderIsoString = BodyQuotedPrintable = false;
   if (MimeAttachmentSubjectKludge || MailProtocolIsPMDF)
   {
      cptr = CgiLibVar ("WWW_FORM_ATC");
      AttachmentTotal = atoi(cptr);
      if (Debug) fprintf (stdout, "AttachmentTotal: %d\n", AttachmentTotal);

      cptr = CgiLibVar ("WWW_FORM_ENC");
      if (cptr[0] == 'I') HeaderIsoString = true;
      if (cptr[1] == 'Q') BodyQuotedPrintable = true;
   }
   if (Debug)
      fprintf (stdout, "HeaderIsoString:%d BodyQuotedPrintable:%d\n",
               HeaderIsoString, BodyQuotedPrintable);

   for (AttachmentCount = 1;
        AttachmentCount <= AttachmentTotal;
        AttachmentCount++)
   {
      CgiFormAttachPtr[AttachmentCount] = 
         CgiFormAttachContentTypePtr[AttachmentCount] = 
         CgiFormAttachFileNamePtr[AttachmentCount] = "";

      sprintf (AttFieldName, "WWW_FORM_ATT%d", AttachmentCount);
      CgiFormAttachPtr[AttachmentCount] = CgiLibVar (AttFieldName);
      if (!CgiFormAttachPtr[AttachmentCount][0]) continue;
     
      /* CGILIB should also have created these variables (i.e. an upload) */
      sprintf (AttFieldName, "WWW_FORM_ATT%d_MIME_FILENAME",
               AttachmentCount);
      CgiFormAttachFileNamePtr[AttachmentCount] = CgiLibVar (AttFieldName);
      sprintf (AttFieldName, "WWW_FORM_ATT%d_MIME_CONTENT_TYPE",
               AttachmentCount);
      CgiFormAttachContentTypePtr[AttachmentCount] = CgiLibVar (AttFieldName);
   }
   AttachmentCount--;
   if (Debug) fprintf (stdout, "AttachmentCount: %d\n", AttachmentCount);

#endif /* YAHMAIL_MUNPACK */

   ToPtr = CgiLibVar("WWW_FORM_STO");
   CcPtr = CgiLibVar("WWW_FORM_SCC");
   SubjectPtr = CgiLibVar("WWW_FORM_SSU");
   BodyPtr = CgiLibVar("WWW_FORM_SBD");
   MimeHeaderPtr = CgiLibVar("WWW_FORM_MHD");

   ReplyToPtr = CgiLibVar("WWW_FORM_RTO");
   if (ReplyToPtr && ReplyToPtr[0])
   {
      /*
         For non-PMDF reply-to yahMAIL tries to cover all bases by defining
         an appropriate logical name for all known agents that provide
         transports for SMTP mailing via VMS callable MAIL.  As these are
         defined at user-mode they are automatically deassigned on image exit.
      */
      if (Debug) fprintf (stdout, "ReplyToPtr |%s|\n", ReplyToPtr);
      LnmReplyToItem[0].buf_addr = ReplyToPtr;
      LnmReplyToItem[0].buf_len = strlen(ReplyToPtr);
      status = sys$crelnm (0, &LnmProcessDsc, &MultiNetSmtpReplyToDsc,
                           &PslUser, &LnmReplyToItem);
      if (VMSnok (status)) goto VmsEmailMessageError;
      status = sys$crelnm (0, &LnmProcessDsc, &MxReplyToDsc,
                           &PslUser, &LnmReplyToItem);
      if (VMSnok (status)) goto VmsEmailMessageError;
      status = sys$crelnm (0, &LnmProcessDsc, &TcpIpSmtpFromDsc,
                           &PslUser, &LnmReplyToItem);
      if (VMSnok (status)) goto VmsEmailMessageError;
      status = sys$crelnm (0, &LnmProcessDsc, &TcpWareSmtpReplyToDsc,
                           &PslUser, &LnmReplyToItem);
      if (VMSnok (status)) goto VmsEmailMessageError;
   }

   cptr = CgiLibVar("WWW_FORM_SCS");
   if (cptr[0])
   {
      /* "courtesy copy to self" checkbox */
      strcpy (CcString, CcPtr);
      strcat (CcString, ",");
      strcat (CcString, MailUserName);
      CcPtr = CcString;
   }

   if (PostMasterAuthenticated)
   {
      FromPtr = CgiLibVar("WWW_FORM_SFR");
#ifdef YAHMAIL_PMDF
      if (MailProtocolIsPMDF)
      {
         /* PMDF objects to appended personal name */
         for (cptr = FromPtr; *cptr && !isspace(*cptr); cptr++);
         strncpy (FromString, FromPtr, cptr-FromPtr);
         FromString[cptr-FromPtr] = '\0';
         FromPtr = FromString;
      }
#endif /* YAHMAIL_PMDF */
   }
   else
   {
      PersonalPtr = CgiLibVar("WWW_FORM_SPN");
#ifdef YAHMAIL_PMDF
      if (MailProtocolIsPMDF)
         FromPtr = MailUserName;
      else
#endif /* YAHMAIL_PMDF */
      if (PersonalPtr[0])
      {
         strcpy (FromString, MailUserName);
         strcat (FromString, " \"");
         strcat (FromString, PersonalPtr);
         strcat (FromString, "\"");
         FromPtr = FromString;
      }
      else
         FromPtr = MailUserName;
   }

   CgiLibHtmlDeEntify (BodyPtr);
   CgiLibHtmlDeEntify (CcPtr);
   CgiLibHtmlDeEntify (FromPtr);
   CgiLibHtmlDeEntify (SubjectPtr);
   CgiLibHtmlDeEntify (ToPtr);

#ifndef YAHMAIL_PMDF

#ifdef YAHMAIL_MUNPACK

   if (HeaderIsoString)
   {
      if (neediso (CcPtr))
      {
         toiso_string (CcPtr, IsoCc, sizeof(IsoCc), ConfigCharsetPtr, 0);
         CcPtr = IsoCc;
      }
      if (neediso (FromPtr))
      {
         toiso_string (FromPtr, IsoFrom, sizeof(IsoFrom), ConfigCharsetPtr, 0);
         FromPtr = IsoFrom;
      }
      if (neediso (SubjectPtr))
      {
         toiso_string (SubjectPtr, IsoSubject, sizeof(IsoSubject),
                       ConfigCharsetPtr, 1);
         SubjectPtr = IsoSubject;
      }
      if (neediso (ToPtr))
      {
         toiso_string (ToPtr, IsoTo, sizeof(IsoTo), ConfigCharsetPtr, 0);
         ToPtr = IsoTo;
      }
   }

#endif /* YAHMAIL_MUNPACK */

#endif /* YAHMAIL_PMDF */

   /****************/
   /* mail message */
   /****************/

   if (ToPtr == NULL || !ToPtr[0])
   {
      CgiLibResponseError (FI_LI, 0, lang_ErrSendRecipient);
      return;
   }

   /* let's keep it within the bounds of reason! */
   if (WrapAt && (WrapAt < 48 || WrapAt > 255)) WrapAt = 72;

   if (ConfigSmtpTransportPtr == NULL)
      SmtpTransportLength = 0;
   else
      SmtpTransportLength = strlen(ConfigSmtpTransportPtr);

#ifdef YAHMAIL_PMDF

   if (MailProtocolIsPMDF)
   {
      PmdfNqCtx = 0;

      status = PMDFinitialize (0);
      if (Debug) fprintf (stdout, "PMDFinitialize() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;

      status = PMDFenqueueInitialize (); 
      if (Debug)
         fprintf (stdout, "PMDFenqueueInitialize() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;

      if (Debug)
      {
         status = PMDFdebug (1, 0); 
         if (Debug)
            fprintf (stdout, "PMDFdebug() %%X%08.08X\n", status);
         if (VMSnok (status)) goto VmsEmailMessageError;
      }

      status = PMDFstartMessageEnvelope (&PmdfNqCtx, "", 0,
                                         FromPtr, strlen(FromPtr));
      if (Debug)
         fprintf (stdout, "PMDFstartMessageEnvelope() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;
   }
   else

#endif /* YAHMAIL_PMDF */

   /* basically to support pre-VMS6.2 where SEND_NO_SIGFILE is an error */
   if (VmsVersion >= 70)
   {
      status = mail$send_begin (&SendContext,
                                &SendBeginSigFileItem,
                                &NullItem);
      if (Debug) fprintf (stdout, "mail$send_begin() %%X%08.08X\n", status);
   }
   else
   {
      status = mail$send_begin (&SendContext,
                                &SendBeginNoSigFileItem,
                                &NullItem);
      if (Debug) fprintf (stdout, "mail$send_begin() %%X%08.08X\n", status);
   }
   if (VMSnok (status)) goto VmsEmailMessageError;

   /*****************/
   /* non-PMDF from */
   /*****************/

#ifdef YAHMAIL_PMDF

   if (!MailProtocolIsPMDF)

#endif /* YAHMAIL_PMDF */

   {
      /* callable Mail "From:" (apparently) must be set after send_begin() */
      if (FromPtr != NULL && FromPtr[0])
      {
         status = sys$setprv (1, &SysPrvMask, 0, &PrevPrvMask);
         if (Debug) fprintf (stdout, "sys$setprv() %%X%08.08X\n", status);
         if (VMSok (status) && status != SS$_NOTALLPRIV)
         {
            FromItem[0].buf_addr = FromPtr;
            if ((FromItem[0].buf_len = strlen(FromPtr)) > 255)
               FromItem[0].buf_len = 255;
            status = mail$send_add_attribute (&SendContext,
                                              &FromItem,
                                              &NullItem);
            if (Debug)
               fprintf (stdout, "mail$send_add_attribute() %%X%08.08X\n",
                        status);
            if (VMSnok (status)) goto VmsEmailMessageError;

            if (PrevPrvMask[0] & PRV$M_SYSPRV)
            {
               status = sys$setprv (0, &SysPrvMask, 0, 0);
               if (Debug) fprintf (stdout, "sys$setprv() %%X%08.08X\n", status);
               if (VMSnok (status)) exit (status);
            }
         }
      }
   }

   /******************/
   /* to address(es) */
   /******************/

   CommercialAtHit = false;

   /* a single, or multiple newline or comma-separated addresses */
   cptr = ToPtr;
   while (*cptr)
   {
      QuoteChar = 0;
      while (*cptr && (*cptr == ',' || isspace(*cptr))) cptr++;
      if (*cptr == '!' || *cptr == '#')
      {
         /* comment "line" */
         while (*cptr && *cptr != '\n') cptr++;
         if (*cptr) cptr++;
         continue;
      }
      SmtpTransportHit = false;
      zptr = (sptr = MailAddress) + sizeof(MailAddress)-1;
      while (*cptr && *cptr != '\n' && sptr < zptr)
      {
         if (!ConfigReplyUseRfc822 && (*cptr == ',' || isspace(*cptr))) break;
         if (*cptr == '@') CommercialAtHit = true;
         if (*(unsigned short*)cptr == '%\"') SmtpTransportHit = true;
         if (*cptr != '\"' && *cptr != '\'')
         {
            if (*cptr == '\\' && sptr < zptr) *sptr++ = *cptr++; 
            if (sptr < zptr) *sptr++ = *cptr; 
            cptr++;
            if (isspace(*cptr) && ConfigReplyUseRfc822 && CommercialAtHit)
            {
               /* not interested in anything *after* the address */
               while (*cptr && *cptr != '\n') cptr++;
               continue;
            }
            continue;
         }
         /* encountered a quote */
         QuoteChar = *cptr++;
         if (sptr < zptr)
         {
            if (SmtpTransportLength && !SmtpTransportHit)
               if ((MailProtocolIsPMDF || ConfigReplyQuoteRfc822) &&
                   !ConfigReplyParenRfc822)
                  *sptr++ = '\'';
               else
                  *sptr++ = '(';
            else
               *sptr++ = QuoteChar;
         }

         while (*cptr && *cptr != QuoteChar && sptr < zptr)
         {
            if (*cptr == '@') CommercialAtHit = true;
            if (*cptr == '\\' && sptr < zptr) *sptr++ = *cptr++; 
            *sptr++ = *cptr;
            cptr++;
         }
         if (*cptr)
         {
            cptr++;
            if (sptr < zptr)
            {
               if (SmtpTransportLength && !SmtpTransportHit)
                  if ((MailProtocolIsPMDF || ConfigReplyQuoteRfc822) &&
                      !ConfigReplyParenRfc822)
                     *sptr++ = '\'';
                  else
                     *sptr++ = ')';
               else
                  *sptr++ = QuoteChar;
            }
         }
      }
      if (sptr >= zptr)
      {
         CgiLibResponseError (FI_LI, 0, lang_ErrSendMailAddressOvf);
         return;
      }
      *sptr = '\0';
      MailAddressLength = sptr - MailAddress;
      if (Debug) fprintf (stdout, "%d |%s|\n", MailAddressLength, MailAddress);

      if (!MailAddressLength) continue;

      if (ConfigLocalToSmtpPtr != NULL && ConfigLocalToSmtpPtr[0])
      {
         for (sptr = MailAddress; *sptr && *sptr != '@'; sptr++);
         if (!*sptr)
         {
            zptr = MailAddress + sizeof(MailAddress)-1;
            CurrentToPtr = cptr;
            for (cptr = ConfigLocalToSmtpPtr;
                 *cptr && sptr < zptr;
                 *sptr++ = *cptr++);
            if (sptr >= zptr)
            {
               CgiLibResponseError (FI_LI, 0, lang_ErrSendMailAddressOvf);
               return;
            }
            *sptr = '\0';
            cptr = CurrentToPtr;
            MailAddressLength = sptr - MailAddress;
            if (Debug)
               fprintf (stdout, "%d |%s|\n", MailAddressLength, MailAddress);
         }
      }

      SendToItem[0].buf_addr = MailAddress;
      SendToItem[0].buf_len = MailAddressLength;

      if (SmtpTransportLength)
      {
         for (sptr = MailAddress; *sptr && *sptr != '@'; sptr++);
         if (*sptr)
         {
            /* looks like an RFC822 address, check for a Mail transport */
            if (!SmtpTransportHit)
            {
               /* no Mail transport, add one */
               strcpy (sptr = SmtpAddress, ConfigSmtpTransportPtr);
               sptr += SmtpTransportLength;
               *sptr++ = '\"';
               strcpy (sptr, MailAddress);
               sptr += MailAddressLength;
               *sptr++ = '\"';
               *sptr = '\0';

               SendToItem[0].buf_addr = SmtpAddress;
               SendToItem[0].buf_len = sptr - SmtpAddress;
               if (Debug)
                  fprintf (stdout, "%d |%s|\n", sptr-SmtpAddress, SmtpAddress);
            }
         }
      }

      if (Debug)
         fprintf (stdout, "To: address |%s|\n", (char*)SendToItem[0].buf_addr);

#ifdef YAHMAIL_PMDF

      if (MailProtocolIsPMDF)
      {
         status = PMDFsetRecipientType (&PmdfNqCtx, 1, 0, 0, 1);
         if (Debug)
            fprintf (stdout, "PMDFsetRecipientType() %%X%08.08X\n", status);

         if (VMSok (status))
         {
            status = PMDFaddRecipient (&PmdfNqCtx,
                                       SendToItem[0].buf_addr,
                                       SendToItem[0].buf_len,
                                       SendToItem[0].buf_addr,
                                       SendToItem[0].buf_len);
            if (Debug)
               fprintf (stdout, "PMDFaddRecipient() %%X%08.08X\n", status);
         }
      }
      else

#endif /* YAHMAIL_PMDF */

      {
         status = mail$send_add_address (&SendContext, &SendToItem, &NullItem);
         if (Debug)
            fprintf (stdout, "mail$send_add_address() %%X%08.08X\n", status);
      }

      if (VMSnok (status)) goto VmsEmailMessageError;
   }

   /******************/
   /* cc address(es) */
   /******************/

   /* a single, or multiple newline or comma-separated addresses */
   if ((cptr = CcPtr) == NULL) cptr = "";
   while (*cptr)
   {
      QuoteChar = 0;
      while (*cptr && (*cptr == ',' || isspace(*cptr))) cptr++;
      if (*cptr == '!' || *cptr == '#')
      {
         /* comment "line" */
         while (*cptr && *cptr != '\n') cptr++;
         if (*cptr) cptr++;
         continue;
      }
      SmtpTransportHit = false;
      zptr = (sptr = MailAddress ) + sizeof(MailAddress)-1;
      while (*cptr && *cptr != '\n' && sptr < zptr)
      {
         if (!ConfigReplyUseRfc822 && (*cptr == ',' || isspace(*cptr))) break;
         if (*cptr == '@') CommercialAtHit = true;
         if (*(unsigned short*)cptr == '%\"') SmtpTransportHit = true;
         if (*cptr != '\"' && *cptr != '\'')
         {
            if (*cptr == '\\' && sptr < zptr) *sptr++ = *cptr++; 
            if (sptr < zptr) *sptr++ = *cptr;
            cptr++;
            if (isspace(*cptr) && ConfigReplyUseRfc822 && CommercialAtHit)
            {
               /* not interested in anything *after* the address */
               while (*cptr && *cptr != '\n') cptr++;
               continue;
            }
            continue;
         }
         /* encountered a quote */
         QuoteChar = *cptr++;
         if (sptr < zptr)
         {
            if (SmtpTransportLength && !SmtpTransportHit)
               if ((MailProtocolIsPMDF || ConfigReplyQuoteRfc822) &&
                   !ConfigReplyParenRfc822)
                  *sptr++ = '\'';
               else
                  *sptr++ = '(';
            else
               *sptr++ = QuoteChar;
         }
         while (*cptr && *cptr != QuoteChar && sptr < zptr)
         {
            if (*cptr == '@') CommercialAtHit = true;
            if (*cptr == '\\' && sptr < zptr) *sptr++ = *cptr++; 
            *sptr++ = *cptr;
            cptr++;
         }
         if (*cptr)
         {
            cptr++;
            if (sptr < zptr)
            {
               if (SmtpTransportLength && !SmtpTransportHit)
                  if ((MailProtocolIsPMDF || ConfigReplyQuoteRfc822) &&
                      !ConfigReplyParenRfc822)
                     *sptr++ = '\'';
                  else
                     *sptr++ = ')';
               else
                  *sptr++ = QuoteChar;
            }
            /* check if it's been a '"blah" <address>' format */
            for (tptr = cptr; *tptr && isspace(*tptr); tptr++);
            if (*tptr == '<')
            {
               /* yep */
               cptr = tptr;
               if (sptr < zptr) *sptr++ = ' ';
            }
         }
      }
      if (sptr >= zptr)
      {
         CgiLibResponseError (FI_LI, 0, lang_ErrSendMailAddressOvf);
         return;
      }
      *sptr = '\0';
      MailAddressLength = sptr - MailAddress;
      if (Debug) fprintf (stdout, "%d |%s|\n", MailAddressLength, MailAddress);

      SendCcItem[0].buf_addr = MailAddress;
      SendCcItem[0].buf_len = sptr - MailAddress;

      if (SmtpTransportLength)
      {
         for (sptr = MailAddress; *sptr && *sptr != '@'; sptr++);
         if (*sptr)
         {
            /* looks like an RFC822 address, check for a Mail transport */
            if (!SmtpTransportHit)
            {
               /* no Mail transport, add one */
               strcpy (sptr = SmtpAddress, ConfigSmtpTransportPtr);
               sptr += SmtpTransportLength;
               *sptr++ = '\"';
               strcpy (sptr, MailAddress);
               sptr += MailAddressLength;
               *sptr++ = '\"';
               *sptr = '\0';

               SendCcItem[0].buf_addr = SmtpAddress;
               SendCcItem[0].buf_len = sptr - SmtpAddress;;
               if (Debug)
                  fprintf (stdout, "%d |%s|\n", sptr-SmtpAddress, SmtpAddress);
            }
         }
      }

      if (Debug)
         fprintf (stdout, "CC: address |%s|\n", (char*)SendCcItem[0].buf_addr);

#ifdef YAHMAIL_PMDF

      if (MailProtocolIsPMDF)
      {
         status = PMDFsetRecipientType (&PmdfNqCtx, 0, 1, 0, 1);
         if (Debug)
            fprintf (stdout, "PMDFsetRecipientType() %%X%08.08X\n", status);

         if (VMSok (status))
         {
            status = PMDFaddRecipient (&PmdfNqCtx,
                                       SendCcItem[0].buf_addr,
                                       SendCcItem[0].buf_len,
                                       SendCcItem[0].buf_addr,
                                       SendCcItem[0].buf_len);
            if (Debug)
               fprintf (stdout, "PMDFaddRecipient() %%X%08.08X\n", status);
         }
      }
      else

#endif /* YAHMAIL_PMDF */

      {
         status = mail$send_add_address (&SendContext, &SendCcItem, &NullItem);
         if (Debug)
            fprintf (stdout, "mail$send_add_address() %%X%08.08X\n", status);
      }

      if (VMSnok (status)) goto VmsEmailMessageError;
   }

#ifdef YAHMAIL_PMDF

   /*************/
   /* PMDF from */
   /*************/

   if (MailProtocolIsPMDF)
   {
      status = PMDFstartMessageHeader (&PmdfNqCtx);
      if (Debug)
         fprintf (stdout, "PMDFstartMessageHeader() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;

      status = PMDFwriteFrom (&PmdfNqCtx, FromPtr, strlen(FromPtr));
      if (Debug) fprintf (stdout, "PMDFwriteFrom() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;
   }

#endif /* YAHMAIL_PMDF */

   /****************/
   /* massage body */
   /****************/

   /*
      "multipart/form-data" lines are delimited by '\r\n', reduce to '\n'.
      Do this now so the scan can be double purpose - looking for eight bit
      characters in case we need to kludge a quoted-printable MIME header!
   */
   EightBitHit = SendQuotedPrintable = false;
   for (cptr = sptr = BodyPtr; *cptr; cptr++)
   {
      if (*cptr & 0x80) EightBitHit = true;
      if (*cptr != '\r' || *(unsigned short*)cptr != '\r\n') *sptr++ = *cptr;
   }
   *sptr = '\0';
         
   if ((cptr = SubjectPtr) == NULL) cptr = "";

   /***********/
   /* subject */
   /***********/

#ifdef YAHMAIL_MUNPACK

   /* look for any possible attachments (identified by being non-empty) */
   for (idx = 1; idx <= AttachmentCount; idx++)
     if (CgiFormAttachPtr[idx][0]) break;
   if (idx > AttachmentCount) AttachmentCount = 0;

   if (AttachmentCount)
   {
      /* create a boundary string for the MIME sections */
      sys$gettim (&BinTime);
      sprintf (Boundary, "796168%08.08X%08.08X4D41494C",
               BinTime[0], BinTime[1]);
   }

#endif /* YAHMAIL_MUNPACK */

#ifdef YAHMAIL_PMDF

   if (MailProtocolIsPMDF)
   {
      status = PMDFwriteSubject (&PmdfNqCtx, cptr, strlen(cptr));
      if (Debug) fprintf (stdout, "PMDFwriteSubject() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;

      status = PMDFwriteDate (&PmdfNqCtx);
      if (Debug) fprintf (stdout, "PMDFwriteDate() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;

      PmdfHdrPtr = NULL;

      if (ReplyToPtr && ReplyToPtr[0])
      {
         /* for non-PMDF just provide the appropriate header line */
         if (Debug) fprintf (stdout, "ReplyToPtr |%s|\n", ReplyToPtr);
         status = PMDFaddHeaderLine (&PmdfHdrPtr, HL_REPLY_TO,
                                     ReplyToPtr, strlen(ReplyToPtr));
         if (Debug) fprintf (stdout, "PMDFaddHeader() %%X%08.08X\n", status);
         if (VMSnok (status)) goto VmsEmailMessageError;
      }

#ifdef YAHMAIL_MUNPACK

      if (AttachmentCount)
      {
         status = PMDFaddHeaderLine (&PmdfHdrPtr, HL_MIME_VERSION, "1.0", 3);
         if (Debug) fprintf (stdout, "PMDFaddHeader() %%X%08.08X\n", status);
         if (VMSnok (status)) goto VmsEmailMessageError;

         sprintf (PmdfContentType, "multipart/mixed; boundary=\"%s\"",
                  Boundary);

         status = PMDFaddHeaderLine (&PmdfHdrPtr, HL_CONTENT_TYPE,
                                     PmdfContentType, strlen(PmdfContentType));
         if (Debug) fprintf (stdout, "PMDFaddHeader() %%X%08.08X\n", status);
         if (VMSnok (status)) goto VmsEmailMessageError;
      }

#endif /* YAHMAIL_MUNPACK */

      sprintf (PmdfXyahMAIL, "X-yahMAIL: %s", SoftwareID);
      status = PMDFaddHeaderLine (&PmdfHdrPtr, HL_OTHER,
                                  PmdfXyahMAIL, strlen(PmdfXyahMAIL));
      if (Debug) fprintf (stdout, "PMDFaddHeader() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;

      status = PMDFwriteHeader (&PmdfNqCtx, PmdfHdrPtr);
      if (Debug) fprintf (stdout, "PMDFwriteHeader() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;
   }
   else

#endif /* YAHMAIL_PMDF */

   {
#ifdef YAHMAIL_MUNPACK
      if (Debug)
         fprintf (stdout,
"CommercialAtHit:%d EightBitHit:%d BodyQuotedPrintable:%d\n",
                  CommercialAtHit, EightBitHit, BodyQuotedPrintable);

      if (AttachmentCount)
      {
         /* create MIME psuedo-header */
         MimeHeaderLength = sprintf (MimeHeader,
"\r\n\
MIME-version: 1.0\r\n\
Content-Type: multipart/mixed; boundary=\"%s\"",
            Boundary);
      }
      else
      if (CommercialAtHit && EightBitHit && BodyQuotedPrintable)
      {
         /* create MIME pseudo-header */
         SendQuotedPrintable = true;
         MimeHeaderLength = sprintf (MimeHeader,
"\r\n\
MIME-version: 1.0\r\n\
Content-Type: text/plain; charset=%s\r\n\
Content-Transfer-Encoding: quoted-printable",
            ConfigCharsetPtr);
      }
      else
      {
         MimeHeaderLength = 0;
         SubjectLength = strlen(cptr);
      }

      if (MimeHeaderLength)
      {
         zptr = (sptr = SubjectBuffer) + 255;
         while (*cptr && sptr < zptr) *sptr++ = *cptr++;
         SubjectLength = sptr - SubjectBuffer;
         /* if greater than 255 characters then adjust to accomodate */
         if (SubjectLength + MimeHeaderLength > 255)
            sptr = (SubjectBuffer + 255) - MimeHeaderLength;
         for (cptr = MimeHeader; *cptr; *sptr++ = *cptr++);
         *sptr = '\0';
         SubjectLength = sptr - SubjectBuffer;
         cptr = SubjectBuffer;
      }

#else /* YAHMAIL_MUNPACK */

      SubjectLength = strlen(cptr);

#endif /* YAHMAIL_MUNPACK */

      if (Debug)
         fprintf (stdout, "%d %d |%s|\n", SubjectLength, strlen(cptr), cptr);

      SubjectItem[0].buf_addr = cptr;

      if ((SubjectItem[0].buf_len = SubjectLength) > 255)
         SubjectItem[0].buf_len = 255;
      status = mail$send_add_attribute (&SendContext, &SubjectItem, &NullItem);
      if (Debug)
         fprintf (stdout, "mail$send_add_attribute() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;
   }

   /********/
   /* body */
   /********/

#ifdef YAHMAIL_PMDF

   if (MailProtocolIsPMDF)
   {
      status = PMDFstartMessageBody (&PmdfNqCtx);
      if (Debug)
         fprintf (stdout, "PMDFstartMessageBody() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;
   }

#endif /* YAHMAIL_PMDF */

#ifdef YAHMAIL_MUNPACK

   if (AttachmentCount)
   {
      /*
         Prepend an RFC-like psuedo-header that [.MUNPACK]DECODE.C will
         read when processing the body for MIME.  This allows messages that
         have not been processed by an SMTP/RFC822 agent (e.g. CC-to-self)
         to be processed as MIME by yahMAIL.  This also provides a bit of
         an explanation for user's of non-MIME compliant readers.
         Add the part boundary for the plain-text portion of the message.
      */
#ifdef YAHMAIL_PMDF

      if (MailProtocolIsPMDF)
      {
         sprintf (Scratch,
"This message is in MIME format.\n\
Since your mail reader does not seem to understand\n\
MIME some or all of the message may not be legible.\n\
\n\
--%s\n\
Content-Type: text/plain;\n\
\n",
            Boundary);
      }
      else

#endif /* YAHMAIL_PMDF */

      {
         sprintf (Scratch,
"X-yahMAIL: This message is in MIME format.\n\
\tSince your mail reader does not seem to understand\n\
\tMIME some or all of the message may not be legible.\n\
\t---------------------------------------------------\n\
\t(This header-like section is *NOT* part of the RFC822\n\
\theader and is only for yahMAIL-internal purposes.)\n\
Content-Type: multipart/mixed; boundary=\"%s\"\n\
\n\
--%s\n\
Content-Type: text/plain;\n\
\n",
            Boundary, Boundary);
      }

      status = SendMailMessageBody (&SendContext, Scratch,
                                    SendQuotedPrintable, 0);
      if (VMSnok (status)) goto VmsEmailMessageError;
   }

#endif /* YAHMAIL_MUNPACK */

   status = SendMailMessageBody (&SendContext, BodyPtr,
                                 SendQuotedPrintable, WrapAt);
   if (VMSnok (status)) goto VmsEmailMessageError;

#ifdef YAHMAIL_MUNPACK

   /* add (any) attachments */
   for (idx = 1; idx <= AttachmentCount; idx++)
   {
      /* if nothing associated with this attachment number */
      if (!CgiFormAttachPtr[idx][0]) continue;

      sprintf (Scratch, "\n--%s\n", Boundary);
      status = SendMailMessageBody (&SendContext, Scratch,
                                    SendQuotedPrintable, 0);
      if (VMSnok (status)) goto VmsEmailMessageError;

      /* parse just the file name and type from any fuller specification */
      for (cptr = CgiFormAttachFileNamePtr[idx]; *cptr; cptr++);
      while (cptr > CgiFormAttachFileNamePtr[idx] &&
         *cptr != '/' && *cptr != '\\' && *cptr != ']') cptr--;
      if (*cptr == '/' || *cptr == '\\' || *cptr == ']') cptr++;
      /* retain that name.type */
      CgiFormAttachFileNamePtr[idx] = cptr;

#ifdef YAHMAIL_MUNPACK
      if (neediso (cptr))
      {
         toiso_string (cptr, IsoFileName, sizeof(IsoFileName),
                       ConfigCharsetPtr, 1);
         cptr = IsoFileName;
      }
#endif /* YAHMAIL_MUNPACK */

      sprintf (Scratch,
"Content-Type: %s;\n\
\tname=\"%s\"\n\
Content-Transfer-Encoding: base64\n\
Content-Disposition: attachment;\n\
\tfilename=\"%s\"\n\
\n",
         CgiFormAttachContentTypePtr[idx], cptr, cptr);

      status = SendMailMessageBody (&SendContext, Scratch,
                                    SendQuotedPrintable, 0);
      if (VMSnok (status)) goto VmsEmailMessageError;

      CgiFormAttachLength[idx] = CgiLibHtmlDeEntify (CgiFormAttachPtr[idx]);
      if (CgiFormAttachLength[idx] == -1) continue;
      cptr = Munpack_to64 (CgiFormAttachPtr[idx], CgiFormAttachLength[idx]);

      status = SendMailMessageBody (&SendContext, cptr,
                                    SendQuotedPrintable, 0);
      if (VMSnok (status)) goto VmsEmailMessageError;

      free (cptr);
   }

   if (AttachmentCount)
   {
      sprintf (Scratch, "\n--%s--\n", Boundary);
      status = SendMailMessageBody (&SendContext, Scratch,
                                    SendQuotedPrintable, 0);
      if (VMSnok (status)) goto VmsEmailMessageError;
   }

#endif /* YAHMAIL_MUNPACK */

#ifdef YAHMAIL_PMDF

   if (MailProtocolIsPMDF)
   {
      status = PMDFenqueueMessage (&PmdfNqCtx);
      if (Debug) fprintf (stdout, "PMDFenqueueMessage() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;

      status = PMDFdone ();
      if (Debug) fprintf (stdout, "PMDFdone() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;
   }
   else

#endif /* YAHMAIL_PMDF */

   {
      status = mail$send_message (&SendContext, &NoSignalItem, &NoSignalItem);
      if (Debug) fprintf (stdout, "mail$send_message() %%X%08.08X\n", status);
      if (VMSnok (status)) goto VmsEmailMessageError;

      mail$send_end (&SendContext, &NullItem, &NullItem);
   }

#ifdef YAHMAIL_MUNPACK

   /* just how many do we _actually_ have? */
   AttachmentCount = 0;
   for (idx = 1; idx <= AttachmentTotal; idx++)
      if (CgiFormAttachPtr[idx][0]) AttachmentCount++;

   sptr = AttList;
   if (AttachmentCount)
   {
      if (AttachmentCount == 1)
         sptr += sprintf (sptr, "<P>%s:\n<UL>\n", lang_AttachmentSingular);
      else
         sptr += sprintf (sptr, "<P>%s:\n<UL>\n", lang_AttachmentPlural);
      for (idx = 1; idx <= AttachmentTotal; idx++)
      {
         if (!CgiFormAttachPtr[idx][0]) continue;
         if (sptr >= AttList+sizeof(AttList)) break;
         sptr += sprintf (sptr,
                    "<LI>%s&nbsp;&nbsp;<I>(%s)</I>&nbsp;&nbsp;%d bytes\n",
                    CgiFormAttachFileNamePtr[idx],
                    CgiFormAttachContentTypePtr[idx],
                    CgiFormAttachLength[idx]);
      }
      strcpy (sptr, "</UL>\n");
      sptr += 6;
   }
   else
      *sptr = '\0';
   if (sptr >= AttList+sizeof(AttList)) exit (SS$_BUGCHECK);

#else /* YAHMAIL_MUNPACK */

   AttList[0] = '\0';

#endif /* YAHMAIL_MUNPACK */

   CgiLibResponseSuccess (
"%s\n\
%s\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
<BR><INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-2)\">\n\
</FORM>\n\
</BODY>\n\
</HTML>\n",
      lang_MessageSent, AttList,
      lang_BtnGoBack, lang_BtnGoBackToFolder);

   return;

VmsEmailMessageError:

#ifdef YAHMAIL_PMDF

   if (MailProtocolIsPMDF)
   {
      if (PmdfNqCtx) PMDFabortMessage (&PmdfNqCtx); 
   }
   else

#endif /* YAHMAIL_PMDF */

      mail$send_end (&SendContext, &NullItem, &NullItem);

   if (status == MAIL$_LOGLINK)
      sprintf (String, "%s \'%s\'.", lang_ErrSendInvalidUser, MailAddress);
   else
   if (status == MAIL$_NOSUCHUSR)
      sprintf (String, "%s \'%s\'.", lang_ErrSendNoSuchUser, MailAddress);
   else
   if (status == MAIL$_PARSEFAIL)
      sprintf (String, "%s \'%s\'.", lang_ErrSendParsing, MailAddress);
   else
   if (status == MAIL$_USERSPEC)
      sprintf (String, "%s \'%s\'.", lang_ErrSendInvalidUser, MailAddress);
   else
   if (status == MAIL$_ERRACTRNS)
      sprintf (String, "%s \'%s\'.", lang_ErrSendTransport, MailAddress);
   else

#ifdef YAHMAIL_PMDF

   if (status == PMDF__PARSE)
      sprintf (String, "%s \'%s\'.", lang_ErrSendParsing, MailAddress);
   else
   if (status == PMDF__USER)
      sprintf (String, "%s \'%s\'.", lang_ErrSendNoSuchUser, MailAddress);
   else
   if ((status & 0xfffff000) == 0x0a9c8000)
   {
      /* take a punt it's a PMDF error */
      strncpy (String, PMDFerrorToText (status), sizeof(String));
      String[sizeof(String)-1] = '\0';
      if (Debug) fprintf (stdout, "%%x%08.08x |%s|\n", status, String);
   }
   else

#endif /* YAHMAIL_PMDF */

   if (VMSok (status = sys$getmsg (status, &Length, &StringDsc, 1, 0))) 
   {
      String[Length] = '.';
      String[Length+1] = '\0';
      String[0] = toupper(String[0]);
   }
   else
      strcpy (String, "sys$getmsg() error!");
   if (Debug) fprintf (stdout, "|%s|\n", String);

   CgiLibResponseError (FI_LI, 0, String);
}

/*****************************************************************************/
/*
*/

int SendMailMessageBody
(
unsigned long *SendContextPtr,
char *BodyPtr,
boolean QuotedPrintable,
int WrapAt
)
{
   static struct VmsItemLongStruct

   BodyPartItem [] =
   {
      { 0, MAIL$_SEND_RECORD, 0, 0 },
      { 0, MAIL$_NOSIGNAL, 0, 0 },
      {0,0,0,0}
   },
   NullItem = {0,0,0,0};

   int  cnt,
        status;
   char  ch;
   char  *cptr, *sptr, *zptr;
   char  QuotedPrintableBuffer [256*4];

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "SendMailMessageBody() |%s|\n", BodyPtr);

   cptr = BodyPtr;
   while (*cptr)
   {
      BodyPartItem[0].buf_addr = cptr;

      /* only wrap non-quoted lines (those without leading '>') */
      if (WrapAt && *cptr != '>')
         cnt = WrapAt;
      else
         cnt = 255;

      while (*cptr && *cptr != '\r' && *cptr != '\n' && cnt)
      {
         cptr++;
         cnt--;
      }
      if (!cnt && *cptr != ' ' && *cptr != '\t')
      {
         /* reached the "wrap-at" limit while in a "word", back a little */
         sptr = cptr;
         while (*cptr && *cptr != ' ' && *cptr != '\t' &&
                cptr > (char*)BodyPartItem[0].buf_addr) cptr--;
         /* if it's a continuous line of characters then just break it! */
         if (cptr == BodyPartItem[0].buf_addr) cptr = sptr;
      }

      BodyPartItem[0].buf_len = cptr - (char*)BodyPartItem[0].buf_addr;
      if (Debug)
         fprintf (stdout, " %d |%*.*s|\n",
                  BodyPartItem[0].buf_len, BodyPartItem[0].buf_len,
                  BodyPartItem[0].buf_len, (char*)BodyPartItem[0].buf_addr);

#ifdef YAHMAIL_PMDF

      if (MailProtocolIsPMDF)
      {
         status = PMDFwriteLine (&PmdfNqCtx, BodyPartItem[0].buf_addr,
                                             BodyPartItem[0].buf_len);
         if (Debug) fprintf (stdout, "PMDFwriteLine() %%X%08.08X\n", status);
         if (VMSnok (status)) return (status);
      }
      else

#endif /* YAHMAIL_PMDF */

      {
#ifdef YAHMAIL_MUNPACK

         if (QuotedPrintable)
         {
            zptr = &((char*)BodyPartItem[0].buf_addr)[BodyPartItem[0].buf_len];
            ch = *zptr;
            ((char*)BodyPartItem[0].buf_addr)[BodyPartItem[0].buf_len] = '\0';
            BodyPartItem[0].buf_len =
               toqp_string (BodyPartItem[0].buf_addr,
                            QuotedPrintableBuffer,
                            sizeof(QuotedPrintableBuffer));
            if (BodyPartItem[0].buf_len == sizeof(QuotedPrintableBuffer))
               return (SS$_RESULTOVF);
            *zptr = ch;
            BodyPartItem[0].buf_addr = QuotedPrintableBuffer; 
            if (Debug)
               fprintf (stdout, " %d |%*.*s|\n",
                        BodyPartItem[0].buf_len, BodyPartItem[0].buf_len,
                        BodyPartItem[0].buf_len, (char*)BodyPartItem[0].buf_addr);
         }

#endif /* YAHMAIL_MUNPACK */

         status = mail$send_add_bodypart (SendContextPtr,
                                          &BodyPartItem,
                                          &NullItem);
         if (Debug)
            fprintf (stdout, "mail$send_add_bodypart() %%X%08.08X\n", status);
      }

      if (VMSnok (status)) return (status);

      /* if it was wrapped then this will absorb leading white-space */
      while (*cptr && (*cptr == ' ' || *cptr == '\t')) cptr++;
      if (*cptr == '\r') sptr = ++cptr;
      if (*cptr == '\n') sptr = ++cptr;
   }

   return (SS$_NORMAL);
}

/*****************************************************************************/
