/*****************************************************************************/
/*
                                 SigFile.c

This module provides maintenance access to an authenticated user's signature
file.  This file must be located in the same directory as the user's other VMS
mail files.


COPYRIGHT
---------
Copyright (C) 1999-2003 Mark G.Daniel
This program, comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.


VERSION HISTORY
---------------
19-FEB-2000  MGD  unbundled from YAHMAIL.C for v1.3
*/

/*****************************************************************************/

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

/* standard C header files */
#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>

/* VMS related header files */
#include <descrip.h>
#include <ssdef.h>
#include <stdlib.h>
#include <stsdef.h>

/* application header file */
#include "yahmail.h"
#include "externs.h"

#define FI_LI __FILE__, __LINE__

/*****************************************************************************/
/*
Read the user's signature file into memory pointed to by
'VmsMailSigFileTextPtr'.  To prevent access to just any old file yahMAIL
insists that the signature file reside in the same directory as the mail files
and that the profile signature entry comprises just the file name and type.
*/

ReadSigFile ()

{
   int  status;
   char  FileName [256];

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ReadSigFile() |%s|\n", VmsMailUserSigFile);

   strcpy (FileName, VmsMailUserFullDirectory);
   strcat (FileName, VmsMailUserSigFile);
   if (Debug) fprintf (stdout, "FileName |%s|\n", FileName);

   if (VmsMailSigFileTextPtr != NULL) free (VmsMailSigFileTextPtr);
   VmsMailSigFileTextLength = 0;
   status = ReadFileIntoMemory (FileName, &VmsMailSigFileTextPtr,
                                          &VmsMailSigFileTextLength);
   if (VMSnok (status))
   {
      char  String [256];
      unsigned short  Length;
      $DESCRIPTOR (StringDsc, String);

      if (VMSok (sys$getmsg (status, &Length, &StringDsc, 1, 0))) 
         String[Length] = '\0';
      else
         strcpy (String, "sys$getmsg() error!");

      VmsMailSigFileTextLength = Length + strlen(lang_ErrSigFileOpen) + 32;
      VmsMailSigFileTextPtr = calloc (VmsMailSigFileTextLength, 1);
      sprintf (VmsMailSigFileTextPtr, "%s: %s (%%X%08.08X)",
               lang_ErrSigFileOpen, String, status);
   }

   if (Debug) fprintf (stdout, "|%s|\n", VmsMailSigFileTextPtr);
}

/*****************************************************************************/
/*
Display the contents of the user's signature file in a <TEXTAREA></TEXTAREA>
tag.   This allows changes to be made and updated.
*/

SigFileAccess ()
       
{
   int  status;
   char  *SigFileTextPtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "SigFileAccess()\n");

   if (!VmsMailUserSigFile[0])
      strzcpy (VmsMailUserSigFile, CgiLibVar ("WWW_FORM_USF"), 255);

   if (!VmsMailUserSigFile[0])
   {
      CgiLibResponseError (FI_LI, 0, lang_ErrSigFileNoName);
      return;
   }

   ReadSigFile ();
   if (VmsMailSigFileTextPtr[0])
      SigFileTextPtr = (char*)CgiLibHtmlEscape (VmsMailSigFileTextPtr, -1, NULL, 0);
   else
      SigFileTextPtr = "";

   CgiLibResponseHeader (200, "text/html");
   fprintf (stdout,
"<HTML>\n\
<HEAD>\n\
<META NAME=\"generator\" CONTENT=\"%s\">\n\
<META NAME=\"environment\" CONTENT=\"%s\">\n\
<META NAME=\"language\" CONTENT=\"%s %s\">\n\
<TITLE>yahMAIL ... %s / %s</TITLE>\n\
</HEAD>\n\
<BODY %s>\n\
%s\
<B><FONT SIZE=+1><U>%s / %s</FONT></U></B>\n\
<BR>&nbsp;<FONT SIZE=-1>yahMAIL<SUP>*</SUP></FONT>\n\
<FORM ACTION=\"%s\" METHOD=POST>\n\
<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR><TD>\n\
<TEXTAREA NAME=txt ROWS=6 COLS=72 WRAP=off>\n\
%s\
</TEXTAREA>\n\
</TD></TR>\n\
</TABLE>\n\
<P><INPUT TYPE=hidden NAME=wha VALUE=\"sig\">\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\">&nbsp;\n\
<INPUT TYPE=reset VALUE=\"%s\">\
<I> ... %s</I>\n\
<P><INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>\n\
</BODY>\n\
</HTML>\n",
      SoftwareID, CgiEnvironmentPtr, lang_Language, lang_LanguageAuthor,
      MailUserName, lang_ProSignatureFile,
      ConfigBodyTagPtr, PostMasterWarningPtr,
      MailUserName, lang_ProSignatureFile,
      ActionPathInfo, SigFileTextPtr,
      lang_BtnUpdate, lang_BtnReset, lang_ResetCaution,
      lang_BtnGoBack);

   free (SigFileTextPtr);
}

/*****************************************************************************/
/*
Update/create the signature file contents.
*/

SigFileUpdate ()
       
{
   int  status;
   char  FileName [256];
   char  *cptr, *sptr,
         *FileTextPtr;
   FILE  *FilePtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "SigFileUpdate()\n");

   if (!VmsMailUserSigFile[0])
      strzcpy (VmsMailUserSigFile, CgiLibVar ("WWW_FORM_USF"), 255);

   if (!VmsMailUserSigFile[0])
   {
      CgiLibResponseError (FI_LI, 0, lang_ErrSigFileNoName);
      return;
   }

   strcpy (FileName, VmsMailUserFullDirectory);
   strcat (FileName, VmsMailUserSigFile);
   if (Debug) fprintf (stdout, "FileName |%s|\n", FileName);

   FileTextPtr = CgiLibVar ("WWW_FORM_TXT");

   FilePtr = fopen (FileName, "w", "shr=nil");
   if (FilePtr == NULL)
   {
      status = vaxc$errno;
      if (Debug) fprintf (stdout, "fopen() %%X%08.08X\n", status);
      return;
   }

   if (fputs (FileTextPtr, FilePtr) == EOF)
   {
      status = vaxc$errno;
      CgiLibResponseError (FI_LI, status, "%s", FileName);
   }
   else
   {
      /* purge the versions back to a maximum of 3 */
      strcat (FileName, ";-3");
      while (!remove (FileName));

      CgiLibResponseSuccess (
"%s\n\
<P><FORM>\n\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>",
         lang_SigFileUpdated, lang_BtnGoBack);
   }

   fclose (FilePtr);
}

/*****************************************************************************/

