/*****************************************************************************/
/*
                               ViewMsg.c

This module accesses and sends to the client the contents of a mail message. 
This can be in the form of a layed-up HTML page, plain-text document or binary
object (octet-stream).


COPYRIGHT
---------
Copyright (C) 1999-2003 Mark G.Daniel
This program, comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.


VERSION HISTORY
---------------
11-FEB-2003  MGD  "From:" now uses 'VmsMailRfc822ReplyTo', VmsMailRfc822From'
                  and then 'VmsMailSender', in that order
23-MAR-2002  MGD  quoted-printable
03-NOV-2000  MGD  add 'wrap long lines'
19-FEB-2000  MGD  unbundled from YAHMAIL.C for v1.3
*/

/*****************************************************************************/

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

/* standard C header files */
#include <ctype.h>
#include <errno.h>
#include <file.h>
#include <stdio.h>
#include <string.h>

/* VMS related header files */
#include <maildef.h>
#include <mailmsgdef.h>
#include <ssdef.h>
#include <stsdef.h>

/* application header file */
#include "yahmail.h"
#include "externs.h"

#define FI_LI __FILE__, __LINE__

/*****************************************************************************/
/*
Display an HTML page containing a single mail message.  Include a form for
requesting the message be returned as a plain-text page or as an octet-stream
download (i.e. binary).  Page is different for public and private access!
*/


ViewMailMessage ()

{
   boolean  MimeContents;
   int  status,
        AttachmentCount;
   char  NextMessage [96],
         PrevMessage [96],
         SizeString [64];
   char  *cptr,
         *CcPtr,
         *CharsetPtr,
         *FromPtr,
         *IncludeRfc822HeaderPtr,
         *MimePtr,
         *MimeKludgePtr,
         *NextMessagePtr,
         *PrevMessagePtr,
         *PickCcPtr,
         *PickFromPtr,
         *PickSubjPtr,
         *PickToPtr,
         *Rfc822Ptr,
         *SubjectPtr,
         *ToPtr,
         *TextPtr;
   char  RfcHeaderString [128],
         NoCcHtmlString [64],
         NoSubjHtmlString [64],
         NoSubjString [64];

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ViewMailMessage()\n");

   if (DoMessageReadPlainText)
   {
      ViewMailMessagePlainText ();
      return;
   }
   if (DoMessageReadOctetStream)
   {
      ViewMailMessageOctetStream ();
      return;
   }
#ifdef YAHMAIL_MUNPACK
   if (DoMessageReadMunpack)
   {
      CgiFormMunpackContentTypePtr = CgiLibVar ("WWW_FORM_MCT");
      MunpackYahmailFile (CgiFormMunpackPtr, CgiFormMunpackContentTypePtr);
      return;
   }
#endif /* YAHMAIL_MUNPACK */

   MimeContents = false;
   CharsetPtr = MimePtr = "";

   if (VmsMailRfc822HeaderLength)
   {
      Rfc822Ptr = "&nbsp;&nbsp;[<FONT SIZE=-1>RFC822</FONT>]";
      sprintf (IncludeRfc822HeaderPtr = RfcHeaderString,
"&nbsp;&nbsp;<INPUT TYPE=checkbox NAME=rfc VALUE=1>\
&nbsp;<I>RFC822&nbsp;&nbsp;%s</I>",
               lang_Header);

      CharsetPtr = VmsMailRfc822MimeCharset;

#ifdef YAHMAIL_MUNPACK

      if (VmsMailRfc822MimeVersion &&
          (!strsame (VmsMailRfc822MimeContentType, "text/plain", -1) ||
           !(VmsMailRfc822MimeContTransEnc[0] == '7' ||
             VmsMailRfc822MimeContTransEnc[0] == '8' ||
             strsame (VmsMailRfc822MimeContTransEnc, "binary", -1))))
      {
         /* not a simple plain-text MIME message */
         MimeContents = true;
      }

#endif /* YAHMAIL_MUNPACK */

   }
   else
   {
      MimePtr = Rfc822Ptr = "";
      IncludeRfc822HeaderPtr =
"<INPUT TYPE=hidden NAME=rfc VALUE=\"\">&nbsp;&nbsp;<I>header</I>";
      CharsetPtr = VmsMailRfc822MimeCharset;
   }

#ifdef YAHMAIL_MUNPACK

   /* look for the VMS send MIME subject line kludge */
   if ((MimeKludgePtr = strstr (VmsMailSubject,
                                "\r\nMIME-version: 1.0\r\n")) != NULL)
   {
      MimeContents = true;
      MimeKludgePtr[0] = '\0';
   }

#endif /* YAHMAIL_MUNPACK */

   /*************/
   /* HTML page */
   /*************/

   if (VmsMailRfc822ReplyTo[0])
      FromPtr = (char*)CgiLibAnchorHtmlEscape (VmsMailRfc822ReplyTo, -1, NULL, 0, MakeAnchors);
   else
   if (VmsMailRfc822From[0])
      FromPtr = (char*)CgiLibAnchorHtmlEscape (VmsMailRfc822From, -1, NULL, 0, MakeAnchors);
   else
      FromPtr = (char*)CgiLibAnchorHtmlEscape (VmsMailFrom, -1, NULL, 0, MakeAnchors);
   ToPtr = (char*)CgiLibAnchorHtmlEscape (VmsMailTo, -1, NULL, 0, MakeAnchors);
 
   if (VmsMailCc[0])
      CcPtr = (char*)CgiLibAnchorHtmlEscape (VmsMailCc, -1, NULL, 0, MakeAnchors);
   else
      sprintf (CcPtr = NoCcHtmlString, "<I>(%s)</I>", lang_NoCc);

   if (VmsMailSubject[0])
      SubjectPtr = (char*)CgiLibHtmlEscape (VmsMailSubject, -1, NULL, 0);
   else
   {
      sprintf (SubjectPtr = NoSubjHtmlString, "<I>(%s)</I>", lang_NoSubject);
      sprintf (NoSubjString, "(%s)", lang_NoSubject);
   }

   if (VmsMailMessageFlags & MAIL$M_EXTNSTD)
      strcpy (SizeString, "[<FONT SIZE=-1>FOREIGN</FONT>]");
   else
   if (VmsMailTextLength)
      sprintf (SizeString, "%d %s", VmsMailTextLength, lang_SizeBytes);
   else
      sprintf (SizeString, "%d %s", VmsMailMessageSize, lang_SizeRecords);

   if (VmsMailMessageId > 1)
   {
      sprintf (PrevMessage,
"<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"buildFormURL(\'%s\')\">",
               lang_BtnPrevious, lang_BtnPrevious);
      PrevMessagePtr = PrevMessage;
   }
   else
      PrevMessagePtr = "";

   if (VmsMailMessageId < VmsMailMessageSelectedCount)
   {
      sprintf (NextMessage,
"<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"buildFormURL(\'%s\')\">",
               lang_BtnNext, lang_BtnNext);
      NextMessagePtr = NextMessage;
   }
   else
      NextMessagePtr = "";

   PickFromPtr = (char*)CgiLibHtmlEscape (MailSubstringFrom, -1, NULL, 0);
   PickSubjPtr = (char*)CgiLibHtmlEscape (MailSubstringSubj, -1, NULL, 0);
   if (ConfigPrivate)
   {
      PickToPtr = (char*)CgiLibHtmlEscape (MailSubstringTo, -1, NULL, 0);
      PickCcPtr = (char*)CgiLibHtmlEscape (MailSubstringCc, -1, NULL, 0);
   }

   BuildActionQueryString ();

#ifdef YAHMAIL_MUNPACK

   if (MimeContents)
   {
      /* not a simple plain-text MIME message */
      static char  MimeString [128];
      extern int  MunpackAttachmentCount;
      extern char  MunpackCharset[];

      MunpackYahmailProcess (false);

      if (Debug) fprintf (stdout, "MunpackCharset |%s|\n", MunpackCharset);
      if (!*(CharsetPtr = MunpackCharset))
         CharsetPtr = VmsMailRfc822MimeCharset;

      if (MunpackAttachmentCount)
         sprintf (MimePtr = MimeString,
"&nbsp;&nbsp;[<FONT SIZE=-1>MIME</FONT>]&nbsp;&nbsp;%d&nbsp;%s",
            MunpackAttachmentCount,
            MunpackAttachmentCount == 1 ? lang_AttachmentSingular :
                                          lang_AttachmentPlural);
      else
         MimePtr = "&nbsp;&nbsp;[<FONT SIZE=-1>MIME</FONT>]";
   }

#endif /* YAHMAIL_MUNPACK */

   if (CharsetPtr[0])
      CgiLibResponseHeader (200, "text/html", "; charset=%s\n", CharsetPtr);
   else
      CgiLibResponseHeader (200, "text/html");

   fprintf (stdout,
"<HTML>\n\
<HEAD>\n\
<META NAME=\"generator\" CONTENT=\"%s\">\n\
<META NAME=\"environment\" CONTENT=\"%s\">\n\
<META NAME=\"language\" CONTENT=\"%s %s\">\n\
<TITLE>yahMAIL ... %s</TITLE>\n\
</HEAD>\n\
<SCRIPT LANGUAGE=\"JavaScript\">\n\
<!--\n\
\
var formURL = \"\";\n\
\
function doSubmit () {\n\
   if (formURL == \"\") return true;\n\
   location.replace(formURL);\n\
   return false;\n\
}\n\
\
function buildFormURL (actionButton) {\n\
   var elementName, elementValue;\n\
   formURL = document.formPage.action + \"?act=\" + escape(actionButton);\n\
   for (idx = 0; idx < document.formPage.elements.length; idx++) {\n\
      if (document.formPage.elements[idx].type == \"hidden\" ||\n\
          document.formPage.elements[idx].type == \"text\") {\n\
         elementName = document.formPage.elements[idx].name;\n\
         elementValue = document.formPage.elements[idx].value;\n\
         formURL += \"&\" + elementName + \"=\" + escape(elementValue);\n\
      }\n\
      else\n\
      if (document.formPage.elements[idx].type == \"checkbox\") {\n\
         if (document.formPage.elements[idx].checked) {\n\
            elementName = document.formPage.elements[idx].name;\n\
            elementValue = document.formPage.elements[idx].value;\n\
            formURL += \"&\" + elementName + \"=\" + escape(elementValue);\n\
         }\n\
      }\n\
      else\n\
      if (document.formPage.elements[idx].type == \"select-one\") {\n\
         elementName = document.formPage.elements[idx].name;\n\
         elementValue = \
document.formPage.elements[idx].options[\
document.formPage.elements[idx].options.selectedIndex].value;\n\
         formURL += \"&\" + elementName + \"=\" + escape(elementValue);\n\
      }\n\
   }\n\
}\n\
\
// -->\n\
</SCRIPT>\n\
<BODY %s>\n\
%s\
<FORM ACTION=\"%s%d\" NAME=formPage onSubmit=\"return doSubmit()\">\n\
<INPUT TYPE=hidden NAME=cmc VALUE=\"%d\">\n\
<INPUT TYPE=hidden NAME=wra VALUE=\"%d\">\n\
<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0>\n\
<TR><TH ALIGN=right VALIGN=top>%s:&nbsp;&nbsp;</TH><TD>%20.20s</TD></TR>\n\
<TR><TH ALIGN=right VALIGN=top>%s:&nbsp;&nbsp;</TH><TD>%s</TD></TR>\n\
<TR><TH ALIGN=right VALIGN=top>%s:&nbsp;&nbsp;</TH><TD>%s</TD></TR>\n\
<TR><TH ALIGN=right VALIGN=top>%s:&nbsp;&nbsp;</TH><TD>%s</TD></TR>\n\
<TR><TH ALIGN=right VALIGN=top>%s:&nbsp;&nbsp;</TH><TD>%s</TD></TR>\n\
<TR><TH ALIGN=right VALIGN=top>%s:&nbsp;&nbsp;</TH>\
<TD>%s%s%s<!-- FLAGS: %04.04X --></TD></TR>\n\
<TR><TH ALIGN=right VALIGN=top>%s:&nbsp;&nbsp;</TH>\
<TD>%s / %s%s%s / %d</TD></TR>\n\
<TR><TD HEIGHT=5></TD></TR>\n\
<TR><TD COLSPAN=2>\n\
&nbsp;%s%s%s%s\
<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">&nbsp;\n\
</TD></TR>\n\
</TABLE>\n\
<PRE><HR ALIGN=left WIDTH=70%% HEIGHT=1 NOSHADE>",
      SoftwareID, CgiEnvironmentPtr, lang_Language, lang_LanguageAuthor,
      VmsMailSubject[0] ? SubjectPtr : NoSubjString,
      ConfigBodyTagPtr, PostMasterWarningPtr,
      ActionPathInfo, VmsMailMessageId,
      CurrentMessageCount, WrapAt,
      lang_MsgDate, VmsMailDate,
      lang_MsgFrom, FromPtr,
      lang_MsgSubj, SubjectPtr,
      lang_MsgTo, ToPtr,
      lang_MsgCc, CcPtr, 
      lang_MsgStatus, SizeString, Rfc822Ptr, MimePtr, VmsMailMessageFlags,
      lang_MsgMessage, ConfigPrivate ? MailUserName : PathPart[0],
      ConfigPrivate ? MailFileName : "",
      ConfigPrivate ? " / " : "",
      HtmlEscapedMailFolderName, VmsMailMessageId,
      PrevMessagePtr,
      (PrevMessagePtr[0] && NextMessagePtr[0]) ? "&nbsp;\n" : "",
      NextMessagePtr,
      (PrevMessagePtr[0] || NextMessagePtr[0]) ? "&nbsp;\n" : "",
      lang_BtnGoBack);

   if (VmsMailMessageFlags & MAIL$M_EXTNSTD)
      fprintf (stdout, " <INPUT TYPE=submit NAME=act VALUE=\"%s\">",
               lang_BtnForeign);
#ifdef YAHMAIL_MUNPACK
   else
   if (MimeContents)
   {
      /* not a simple plain-text MIME message */
      extern int  MunpackAttachmentCount;
      MunpackYahmailText (stdout, true, WrapLongLines);
      if (MunpackAttachmentCount) MunpackYahmailParts (stdout);
   }
#endif /* YAHMAIL_MUNPACK */
   else
   {
      /* text file */
      TextPtr = VmsMailTextPtr;
      cptr = CgiLibVar("WWW_FORM_HEA");
      if (!cptr[0])
      {
         TextPtr += VmsMailHeaderLength;
         cptr = CgiLibVar("WWW_FORM_RFC");
         if (!cptr[0])
         {
            TextPtr += VmsMailRfc822HeaderLength;
#ifdef YAHMAIL_MUNPACK
            if (MimeQuotedPrintable) fromqp_string (TextPtr, NULL, true);
#endif /* YAHMAIL_MUNPACK */
         }
      }
#ifdef YAHMAIL_MUNPACK
      else
      if (MimeQuotedPrintable)
         fromqp_string (TextPtr, NULL, true);
#endif /* YAHMAIL_MUNPACK */

      if (WrapLongLines) ViewMsgWrapLongLines (TextPtr, WrapLongLines);

      TextPtr = (char*)CgiLibAnchorHtmlEscape (TextPtr, -1, NULL, 0, MakeAnchors);
      fputs (TextPtr, stdout);
      free (TextPtr);
   }

   fputs (
"<HR ALIGN=left WIDTH=70%% HEIGHT=1 NOSHADE></PRE>\n\
<TABLE CELLPADDING=0 CELLSPACING=5 BORDER=0>\n",
      stdout);

   if (ConfigPrivate)
   {
      fprintf (stdout,
"<TR><TD><NOBR>\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"buildFormURL(\'%s\')\">&nbsp;\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"buildFormURL(\'%s\')\">&nbsp;&nbsp;\n\
</NOBR></TD><TD><NOBR>\n\
<INPUT TYPE=checkbox NAME=taw VALUE=%d%s>\
&nbsp;<I>%s</I>&nbsp;\n\
<INPUT TYPE=checkbox NAME=inc VALUE=1 CHECKED>\
&nbsp;<I>%s</I>&nbsp;\n\
<INPUT TYPE=checkbox NAME=quo VALUE=1 CHECKED>\
&nbsp;<I>%s</I>&nbsp;\n",
         lang_BtnReply, lang_BtnReply,
         lang_BtnForward, lang_BtnForward,
         WrapAt ? WrapAt : 72, WrapAt ? " CHECKED" : "", lang_AutoWrap, 
         lang_ChkInclude, lang_ChkQuote);

#ifdef YAHMAIL_MUNPACK

      if (MimeAttachmentSubjectKludge || MailProtocolIsPMDF)
      {
         fprintf (stdout, "<SELECT NAME=atc>\n");
         for (AttachmentCount = 1;
              AttachmentCount <= MAX_ATTACHMENTS;
              AttachmentCount++)
            fprintf (stdout, "<OPTION VALUE=%d%s>%d\n",
                     AttachmentCount,
                     AttachmentCount == 1 ? " SELECTED" : "",
                     AttachmentCount);
         fprintf (stdout, "</SELECT>&nbsp;<NOBR><I>%s</I></NOBR>\n",
                  lang_AttachmentsMax);
      }

#endif /* YAHMAIL_MUNPACK */

      fprintf (stdout,
"</NOBR></TD></TR>\n\
<P>");
   }

   fprintf (stdout,
"<TR><TD><NOBR>\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\" \
onClick=\"buildFormURL(\'%s\')\">&nbsp;\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\">&nbsp;\n\
<INPUT TYPE=submit NAME=act VALUE=\"%s\">&nbsp;&nbsp;\n\
</NOBR></TD><TD>\n\
<INPUT TYPE=checkbox NAME=wll VALUE=%d%s>&nbsp;<I>%s</I>&nbsp;&nbsp;\
<INPUT TYPE=checkbox NAME=hea VALUE=1>&nbsp;<I>VMS</I>%s<BR>\n\
</TD></TR>\n\
<INPUT TYPE=hidden NAME=pfr VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=psu VALUE=\"%s\">\n",
      lang_BtnReload, lang_BtnReload,
      lang_BtnText, lang_BtnBinary,
      WrapLongLines ? WrapLongLines : 72,
      WrapLongLines ? " CHECKED" : "", lang_WrapLongLines,
      IncludeRfc822HeaderPtr, PickFromPtr, PickSubjPtr);

   if (ConfigPrivate)
   {
      fprintf (stdout,
"<INPUT TYPE=hidden NAME=pcc VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=pto VALUE=\"%s\">\n\
<INPUT TYPE=hidden NAME=mcs VALUE=\"%s\">\n",
      PickCcPtr, PickToPtr, VmsMailRfc822MimeCharset);
   }

   fprintf (stdout,
"<INPUT TYPE=hidden NAME=nnn VALUE=\"%s\">\n\
</FORM>\n\
</TABLE>\n\
<P><FORM>\n\
&nbsp;<INPUT TYPE=button VALUE=\"%s\" onClick=\"history.go(-1)\">\n\
</FORM>\n\
<P>%s\n\
</BODY>\n\
</HTML>\n",
      CgiFormNnnPtr, lang_BtnGoBack,
      ConfigPrivate ? ConfigReadFooterPtr : "");

   free (PickFromPtr);
   free (PickSubjPtr);
   if (ConfigPrivate)
   {
      free (PickCcPtr);
      free (PickToPtr);
   }

   free (FromPtr);
   free (SubjectPtr);
   free (CcPtr);
   free (ToPtr);
}

/*****************************************************************************/
/*
Insert a newline into the first white-space following the 'MaxLength'
character.  If multiple spaces then insert into the last space of the series so
that all wrapped lines begin with a non-space character.
*/

ViewMsgWrapLongLines
(
char *TextPtr,
int MaxLength
)
{                                                          
   int  ccnt;
   char  *cptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ViewMsgWrapLongLines()\n");

   ccnt = MaxLength;
   cptr = TextPtr;
   while (*cptr)
   {
      while (*cptr && *cptr != '\n' && ccnt)
      {
         cptr++;
         ccnt--;
      }
      if (!ccnt && *cptr && *cptr != '\n')
      {
         while (*cptr && *cptr != '\n' && *cptr != ' ') cptr++;
         while (*cptr && *cptr == ' ') cptr++;
         if (*cptr && *cptr != '\n') cptr--;
         if (*cptr && *cptr != '\n') *cptr = '\n';
      }
      if (*cptr) cptr++;
      ccnt = MaxLength;
   }
}

/*****************************************************************************/
/*
Return the mail message body as a plain text page.
*/

ViewMailMessagePlainText ()

{                                                          
   char  *cptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ViewMailMessagePlainText()\n");

   if (VmsMailMessageFlags & MAIL$M_EXTNSTD)
   {
      ViewMailMessageForeign ();
      return;
   }

   cptr = CgiLibVar("WWW_FORM_HEA");
   if (cptr[0])
   {
      /* include VMS mail header lines (the whole box and dice) */
      if (VmsMailRfc822MimeCharset[0])
         CgiLibResponseHeader (200, "text/plain",
                               "; charset=%s\n", VmsMailRfc822MimeCharset);
      else
         CgiLibResponseHeader (200, "text/plain");
      fputs (VmsMailTextPtr, stdout);
   }
   else
   {
      cptr = CgiLibVar("WWW_FORM_RFC");
      if (cptr[0])
      {
         /* include RFC822 header lines */
         if (VmsMailRfc822MimeCharset[0])
            CgiLibResponseHeader (200, "text/plain",
                                  "; charset=%s\n", VmsMailRfc822MimeCharset);
         else
            CgiLibResponseHeader (200, "text/plain");
         fputs (VmsMailTextPtr+VmsMailHeaderLength, stdout);
      }
      else
      {
         /* exclude VMS mail and any RFC822 header lines */
         if (VmsMailRfc822MimeCharset[0])
            CgiLibResponseHeader (200, "text/plain",
                                  "; charset=%s\n", VmsMailRfc822MimeCharset);
         else
            CgiLibResponseHeader (200, "text/plain");
         fputs (VmsMailTextPtr +
                VmsMailHeaderLength +
                VmsMailRfc822HeaderLength, stdout);
      }
   }
}

/*****************************************************************************/
/*
Return the mail message body as an octet-stream (i.e. binary).
*/

ViewMailMessageOctetStream ()

{
   char  *cptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ViewMailMessageOctetStream()\n");

   if (VmsMailMessageFlags & MAIL$M_EXTNSTD)
   {
      ViewMailMessageForeign ();
      return;
   }

   CgiLibResponseHeader (200, "application/octet-stream");

   CgiLibEnvironmentBinaryOut();

   cptr = CgiLibVar("WWW_FORM_HEA");
   if (cptr[0])
   {
      /* include VMS mail header lines */
      if (Debug) fprintf (stdout, "%d bytes\n", VmsMailTextLength);
      if (!Debug) fwrite (VmsMailTextPtr, VmsMailTextLength, 1, stdout);
   }
   else
   {
      cptr = CgiLibVar("WWW_FORM_RFC");
      if (cptr[0])
      {
         /* include RFC822 header lines */
         if (Debug)
            fprintf (stdout, "%d bytes\n",
                     VmsMailTextLength - VmsMailHeaderLength);
         if (!Debug)
            fwrite (VmsMailTextPtr + VmsMailHeaderLength,
                    VmsMailTextLength - VmsMailHeaderLength,
                    1,
                    stdout);
      }
      else
      {
         /* exclude VMS mail and any RFC822 header lines */
         if (Debug)
            fprintf (stdout, "%d bytes\n",
                     VmsMailTextLength -
                     VmsMailHeaderLength -
                     VmsMailRfc822HeaderLength);
         if (!Debug)
            fwrite (VmsMailTextPtr +
                    VmsMailHeaderLength +
                    VmsMailRfc822HeaderLength,
                    VmsMailTextLength -
                    VmsMailHeaderLength -
                    VmsMailRfc822HeaderLength,
                    1,
                    stdout);
      }
   }

   CgiLibEnvironmentStandardOut();
}

/*****************************************************************************/
/*
Return the /FOREIGN mail message body as an octet-stream (i.e. binary).
*/

ViewMailMessageForeign ()

{
   int  status,
        cnt,
        fd;
   char  *cptr;
   char  Buffer [MESSAGE_TEXT_CHUNK],
         FileName [256];

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ViewMailMessageForeign()\n");

   if (!((VmsMailMessageFlags & MAIL$M_EXTNSTD) && VmsMailExtId[0]))
   {
      CgiLibResponseError (FI_LI, 0, lang_ErrSanityCheck);
      return;
   }

   if (ConfigPublic)
   {
      /* full specification for locations of mail files */
      strcpy (FileName, MailFileName);
      for (cptr = FileName; *cptr; cptr++);
      while (cptr > FileName && *cptr != ']') cptr--;
      if (*cptr != ']') while (*cptr && *cptr != ':') cptr++;
      if (*cptr == ']' || *cptr == ':') *++cptr = '\0';
   }
   else
   {
      /* user-based location of mail files */
      strcpy (FileName, VmsMailUserFullDirectory);
   }
   strcat (FileName, VmsMailExtId);
   if (Debug) fprintf (stdout, "|%s|\n", FileName);

   if ((fd = open (FileName, O_RDONLY, 0, "ctx=stm")) == -1)
   {
      status = vaxc$errno;
      CgiLibResponseError (FI_LI, status, lang_ErrMessageForeign);
      return;
   }

   if (DoMessageReadPlainText)
      CgiLibResponseHeader (200, "text/plain");
   else
      CgiLibResponseHeader (200, "application/octet-stream");

   CgiLibEnvironmentBinaryOut();

   while ((cnt = read (fd, Buffer, sizeof(Buffer))) > 0)
   {
      if (Debug) fprintf (stdout, "%d bytes\n", cnt);
      if (!Debug) fwrite (Buffer, cnt, 1, stdout);
   }

   CgiLibEnvironmentStandardOut();

   close (fd);
}

/*****************************************************************************/

