/*****************************************************************************/
/*
                                yahMAIL.h

VERSION HISTORY
---------------
14-JUN-2000  MGD  v1.3.1
17-FEB-2000  MGD  initial for v1.3
*/

/*****************************************************************************/

#ifndef YAHMAIL_H_LOADED
#define YAHMAIL_H_LOADED

#include "lang.h"
#include <cgilib.h>

#pragma message __save
#pragma message disable (INCOMPARRY)

/*****************************/
/* configuration definitions */
/*****************************/

/* make false to exclude authenticated (private) functionality from image */
#ifndef YAHMAIL_PRIVATE
#  define YAHMAIL_PRIVATE 1
#endif

/* make false to exclude POSTMASTER functionality from image */
#ifndef YAHMAIL_POSTMASTER
#  if YAHMAIL_PRIVATE
#     define YAHMAIL_POSTMASTER 1
#  else
#     define YAHMAIL_POSTMASTER 0
#  endif
#endif

/* maximum number of attachments allowed for a private create-send */
#define MAX_ATTACHMENTS 8

/* size of "chunks" of memory allocated when reading message text */
#define MESSAGE_TEXT_CHUNK 4096

/* size of "chunks" of memory allocated when reading configuration text */
#define CONFIG_TEXT_CHUNK 1024

/* number of messages to show per folder page */
#define DEFAULT_BROWSE_WINDOW 10

/* create-send <TEXTAREA> defaults */
#define CREATESEND_TEXTAREA_ROWS 20
#define CREATESEND_TEXTAREA_COLS 72

/* string used in "Subj:" field to indicate it's the folder config message */
#define DEFAULT_PUBLIC_CONFIG_SUBJ "!yahMAIL!"

#define DEFAULT_BODY_TAG \
"BGCOLOR=\"#ffffff\" TEXT=\"#000000\" LINK=\"#0000ff\" VLINK=\"#000099\""

#define ADDRESS_LIST_WINDOW \
"menubar=1,toolbar=0,location=0,directories=0,width=550,height=500,resizable=1"

/* make HTML anchors out of URLs and/or mail addresses in plain text */
#define DEFAULT_ANCHORS (CGILIB_ANCHOR_WEB | CGILIB_ANCHOR_MAIL)

#define DEFAULT_CONFIG_FILE "YAHMAIL$CONFIG"

/*********************/
/* other definitions */
/*********************/

#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) !(((x) & STS$M_SUCCESS))

#define boolean int
#define true 1
#define false 0

/* make up for the lack of these in some header files */
#ifndef MAIL$_USER_SIGFILE
#  define MAIL$_SEND_SIGFILE 23
#  define MAIL$_SEND_NO_SIGFILE 24
#  define MAIL$_USER_SET_SIGFILE 3110
#  define MAIL$_USER_SET_NO_SIGFILE 3111
#  define MAIL$_USER_SIGFILE 3141
#endif

/*******************/
/* data structures */
/*******************/

struct VmsItemStruct {
   short int  buf_len;
   short int  item;
   void  *buf_addr;
   unsigned short  *ret_len;
};

struct VmsItemLongStruct {
   short int  buf_len;
   short int  item;
   void  *buf_addr;
   unsigned long  *ret_len;
};

struct FolderListStruct
{
   struct FolderListStruct  *NextPtr;
   unsigned long  MessageCount;
   char  *FolderNamePtr;
   char  Data [];
};

struct MessageListStruct
{
   struct MessageListStruct  *PrevPtr,
                             *NextPtr;
   unsigned long  MessageId;
   unsigned long  BinaryDate [2];
   char  *DatePtr,
         *ToPtr,
         *FromPtr,
         *SubjectPtr;
   char  Data [];
};

struct UserListStruct
{
   struct UserListStruct  *NextPtr;
   char  *UserNamePtr;
   char  Data [];
};

/***********************/
/* required prototypes */
/***********************/

char* CreateMailMessageReFw (char*, char*);

/* CALLMAIL.C */
int GenerateFolderListEntry ();

/* SENDMSG.C */
int SendMessage ();
char* VmsEmailMessage (char*, char*, char*, char*, char*, char*, char*, int);

/* munpack CODES.C */
char* Munpack_to64 (char*, int);

#pragma message __restore

#endif /* YAHMAIL_H_LOADED */

/*****************************************************************************/

